/*
 * P3 python wrapper
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**********************************************
 * Copyright (C) 2002-2003 Bertrand 'blam' LAMY
 **********************************************/

/*====================*
 * COORDSYS ANIMATION *
 *====================*/

static int PyP3AnimCoordsys_Init (P3_anim_coordsys* self, PyObject* args, PyObject* kwds) {
  P3_anim_coordsys_new (self);
	return 0;
}

static void PyP3AnimCoordsys_Dealloc (P3_anim_coordsys* d) {
  free (d->states);
  d->ob_type->tp_free ((PyObject*) d);
}

static PyObject* PyP3AnimCoordsys_AddState (P3_anim_coordsys* a, PyObject* args) {
  P3_anim_coordsys_add_state (a, (P3_coordsys*) PySequence_Fast_GET_ITEM (args, 0), PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 1)));
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3AnimCoordsys_RemoveState (P3_anim_coordsys* a, PyObject* arg) {
  if (PyFloat_Check (arg)) {
    P3_anim_coordsys_remove_state (a, (float) PyFloat_AS_DOUBLE (arg));
  } else if (PyInt_Check (arg)) {
    P3_anim_coordsys_delete_state (a, (int) PyInt_AS_LONG (arg));
  }
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3AnimCoordsys_GetTimeFor (P3_anim_coordsys* d, PyObject* arg) {
  return PyFloat_FromDouble ((double) (d->states + PyInt_AS_LONG (arg))->time);
}

static PyObject* PyP3AnimCoordsys_SetTimeFor (P3_anim_coordsys* d, PyObject* args) {
  (d->states + PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 0)))->time = (float) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 1));
  Py_INCREF (Py_None);
  return Py_None;
}

/*
static PyObject* PyP3AnimCoordsys_GetState (P3_anim_coordsys* a) {
  void* buffer;
  void* buf;
  int all_size;
//  int i;
  PyObject* o;
//  P3_state_coordsys* state;
  all_size = (3 + a->nb_states) * sizeof (float) + (19 + 4) * a->nb_states * sizeof (GLfloat) + sizeof (int);
  buffer = (void*) malloc (all_size);
  all_size /= (double) sizeof (char);
  buf = buffer;
  PUT_IN_BUFFER (buf, a->nb_states,  int);
  PUT_IN_BUFFER (buf, a->cyclic_lap, float);
  PUT_IN_BUFFER (buf, a->time_min,   float);
  PUT_IN_BUFFER (buf, a->time_max,   float);
  PUT_ARRAY_IN_BUFFER (buf, a->states, a->nb_states, P3_state_coordsys);
//  for (i = 0; i < a->nb_states; i++) {
//    state = a->states + i;
//    PUT_IN_BUFFER (buf, state->time, float);
//    PUT_ARRAY_IN_BUFFER (buf, state->quaternion,  4, GLfloat);
//    PUT_ARRAY_IN_BUFFER (buf, state->m,          19, GLfloat);
//  }
  o = PyString_FromStringAndSize ((char*) buffer, all_size);
  free (buffer);
  return o;
}

static PyObject* PyP3AnimCoordsys_SetState (P3_anim_coordsys* a, PyObject* arg) {
  void* buf;
//  int i;
  buf = (void*) PyString_AS_STRING (arg);
  GET_FROM_BUFFER (buf, a->nb_states,  int);
  GET_FROM_BUFFER (buf, a->cyclic_lap, float);
  GET_FROM_BUFFER (buf, a->time_min,   float);
  GET_FROM_BUFFER (buf, a->time_max,   float);
  GET_MALLOC_ARRAY_FROM_BUFFER (buf, a->states, a->nb_states, P3_state_coordsys);
//  a->states = (P3_state_coordsys*) malloc (a->nb_states * sizeof (P3_coordsys_state));
//  for (i = 0; i < a->nb_states; i++) {
//    state = a->states + i;
//    GET_FROM_BUFFER (buf, state->time, float);
//    GET_ARRAY_FROM_BUFFER (buf, state->quaternion,  4, GLfloat);
//    GET_ARRAY_FROM_BUFFER (buf, state->m,          19, GLfloat);
//  }
  Py_INCREF (Py_None);
  return Py_None;
}
*/

static PyMethodDef PyP3AnimCoordsys_Methods[] = {
  { "add",          (PyCFunction) PyP3AnimCoordsys_AddState,    METH_VARARGS },
  { "remove",       (PyCFunction) PyP3AnimCoordsys_RemoveState, METH_O },
  { "get_time_for", (PyCFunction) PyP3AnimCoordsys_GetTimeFor,  METH_O },
  { "set_time_for", (PyCFunction) PyP3AnimCoordsys_SetTimeFor,  METH_VARARGS },
//  { "_getstate",    (PyCFunction) PyP3AnimCoordsys_GetState,    METH_NOARGS },
//  { "_setstate",    (PyCFunction) PyP3AnimCoordsys_SetState,    METH_O },
  { NULL, NULL }
};

static PyObject* PyP3AnimCoordsys_GetNbStates (P3_anim_coordsys* d, void* context) {
  return PyInt_FromLong ((long) d->nb_states);
}

PY_GET_SET_ON_FLOAT (AnimCoordsys, P3_anim_coordsys*, CyclicLap, cyclic_lap)

static PyGetSetDef PyP3AnimCoordsys_GetSets[] = {
	{ "cyclic_lap",    (getter) PyP3AnimCoordsys_GetCyclicLap, (setter) PyP3AnimCoordsys_SetCyclicLap, NULL },
	{ "states_number", (getter) PyP3AnimCoordsys_GetNbStates,  (setter) 0,                             NULL },
  { NULL }
};

PyTypeObject PyP3AnimCoordsys_Type = {
  PyObject_HEAD_INIT(NULL)
  0,
  "_soya._AnimCoordsys",
  sizeof(P3_anim_coordsys),
  0,
  (destructor) PyP3AnimCoordsys_Dealloc,/* tp_dealloc */
  0,/* tp_print */
  0,/* tp_getattr */
  0,/* tp_setattr */
  0,/* tp_compare */
  0,/* tp_repr */
  0,/* tp_as_number */
  0,/* tp_as_sequence */
  0,/* tp_as_mapping */
  0,/* tp_hash */
  0,/* tp_call */
  0,/* tp_str */
  PYP3_GENERIC_GETATTR,/* tp_getattro */
  0,/* tp_setattro */
  0,/* tp_as_buffer */
  Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,/* tp_flags */
  0,/* tp_doc */
  (traverseproc) 0,/* tp_traverse */
  (inquiry) 0,/* tp_clear */
  0,/* tp_richcompare */
  0,/* tp_weaklistoffset */
  0,/* tp_iter */
  0,/* tp_iternext */
  (PyMethodDef*) PyP3AnimCoordsys_Methods,/* tp_methods */
  0,/* tp_members */
  (PyGetSetDef*) PyP3AnimCoordsys_GetSets,/* tp_getset */
  0,/* tp_base */
  0,/* tp_dict */
  0,/* tp_descr_get */
  0,/* tp_descr_set */
  0,/* tp_dictoffset */
  (initproc) PyP3AnimCoordsys_Init,/* tp_init */
  PYP3_GENERIC_ALLOC,/* tp_alloc */
  (newfunc) PyP3Object_New,/* tp_new */
  PYP3_GENERIC_FREE,/* tp_free */
};


/*============*
 * MORPH DATA *
 *============*/

/*
static int PyP3MorphData_Init (PyObject* self, PyObject* args, PyObject* kwds) {
  P3_morph_data_new ((P3_morph_data*) self);
	return 0;
}
*/

static void PyP3MorphData_Dealloc (P3_morph_data* d) {
  P3_morph_data_free_data (d);
  Py_XDECREF (d->w);
  d->ob_type->tp_free ((PyObject*) d);
}

static int PyP3MorphData_Traverse (P3_morph_data* w, visitproc visit, void* arg) {
  P3_material* m;
	int err;
  int i;
  if (w->w != NULL) {
    err = visit ((PyObject*) w->w, arg);
    if (err) { return err; }
  }
  for (i = 0; i < w->nb_materials; i++) {
    m = w->materials[i];
    if (m != NULL) {
      err = visit ((PyObject*) m, arg);
      if (err) { return err; }
    }
  }
	return 0;
}

static int PyP3MorphData_Clear (P3_morph_data* w) {
  int i;
  Py_XDECREF (w->w);
  w->w = NULL;
  for (i = 0; i < w->nb_materials; i++) {
    Py_XDECREF (w->materials[i]);
    w->materials[i] = NULL;
  }
  return 0;
}

/*
static PyObject* PyP3MorphData_GetState (P3_morph_data* d) {
  void* buffer;
  void* buf;
  int all_size;
  PyObject* o;
  PyObject* tuple;
  P3_morph_face* face;
  P3_morph_mesh* mesh;
  int i;
  all_size = (4 + d->nb_v_coords * 3 + d->nb_v_texcoords * 2 + d->nb_v_normals * 3 + d->nb_v_colors * 4 + d->nb_f * 3) * sizeof (GLfloat) 
    + (10 + d->nb_v * 5) * sizeof (int);
  for (i = 0; i < d->nb_f; i++) {
    all_size += (4 + (d->f + i)->nb_v) * sizeof (int);
  }
  for (i = 0; i < d->nb_m; i++) {
    all_size += (3 + (d->meshes + i)->nb_f) * sizeof (int);
  }
  buffer = (void*) malloc (all_size);
  all_size /= (double) sizeof (char);
  buf = buffer;

  PUT_IN_BUFFER (buf, d->nb_v, int);
  PUT_ARRAY_IN_BUFFER (buf, d->v, d->nb_v, P3_morph_vertex);
//  for (i = 0; i < d->nb_v; i++) {
//    vertex = d->v + i;
//    PUT_IN_BUFFER (buf, vertex->option,   int);
//    PUT_IN_BUFFER (buf, vertex->coord,    int);
//    PUT_IN_BUFFER (buf, vertex->texcoord, int);
//    PUT_IN_BUFFER (buf, vertex->color,    int);
//    PUT_IN_BUFFER (buf, vertex->world,    int);
//  }
  PUT_IN_BUFFER (buf, d->nb_v_coords, int);
  PUT_ARRAY_IN_BUFFER (buf, d->v_coords, 3 * d->nb_v_coords, GLfloat);
  PUT_IN_BUFFER (buf, d->nb_v_texcoords, int);
  PUT_ARRAY_IN_BUFFER (buf, d->v_coords, 2 * d->nb_v_texcoords, GLfloat);
  PUT_IN_BUFFER (buf, d->nb_v_normals, int);
  PUT_ARRAY_IN_BUFFER (buf, d->v_normals, 3 * d->nb_v_normals, GLfloat);
  PUT_IN_BUFFER (buf, d->nb_v_colors, int);
  PUT_ARRAY_IN_BUFFER (buf, d->v_colors, 4 * d->nb_v_colors, GLfloat);
  PUT_IN_BUFFER (buf, d->nb_f, int);
  for (i = 0; i < d->nb_f; i++) {
    face = d->f + i;
    PUT_IN_BUFFER (buf, face->option, int);
    PUT_IN_BUFFER (buf, face->normal, int);
    PUT_IN_BUFFER (buf, face->world,  int);
    PUT_IN_BUFFER (buf, face->nb_v,   int);
    PUT_ARRAY_IN_BUFFER (buf, face->v, face->nb_v, int);
  }
  PUT_ARRAY_IN_BUFFER (buf, d->f_normals, 3 * d->nb_f, GLfloat);
  PUT_IN_BUFFER (buf, d->nb_m, int);
  for (i = 0; i < d->nb_m; i++) {
    mesh = d->meshes + i;
    PUT_IN_BUFFER (buf, mesh->option,   int);
    PUT_IN_BUFFER (buf, mesh->material, int);
    PUT_IN_BUFFER (buf, mesh->nb_f,     int);
    PUT_ARRAY_IN_BUFFER (buf, mesh->f, mesh->nb_f, int);
  }
  PUT_IN_BUFFER (buf, d->option, int);
  PUT_ARRAY_IN_BUFFER (buf, d->bsphere, 4, GLfloat);
  PUT_IN_BUFFER (buf, d->nb_w, int);
  // string buffer
  tuple = PyTuple_New (3);
  o = PyString_FromStringAndSize ((char*) buffer, all_size);
  free (buffer);
  PyTuple_SET_ITEM (tuple, 0, o);
  // material 
  o = PyTuple_New (d->nb_materials);
  for (i = 0; i < d->nb_materials; i++) {
    if (d->materials[i] == NULL) {
      Py_INCREF (Py_None);
      PyTuple_SET_ITEM (o, i, Py_None);
    } else {
      Py_INCREF ((PyObject*) d->materials[i]);
      PyTuple_SET_ITEM (o, i, (PyObject*) d->materials[i]);
    }
  }
  PyTuple_SET_ITEM (tuple, 1, o);
  // worlds
  Py_INCREF ((PyObject*) d->w);
  PyTuple_SET_ITEM (tuple, 2, (PyObject*) d->w);
  return tuple;
}

static PyObject* PyP3MorphData_SetState (P3_morph_data* d, PyObject* args) {
  P3_morph_face* face;
  P3_morph_mesh* mesh;
  PyObject* o;
  void* buf;
  int i;
  // string buffer
  o = PySequence_Fast_GET_ITEM (args, 0);
  buf = PyString_AS_STRING (o);
  GET_FROM_BUFFER (buf, d->nb_v, int);
  GET_MALLOC_ARRAY_FROM_BUFFER (buf, d->v, d->nb_v, P3_morph_vertex);
  GET_FROM_BUFFER (buf, d->nb_v_coords, int);
  GET_MALLOC_ARRAY_FROM_BUFFER (buf, d->v_coords, 3 * d->nb_v_coords, GLfloat);
  GET_FROM_BUFFER (buf, d->nb_v_texcoords, int);
  GET_MALLOC_ARRAY_FROM_BUFFER (buf, d->v_coords, 2 * d->nb_v_texcoords, GLfloat);
  GET_FROM_BUFFER (buf, d->nb_v_normals, int);
  GET_MALLOC_ARRAY_FROM_BUFFER (buf, d->v_normals, 3 * d->nb_v_normals, GLfloat);
  GET_FROM_BUFFER (buf, d->nb_v_colors, int);
  GET_MALLOC_ARRAY_FROM_BUFFER (buf, d->v_colors, 4 * d->nb_v_colors, GLfloat);
  GET_FROM_BUFFER (buf, d->nb_f, int);
  d->f = (P3_morph_face*) malloc (d->nb_f * sizeof (P3_morph_face));
  for (i = 0; i < d->nb_f; i++) {
    face = d->f + i;
    GET_FROM_BUFFER (buf, face->option, int);
    GET_FROM_BUFFER (buf, face->normal, int);
    GET_FROM_BUFFER (buf, face->world,  int);
    GET_FROM_BUFFER (buf, face->nb_v,   int);
    GET_MALLOC_ARRAY_FROM_BUFFER (buf, face->v, face->nb_v, int);
  }
  GET_MALLOC_ARRAY_FROM_BUFFER (buf, d->f_normals, 3 * d->nb_f, GLfloat);
  GET_FROM_BUFFER (buf, d->nb_m, int);
  d->meshes = (P3_morph_mesh*) malloc (d->nb_m * sizeof (P3_morph_mesh));
  for (i = 0; i < d->nb_m; i++) {
    mesh = d->meshes + i;
    mesh->class = &P3_class_morph_mesh;
    GET_FROM_BUFFER (buf, mesh->option,   int);
    GET_FROM_BUFFER (buf, mesh->material, int);
    GET_FROM_BUFFER (buf, mesh->nb_f,     int);
    GET_MALLOC_ARRAY_FROM_BUFFER (buf, mesh->f, mesh->nb_f, int);
  }
  GET_FROM_BUFFER (buf, d->option, int);
  GET_ARRAY_FROM_BUFFER (buf, d->bsphere, 4, GLfloat);
  GET_FROM_BUFFER (buf, d->nb_w, int);
  // material
  o = PySequence_Fast_GET_ITEM (args, 1);
  d->nb_materials = PySequence_Size (o);
  d->materials = (P3_material**) malloc (d->nb_materials * sizeof (P3_material*));
  for (i = 0; i < d->nb_materials; i++) {
    d->materials[i] = (P3_material*) PySequence_Fast_GET_ITEM (o, i);
    if ((PyObject*) d->materials[i] == Py_None) {
      d->materials[i] = NULL;
    } else {
      Py_INCREF (d->materials[i]);
    }
  }
  // worlds
  o = PySequence_Fast_GET_ITEM (args, 2);
  Py_INCREF (o);
  d->w = (P3_children) o;
  // init
//  P3_morph_data_init (d);
  Py_INCREF (Py_None);
  return Py_None;
}
*/

static PyMethodDef PyP3MorphData_Methods[] = {
//  { "_getstate",  (PyCFunction) PyP3MorphData_GetState,  METH_NOARGS },
//  { "_setstate",  (PyCFunction) PyP3MorphData_SetState,  METH_O },
  { NULL, NULL }
};

static PyObject* PyP3MorphData_GetFaceNumber (P3_morph_data* m, void* context) {
  return PyInt_FromLong ((long) m->nb_f);
}

static PyObject* PyP3MorphData_GetMeshNumber (P3_morph_data* m, void* context) {
  return PyInt_FromLong ((long) m->nb_m);
}

PY_GET_SET_ON_OBJECT      (MorphData, P3_morph_data*, Worlds, w, PyObject*)
PY_GET_SET_ON_FLOAT_ARRAY (MorphData, P3_morph_data*, BSphere, bsphere, 4)

static PyGetSetDef PyP3MorphData_GetSets[] = {
	{ "worlds",      (getter) PyP3MorphData_GetWorlds,     (setter) PyP3MorphData_SetWorlds,  NULL },
	{ "sphere",      (getter) PyP3MorphData_GetBSphere,    (setter) PyP3MorphData_SetBSphere, NULL },
	{ "face_number", (getter) PyP3MorphData_GetFaceNumber, (setter) 0,                        NULL },
	{ "mesh_number", (getter) PyP3MorphData_GetMeshNumber, (setter) 0,                        NULL },
  { NULL }
};

PyTypeObject PyP3MorphData_Type = {
  PyObject_HEAD_INIT(NULL)
  0,
  "_soya._MorphData",
  sizeof(P3_morph_data),
  0,
  (destructor) PyP3MorphData_Dealloc,/* tp_dealloc */
  0,/* tp_print */
  0,/* tp_getattr */
  0,/* tp_setattr */
  0,/* tp_compare */
  0,/* tp_repr */
  0,/* tp_as_number */
  0,/* tp_as_sequence */
  0,/* tp_as_mapping */
  0,/* tp_hash */
  0,/* tp_call */
  0,/* tp_str */
  PYP3_GENERIC_GETATTR,/* tp_getattro */
  0,/* tp_setattro */
  0,/* tp_as_buffer */
  Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE | Py_TPFLAGS_HAVE_GC,/* tp_flags */
  0,/* tp_doc */
  (traverseproc) PyP3MorphData_Traverse,/* tp_traverse */
  (inquiry) PyP3MorphData_Clear,/* tp_clear */
  0,/* tp_richcompare */
  0,/* tp_weaklistoffset */
  0,/* tp_iter */
  0,/* tp_iternext */
  (PyMethodDef*) PyP3MorphData_Methods,/* tp_methods */
  0,/* tp_members */
  (PyGetSetDef*) PyP3MorphData_GetSets,/* tp_getset */
  0,/* tp_base */
  0,/* tp_dict */
  0,/* tp_descr_get */
  0,/* tp_descr_set */
  0,/* tp_dictoffset */
  0,//  (initproc) PyP3MorphData_Init,/* tp_init */
  PYP3_GENERIC_ALLOC,/* tp_alloc */
  (newfunc) PyP3Object_New,/* tp_new */
  PYP3_GENERIC_GC_FREE,/* tp_free */
};


/*=======*
 * MORPH *
 *=======*/

static int PyP3Morph_Init (PyObject* self, PyObject* args, PyObject* kwds) {
  PyObject* o;
  P3_morph* m;
  m = (P3_morph*) self;
  o = PySequence_Fast_GET_ITEM (args, 0);
  Py_INCREF (o);
  P3_morph_instantiate (m, (P3_morph_data*) o);
  m->worlds = PySequence_Fast_GET_ITEM (args, 1);
  if ((PyObject*) m->worlds == Py_None) { 
    m->worlds = NULL; 
  } else { 
    Py_INCREF (m->worlds); 
  }
	return 0;
}

static int PyP3Morph_Traverse (P3_morph* w, visitproc visit, void* arg) {
	int err;
  if (w->parent != NULL) {
    err = visit ((PyObject*) w->parent, arg);
    if (err) { return err; }
  }
  err = visit ((PyObject*) w->data, arg);
  if (err) { return err; }
  if (w->worlds != NULL) {
    err = visit ((PyObject*) w->worlds, arg);
    if (err) { return err; }
  }
	return 0;
}

static int PyP3Morph_Clear (P3_morph* self) {
  Py_XDECREF (self->parent);
  Py_XDECREF (self->data);
  Py_XDECREF (self->worlds);
  self->parent = NULL;
  self->data = NULL;
  self->worlds = NULL;
  return 0;
}

static void PyP3Morph_Dealloc (P3_morph* m) {
  /* morph materials are not decref cause it is not increfed cause it is managed
   * by morph_data */
  free (m->f_visibility);
  free (m->materials);
  free (m->v_c_coords);
  free (m->v_c_normals);
  free (m->f_c_normals);
  Py_XDECREF (m->data);
  Py_XDECREF (m->worlds);
  Py_XDECREF (m->parent);
  m->ob_type->tp_free ((PyObject*) m);
}

static PyObject* PyP3Morph_SetFaceVisibility (P3_morph* m, PyObject* args) {
  m->f_visibility[PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 0))] = (char) PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 1));
  Py_INCREF (Py_None);
  return Py_None;
}

//static PyObject* PyP3Morph_GetFaceVisibility (P3_morph* m, PyObject* arg) {
//  return PyInt_FromLong ((long) m->f_visibility[PyInt_AS_LONG (arg)]);
//}

static PyObject* PyP3Morph_ShowFace (P3_morph* m, PyObject* arg) {
  int i;
  i = PyInt_AS_LONG (arg);
  if (m->f_visibility[i] == P3_MORPH_INVISIBLE) {
    m->f_visibility[i] -= P3_MORPH_INVISIBLE;
  }
  Py_INCREF (Py_None);
  return Py_None;
}
static PyObject* PyP3Morph_HideFace (P3_morph* m, PyObject* arg) {
  m->f_visibility[PyInt_AS_LONG (arg)] |= P3_MORPH_INVISIBLE;
  Py_INCREF (Py_None);
  return Py_None;
}
static PyObject* PyP3Morph_EnableFace (P3_morph* m, PyObject* arg) {
  int i;
  i = PyInt_AS_LONG (arg);
  if (m->f_visibility[i] == P3_MORPH_HIDDEN) {
    m->f_visibility[i] -= P3_MORPH_HIDDEN;
  }
  Py_INCREF (Py_None);
  return Py_None;
}
static PyObject* PyP3Morph_DisableFace (P3_morph* m, PyObject* arg) {
  m->f_visibility[PyInt_AS_LONG (arg)] |= P3_MORPH_HIDDEN;
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Morph_SetMeshMaterial (P3_morph* m, PyObject* args) {
  int i;
  if (m->materials == NULL) {
    m->materials = (P3_material**) malloc (m->data->nb_materials * sizeof (P3_material*));
    for (i = 0; i < m->data->nb_materials; i++) {
      m->materials[i] = m->data->materials[i];
      Py_INCREF (m->materials[i]);
    }
  }
  i = PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 0));
  Py_XDECREF (m->materials[i]);
  m->materials[i] = (P3_material*) PySequence_Fast_GET_ITEM (args, 1);
// why ?
//  /* warning: material must NEVER be set to NULL or None */
  if ((PyObject*) m->materials[i] == Py_None) {
    m->materials[i] = NULL;
  } else {
    Py_INCREF (m->materials[i]);
  }
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Morph_GetMeshMaterial (P3_morph* m, PyObject* arg) {
  P3_material* material;
  int i;
  i = PyInt_AS_LONG (arg);
  if (m->materials == NULL) {
    material = m->data->materials[i];
  } else {
    material = m->materials[i];
  }
  if (material == NULL) {
    Py_INCREF (Py_None);
    return Py_None;
  } else {
    Py_INCREF ((PyObject*) material);
    return (PyObject*) material;
  }
}

/*
static PyObject* PyP3Morph_GetState (P3_morph* m) {
  void* buffer;
  void* buf;
  int all_size;
  PyObject* o;
  PyObject* tuple;
  int i;
  all_size = 19 * sizeof (GLfloat) + sizeof (int) + m->data->nb_f * sizeof (char);
  buffer = (void*) malloc (all_size);
  all_size /= (double) sizeof (char);
  buf = buffer;
  tuple = PyTuple_New (5);
  // coordsys
  PUT_ARRAY_IN_BUFFER (buf, m->m, 19, GLfloat);
  PUT_IN_BUFFER (buf, m->option, int);
  // visibility
  PUT_ARRAY_IN_BUFFER (buf, m->f_visibility, m->data->nb_f, char);
  PyTuple_SET_ITEM (tuple, 0, PyString_FromStringAndSize ((char*) buffer, all_size));
  free (buffer);
  // parent
//  if (m->parent == NULL) {
    Py_INCREF (Py_None);
    PyTuple_SET_ITEM (tuple, 1, Py_None);
//  } else {
//    Py_INCREF ((PyObject*) m->parent);
//    PyTuple_SET_ITEM (tuple, 1, (PyObject*) m->parent);
//  }
  // data 
  Py_INCREF ((PyObject*) m->data);
  PyTuple_SET_ITEM (tuple, 2, (PyObject*) m->data);
  // worlds
  Py_INCREF ((PyObject*) m->worlds);
  PyTuple_SET_ITEM (tuple, 3, (PyObject*) m->worlds);
  // materials
  if (m->materials == NULL) {
    Py_INCREF (Py_None);
    PyTuple_SET_ITEM (tuple, 4, Py_None);
  } else {
    o = PyTuple_New (m->data->nb_materials);
    for (i = 0; i < m->data->nb_materials; i++) {
      Py_INCREF ((PyObject*) m->materials[i]);
      PyTuple_SET_ITEM (o, i, (PyObject*) m->materials[i]);
    }
    PyTuple_SET_ITEM (tuple, 4, o);
  }
  return tuple;
}

static PyObject* PyP3Morph_SetState (P3_morph* m, PyObject* args) {
  void* buf;
  PyObject* o;
  P3_any_object* ob;
  int i;
  o = PySequence_Fast_GET_ITEM (args, 0);
  buf = (void*) PyString_AS_STRING (o);
  // coordsys
  GET_ARRAY_FROM_BUFFER (buf, m->m, 19, GLfloat);
  GET_FROM_BUFFER (buf, m->option, int);
  // data
  m->data = (P3_morph_data*) PySequence_Fast_GET_ITEM (args, 2);
  Py_INCREF ((PyObject*) m->data);
  // visibility
  GET_MALLOC_ARRAY_FROM_BUFFER (buf, m->f_visibility, m->data->nb_f, char);
  // parent
//  m->parent = (P3_coordsys*) PySequence_Fast_GET_ITEM (args, 1);
//  if ((PyObject*) m->parent == Py_None) { m->parent = NULL; } else { Py_INCREF (m->parent); }
  // worlds
  m->worlds = (P3_children) PySequence_Fast_GET_ITEM (args, 3);
  Py_INCREF ((PyObject*) m->worlds);

  for (i = 0; i < P3_children_size (m->worlds); i++) {
    ob = P3_children_get (m->worlds, i);
    PyObject_SetAttrString ((PyObject*) ob, "_parent", (PyObject*) m);
//    ((P3_coordsys*) ob)->parent = (P3_coordsys*) m;
//    Py_INCREF ((PyObject*) m);
  }

  // materials
  o = PySequence_Fast_GET_ITEM (args, 4);
  if (o == Py_None) {
    m->materials = NULL;
  } else {
    m->materials = (P3_material**) malloc (m->data->nb_materials * sizeof (P3_material*));
    for (i = 0; i < m->data->nb_materials; i++) {
      m->materials[i] = (P3_material*) PySequence_Fast_GET_ITEM (o, i);
      if ((PyObject*) m->materials[i] == Py_None) {
        m->materials[i] = NULL;
      } else {
        Py_INCREF (m->materials[i]);
      }
    }
  }
  // init
//  if (m->data->option & P3_MORPH_DATA_MIXED_ALPHA) {
    m->v_c_coords  = (GLfloat*) malloc (m->data->nb_v_coords  * 3 * sizeof (GLfloat));
    m->v_c_normals = (GLfloat*) malloc (m->data->nb_v_normals * 3 * sizeof (GLfloat));
    m->f_c_normals = (GLfloat*) malloc (m->data->nb_f         * 3 * sizeof (GLfloat));
//  } else {
//    m->v_c_coords  = NULL;
//    m->v_c_normals = NULL;
//    m->f_c_normals = NULL;
//  }
  Py_INCREF (Py_None);
  return Py_None;
}
*/

PY_GET_SET_ON_OBJECT (Morph, P3_morph*, Worlds, worlds, PyObject*)
PY_GET_SET_ON_OBJECT (Morph, P3_morph*, Data,   data,   P3_morph_data*)

static PyGetSetDef PyP3Morph_GetSets[] = {
  PYP3_CHILD_GETSETS,
  PYP3_VISIBLE_GETSETS,
  PYP3_COORDSYS_GETSETS,
  { "children",  (getter) PyP3Morph_GetWorlds, (setter) PyP3Morph_SetWorlds, NULL },
  { "data",      (getter) PyP3Morph_GetData,   (setter) PyP3Morph_SetData,   NULL },
  { NULL }
};

static PyMethodDef PyP3Morph_Methods[] = {
  PYP3_COORDSYS_FUNCS,
  { "set_face_visible", (PyCFunction) PyP3Morph_SetFaceVisibility, METH_VARARGS }, 
  { "show_face",        (PyCFunction) PyP3Morph_ShowFace,          METH_O }, 
  { "hide_face",        (PyCFunction) PyP3Morph_HideFace,          METH_O }, 
  { "enable_face",      (PyCFunction) PyP3Morph_EnableFace,        METH_O }, 
  { "disable_face",     (PyCFunction) PyP3Morph_DisableFace,       METH_O }, 
  { "get_material",     (PyCFunction) PyP3Morph_GetMeshMaterial,   METH_O }, 
  { "set_material",     (PyCFunction) PyP3Morph_SetMeshMaterial,   METH_VARARGS }, 
//  { "_getstate",        (PyCFunction) PyP3Morph_GetState,          METH_NOARGS },
//  { "_setstate",        (PyCFunction) PyP3Morph_SetState,          METH_O },
  { NULL, NULL }
};

PyTypeObject PyP3Morph_Type = {
  PyObject_HEAD_INIT(NULL)
  0,
  "_soya._Morph",
  sizeof(P3_morph),// + PyGC_HEAD_SIZE,
  0,
  (destructor) PyP3Morph_Dealloc,/* tp_dealloc */
  0,/* tp_print */
  0,/* tp_getattr */
  0,/* tp_setattr */
  0,/* tp_compare */
  0,/* tp_repr */
  0,/* tp_as_number */
  0,/* tp_as_sequence */
  0,/* tp_as_mapping */
  0,/* tp_hash */
  0,/* tp_call */
  0,/* tp_str */
  PYP3_GENERIC_GETATTR,/* tp_getattro */
  0,/* tp_setattro */
  0,/* tp_as_buffer */
  Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE | Py_TPFLAGS_HAVE_GC,/* tp_flags */
  0,/* tp_doc */
  (traverseproc) PyP3Morph_Traverse,/* tp_traverse */
  (inquiry) PyP3Morph_Clear,/* tp_clear */
  0,/* tp_richcompare */
  0,/* tp_weaklistoffset */
  0,/* tp_iter */
  0,/* tp_iternext */
  (PyMethodDef*) PyP3Morph_Methods,/* tp_methods */
  0,/* tp_members */
  (PyGetSetDef*) PyP3Morph_GetSets,/* tp_getset */
  0,/* tp_base */
  0,/* tp_dict */
  0,/* tp_descr_get */
  0,/* tp_descr_set */
  0,/* tp_dictoffset */
  (initproc) PyP3Morph_Init,/* tp_init */
  PYP3_GENERIC_ALLOC,/* tp_alloc */
  (newfunc) PyP3Object_New,/* tp_new */
  PYP3_GENERIC_GC_FREE,/* tp_free */
};

