/*
 * P3 python wrapper
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*****************************************
 * Copyright (C) 2002 Bertrand 'blam' LAMY
 *****************************************/

static PyObject* PyP3GL_ClearWithColor (PyObject* module, PyObject* color) {
  glClearColor ((GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (color, 0)), 
                (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (color, 1)), 
                (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (color, 2)), 
                (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (color, 3)));
  /* some OpenGL doesn't clear depth buffer if it is not used */
  glDepthMask (GL_TRUE);
  glEnable (GL_DEPTH_TEST);
  glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  glDepthMask (GL_FALSE);
  glDisable (GL_DEPTH_TEST);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3GL_GenList (PyObject* module) {
  GLuint i;
  i = glGenLists (1);
  return PyInt_FromLong ((long) i);
}

static PyObject* PyP3GL_NewList (PyObject* module, PyObject* arg) {
  glNewList (PyInt_AS_LONG (arg), GL_COMPILE);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3GL_EndList (PyObject* module) {
  glEndList ();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3GL_CallList (PyObject* module, PyObject* arg) {
  glCallList (PyInt_AS_LONG (arg));
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3GL_DeleteList (PyObject* module, PyObject* arg) {
  glDeleteLists (PyInt_AS_LONG (arg), 1);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3GL_PointSize (PyObject* module, PyObject* arg) {
  glPointSize ((GLfloat) PyFloat_AS_DOUBLE (arg));
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3GL_LineWidth (PyObject* module, PyObject* arg) {
  glLineWidth ((GLfloat) PyFloat_AS_DOUBLE (arg));
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3GL_Enable (PyObject* module, PyObject* arg) {
  glEnable (PyInt_AS_LONG (arg));
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3GL_Disable (PyObject* module, PyObject* arg) {
  glDisable (PyInt_AS_LONG (arg));
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3GL_LightModeli (PyObject* module, PyObject* args) {
  glLightModeli (PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 0)), 
                 PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 1)));
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3GL_Begin (PyObject* module, PyObject* arg) {
  glBegin (PyInt_AS_LONG (arg));
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3GL_End (PyObject* module) {
  glEnd ();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3GL_Vertex2i (PyObject* module, PyObject* arg) {
  glVertex2i ((GLint) PyInt_AS_LONG (PySequence_Fast_GET_ITEM (arg, 0)),
              (GLint) PyInt_AS_LONG (PySequence_Fast_GET_ITEM (arg, 1)));
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3GL_Vertex2f (PyObject* module, PyObject* arg) {
  glVertex2f ((GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 0)),
              (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 1)));
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3GL_Vertex3f (PyObject* module, PyObject* arg) {
  glVertex3f ((GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 0)),
              (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 1)),
              (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 2)));
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3GL_Vertex4f (PyObject* module, PyObject* arg) {
  glVertex4f ((GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 0)),
              (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 1)),
              (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 2)),
              (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 3)));
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3GL_Normal3f (PyObject* module, PyObject* arg) {
  glNormal3f ((GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 0)),
              (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 1)),
              (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 2)));
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3GL_Color4f (PyObject* module, PyObject* arg) {
  glColor4f ((GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 0)),
             (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 1)),
             (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 2)),
             (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 3)));
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3GL_TexCoord2f (PyObject* module, PyObject* arg) {
  glTexCoord2f ((GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 0)),
                (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 1)));
  Py_INCREF (Py_None);
  return Py_None;
}

