/*
 * P3
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**********************************************
 * morph_build.c
 * Copyright (C) 2001-2002 Bertrand 'blam' LAMY
 **********************************************/

#if 0


#include "p3_base.h"
#include "math3d.h"
#include "util.h"
#include "coordsys.h"
#include "world.h"
//#include "mesh_build.h"
#include "morph.h"

#ifdef COMPILE_FOR_PYTHON
#include "python/face_python.h"
#endif /* COMPILE_FOR_PYTHON */

extern P3_class P3_class_morph_mesh;
/* internal prototypes */
int P3_face_get_option (P3_face* f1);


int P3_morph_data_index_coord (P3_morph_data* data, GLfloat x, GLfloat y, GLfloat z, int has_normal) {
  GLfloat* ip;
  int i;
  /* look for the given coordinates value in the data */
  for (i = 0; i < data->nb_v_coords; i++) {
    ip = data->v_coords + i * 3;
    if (fabs (ip[0] - x) < P3_EPSILON && fabs (ip[1] - y) < P3_EPSILON && fabs (ip[2] - z) < P3_EPSILON) { 
      return i * 3; 
    }
  }
  /* add the given value to the data */
  i = data->nb_v_coords * 3;
  (data->nb_v_coords)++;
  data->v_coords = (GLfloat*) realloc (data->v_coords, data->nb_v_coords * 3 * sizeof (GLfloat));
  data->v_coords[i]     = x;
  data->v_coords[i + 1] = y;
  data->v_coords[i + 2] = z;
  if (has_normal == P3_TRUE) {
    data->nb_v_normals = data->nb_v_coords;
    data->v_normals = (GLfloat*) realloc (data->v_normals, data->nb_v_normals * 3 * sizeof (GLfloat));
    data->v_normals[i]     = 0.0;
    data->v_normals[i + 1] = 0.0;
    data->v_normals[i + 2] = 0.0;
  }
  return i;
}

int P3_morph_data_index_texcoord (P3_morph_data* data, GLfloat u, GLfloat v) {
  GLfloat* ip;
  int i;
  /* look for the given texture coordinates value in the data */
  for (i = 0; i < data->nb_v_texcoords; i++) {
    ip = data->v_texcoords + i * 2;
    if (fabs (ip[0] - u) < P3_EPSILON && fabs (ip[1] - v) < P3_EPSILON) { return i * 2; }
  }
  /* add the given value to the data */
  i = data->nb_v_texcoords * 2;
  (data->nb_v_texcoords)++;
  data->v_texcoords = (GLfloat*) realloc (data->v_texcoords, data->nb_v_texcoords * 2 * sizeof (GLfloat));
  data->v_texcoords[i]     = u;
  data->v_texcoords[i + 1] = v;
  return i;
}

int P3_morph_data_index_color (P3_morph_data* data, GLfloat r, GLfloat g, GLfloat b, GLfloat a) {
  GLfloat* ip;
  int i;
  /* look for the given color value in the data */
  for (i = 0; i < data->nb_v_colors; i++) {
    ip = data->v_colors + i * 4;
    if (fabs (ip[0] - r) < P3_EPSILON && fabs (ip[1] - g) < P3_EPSILON && fabs (ip[2] - b) < P3_EPSILON && fabs (ip[3] - a) < P3_EPSILON) { return i * 4; }
  }
  /* add the given value to the data */
  i = data->nb_v_colors * 4;
  (data->nb_v_colors)++;
  data->v_colors = (GLfloat*) realloc (data->v_colors, data->nb_v_colors * 4 * sizeof (GLfloat));
  data->v_colors[i]     = r;
  data->v_colors[i + 1] = g;
  data->v_colors[i + 2] = b;
  data->v_colors[i + 3] = a;
  return i;
}

int P3_morph_data_index_vertex (P3_morph_data* data, int coord, int texcoord, int color, int world) {
  P3_morph_vertex* v;
  int i;
  /* look for the given vertex in the data */
  for (i = 0; i < data->nb_v; i++) {
    v = data->v + i;
    if (coord == v->coord && texcoord == v->texcoord && color == v->color && world == v->world) { return i; }
  }
  /* add the given vertex to the data */
  i = data->nb_v;
  (data->nb_v)++;
  data->v = (P3_morph_vertex*) realloc (data->v, data->nb_v * sizeof (P3_morph_vertex));
  v = data->v + i;
  v->coord = coord;
  v->texcoord = texcoord;
  v->color = color;
  v->world = world;
  v->option = 0;
  return i;
}

int P3_morph_data_index_material (P3_morph_data* d, P3_material* m) {
  int i;
  for (i = 0; i < d->nb_materials; i++) {
    if (d->materials[i] == m) { return i; }
  }
  i = d->nb_materials;
  (d->nb_materials)++;
  d->materials = (P3_material**) realloc (d->materials, d->nb_materials * sizeof (P3_material*));
  P3_material_incref (m);
  d->materials[i] = m;
  return i;
}

P3_morph_data* P3_morph_data_new (P3_morph_data* d) {
  if (d == NULL) {
    d = (P3_morph_data*) malloc (sizeof (P3_morph_data));
  }
  d->nb_v = 0;
  d->v = NULL;
  d->nb_v_coords = 0;
  d->nb_v_texcoords = 0;
  d->nb_v_normals = 0;
  d->nb_v_colors = 0;
  d->v_coords = NULL;
  d->v_texcoords = NULL;
  d->v_normals = NULL;
  d->v_colors = NULL;
//  d->v_c_coords = NULL;
//  d->v_c_normals = NULL;
  d->nb_f = 0;
  d->f = NULL;
  d->f_normals = NULL;
//  d->f_c_normals = NULL;
  d->nb_m = 0;
  d->meshes = NULL;
  d->nb_materials = 0;
  d->materials = NULL;
  d->nb_w = 0;
  d->w = NULL;
//  d->w_struct_size = 0;
//  d->w_struct = NULL;
  d->option = 0;
//  d->nb_anims = 0;
//  d->anims = NULL;
  return d;
}

int P3_morph_data_register_vertex (P3_morph_data* data, P3_vertex* vertex, int face_option, P3_list* worlds) {
  P3_morph_vertex* v;
  int v_index;
  int tv[4] = { -1, -1, -1, -1}; /* coord, texcoord, color, world */
  if (face_option & P3_R_SMOOTHLIT) { 
    tv[0] = P3_morph_data_index_coord (data, P3_vertex_get_x (vertex), P3_vertex_get_y (vertex), P3_vertex_get_z (vertex), P3_TRUE);
  } else {
    tv[0] = P3_morph_data_index_coord (data, P3_vertex_get_x (vertex), P3_vertex_get_y (vertex), P3_vertex_get_z (vertex), P3_FALSE);
  }
  if (face_option & P3_R_TEXTURED) {
    tv[1] = P3_morph_data_index_texcoord (data, P3_vertex_get_u (vertex), P3_vertex_get_v (vertex));
  }
  if (face_option & P3_R_COLORED) {
    tv[2] = P3_morph_data_index_color (data, P3_vertex_get_r (vertex), P3_vertex_get_g (vertex), P3_vertex_get_b (vertex), P3_vertex_get_a (vertex));
  }
  tv[3] = P3_list_find (worlds, P3_vertex_get_coordsys (vertex));
  /* search for 'vertex' tv */
  v_index = P3_morph_data_index_vertex (data, tv[0], tv[1], tv[2], tv[3]);
  v = data->v + v_index;
  /* option is mainly computed by the face */
  if (face_option & P3_R_SMOOTHLIT) { v->option |= P3_MORPH_HAS_NORMAL; }
  return v_index;
}

void P3_morph_data_register_face (P3_morph_data* data, P3_face* face, P3_list* worlds) {
  P3_morph_face* f;
  P3_morph_vertex* v;
  P3_coordsys* base_c;
  GLfloat vc[9];
//  GLfloat* p;
//  int has_normal;
  int opt;
  int n;
  int i;
  int j;
  /* create a new face */
  n = data->nb_f;
  (data->nb_f)++;
  data->f = (P3_morph_face*) realloc (data->f, data->nb_f * sizeof (P3_morph_face));
  f = data->f + n;
  /* world */
  base_c = P3_face_get_coordsys (face);
  f->world = P3_list_find (worlds, base_c);
  /* compute option */
  f->option = 0;
  if (f->nb_v > 2) { f->option |= P3_MORPH_HAS_NORMAL; }
  if (P3_face_is_smoothlit (face) && f->option & P3_MORPH_HAS_NORMAL) { f->option |= P3_MORPH_SMOOTHLIT; }
//  for (i = 0; i < f->nb_v; i++) {
//    v = data->v + f->v[i];
//    if (v->option & P3_MORPH_MORPHING_NORMAL) { f->option |= P3_MORPH_HAS_VERTEX_WITH_MORPHING_NORMAL; }
//    if (v->world != f->world) { f->option |= P3_MORPH_MORPHING_NORMAL; }
//  }
  /* vertices */
/*
  if (f->option & P3_MORPH_SMOOTHLIT) {
    has_normal = P3_TRUE;
  } else {
    has_normal = P3_FALSE;
  }
*/
  f->nb_v = P3_face_get_vertices_number(face);
  f->v = (int*) malloc (f->nb_v * sizeof (int));
  opt = P3_face_get_option (face);
  for (i = 0; i < f->nb_v; i++) {
    f->v[i] = P3_morph_data_register_vertex (data, P3_face_get_vertex (face, i), opt, worlds);
//    f->v[i] = P3_morph_data_register_vertex (data, P3_face_get_vertex (face, i), has_normal, worlds);
  }
  if (f->option & P3_MORPH_SMOOTHLIT) { 
    for (i = 0; i < f->nb_v; i++) {
      v = data->v + f->v[i];
      if (v->world != f->world) {
        /* 1 vertex is morphing and face is smoothlit -> all face vertices have a morphing normal */
        for (j = 0; j < f->nb_v; j++) {
          v = data->v + f->v[j];
          if (v->option & P3_MORPH_HAS_NORMAL) { v->option |= P3_MORPH_MORPHING_NORMAL; }
        }
        break;
      }
    }
  }
  /* assign normal */
  if (f->option & P3_MORPH_HAS_NORMAL) {
    f->normal = n * 3;
// ???
//    data->f_c_normals = (GLfloat*) realloc (data->f_c_normals, data->nb_f * 3 * sizeof (GLfloat));
    if (!(f->option & P3_MORPH_MORPHING_NORMAL)) {
      data->f_normals = (GLfloat*) realloc (data->f_normals, data->nb_f * 3 * sizeof (GLfloat));
//      p =  P3_coordsys_get_inverted_root_matrix (base_c);
      v = data->v + f->v[0];
      memcpy (vc, data->v_coords + v->coord, 3 * sizeof (GLfloat));
      if (v->world != -1) {
        P3_point_by_matrix (vc, P3_coordsys_get_root_matrix ((P3_coordsys*) P3_list_get (worlds, v->world)));
      }
//      P3_point_by_matrix_copy (vc, data->v_coords + v->coord, P3_coordsys_get_root_matrix ((P3_coordsys*) P3_list_get (worlds, v->world)));
//      P3_point_by_matrix      (vc, p);
      v = data->v + f->v[1];
      memcpy (vc + 3, data->v_coords + v->coord, 3 * sizeof (GLfloat));
      if (v->world != -1) {
        P3_point_by_matrix (vc + 3, P3_coordsys_get_root_matrix ((P3_coordsys*) P3_list_get (worlds, v->world)));
      }
//      P3_point_by_matrix_copy (vc + 3, data->v_coords + v->coord, P3_coordsys_get_root_matrix ((P3_coordsys*) P3_list_get (worlds, v->world)));
//      P3_point_by_matrix      (vc + 3, p);
      v = data->v + f->v[2];
      memcpy (vc + 6, data->v_coords + v->coord, 3 * sizeof (GLfloat));
      if (v->world != -1) {
        P3_point_by_matrix (vc + 6, P3_coordsys_get_root_matrix ((P3_coordsys*) P3_list_get (worlds, v->world)));
      }
//      P3_point_by_matrix_copy (vc + 6, data->v_coords + v->coord, P3_coordsys_get_root_matrix ((P3_coordsys*) P3_list_get (worlds, v->world)));
//      P3_point_by_matrix      (vc + 6, p);
      P3_face_normal (data->f_normals + f->normal, vc + 3, vc, vc + 6);
    }
  } else {
    f->normal = -1;
  }
}

void P3_morph_face_compute_option (P3_morph_data* data, P3_morph_face* face) {
  P3_morph_vertex* v;
  int i;
  for (i = 0; i < face->nb_v; i++) {
    v = data->v + face->v[i];
    if (face->option & P3_MORPH_HAS_NORMAL) {
      if (v->world != face->world) {
        face->option |= P3_MORPH_MORPHING_NORMAL;
      }
      if (face->option & P3_MORPH_SMOOTHLIT && v->option & P3_MORPH_MORPHING_NORMAL) {
        face->option |= P3_MORPH_HAS_VERTEX_WITH_MORPHING_NORMAL;
      }
    }
  }
}

#define P3_option_equal(ptr1, ptr2, opt) \
  ((ptr1 & opt && ptr2 & opt) || (!(ptr1 & opt) && !(ptr2 & opt)))

int P3_morph_face_compatible (P3_morph_face* f1, P3_morph_face* f2) {
  if (f1->nb_v == f2->nb_v) {
    return P3_TRUE;
  } else {
    return P3_FALSE;
  }
}

void P3_morph_data_create_mesh (P3_morph_data* data, P3_morph_face** faces, int nb_faces, P3_material* material, int option) {
  P3_morph_mesh* m;
  int n;
  int i;
  n = data->nb_m;
  (data->nb_m)++;
  data->meshes = (P3_morph_mesh*) realloc (data->meshes, data->nb_m * sizeof (P3_morph_mesh));
  m = data->meshes + n;
  m->class = &P3_class_morph_mesh;
  m->option = option;
  if (material == NULL) {
    m->material = -1;
  } else {
    m->material = P3_morph_data_index_material (data, material);
  }
  m->nb_f = nb_faces;
  m->f = (int*) malloc (m->nb_f * sizeof (int));
  for (i = 0; i < nb_faces; i++) {
    /* we use the pointer value to get the index ;) */
    m->f[i] = (int) (faces[i] - data->f);
//    m->f[i] = (int) (faces[i] - data->f) / sizeof (P3_morph_face);
  }
}

void P3_morph_data_create_meshes (P3_morph_data* data, P3_list* materials, int* options) {
  P3_list* faces;
  P3_list* list;
  P3_morph_face* ref;
  P3_morph_face* f;
  int i;
  /* add all the faces of data into a list for more convenience */
  faces = P3_list_new (data->nb_f);
  for (i = 0; i < data->nb_f; i++) {
// TO DO ok? -> WARNING !!!
    P3_list_add (faces, data->f + i);
//    P3_list_add (faces, data->f + i * sizeof (P3_morph_face));
  }
  /* find compatible faces */
  list = P3_list_new (20);
  while (faces->nb > 0) {
    list->nb = 0;
    ref = (P3_morph_face*) P3_list_get (faces, 0);
    P3_list_add (list, ref);
    i = 1;
    while (i < faces->nb) {
      f = (P3_morph_face*) P3_list_get (faces, i);
      if (P3_list_get (materials, 0) == P3_list_get (materials, i) 
          && P3_morph_face_compatible (ref, f) == P3_TRUE
          && P3_option_equal (options[0], options[i], P3_R_NEVER_LIT)
          && P3_option_equal (options[0], options[i], P3_R_FRONT_AND_BACK)) {
        P3_list_add (list, f);
        P3_list_remove (faces, i);
        P3_list_remove (materials, i);
      } else {
        i++;
      }
    }
    /* create a mesh with collected faces */
    P3_morph_data_create_mesh (data, (P3_morph_face**) list->content, list->nb, (P3_material*) P3_list_get (materials, 0), options[0]);
    P3_list_remove (faces, 0);
    P3_list_remove (materials, 0);
  }
  /* clean */
  P3_list_dealloc (list);
  P3_list_dealloc (faces);
}

P3_morph_data* P3_morph_data_from_world (P3_morph_data* data, P3_world* world) {
  P3_list* coordsys;
  P3_list* faces;
  P3_list* faces_material;
  int* faces_option;
  P3_list* list;
  P3_face* face;
  P3_vertex* vertex;
  P3_coordsys* face_c;
  int broken;
  int i;
  int j;
  if (data == NULL) { data = P3_morph_data_new (NULL); }
  /* collect all sub-worlds or volumes */
  coordsys = P3_list_new (20);
//  P3_list_add (coordsys, world);
  P3_world_extract (world, P3_ID_VOLUME, coordsys);
  P3_world_extract (world, P3_ID_WORLD,  coordsys);
  data->nb_w = coordsys->nb;
  /* make a copy of worlds hierarchy */
  data->w = P3_children_new (data->nb_w);
  for (i = 0; i < data->nb_w; i++) {
    P3_children_add (data->w, P3_list_get (coordsys, i));
  }
  /* collect faces */
  faces = P3_list_new (50);
  P3_world_extract (world, P3_ID_FACE, faces);

printf ("begin morph creation (%i coordsys)\n", coordsys->nb);

  /* index smoothlit vertices (to be indexed first) */
  for (i = 0; i < faces->nb; i++) {
    face = (P3_face*) P3_list_get (faces, i);
    if (P3_face_is_smoothlit (face)) {
      for (j = 0; j < P3_face_get_vertices_number (face); j++) {
        vertex = P3_face_get_vertex (face, j);
        P3_morph_data_index_coord (data, P3_vertex_get_x (vertex), P3_vertex_get_y (vertex), P3_vertex_get_z (vertex), P3_TRUE);
//        P3_morph_data_register_vertex (data, P3_face_get_vertex (face, j), P3_TRUE, coordsys);
      }
    }
  }

printf ("...registering %i faces\n", faces->nb);

  /* index face. the ones with morphing normal last */
  faces_material = P3_list_new (faces->nb);
  faces_option = (int*) malloc (faces->nb * sizeof (int));
  list = P3_list_new (30);
  for (i = 0; i < faces->nb; i++) {
    face = (P3_face*) P3_list_get (faces, i);
    face_c = P3_face_get_coordsys (face);
    broken = P3_FALSE;
    for (j = 0; j < P3_face_get_vertices_number (face); j++) {
      vertex = P3_face_get_vertex (face, j);
      if (P3_vertex_is_morphing (vertex) || P3_vertex_get_coordsys (vertex) != face_c) {
        broken = P3_TRUE;
        break;
      }
    }
    if (broken == P3_TRUE) {
      P3_list_add (list, face);
    } else {
      P3_morph_data_register_face (data, face, coordsys);
      faces_option[faces_material->nb] = P3_face_get_option (face);
      P3_list_add (faces_material, P3_face_get_material (face));
    }
  }
  for (i = 0; i < list->nb; i++) {
    face = (P3_face*) P3_list_get (list, i);
    P3_morph_data_register_face (data, face, coordsys);
    faces_option[faces_material->nb] = P3_face_get_option (face);
    P3_list_add (faces_material, P3_face_get_material (face));
  }
  for (i = 0; i < faces->nb; i++) {
    P3_morph_face_compute_option (data, data->f + i);
  }
//printf ("...creating morphing meshes\n");

  /* create meshes */
  P3_morph_data_create_meshes (data, faces_material, faces_option);
//  P3_morph_data_init (data);

// TO DO compute major option

  /* clean */
  P3_list_dealloc (list);
  P3_list_dealloc (coordsys);
  P3_list_dealloc (faces);
  P3_list_dealloc (faces_material);
  free (faces_option);

printf ("...morph data finalized (%i mesh)\n", data->nb_m);

  return data;
}

#endif
