/*
 * P3
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**********************************************
 * light.h
 * Copyright (C) 2001-2003 Bertrand 'blam' LAMY
 **********************************************/


int       P3_light_get_id          (void);
void      P3_disable_all_lights    (void);
void      P3_disable_deep_lights   (void);
//void      P3_static_lights_off     (void);
//void      P3_static_lights_on      (void);

P3_light* P3_light_new                (P3_light*);
void      P3_light_batch              (P3_light*, P3_instance*);
void      P3_light_render             (P3_light*, P3_instance*);
void      P3_light_compute_radius     (P3_light*);
GLfloat   P3_light_get_spotlight_at   (P3_light*, GLfloat[3]);
GLfloat   P3_light_get_attenuation_at (P3_light*, GLfloat[3]);
void      P3_light_get_color_at       (P3_light*, GLfloat position[3], GLfloat* normal, int shadow, GLfloat result[4]);
int       P3_light_get_shadow_at      (P3_light*, GLfloat position[3]);
void      P3_light_cast_into          (P3_light*, P3_coordsys*);
void      P3_light_list_cast_into     (P3_list*,  P3_coordsys*);
void      P3_light_get_data           (P3_light*, P3_chunk*);
void      P3_light_set_data           (P3_light*, P3_chunk*);

/*
void      P3_light_look_at         (P3_light*, GLfloat[3]);
void      P3_light_rotate_lateral  (P3_light*, GLfloat);
void      P3_light_rotate_vertical (P3_light*, GLfloat);
void      P3_light_rotate_incline  (P3_light*, GLfloat);
void      P3_light_rotate_axe      (P3_light*, GLfloat, GLfloat, GLfloat, GLfloat);
void      P3_light_rotate          (P3_light*, GLfloat, GLfloat[3], GLfloat[3]);
*/
