/*
 * P3
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*****************************************
 * fx.c
 * Copyright (C) 2003 Bertrand 'blam' LAMY
 *****************************************/

#include "p3_base.h"
#include "util.h"
#include "mesh.h"
#include "fx.h"

extern P3_list* fx_color_faders;
//extern P3_list* fx_colors;
extern float delta_time;
extern int engine_option;


/*===========+
 | FX COLORS |
 +===========*/

// TO DO ???
/*
GLfloat* P3_fx_register_color (GLfloat color[4]) {
  GLfloat* c;
  int i;
  for (i = 0; i < fx_colors->nb; i++) {
    c = (GLfloat*) P3_list_get (fx_colors, i);
    if (fabs (c[0] - color[0]) < P3_EPSILON && 
        fabs (c[1] - color[1]) < P3_EPSILON && 
        fabs (c[2] - color[2]) < P3_EPSILON && 
        fabs (c[3] - color[3]) < P3_EPSILON) return c;
  }
  c = (GLfloat*) malloc (4 * sizeof (GLfloat));
  memcpy (c, color, 4 * sizeof (GLfloat));
  P3_list_add (fx_colors, c);
  return c;
}
*/

/*=================+
 | FX FADING COLOR |
 +=================*/

GLfloat* P3_fx_get_color_fader (GLfloat* from, GLfloat* to, float duration, P3_list* local_faders,
                                void (*callback) (P3_fx_color_fader*, P3_fx_transition_data*), P3_fx_transition_data* callback_data) {
  P3_fx_color_fader* fader;
  int i;
  if (local_faders != NULL) {
    for (i = 0; i < local_faders->nb; i++) {
      fader = (P3_fx_color_fader*) P3_list_get (local_faders, i);
      if (fader->from == from && fader->to == to) return fader->color;
    }
  }
  fader = (P3_fx_color_fader*) malloc (sizeof (P3_fx_color_fader));
  fader->from = from;
  fader->to = to;
  fader->percent = 0.0;
  fader->time_factor = 1.0 / duration;
  fader->callback = callback;
  fader->callback_data = callback_data;
  memcpy (fader->color, from, 4 * sizeof (GLfloat));
  P3_list_add (fx_color_faders, fader);
  if (local_faders != NULL) P3_list_add (local_faders, fader);
  return fader->color;
}

static void P3_fx_color_fader_free_callback_data (P3_fx_transition_data* data) {
  P3_fx_color_fader* fader;
  int i;
  for (i = 0; i < fx_color_faders->nb; i++) {
    fader = (P3_fx_color_fader*) P3_list_get (fx_color_faders, i);
    if (fader->callback_data == data) return;
  }
  P3_drop_chunk (data->chunk);
/*
  if (*((char*) data) == P3_FX_CALLBACK_DATA_ID_MESH) {
    P3_chunk_dealloc (((struct P3_mesh_fx_transition_data*) data)->chunk);
  } else {
    free (data);
  }
*/
}

void P3_fx_advance_time (void) {
  P3_fx_color_fader* fader;
  GLfloat f;
  int i = 0;

// HACK TO DO now
  if (delta_time == 0.0) delta_time = 1.0;

  while (i < fx_color_faders->nb) {
    fader = (P3_fx_color_fader*) P3_list_get (fx_color_faders, i);
    fader->percent += fader->time_factor * delta_time;
    if (fader->percent >= 1.0) {
      fader->callback (fader, fader->callback_data);
      P3_list_remove (fx_color_faders, i);
      P3_fx_color_fader_free_callback_data (fader->callback_data);
      free (fader);
    } else {
      f = 1.0 - fader->percent;
      fader->color[0] = fader->from[0] * f + fader->to[0] * fader->percent;
      fader->color[1] = fader->from[1] * f + fader->to[1] * fader->percent;
      fader->color[2] = fader->from[2] * f + fader->to[2] * fader->percent;
      fader->color[3] = fader->from[3] * f + fader->to[3] * fader->percent;
      i++;
    }
  }
}


/*===========+
 | FX EFFECT |
 +===========*/

P3_fx_transition_data* P3_fx_transition_data_new (P3_fx* fx) {
  P3_fx_transition_data* data = (P3_fx_transition_data*) malloc (sizeof (P3_fx_transition_data));
  data->chunk = P3_get_chunk ();
  data->vertex_warfogs = fx->vertex_warfogs;
  data->vertex_colors  = fx->vertex_colors;
  data->vertex_options = fx->vertex_options;
  return data;
}

void P3_fx_set_color (P3_fx* fx, int index) {
  if (fx->vertex_warfogs[index] != fx->color) {
    fx->vertex_warfogs[index] = fx->color;
    if (1.0 - fx->color[3] > P3_EPSILON) {
      /* alpha */
      fx->vertex_options[index] |= P3_VERTEX_ALPHA;
      if (fx->color[3] < P3_EPSILON) {
        fx->vertex_options[index] |= P3_VERTEX_INVISIBLE;
      } else {
        fx->vertex_options[index] &= ~P3_VERTEX_INVISIBLE;
      }
    } else {
      fx->vertex_options[index] &= ~(P3_VERTEX_ALPHA | P3_VERTEX_INVISIBLE);
    }
  }
}

void P3_fx_set_alpha (P3_fx* fx, int index) {
  GLfloat* color;
  GLfloat buf[4];
  color = fx->vertex_warfogs[index];
  if (fabs (color[3] - fx->alpha) > P3_EPSILON) {
    memcpy (buf, color, 3 * sizeof (GLfloat));
    buf[3] = fx->alpha;
    color = fx->register_color (fx->obj, buf);
    fx->vertex_warfogs[index] = color;
    if (1.0 - fx->alpha > P3_EPSILON) {
      /* alpha */
      fx->vertex_options[index] |= P3_VERTEX_ALPHA;
      if (fx->alpha < P3_EPSILON) {
        fx->vertex_options[index] |= P3_VERTEX_INVISIBLE;
      } else {
        fx->vertex_options[index] &= ~P3_VERTEX_INVISIBLE;
      }
    } else {
      fx->vertex_options[index] &= ~(P3_VERTEX_ALPHA | P3_VERTEX_INVISIBLE);
    }
  }
}

void P3_fx_restore (P3_fx* fx, int index) {
  if (fx->vertex_colors != NULL) {
    GLfloat* color = fx->vertex_colors[index];
    fx->vertex_warfogs[index] = color;
    if (1.0 - color[3] > P3_EPSILON) {
      /* alpha */
      fx->vertex_options[index] |= P3_VERTEX_ALPHA;
      if (color[3] < P3_EPSILON) {
        fx->vertex_options[index] |= P3_VERTEX_INVISIBLE;
      } else {
        fx->vertex_options[index] &= ~P3_VERTEX_INVISIBLE;
      }
    } else {
      fx->vertex_options[index] &= ~(P3_VERTEX_ALPHA | P3_VERTEX_INVISIBLE);
    }
  } else {
    fx->vertex_warfogs[index] = fx->color;
    fx->vertex_options[index] &= ~(P3_VERTEX_ALPHA | P3_VERTEX_INVISIBLE);
  }
}

void P3_fx_end_transition (P3_fx_color_fader* fader, P3_fx_transition_data* data) {
  int* ptr;
  int* max;
  int t;
  ptr = (int*) data->chunk->content;
  max = (int*) (data->chunk->content + data->chunk->nb);
  while (ptr < max) {
    t = *ptr;
    data->vertex_warfogs[t] = fader->to;
    data->vertex_options[t] &= ~P3_VERTEX_FX_TRANSITION;
    if (1.0 - fader->to[3] < P3_EPSILON) {
      data->vertex_options[t] &= ~P3_VERTEX_ALPHA;
    } else if (fader->to[3] < P3_EPSILON) {
      data->vertex_options[t] |= P3_VERTEX_INVISIBLE;
    }
    ptr++;
  }
}

void P3_fx_transition_color (P3_fx* fx, int index) {
  if (!(fx->vertex_options[index] & P3_VERTEX_FX_TRANSITION) && fx->vertex_warfogs[index] != fx->color) {
    fx->vertex_warfogs[index] = P3_fx_get_color_fader (fx->vertex_warfogs[index], fx->color, fx->duration, fx->list, P3_fx_end_transition, fx->data);
    P3_chunk_add_int (fx->data->chunk, index);
    if (1.0 - fx->color[3] > P3_EPSILON) {
      /* alpha */
      fx->vertex_options[index] |= P3_VERTEX_ALPHA;
    }
    if (fx->color[3] > P3_EPSILON) {
      fx->vertex_options[index] &= ~P3_VERTEX_INVISIBLE;
    }
    fx->vertex_options[index] |= P3_VERTEX_FX_TRANSITION;
  }
}

void P3_fx_transition_alpha (P3_fx* fx, int index) {
  GLfloat* color;
  GLfloat buf[4];
  int i;
  color = fx->vertex_warfogs[index];
  if (!(fx->vertex_options[index] & P3_VERTEX_FX_TRANSITION) && fabs (color[3] - fx->alpha) > P3_EPSILON) {
    memcpy (buf, color, 3 * sizeof (GLfloat));
    buf[3] = fx->alpha;
    color = fx->register_color (fx->obj, buf);
    fx->vertex_warfogs[index] = P3_fx_get_color_fader (fx->vertex_warfogs[index], color, fx->duration, fx->list, P3_fx_end_transition, fx->data);
    P3_chunk_add_int (fx->data->chunk, index);
    if (1.0 - fx->alpha > P3_EPSILON) {
      /* alpha */
      fx->vertex_options[index] |= P3_VERTEX_ALPHA;
    }
    if (fx->alpha > P3_EPSILON) {
      fx->vertex_options[index] &= ~P3_VERTEX_INVISIBLE;
    }
    fx->vertex_options[index] |= P3_VERTEX_FX_TRANSITION;
  }
}

void P3_fx_end_restore (P3_fx_color_fader* fader, P3_fx_transition_data* data) {
  GLfloat* color;
  int* ptr;
  int* max;
  int t;
  ptr = (int*) data->chunk->content;
  max = (int*) (data->chunk->content + data->chunk->nb);
  while (ptr < max) {
    t = *ptr;
    color = data->vertex_colors[t];
    data->vertex_warfogs[t] = color;
    data->vertex_options[t] &= ~P3_VERTEX_FX_TRANSITION;
    if (1.0 - color[3] < P3_EPSILON) {
      data->vertex_options[t] &= ~P3_VERTEX_ALPHA;
    } else if (color[3] < P3_EPSILON) {
      data->vertex_options[t] |= P3_VERTEX_INVISIBLE;
    }
    ptr++;
  }
}

void P3_fx_transition_restore (P3_fx* fx, int index) {
  if (fx->vertex_colors != NULL) {
    GLfloat* color = fx->vertex_colors[index];
    if (!(fx->vertex_options[index] & P3_VERTEX_FX_TRANSITION) && fx->vertex_warfogs[index] != color) {
      fx->vertex_warfogs[index] = P3_fx_get_color_fader (fx->vertex_warfogs[index], color, fx->duration, fx->list, P3_fx_end_restore, fx->data);
      P3_chunk_add_int (fx->data->chunk, index);
      if (1.0 - color[3] > P3_EPSILON) {
        /* alpha */
        fx->vertex_options[index] |= P3_VERTEX_ALPHA;
      }
      if (color[3] > P3_EPSILON) {
        fx->vertex_options[index] &= ~P3_VERTEX_INVISIBLE;
      }
      fx->vertex_options[index] |= P3_VERTEX_FX_TRANSITION;
    }
  } else {
    if (fx->vertex_warfogs[index] != fx->color) {
      fx->vertex_warfogs[index] = P3_fx_get_color_fader (fx->vertex_warfogs[index], fx->color, fx->duration, fx->list, P3_fx_end_transition, fx->data);
      fx->vertex_options[index] &= ~P3_VERTEX_INVISIBLE;
    }
  }
}


/*====+
 | FX |
 +====*/

void P3_fx_init (void) {
  if (!(engine_option & P3_FX_INITED)) {
    engine_option |= P3_FX_INITED;
    fx_color_faders = P3_list_new (0);
//    fx_colors = P3_list_new (0);
  }
}

void P3_fx_quit (void) {
  P3_fx_color_fader* fader;
  int i, nb;
  nb = fx_color_faders->nb;
  for (i = nb - 1; i >= 0; i--) {
    (fx_color_faders->nb)--;
    fader = (P3_fx_color_fader*) P3_list_get (fx_color_faders, i);
    P3_fx_color_fader_free_callback_data (fader->callback_data);
    free (fader);
  }
  P3_list_dealloc (fx_color_faders);
//  for (i = 0; i < fx_colors->nb; i++) free (P3_list_get (fx_colors, i));
//  P3_list_dealloc (fx_colors);
}

