/*
 * P3
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/***************************************************************************
 * coordsys.h
 *
 * INFO after modifying a coordsys matrix (with translate, rotate matrix...)
 * you must allways call P3_coordsys_invalid
 *
 * Copyright (C) 2001-2002 Bertrand 'blam' LAMY
 ***************************************************************************/


void         P3_coordsys_lefthanded               (P3_coordsys*);
//void         P3_coordsys_invalid                  (P3_coordsys*);
GLfloat*     P3_coordsys_get_root_matrix          (P3_coordsys*);
GLfloat*     P3_coordsys_get_inverted_root_matrix (P3_coordsys*);
//GLfloat*     P3_coordsys_get_inverted_matrix      (P3_coordsys*);
void         P3_coordsys_initialize               (P3_coordsys*);
P3_coordsys* P3_coordsys_get_root                 (P3_coordsys*);
int          P3_coordsys_is_inside                (P3_coordsys*, void* parent);

P3_coordsys* P3_object_get_coordsys         (P3_any_object*);
void         P3_object_invalid              (P3_any_object*);

#define P3_coordsys_invalid(coordsys) \
  (coordsys)->validity = P3_COORDSYS_INVALID

