/*
 * P3
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/***************************************************************************
 * coordsys.c
 *
 * INFO after modifying a coordsys matrix (with translate, rotate matrix...)
 * you must allways call P3_coordsys_invalid
 *
 * Copyright (C) 2001-2003 Bertrand 'blam' LAMY
 ***************************************************************************/

#include "p3_base.h"
#include "math3d.h"
#include "world.h"
//#include "morph.h"
#include "coordsys.h"


/*==========+
 | COORDSYS |
 +==========*/

void P3_coordsys_lefthanded (P3_coordsys* c) {
  int i;
  if (c->option & P3_COORDSYS_LEFTHANDED) {
    c->option -= P3_COORDSYS_LEFTHANDED;
  }
  if (c->m[16] < 0.0) { i = -1; } else { i = 1; }
  if (c->m[17] < 0.0) { i = -i; }
  if (c->m[18] < 0.0) { i = -i; }
  if (i < 0.0) { c->option |= P3_COORDSYS_LEFTHANDED; }
}

/*
void P3_coordsys_invalid (P3_coordsys* c) {
  c->validity = P3_COORDSYS_INVALID;
}
*/

void P3_coordsys_initialize (P3_coordsys* c) {
  P3_matrix_set_identity (c->m);
  c->parent = NULL;
  c->option = 0;
  c->validity = P3_COORDSYS_INVALID;
}

/*
GLfloat* P3_coordsys_get_inverted_matrix (P3_coordsys* c) {
  if (!(c->validity & P3_COORDSYS_INVERSE_VALID)) {
    // compute the inverted matrix
    c->validity |= P3_COORDSYS_INVERSE_VALID;
    P3_matrix_invert (c->mi, c->m);
  }
  return c->mi;
}
*/

GLfloat* P3_coordsys_get_root_matrix (P3_coordsys* c) {
  if (!(c->validity & P3_COORDSYS_ROOT_VALID)) {
    /* compute the root matrix */
    if (c->parent == NULL) {
      P3_matrix_copy (c->mroot, c->m);
    } else {
      P3_multiply_matrix (c->mroot, P3_coordsys_get_root_matrix ((P3_coordsys*) c->parent), c->m);
    }
    c->validity |= P3_COORDSYS_ROOT_VALID;
  }
  return c->mroot;
}

GLfloat* P3_coordsys_get_inverted_root_matrix (P3_coordsys* c) {
  if (!(c->validity & P3_COORDSYS_INVERSE_ROOT_VALID)) {
    P3_matrix_invert (c->mrooti, P3_coordsys_get_root_matrix (c));
    c->validity |= P3_COORDSYS_INVERSE_ROOT_VALID;
  }
  return c->mrooti;
}

P3_coordsys* P3_coordsys_get_root (P3_coordsys* c) {
  if (c->parent == NULL) { 
    if (c->class->id == P3_ID_WORLD || c->class->id == P3_ID_VOLUME || c->class->id == P3_ID_INSTANCE || 
        c->class->id == P3_ID_CAL3D_VOLUME) {
      return (P3_coordsys*) c; 
    } else {
      return NULL;
    }
  }
  return P3_coordsys_get_root (c->parent);
}

int P3_coordsys_is_inside (P3_coordsys* c, void* parent) {
  if (parent == c || (c->parent != NULL && P3_coordsys_is_inside (c->parent, parent) == P3_TRUE)) {
    return P3_TRUE;
  }
  return P3_FALSE;
}

P3_coordsys* P3_object_get_coordsys (P3_any_object* obj) {
  switch (obj->class->id) {
  case P3_ID_INSTANCE:
  case P3_ID_VOLUME:
  case P3_ID_WORLD:
  case P3_ID_CAMERA:
  case P3_ID_PORTAL:
  case P3_ID_LIGHT:
//  case P3_ID_MORPH:
  case P3_ID_PARTICLES:
  case P3_ID_WATERCUBE:
  case P3_ID_CAL3D_VOLUME:
    return (P3_coordsys*) obj;
  default:
    return NULL;
  }
}

void P3_object_invalid (P3_any_object* obj) {
  switch (obj->class->id) {
//  case P3_ID_MORPH:
//    P3_morph_invalid ((P3_morph*) obj);
//    break;
  case P3_ID_WORLD:
    P3_world_invalid ((P3_world*) obj);
    break;
  case P3_ID_INSTANCE:
  case P3_ID_VOLUME:
  case P3_ID_CAMERA:
  case P3_ID_PORTAL:
  case P3_ID_LIGHT:
  case P3_ID_PARTICLES:
  case P3_ID_WATERCUBE:
  case P3_ID_CAL3D_VOLUME:
    P3_coordsys_invalid ((P3_coordsys*) obj);
    break;
  default:
    break;
  }
}



