/*
 * P3
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/********************************************************
 * cal3d4p3.c : use Cal3D (http://cal3d.sourceforge.net)
 *              rocking animation lib with Soya
 * Copyright (C) 2003 Jean-Baptiste 'Jiba' LAMY
 *                         Bertrand 'blam' LAMY
 ********************************************************/

#ifdef HAVE_CAL3D

void             P3_cal3d_init          (void);
void             P3_cal3d_quit          (void);

P3_cal3d_shape*  P3_cal3d_shape_new     (P3_cal3d_shape*);
void             P3_cal3d_shape_render  (P3_cal3d_shape*, P3_instance*);
void             P3_cal3d_shape_dealloc (P3_cal3d_shape*);
void             P3_cal3d_shape_set_cell_shading (P3_cal3d_shape*, P3_material*, GLfloat* color, GLfloat line_width_factor);

P3_cal3d_volume* P3_cal3d_volume_new             (P3_cal3d_volume*);
void             P3_cal3d_volume_dealloc         (P3_cal3d_volume*);
void             P3_cal3d_volume_batch           (P3_cal3d_volume*, P3_instance*);
int              P3_cal3d_volume_shadow          (P3_cal3d_volume*, P3_instance*, P3_light*);
void             P3_cal3d_volume_set_shape       (P3_cal3d_volume*, P3_cal3d_shape*);
void             P3_cal3d_volume_build_submeshes (P3_cal3d_volume*);
void             P3_cal3d_volume_set_lod_level   (P3_cal3d_volume*, float lod_level);
void             P3_cal3d_volume_attach_all      (P3_cal3d_volume*);
void             P3_cal3d_volume_set_attached    (P3_cal3d_volume*, int mesh_id, int attach);
void             P3_cal3d_volume_get_data        (P3_cal3d_volume*, P3_chunk*);
void             P3_cal3d_volume_set_data        (P3_cal3d_volume*, P3_chunk*);

#endif /* HAVE_CAL3D */
