# export blender model to soya

# HOW TO EXPORT A BLENDER MODEL :
DESCRIPTION = """
       This file must be executed from within blender
       version 2.28 or above.  

       To execute this script:
         1. Switch a blender text editor type window inside blender
              This can done from the lower left corner of most blender windows
         2. Load this file.
         3. Press Alt-P
         4. Fill in the required values
         5. Press OK
  """

# WARNING : there are some hack on this script since Blender python module is very few documented...
#   (for example for vertices color)



import os, os.path, tempfile, string, sys
try:
  import Blender
except ImportError:
  print DESCRIPTION
  sys.exit()

from Blender.BGL import *
from Blender.Draw import *
from Blender.Window import RedrawAll

# error text




# GUI Events
EVENT_NOEVENT = 0
EVENT_OK=1
EVENT_CANCEL=2
EVENT_PATHCHANGE=3

##
# Class which creates the blender GUI dialog boxes.
# It passes the set values to an instance of 
# blender2soya which is defined below
#
class blenderDialog:
  def __init__(self):
    # The directories where files will be saved
    self.projectDir = ""
    self.imageDir = ""
    self.materialDir = "" 
    self.worldDir = ""
    self.shapeDir = ""

    if os.environ.has_key('HOME'):
      self.homeDir = os.environ['HOME']
    else:
      self.homeDir = ""  

    self._setPaths()

    self.modelFile = "model"



    # Options
    self.launchEditor = 0 # If 1 then model is edited in the Soya editor instead of being saved.
    self.keepPointsLines = 0 # If 0 point and lines are removed 
                             # (only triangles, quads or poly are kept).
                             # This is usefull since creating useless lines or point is easy in Blender.

  ##
  # Sets the various output directory paths based upon
  # the current home and project dir settings
  def _setPaths(self):
    self.imageDir = os.path.join(self.homeDir,self.projectDir,'images')
    self.materialDir = os.path.join(self.homeDir,self.projectDir,'materials')
    self.worldDir = os.path.join(self.homeDir,self.projectDir,'worlds')
    self.shapeDir = os.path.join(self.homeDir,self.projectDir,'shapes')


  ##
  # Generates the blender UI panel upon script execution 
  #
  def draw(self):
    glClear(GL_COLOR_BUFFER_BIT)

    glRasterPos2d(8, 300)
    Text("Blender2Soya Exporter")

    ######### Parameters GUI Buttons
    glRasterPos2d(8, 280)
    Text("Save file to:")
    self.homeDirWidget = String("Home Dir:", EVENT_PATHCHANGE,10, 260, 300, 18, 
                                self.homeDir, 50, "Your home directory")
    self.projectDirWidget = String("Project Dir:", EVENT_PATHCHANGE,10, 240, 210, 18, 
                                   self.projectDir, 50, "Your home directory")
    self.imageDirWidget = String("Images Dir:", EVENT_NOEVENT,20, 220, 210, 18, 
                        self.imageDir, 50, "Images Directory")
    self.materialDirWidget = String("Material Dir:", EVENT_NOEVENT,20, 200, 210, 18, 
                           self.materialDir, 50, "Material Directory")
    self.worldDirWidget = String("World Dir:", EVENT_NOEVENT,20, 180, 210, 18, 
                                 self.worldDir, 50, "World Directory")
    self.shapeDirWidget = String("Shape Dir:", EVENT_NOEVENT,20, 160, 210, 18, 
                                  self.shapeDir, 50, "Shape Directory")

    self.modelNameWidget = String("Model Filename:", EVENT_NOEVENT,20, 120, 210, 18, 
                                  self.modelFile, 50, "Shape Directory")

    glRasterPos2d(8, 100)
    Text("Options:")

    self.keepWidget = Toggle("Keep points/lines", EVENT_NOEVENT, 20, 80, 210, 20, 
                                 self.keepPointsLines, "Keep points and lines")
    self.launchEditorWidget = Toggle("Launch Editor", EVENT_NOEVENT, 20, 60, 210, 20,
                                 self.launchEditor, "Launch Soya editor instead of saving") 
 
    ######### Draw and Exit Buttons
    Button("OK",EVENT_OK , 10, 10, 40, 18)
    Button("Exit",EVENT_CANCEL , 140, 10, 40, 18)

  ##
  # Process blender keyboard events
  def event(self, evt, val):        
    if (evt == QKEY and not val): 
      Exit()

  ##
  # Process blender widget events
  #
  def bevent(self, evt):
    if (evt == EVENT_CANCEL): 
      Exit()

    elif (evt== EVENT_OK):
      options = { 'KEEP_POINTS_AND_LINES': int("%s" % self.keepWidget),
                  'EDIT': int("%s" % self.launchEditorWidget),
                  'IMAGE_PATH': ("%s" % self.imageDirWidget)[1:-1],
                  'MATERIAL_PATH': ("%s" % self.materialDirWidget)[1:-1],
                  'WORLD_PATH': ("%s" % self.worldDirWidget)[1:-1],
                  'SHAPE_PATH' : ("%s" % self.shapeDirWidget)[1:-1],
                  'MODEL_FILENAME' : ("%s" % self.modelNameWidget)[1:-1],
                }
      exporter = blender2soya(options)
      exporter.run()

      Exit() # TODO: Should present a status dialog on completion?

    elif (evt== EVENT_PATHCHANGE):
      self.homeDir = ("%s" % self.homeDirWidget)[1:-1]
      self.projectDir = ("%s" % self.projectDirWidget)[1:-1]
      self._setPaths()
      RedrawAll()      


class blender2soya:
  def __init__(self, options):
    self.KEEP_POINTS_AND_LINES = options['KEEP_POINTS_AND_LINES']
    self.EDIT = options['EDIT']
    self.IMAGE_PATH = options['IMAGE_PATH']
    self.MATERIAL_PATH = options['MATERIAL_PATH']
    self.WORLD_PATH = options['WORLD_PATH']
    self.SHAPE_PATH = options['SHAPE_PATH']
    self.FILENAME = options['MODEL_FILENAME']

  ##
  # translates the names of objects so that 
  # valid python code is generated in the code below
  #
  def to_name(self, s):     
     name_trans = string.maketrans(" -.", "___")
     print "Translating %s to %s " % (s, s.translate(name_trans))
     return s.translate(name_trans)

  def pointbymatrix(self, p, m):
    return [p[0] * m[0][0] + p[1] * m[1][0] + p[2] * m[2][0] + m[3][0],
            p[0] * m[0][1] + p[1] * m[1][1] + p[2] * m[2][1] + m[3][1],
            p[0] * m[0][2] + p[1] * m[1][2] + p[2] * m[2][2] + m[3][2]]

  def export_to_soya(self):
    objs      = Blender.Object.Get()
    code      = ""
    materials = []
  
    for obj in objs:
      data = obj.getData()
      if (type(data) is Blender.Types.NMeshType) and data.faces:
        nmesh = Blender.NMesh.GetRawFromObject(obj.name)
      
        matrix = [[obj.mat[0][0], obj.mat[0][1], obj.mat[0][2], obj.mat[0][3]],
                  [obj.mat[1][0], obj.mat[1][1], obj.mat[1][2], obj.mat[1][3]],
                  [obj.mat[2][0], obj.mat[2][1], obj.mat[2][2], obj.mat[2][3]],
                  [obj.mat[3][0], obj.mat[3][1], obj.mat[3][2], obj.mat[3][3]]]
      
        for face in nmesh.faces:
          if (not self.KEEP_POINTS_AND_LINES) and (len(face.v) <= 2): continue
        
          code += "f = soya.model.Face(root_world)\n"
        
          # face option
          if(face.smooth != 0): code += "f.smooth_lit = 1\n"
          if(face.mode & Blender.NMesh.FaceModes.TWOSIDE): code += "f.double_sided = 1\n"
        
          # material
          if(face.image != None):
            m_filename = face.image.name[:face.image.name.find(".")]
            m_name = self.to_name(m_filename)
            code += "f.material = mat_%s \n" % m_name
            for (already_name, already_image) in materials:
              if m_name == already_name: break
            else: materials.append((m_name, m_filename))
          
          # vertices
          index = 0
          for vertex in face.v:
            # vertex coordinates
            co = self.pointbymatrix(vertex.co, matrix)
            code += "v = soya.model.Vertex(root_world, " + str(co[0]) + ", " + str(co[1]) + ", " + str(co[2]) + ")\n"
          
            # vertex color
            if(face.col != None and len(face.col) > 0):
              color = face.col[index]
              code += "v.color = (%s, %s, %s, %s)\n" % (color.r / 255.0, color.g / 255.0, color.b / 255.0, color.a / 255.0)
            
            # vertex texture coordinates
            if(len(face.uv) > 0):
              uv = face.uv[index]
              code += "v.tex_x = %s\nv.tex_y = %s\n" % (uv[0], 1.0 - uv[1])
            
            code += "f.append(v)\n"
            index = index + 1


          
    full_code = """
# This file has been generated by the Soya Blender exporter

import Tkinter, sys, os, os.path, shutil, glob, soya, soya.model, soya.soya3d, soya.editor, soya.editor.main

root_world = soya.soya3d.World()
root_world.filename = '%s'

new_materials = []
""" % self.FILENAME



    if self.EDIT: full_code += """
soya.editor.main.App()
  """
    full_code += """
soya.model.Image.PATH    = '%s'
soya.model.Material.PATH = '%s'
soya.soya3d.World.PATH   = '%s'
soya.model.Shape.PATH    = '%s'
""" % (self.IMAGE_PATH, self.MATERIAL_PATH, self.WORLD_PATH, self.SHAPE_PATH)


  
    for material, texture_filename in materials:
      full_code += """
try:
  mat_%(material)s = soya.model.Material.get('%(material)s')
except IOError: # New material
  mat_%(material)s = soya.model.Material('%(material)s')
  image = glob.glob(os.path.join(soya.model.Image.PATH, "%(texture_filename)s.*"))
  if image:
    mat_%(material)s.tex_filename = os.path.basename(image[0])
  new_materials.append(mat_%(material)s)
""" % locals()


    
    full_code += """

# This is to compensate because upper axis is Z in blender, Y in Soya
root_world.rotate_vertical(-90.0)

import soya.facecutter as facecutter
facecutter.check_quads(root_world)

os.remove(sys.argv[0])
"""

  
    if self.EDIT: return full_code + "\n\n" + code + """
soya.editor.edit(root_world)
for material in new_materials: soya.editor.edit(material)
Tkinter.mainloop()
"""
    else: return full_code + "\n\n" + code + """
root_world.save()
for material in new_materials: material.save()
"""


  def run(self):
   filename = tempfile.mktemp(".py")
   open(filename, "w").write(self.export_to_soya())
   os.system("python %s &" % filename)
   os.system("cp  %s  ~/testfile.py" % filename)

#
# Only execute if ran as the main script
#
if __name__ == '__main__':
  # Create the dialog instance and register 
  # the event handlers with blender
  dialog = blenderDialog()
  Register(dialog.draw, dialog.event, dialog.bevent) 
