# Soya 3D
# Copyright (C) 2001-2002 Jean-Baptiste LAMY -- jiba@tuxfamily.org
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from _soya import *
import _soya
import os, os.path, cPickle as pickle, copy_reg, atexit

VERSION = "0.6"

root_widget = None

inited = 0

DATADIR = os.path.join(os.path.dirname(__file__), "data")
if not os.path.exists(DATADIR):
  DATADIR = "/usr/share/soya"
  if not os.path.exists(DATADIR):
    DATADIR = "/usr/local/share/soya"
    if not os.path.exists(DATADIR):
      DATADIR = "/usr/share/python-soya"
      if not os.path.exists(DATADIR):
        import warnings
        warnings.warn("Soya's data directory cannot be found !")
        
def init(title = "Soya 3D", width = 640, height = 480, fullscreen = 0, resizeable = 1):
  """init(title = "Soya 3D", width = 640, height = 480, fullscreen = 0, resizeable = 1)

Inits Soya 3D and display the 3D view.

TITLE is the title of the window.
WIDTH and HEIGHT the dimensions of the 3D view.
FULLSCREEN is true for fullscreen and false for windowed mode.
RESIZEABLE is true for a resizeable window."""
  global inited
  
  if not inited:
    _soya.init(title, width, height, fullscreen, resizeable)
    if root_widget: root_widget.resize(0, 0, width, height)
    
    def quit():
      print "* Soya3D * Quit..."
      _soya.quit()
      
    atexit.register(quit)
    
    inited = 1

def init_for_pygame(width, height):
  """init_for_pygame()

Inits Soya 3D for use with PyGame."""
  global inited
  
  if not inited:
    _soya.init(width, height)
    
    def quit():
      print "* Soya3D * Quit..."
      _soya.quit()
      
    atexit.register(quit)
    
    inited = 1

def _soya_reconstructor(clazz, state = None):
  obj = clazz()
  #if state: obj.__setstate__(state)
  return obj

def _soya_getter(clazz, filename): return clazz.get (filename)
def _soya_loader(clazz, filename): return clazz.load(filename) # Always load a new one !!!

copy_reg.constructor(_soya_reconstructor)
copy_reg.constructor(_soya_getter)
copy_reg.constructor(_soya_loader)



class _CObj:
  """_CObj

Base class for all objects written in C. Add pickling and copying capabilities."""
  def __reduce__(self):
    #print "__reduce__   pour", id(self), self
    
    return _soya_reconstructor, (self.__class__,), self.__getstate__()
    
  def __getstate__(self):
    #print "__getstate__ pour", self
    
    state = self.__dict__.copy()
    state["_cdata"] = self._getstate()
    
    #if getattr(self, "material", None) and self.material.filename:
    #  state["material"] = self.material.filename
    
    return state
    
  def __setstate__(self, state):

    cdata = state["_cdata"]
    del state["_cdata"]
    
    self.__dict__ = state
    self._setstate(cdata)
    
    if type(getattr(self, "material", None)) is str:
      from model import Material
      self.material = Material.get(self.material)
      
    if isinstance(self, SavedInAPath):
      if self.filename:
        self._alls[self.filename] = self
        
  def __deepcopy__(self, memo):
    # Do not clone the parent (except if already cloned before, in the memo) !
    
    import copy

    if hasattr(self, "filename") and self.filename:
      _filename = self.filename
      self.filename = ""
      red = self.__reduce__()
      self.filename = _filename
    else:
      red = self.__reduce__()
    
    clone = red[1][0]()
    memo[id(self)] = clone
    
    state = red[2]
    
    if hasattr(self, "parent") and (not id(self.parent) in memo.keys()):
      if state is self.__dict__: state = state.copy()
      if (state.has_key("_cdata")):
        _cdata = state["_cdata"]
        if _cdata[1] is self.parent:
          state["_cdata"] = (_cdata[0], None) + _cdata[2:]
      elif state.has_key("_parent"): state["_parent"] = None
      else:                          state["parent" ] = None
      
    s2 = copy.deepcopy(state, memo)
    clone.__setstate__(s2)
    
    return clone
  
#   def __deepcopy__(self, memo):
#     # Do not clone the parent (except if already cloned before, in the memo) !
    
#     import copy
    
#     red = self.__reduce__()
    
#     copy._keep_alive(red, memo)
    
#     clone = red[1][0]()
#     memo[id(self)] = clone
    
#     copy._keep_alive(self, memo)
#     copy._keep_alive(clone, memo)
    
#     state = red[2]
#     copy._keep_alive(state, memo)
    
#     if hasattr(self, "parent") and (not id(self.parent) in memo.keys()):
#       if (state.has_key("_cdata")):
#         _cdata = state["_cdata"]
#         if _cdata[1] is self.parent:
#           state["_cdata"] = (_cdata[0], None) + _cdata[2:]
#       elif state.has_key("_parent"): state["_parent"] = None
#       else:                          state["parent"] = None
      
#     copy._keep_alive(state, memo)
    
#     s2 = copy.deepcopy(state, memo)
    
#     copy._keep_alive(s2, memo)
    
#     clone.__setstate__(s2)
    
#     return clone

class SavedInAPath(object):
  """SavedInAPath

Base class for all objects that can be saved in a path, such as Material,
World,...

The PATH class attribute can be used to set the path."""
  PATH = ""
  
  def get(klass, filename):
    """SavedInAPath.get(filename)

Gets the object of this class with the given FILENAME attribute.
The object is loaded from the path if it is not already loaded.
If it is already loaded, the SAME object is returned."""
    
    # Fucking winedaube OS requires binary file
    return klass._alls.get(filename) or pickle.loads(open(os.path.join(klass.PATH, filename + ".data"), "rb").read())
  
  get = classmethod(get)
  
  def load(klass, filename):
    """SavedInAPath.get(filename)

Loads the object of this class with the given FILENAME attribute.
Contrary to get, load ALWAYS returns a new object."""

    # Fucking winedaube OS requires binary file
    return pickle.loads(open(os.path.join(klass.PATH, filename + ".data"), "rb").read())
      
  load = classmethod(load)
  
  def __init__(self, filename):
    if filename: self._alls[filename] = self
    self._filename = filename
    
  def get_filename(self): return self._filename
  def set_filename(self, filename):
    if self._filename:
      try: del self._alls[self.filename]
      except KeyError: pass
    if filename: self._alls[filename     ] = self
    self._filename = filename
  filename = property(get_filename, set_filename)
  
  def save(self, filename = None):
    """SavedInAPath.save(filename = None)

Saves this object. If no FILENAME is given, the object is saved in the path,
using its filename attribute. If FILENAME is given, it is saved at this
location."""
    filename = filename or os.path.join(self.PATH, self._filename)
    self._saving = 1 # Hack !!
    pickle.dump(self, open(filename + ".data", "wb"), 1)
    
  def __reduce__(self):
    if hasattr(self, "_saving"): # Hack !!
      del self._saving
    elif self.filename:
      if hasattr(self, "parent"): return _soya_loader, (self.__class__, self._filename)
      else:                       return _soya_getter, (self.__class__, self._filename)
    return _CObj.__reduce__(self)
  
  def availables(self):
    """SavedInAPath.availables() -> list

Returns the list of the filename all the objects available in the current path."""
    import dircache
    filenames = self._alls.keys()
    for filename in dircache.listdir(self.PATH):
      if filename.endswith(".data") and (not filename in filenames): filenames.append(filename[:-5])
    filenames.append(None)
    return filenames
  availables = classmethod(availables)
  

def set_root_widget(widget):
  """set_root_widget(widget)

Sets the root widget of Soya3D. The root widget is the one used for rendering.
It is typically a camera, or a group of widget (soya.widget.Group) which includes
a camera."""
  global root_widget
  root_widget = widget
  if root_widget:
    root_widget.resize(0, 0, _soya.get_screen_width(), _soya.get_screen_height())

def render():
  """render()

Renders the 3D scene. Use set_root_widget() to choose which camera is used."""
  if root_widget:
    root_widget.render()
    _soya.display()

def render_no_flip():
  """render_no_flip()

Renders the 3D scene as render(), but doesn't not flip/swap buffer.
Usefull with PyGame (see tutoriel lesson 113)."""
  if root_widget: root_widget.render()
  
def process_event():
  """process_event() -> list of event tuples

Process events internally, and returns a list of events.

Each event is a tuple. The first value identifies the type of event:
MOUSEBUTTONDOWN, MOUSEBUTTONUP, MOUSEMOTION, KEYDOWN, KEYUP,...

The other tuple elements depends of the type of event.

See tutorial lesson 006 for event management.
"""
  events = _soya._process_event()
  for event in events:
    if event[0] == _soya.VIDEORESIZE:
      if root_widget: root_widget.resize(0, 0, event[1], event[2])
      events.remove(event)
  return events

def set_video(width = 640, height = 480, fullscreen = 0, resizable = 1):
  _soya.set_video(width, height, fullscreen, resizable)
  if root_widget: root_widget.resize(0, 0, width, height)
