#ifndef STYLECOMBOBOX_H
#define STYLECOMBOBOX_H

#include <QComboBox>

namespace srchiliteqt {

/**
  * A subclass of QComboBox which provides functionalities for showing
  * and selecting the style files of Source-Highlight.
  */
class StyleComboBox : public QComboBox
{
    Q_OBJECT
public:
    StyleComboBox();

public slots:
    /**
     * Sets the style file in the combo
     * @param styleFile the style file name; if the file is not part of the
     * combo list, nothing happens
     */
    void setCurrentStyle(const QString &styleFile);

    /**
      * @return the currently selected style file
      */
    const QString getCurrentStyle() const;
};

}

#endif // STYLECOMBOBOX_H
