#include "LanguageComboBox.h"

namespace srchiliteqt {

LanguageComboBox::LanguageComboBox(srchiliteqt::Qt4SyntaxHighlighter *highlighter)
{
    std::set<std::string> langfiles = highlighter->getLangMap()->getMappedFileNames();
    for (std::set<std::string>::const_iterator it = langfiles.begin(); it != langfiles.end(); ++it) {
        addItem(QString((*it).c_str()));
    }
}

void LanguageComboBox::setCurrentLanguage(const QString &lang) {
    int item = findText(lang);
    if (item != -1)
        setCurrentIndex(item);
}

const QString LanguageComboBox::getCurrentLanguage() const {
    return currentText();
}

}
