

#ifndef OPTIONSDETAILED_H
#define OPTIONSDETAILED_H

#include "outputdirectory.h"
#include "conversionoptions.h"

#include <qwidget.h>

class Config;
//class OutputDirectory;
class ConversionOptions;

class QLabel;
class KIntSpinBox;
class QCheckBox;
class KComboBox;
class KLineEdit;
class KToolBarButton;

/**
 * @short The options widget for setting up the output options more detailed
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class OptionsDetailed : public QWidget
{
    Q_OBJECT
public:
    /**
     * Constructor
     */
    OptionsDetailed( Config*, QWidget* parent=0, const char* name=0 );

    /**
     * Destructor
     */
    virtual ~OptionsDetailed();

    /**
     * Return the current options
     */
    ConversionOptions getCurrentOptions();

    /**
     * Set the current options
     */
    void setCurrentOptions( const ConversionOptions& );

    /**
     * Refills the whole form (e.g. after a config change)
     */
    void refill(); // TODO syncronize with optionsSimple

private:
    KComboBox* cFormat;
    KComboBox* cQualityMode;
    KIntSpinBox* iQuality;
    KComboBox* cBitrateMode;

    QCheckBox* cBitrateRangeSwitch;
    KIntSpinBox* iMinBitrate;
    QLabel* lBitrateRangeTo;
    KIntSpinBox* iMaxBitrate;
    QLabel* lBitrateRangeUnit;

    QCheckBox* cSamplingrateSwitch;
    KComboBox* cSamplingrate;
    QLabel* lSamplingrateUnit;
    QCheckBox* cChannelsSwitch;
    KComboBox* cChannels;
    QCheckBox* cReplayGain;

    KToolBarButton* pProfileSave;

    KLineEdit* lUserOptions;

    QWidget* normalOptions;
    QWidget* advancedOptions;

    OutputDirectory* outputDirectory;

    Config* config;
//     QString getQualityMode();

    QString lastQualityMode;

    /** because we can't search within combo boxes, we need a seperate string lists, that we can search */
    QStringList sFormat;
    QStringList sQualityMode;
    QStringList sBitrateMode;
    QStringList sChannels;
    int formatIndex( const QString &string );
    int qualityModeIndex( const QString &string );
    int bitrateModeIndex( const QString &string );
    int channelsIndex( const QString &string );

    int getQuality();
    bool getBitrateRangeEnabled();
    bool getSamplingrateEnabled();
    int getSamplingrate();
    bool getChannelsEnabled();
    QString getChannels();

private slots:
    void formatChanged();
    void qualityModeChanged();
    void qualityChanged();
    void bitrateModeChanged();
    void bitrateRangeToggled();
    void samplingrateToggled();
    void channelsToggled();
    void saveProfile();
    void somethingChanged();

public:
    QString getFormat();
    OutputDirectory::Mode getOutputDirectoryMode();
    QString getOutputDirectoryPath();
    void setFormat( const QString &format );
    void setQualityMode( const QString &qualityMode );
    void setQuality( int quality );
    void setBitrateMode( const QString &bitrateMode );
    void setBitrateRangeEnabled( bool enabled );
    void setMinBitrate( int bitrate );
    void setMaxBitrate( int bitrate );
    void setSamplingrateEnabled( bool enabled );
    void setSamplingrate( int sampleRate );
    void setSamplingrate( const QString &sampleRate );
    void setChannelsEnabled( bool enabled );
    void setChannels( const QString &channels );
    void setReplayGainEnabled( bool enabled );
    void setOutputDirectoryMode( OutputDirectory::Mode mode );
    void setOutputDirectoryPath( const QString &path );
    void setUserOptions( const QString &options );

public slots:
    void toggleAdvancedOptions();

signals:
    void optionsChanged();
};

#endif // OPTIONSDETAILED_H
