
#include "formatinfoloader.h"

#include <qfile.h>

#include <klocale.h>
#include <kglobal.h>

FormatInfo::FormatInfo()
{}

FormatInfo::~FormatInfo()
{}


FormatInfoLoader::FormatInfoLoader()
{}

FormatInfoLoader::~FormatInfoLoader()
{}

bool FormatInfoLoader::verifyFile( QString fileName )
{
    QFile opmlFile( fileName );
    if( !opmlFile.open( IO_ReadOnly ) ) {
        return false;
    }
    if( !domTree.setContent( &opmlFile ) ) {
        return false;
    }
    opmlFile.close();

    QDomElement root = domTree.documentElement();
    if( root.attribute("type") == "format_info" ) return true;

    return false;
}

FormatInfo* FormatInfoLoader::loadFile( QString fileName )
{
    int t_int;
    float t_float;
    QString t_str;

    FormatInfo* plugin = new FormatInfo();
    plugin->mime_types = "application/octet-stream"; // if something goes wrong, we can see that by looking at plugin->mimetype

    QFile opmlFile( fileName );
    if( !opmlFile.open( IO_ReadOnly ) ) {
        return plugin;
    }
    if( !domTree.setContent( &opmlFile ) ) {
        return plugin;
    }
    opmlFile.close();

    QString language = KGlobal::locale()->languagesTwoAlpha().first();

    QDomElement root = domTree.documentElement();
    if( root.attribute("type") != "format_info" ) return plugin;
    QDomNode node;
    node = root.firstChild();

    while( !node.isNull() ) {
        if( node.isElement() && node.nodeName() == "data" ) {

            plugin->mime_types = QStringList::split( ',',node.toElement().attribute("mime_types","application/octet-stream") );
            plugin->description = node.toElement().attribute("description_"+language);
            if( plugin->description.isEmpty() ) plugin->description = node.toElement().attribute("description");
            plugin->urls = QStringList::split( ',',node.toElement().attribute("urls_"+language) );
            if( plugin->urls.isEmpty() ) plugin->urls = QStringList::split( ',',node.toElement().attribute("urls") );
            QStringList compressionTypeList = QStringList::split( ',',node.toElement().attribute("compression_type") );
            plugin->compressionType = (FormatInfo::CompressionType)0x0000;
            for( QStringList::Iterator it = compressionTypeList.begin(); it != compressionTypeList.end(); ++it ) {
                if( *it == "lossy" ) plugin->compressionType = FormatInfo::CompressionType( plugin->compressionType | FormatInfo::lossy );
                else if( *it == "lossless" ) plugin->compressionType = FormatInfo::CompressionType( plugin->compressionType | FormatInfo::lossless );
                else if( *it == "hybrid" ) plugin->compressionType = FormatInfo::CompressionType( plugin->compressionType | FormatInfo::hybrid );
            }
            plugin->size = node.toElement().attribute("size","15000").toInt();

        }
        node = node.nextSibling();
    }

    return plugin;
}

