

#ifndef REPLAYGAINSCANNER_H
#define REPLAYGAINSCANNER_H

#include <kdialog.h>

#include "replaygainfilelist.h"

class Config;
class Logger;
class ComboButton;

class QCheckBox;

class KPushButton;
class KProgress;


/**
 * @short The Replay Gain Tool
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class ReplayGainScanner : public KDialog
{
    Q_OBJECT
public:
    /**
     * Constructor
     */
    ReplayGainScanner( TagEngine*, Config*, Logger*, QWidget* parent=0, const char* name=0, bool modal=true, WFlags f=0 );

    /**
     * Destructor
     */
    virtual ~ReplayGainScanner();

    void addFiles( QStringList );

private slots:
    void addClicked( int );
    void showDirDialog();
    void showFileDialog();
    void calcReplayGainClicked();
    void removeReplayGainClicked();
    void cancelClicked();
    void processStarted();
    void processStopped();
    void updateProgress( int, int );

private:
    ComboButton* cAdd;
    QCheckBox* cForce;
    //QComboBox* cFilter;
    ReplayGainFileList* lList;
    KProgress* pProgressBar;
    KPushButton* pTagVisible;
    KPushButton* pRemoveTag;
    KPushButton* pCancel;
    KPushButton* pOk;

    TagEngine* tagEngine;
    Config* config;
    Logger* logger;

    QTime elapsedTime;

signals:
    void addFile( const QString& );
    void addDir( const QString&, const QStringList& filter = "", bool recursive = true );
    void calcAllReplayGain( bool force );
    void removeAllReplayGain();
    void cancelProcess();
};

#endif // REPLAYGAINSCANNER_H
