
#include "configenvironmentpage.h"

#include "config.h"

#include <klocale.h>
#include <kiconloader.h>
#include <kpushbutton.h>
#include <klistbox.h>
//#include <keditlistbox.h>
//#include <kurlrequester.h>
#include <kfiledialog.h>
#include <kstandarddirs.h>

#include <qlayout.h>
#include <qlabel.h>
#include <qtooltip.h>
#include <qmap.h>


ConfigEnvironmentPage::ConfigEnvironmentPage( Config* _config, QMap<QString, QString>* _binaries, QWidget *parent, const char *name )
    : ConfigPageBase( parent, name )
{
    config = _config;
    binaries = _binaries;

    // create an icon loader object for loading icons
    KIconLoader* iconLoader = new KIconLoader();

    QVBoxLayout* box = new QVBoxLayout( parent, 0, 6 );

    QLabel* lDirectoriesLabel = new QLabel( i18n("Directories to be scanned")+":", parent, "lDirectoriesLabel" );
    box->addWidget( lDirectoriesLabel );

//     KEditListBox* eDirectories = new KEditListBox( parent, "eDirectories" );
//     box->addWidget( eDirectories );

    QHBoxLayout* directoriesBox = new QHBoxLayout( box );
    lDirectories = new KListBox( parent, "lDirectories" );
    lDirectories->insertStringList( config->data.environment.directories );
    directoriesBox->addWidget( lDirectories );
    connect( lDirectories, SIGNAL(highlighted(int)),
               this, SLOT(directoriesSelectionChanged(int))
             );

    QVBoxLayout* directoriesMiddleBox = new QVBoxLayout( directoriesBox );
    pDirUp = new KPushButton( "", parent, "pDirUp" );
    pDirUp->setPixmap( iconLoader->loadIcon("up",KIcon::Toolbar) );
    pDirUp->setEnabled( false );
    QToolTip::add( pDirUp, i18n("Move selected directory one position up.\nThis effects which backend will be chosen, if there are several versions.") );
    directoriesMiddleBox->addWidget( pDirUp );
    connect( pDirUp, SIGNAL(clicked()),
               this, SLOT(dirUp())
             );

    directoriesMiddleBox->addStretch();
    pDirDown = new KPushButton( "", parent, "pDirDown" );
    pDirDown->setPixmap( iconLoader->loadIcon("down",KIcon::Toolbar) );
    pDirDown->setEnabled( false );
    QToolTip::add( pDirDown, i18n("Move selected directory one position down.\nThis effects which backend will be chosen, if there are several versions.") );
    directoriesMiddleBox->addWidget( pDirDown );
    connect( pDirDown, SIGNAL(clicked()),
               this, SLOT(dirDown())
             );

    QVBoxLayout* directoriesRightBox = new QVBoxLayout( directoriesBox );
    pAddDirectory = new KPushButton( iconLoader->loadIcon("add",KIcon::Small), i18n("Add ..."), parent, "pAddDirectory" );
    directoriesRightBox->addWidget( pAddDirectory );
    connect( pAddDirectory, SIGNAL(clicked()),
               this, SLOT(addDirectory())
             );

    pRemoveDirectory = new KPushButton( iconLoader->loadIcon("remove",KIcon::Small), i18n("Remove"), parent, "pRemoveDirectory" );
    directoriesRightBox->addWidget( pRemoveDirectory );
    pRemoveDirectory->setEnabled( false );
    connect( pRemoveDirectory, SIGNAL(clicked()),
               this, SLOT(removeDirectory())
             );

    directoriesRightBox->addStretch();

    box->addSpacing( 5 );

    QHBoxLayout* programsBox = new QHBoxLayout( box );

    QVBoxLayout* foundProgramsBox = new QVBoxLayout( programsBox );
    QLabel* lFoundProgramsLabel = new QLabel( i18n("Programs found")+":", parent, "lFoundProgramsLabel" );
    foundProgramsBox->addWidget( lFoundProgramsLabel );
    lFoundPrograms = new KListBox( parent, "lFoundPrograms" );
    lFoundPrograms->setSelectionMode( QListBox::NoSelection );
    foundProgramsBox->addWidget( lFoundPrograms );
    //connect(lPrograms,SIGNAL(highlighted(int)),this,SLOT(programsSelectionChanged(int)));
    programsBox->setStretchFactor( foundProgramsBox, 3 );

    QVBoxLayout* notFoundProgramsBox = new QVBoxLayout( programsBox );
    QLabel* lNotFoundProgramsLabel = new QLabel( i18n("Programs not found")+":", parent, "lNotFoundProgramsLabel" );
    notFoundProgramsBox->addWidget( lNotFoundProgramsLabel );
    lNotFoundPrograms = new KListBox( parent, "lNotFoundPrograms" );
    lNotFoundPrograms->setSelectionMode( QListBox::NoSelection );
    notFoundProgramsBox->addWidget( lNotFoundPrograms );
    //connect(lPrograms,SIGNAL(highlighted(int)),this,SLOT(programsSelectionChanged(int)));
    programsBox->setStretchFactor( notFoundProgramsBox, 2 );

    for( QMap<QString, QString>::Iterator it = config->binaries.begin(); it != config->binaries.end(); ++it ) {
        if( it.data() != "" ) {
            lFoundPrograms->insertItem( it.data() );
        }
        else {
            lNotFoundPrograms->insertItem( it.key() );
        }
    }

//     box->addStretch();

    // delete the icon loader object
    delete iconLoader;
}

ConfigEnvironmentPage::~ConfigEnvironmentPage()
{}

void ConfigEnvironmentPage::resetDefaults()
{
    lDirectories->clear();
    QString datadir = locateLocal( "data", "soundkonverter/bin/" );
    datadir.remove( datadir.length() - 1, 1 );
    lDirectories->insertItem( datadir );
    lDirectories->insertItem( QDir::homeDirPath() + "/bin" );
    lDirectories->insertItem( "/usr/local/bin" );
    lDirectories->insertItem( "/usr/bin" );

    refill();
    cfgChanged();
}

void ConfigEnvironmentPage::saveSettings()
{
    config->data.environment.directories.clear();
    for( uint i = 0; i < lDirectories->count(); i++ ) {
        config->data.environment.directories.append( lDirectories->text(i) );
    }

    config->binaries = *binaries;
}

void ConfigEnvironmentPage::directoriesSelectionChanged( int index )
{
    pRemoveDirectory->setEnabled( true );
    if( index != 0 ) pDirUp->setEnabled( true );
    else pDirUp->setEnabled( false );
    if( index != lDirectories->count() - 1 ) pDirDown->setEnabled( true );
    else pDirDown->setEnabled( false );
}

void ConfigEnvironmentPage::dirUp()
{
    int index = lDirectories->currentItem();
    if( index > 0 ) {
        QString text = lDirectories->currentText();
        lDirectories->removeItem( index );
        lDirectories->insertItem( text, index - 1 );
        lDirectories->setSelected( index - 1, true );
        refill();
        cfgChanged();
    }
}

void ConfigEnvironmentPage::dirDown()
{
    int index = lDirectories->currentItem();
    if( (uint)index < lDirectories->count() - 1 ) {
        QString text = lDirectories->currentText();
        lDirectories->removeItem( index );
        lDirectories->insertItem( text, index + 1 );
        lDirectories->setSelected( index + 1, true );
        refill();
        cfgChanged();
    }
}

void ConfigEnvironmentPage::addDirectory()
{
    QString dirname = KFileDialog::getExistingDirectory( "/", 0 );
    if( dirname != NULL ) {
        lDirectories->insertItem( dirname );
        refill();
        cfgChanged();
    }
}

void ConfigEnvironmentPage::removeDirectory()
{
    lDirectories->removeItem( lDirectories->currentItem() );
    refill();
    cfgChanged();
}

void ConfigEnvironmentPage::refill()
{
    for( QMap<QString, QString>::Iterator it = binaries->begin(); it != binaries->end(); ++it ) {
        it.data() = "";
        for( uint i = 0; i < lDirectories->count(); i++ ) {
            if( it.data() == "" && QFile::exists(lDirectories->text(i) + "/" + it.key()) ) {
                it.data() = lDirectories->text(i) + "/" + it.key();
            }
        }
    }

    lFoundPrograms->clear();
    lNotFoundPrograms->clear();
    for( QMap<QString, QString>::Iterator it = binaries->begin(); it != binaries->end(); ++it ) {
        if( it.data() != "" ) {
            lFoundPrograms->insertItem( it.data() );
        }
        else {
            lNotFoundPrograms->insertItem( it.key() );
        }
    }

    emit rebuildBackendsPage();
}


