

#ifndef CDOPENER_H
#define CDOPENER_H

#include <kdialog.h>

class CDManager;
class TagEngine;
class Config;
class ComboButton;
class KListView;
class KPushButton;
class KLineEdit;
class KComboBox;
class KIntSpinBox;
class KTextEdit;
class QGroupBox;
class QListViewItem;

/**
 * @short Shows a dialog for selecting files from a CD
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class CDOpener : public KDialog
{
     Q_OBJECT
public:
//     enum Mode {
//         all_tracks,
//         selected_tracks,
//         full_cd
//     };

    /**
     * Constructor
     * @param parent The parent widget
     * @param name The name of the file list
     * @p modal Sets whether the dialog is modal or not
     * @p f Some flags
     */
    CDOpener( Config*, CDManager*, TagEngine*, const QString &device, QWidget *parent = 0, const char *name = 0, /*Mode default_mode = all_tracks, const QString& default_text = "",*/ bool modal = true, WFlags f = 0 );

    /**
     * Destructor
     */
    virtual ~CDOpener();

private:
    /** A list of all tracks on the CD */
    KListView *trackList;

    /** A combobox for entering the artist or selecting VA of the whole CD */
    KComboBox *cArtist;
    /** A combobox for entering the composer or selecting VC of the whole CD */
    KComboBox *cComposer;
    /** A lineedit for entering the album name */
    KLineEdit *lAlbum;
    /** A spinbox for entering or selecting the disc number */
    KIntSpinBox *iDisc;
    /** A spinbox for entering or selecting the year of the album */
    KIntSpinBox *iYear;
    /** A combobox for entering or selecting the genre of the album */
    KComboBox *cGenre;

    /** Request CDDB information */
//     KPushButton *pCDDB;

    /** The groupbox shows the selected track numbers */
    QGroupBox *tagGroupBox;

    /** Set the focus of the tag editor to the track over it */
    KPushButton *pTrackUp;
    /** Set the focus of the tag editor to the track under it */
    KPushButton *pTrackDown;

    /** A lineedit for entering the title of track */
    KLineEdit *lTrackTitle;
    KPushButton *pTrackTitleEdit;
    /** A lineedit for entering the artist of a track */
    KLineEdit *lTrackArtist;
    KPushButton *pTrackArtistEdit;
    /** A lineedit for entering the composer of a track */
    KLineEdit *lTrackComposer;
    KPushButton *pTrackComposerEdit;
    /** A textedit for entering a comment for a track */
    KTextEdit *tTrackComment;
    KPushButton *pTrackCommentEdit;

    /** Save the tag information to a cue file */
    KPushButton *pSaveCue;
    //** Add whole CD as one track and quit the dialog */
    //KPushButton *pAddAsOneTrack;
    //** Add selected tracks to the file list and quit the dialog */
    //KPushButton *pAdd;
    ComboButton* cAdd;
    /** Quit the dialog */
    KPushButton *pCancel;

    CDManager* cdManager;
    TagEngine* tagEngine;
    Config* config;

    QString device;

    QValueList<int> selectedTracks;
    QValueList<QListViewItem*> selectedItems;

    int columnByName( const QString& name );

private slots:
    void trackChanged();
    void trackUpPressed();
    void trackDownPressed();
    void artistChanged( const QString& text );
    void composerChanged( const QString& text );
    void trackTitleChanged( const QString& text );
    void trackArtistChanged( const QString& text );
    void trackComposerChanged( const QString& text );
    void trackCommentChanged();
    void editTrackTitleClicked();
    void editTrackArtistClicked();
    void editTrackComposerClicked();
    void editTrackCommentClicked();
    void addClicked( int index = 1 );
//     void addAsOneTrackClicked();
    void saveCuesheetClicked();

signals:
    void addTracks( const QString& device, QValueList<int> );
    void addDisc( const QString& device );
    //void openCuesheetEditor( const QString& content );
};

#endif // CDOPENER_H
