

#include "options.h"
#include "options_simple.h"
#include "options_detailed.h"
//#include "debug_tab.h"
//#include "more_options.h"
#include "config.h"
#include "tools.h"
#include "backend_plugins.h"

#include <qlayout.h>
#include <qtabwidget.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qcombobox.h>
#include <qspinbox.h>
#include <qcheckbox.h>
#include <qfileinfo.h>

#include <klocale.h>

#include <fileref.h>
#include <tag.h>
#include <tstring.h>


Options::Options( QWidget *parent, const char *name, int text )
    : QWidget( parent, name )
{
    startup=true;

    QGridLayout *grid = new QGridLayout( this, 1, 1 );

    tab = new QTabWidget( this, "tab" );

    optionsS = new OptionsSimple( this, "optionsS", text );
    tab->addTab( optionsS, i18n("Simple") );

    optionsD = new OptionsDetailed( this, "optionsD" );
    tab->addTab( optionsD, i18n("Detailed") );

    /*debugTab = new DebugTab( this, "debugTab" );
    tab->addTab( debugTab, "Debug" );
    */

    tab->setCurrentPage(prefs.startTab);
    grid->addWidget( tab, 0, 0 );

    optionsS->cProfile->setCurrentItem( optionsS->profileIndex(prefs.lastOptions.profile) );
    optionsS->profileChanged();
    optionsS->cFormat->setCurrentItem( optionsS->formatIndex(prefs.lastOptions.format) );
    optionsS->formatChanged();
    if( prefs.lastOptions.profile == i18n("User defined") ) {
        //optionsD->setFormat( prefs.lastOptions.format );
        optionsD->setQualityMode( prefs.lastOptions.qualityMode );
        optionsD->setQuality( prefs.lastOptions.quality );
        optionsD->setBitrateMode( prefs.lastOptions.bitrateMode );
        optionsD->setBitrateRange( prefs.lastOptions.bitrateRange );
        optionsD->setMinBitrate( prefs.lastOptions.minBitrate );
        optionsD->setMaxBitrate( prefs.lastOptions.maxBitrate );
        optionsD->setResample( prefs.lastOptions.resample );
        optionsD->setSampleRateString( prefs.lastOptions.samplingrate );
        optionsD->setChannels( prefs.lastOptions.channels );
        optionsD->setNumChannels( prefs.lastOptions.numChannels );
        optionsD->setReplayGain( prefs.lastOptions.replaygain );
    }

    /*moreOptions = new MoreOptions(this);

    connect( optionsD, SIGNAL(showMoreOptions()),
             this, SLOT(showMoreOptions()) );
    */

    connect(optionsS,SIGNAL(setFormat(QString)),optionsD,SLOT(setFormat(QString)));
    connect(optionsS,SIGNAL(setQualityMode(QString)),optionsD,SLOT(setQualityMode(QString)));
    connect(optionsS,SIGNAL(setQuality(int)),optionsD,SLOT(setQuality(int)));
    connect(optionsS,SIGNAL(setBitrateRange(bool)),optionsD,SLOT(setBitrateRange(bool)));
    connect(optionsS,SIGNAL(setResample(bool)),optionsD,SLOT(setResample(bool)));
    connect(optionsS,SIGNAL(setSampleRate(int)),optionsD,SLOT(setSampleRate(int)));
    connect(optionsS,SIGNAL(setChannels(bool)),optionsD,SLOT(setChannels(bool)));
    connect(optionsS,SIGNAL(setNumChannels(QString)),optionsD,SLOT(setNumChannels(QString)));

    connect(tab,SIGNAL(currentChanged(QWidget*)),this,SLOT(tabChanged(QWidget*)));

    optionsS->profileChanged();
}

Options::~Options()
{
}

void Options::saveOptions()
{
/*    prefs.lastOptions.profile=*(optionsS->sProfile.at(optionsS->cProfile->currentItem()));
    prefs.lastOptions.format=optionsD->cFormat->currentText();
    prefs.lastOptions.qualityMode=*(optionsD->sQualityMode.at(optionsD->cQualityMode->currentItem()));
    prefs.lastOptions.quality=optionsD->sQuality->value();
    prefs.lastOptions.bitrateMode=*(optionsD->sBitrateMode.at(optionsD->cBitrateMode->currentItem()));
    prefs.lastOptions.bitrateRange=optionsD->cBitrateRange->isChecked();
    prefs.lastOptions.minBitrate=optionsD->sMinBitrate->value();
    prefs.lastOptions.maxBitrate=optionsD->sMaxBitrate->value();
    prefs.lastOptions.resample=optionsD->cResample->isChecked();
    prefs.lastOptions.samplingrate=optionsD->cSampleRate->currentText();
    prefs.lastOptions.channels=optionsD->cChannels->isChecked();
    prefs.lastOptions.numChannels=*(optionsD->sNumChannels.at(optionsD->cNumChannels->currentItem()));
    prefs.lastOptions.replaygain=optionsD->cReplayGain->isChecked();
*/
    if( tab->currentPage() == optionsS ) {
        prefs.lastOptions.profile=optionsS->cProfile->currentText();
    }
    else {
        prefs.lastOptions.profile=i18n("User defined");
    }
    if( optionsD->cQualityMode->currentText() == i18n("Lossless") ) {
        prefs.lastOptions.profile=i18n("Lossless");
    }
    prefs.lastOptions.format=optionsD->cFormat->currentText();
    prefs.lastOptions.qualityMode=optionsD->cQualityMode->currentText();
    prefs.lastOptions.quality=optionsD->sQuality->value();
    prefs.lastOptions.bitrateMode=optionsD->cBitrateMode->currentText();
    prefs.lastOptions.bitrateRange=optionsD->cBitrateRange->isChecked();
    prefs.lastOptions.minBitrate=optionsD->sMinBitrate->value();
    prefs.lastOptions.maxBitrate=optionsD->sMaxBitrate->value();
    prefs.lastOptions.resample=optionsD->cResample->isChecked();
    prefs.lastOptions.samplingrate=optionsD->cSampleRate->currentText();
    prefs.lastOptions.channels=optionsD->cChannels->isChecked();
    prefs.lastOptions.numChannels=optionsD->cNumChannels->currentText();
    prefs.lastOptions.replaygain=optionsD->cReplayGain->isChecked();
}

#ifdef DEBUG
void Options::debugInit()
{
    QStringList fileoptions;
    QString samplingrate;
    QString channels;
    QString replaygain;

    for( FileFormatList::Iterator it=prefs.fileFormatList.begin(); it!=prefs.fileFormatList.end(); ++it )
    {
      BackendPlugins::PluginStructure plugin=backendPlugins.plugin(prefs.fileFormat((*it).extension).encoder);
      if( plugin.info.name == i18n("Unnamed") || plugin.enc.formats.findIndex((*it).extension) == -1 ) continue;

      for( int i=0; i<4; i++ )
      {
        if(i==0&&plugin.enc.resample.enabled){
            samplingrate="22050 Hz";
            channels="-";
            replaygain=i18n("no");
        } else if(i==0) continue;
        if(i==1&&plugin.enc.channels.mono_enabled){
            samplingrate="-";
            channels=i18n("Mono");
            replaygain=i18n("no");
        } else if(i==1) continue;
        if(i==2&&plugin.enc.replaygain.enabled){
            samplingrate="-";
            channels="-";
            replaygain=i18n("yes");
        } else if(i==2) continue;
        if(i==3){
            samplingrate="-";
            channels="-";
            replaygain=i18n("no");
        }
        if(plugin.enc.quality.enabled) {
            fileoptions.clear();
            fileoptions.append(QString("/home/daniel/test.wav").append("$soundkonverter-spacer$").append((*it).extension).append("$soundkonverter-spacer$").append("4").append("$soundkonverter-spacer$").append("-").append("$soundkonverter-spacer$").append("vbr").append("$soundkonverter-spacer$").append(samplingrate).append("$soundkonverter-spacer$").append(channels).append("$soundkonverter-spacer$").append(replaygain).append("$soundkonverter-spacer$").append("Waiting (Auto)"));
            fileoptions.append("/home/daniel/test.wav");
            fileoptions.append((*it).extension);
            fileoptions.append("4");
            fileoptions.append("-");
            fileoptions.append("vbr");
            fileoptions.append(samplingrate);
            fileoptions.append(channels);
            fileoptions.append(replaygain);
            fileoptions.append("plugin.enc.quality.enabled");
            emit addFile(fileoptions);
            emit timeAdded( tools.timeByFile("/home/daniel/test.wav")*prefs.fileFormat((*it).extension).encTime );
            if( replaygain == i18n("yes") ) {
                emit timeAdded( tools.timeByFile("/home/daniel/test.wav")*prefs.fileFormat((*it).extension).repTime );
            }
        }
        if(plugin.enc.bitrate.cbr.enabled) {
            fileoptions.clear();
            fileoptions.append(QString("/home/daniel/test.wav").append("$soundkonverter-spacer$").append((*it).extension).append("$soundkonverter-spacer$").append("128 kbps").append("$soundkonverter-spacer$").append("-").append("$soundkonverter-spacer$").append("cbr").append("$soundkonverter-spacer$").append(samplingrate).append("$soundkonverter-spacer$").append(channels).append("$soundkonverter-spacer$").append(replaygain).append("$soundkonverter-spacer$").append("Waiting (Auto)"));
            fileoptions.append("/home/daniel/test.wav");
            fileoptions.append((*it).extension);
            fileoptions.append("128 kbps");
            fileoptions.append("-");
            fileoptions.append("cbr");
            fileoptions.append(samplingrate);
            fileoptions.append(channels);
            fileoptions.append(replaygain);
            fileoptions.append("plugin.enc.bitrate.cbr.enabled");
            emit addFile(fileoptions);
            emit timeAdded( tools.timeByFile("/home/daniel/test.wav")*prefs.fileFormat((*it).extension).encTime );
            if( replaygain == i18n("yes") ) {
                emit timeAdded( tools.timeByFile("/home/daniel/test.wav")*prefs.fileFormat((*it).extension).repTime );
            }
        }
        if(plugin.enc.bitrate.abr.enabled) {
            fileoptions.clear();
            fileoptions.append(QString("/home/daniel/test.wav").append("$soundkonverter-spacer$").append((*it).extension).append("$soundkonverter-spacer$").append("128 kbps").append("$soundkonverter-spacer$").append("-").append("$soundkonverter-spacer$").append("abr").append("$soundkonverter-spacer$").append(samplingrate).append("$soundkonverter-spacer$").append(channels).append("$soundkonverter-spacer$").append(replaygain).append("$soundkonverter-spacer$").append("Waiting (Auto)"));
            fileoptions.append("/home/daniel/test.wav");
            fileoptions.append((*it).extension);
            fileoptions.append("128 kbps");
            fileoptions.append("-");
            fileoptions.append("abr");
            fileoptions.append(samplingrate);
            fileoptions.append(channels);
            fileoptions.append(replaygain);
            fileoptions.append("plugin.enc.bitrate.abr.enabled");
            emit addFile(fileoptions);
            emit timeAdded( tools.timeByFile("/home/daniel/test.wav")*prefs.fileFormat((*it).extension).encTime );
            if( replaygain == i18n("yes") ) {
                emit timeAdded( tools.timeByFile("/home/daniel/test.wav")*prefs.fileFormat((*it).extension).repTime );
            }
        }
        if(plugin.enc.bitrate.abr.bitrate_range.enabled) {
            fileoptions.clear();
            fileoptions.append(QString("/home/daniel/test.wav").append("$soundkonverter-spacer$").append((*it).extension).append("$soundkonverter-spacer$").append("128 kbps").append("$soundkonverter-spacer$").append("96-192 kbps").append("$soundkonverter-spacer$").append("abr").append("$soundkonverter-spacer$").append(samplingrate).append("$soundkonverter-spacer$").append(channels).append("$soundkonverter-spacer$").append(replaygain).append("$soundkonverter-spacer$").append("Waiting (Auto)"));
            fileoptions.append("/home/daniel/test.wav");
            fileoptions.append((*it).extension);
            fileoptions.append("128 kbps");
            fileoptions.append("96-192 kbps");
            fileoptions.append("abr");
            fileoptions.append(samplingrate);
            fileoptions.append(channels);
            fileoptions.append(replaygain);
            fileoptions.append("plugin.enc.bitrate.abr.bitrate_range.enabled");
            emit addFile(fileoptions);
            emit timeAdded( tools.timeByFile("/home/daniel/test.wav")*prefs.fileFormat((*it).extension).encTime );
            if( replaygain == i18n("yes") ) {
                emit timeAdded( tools.timeByFile("/home/daniel/test.wav")*prefs.fileFormat((*it).extension).repTime );
            }
        }
        if(plugin.enc.lossless.enabled) {
            fileoptions.clear();
            fileoptions.append(QString("/home/daniel/test.wav").append("$soundkonverter-spacer$").append((*it).extension).append("$soundkonverter-spacer$").append("-").append("$soundkonverter-spacer$").append("-").append("$soundkonverter-spacer$").append("-").append("$soundkonverter-spacer$").append(samplingrate).append("$soundkonverter-spacer$").append(channels).append("$soundkonverter-spacer$").append(replaygain).append("$soundkonverter-spacer$").append("Waiting (Auto)"));
            fileoptions.append("/home/daniel/test.wav");
            fileoptions.append((*it).extension);
            fileoptions.append("-");
            fileoptions.append("-");
            fileoptions.append("-");
            fileoptions.append(samplingrate);
            fileoptions.append(channels);
            fileoptions.append(replaygain);
            fileoptions.append("plugin.enc.lossless.enabled");
            emit addFile(fileoptions);
            emit timeAdded( tools.timeByFile("/home/daniel/test.wav")*prefs.fileFormat((*it).extension).encTime );
            if( replaygain == i18n("yes") ) {
                emit timeAdded( tools.timeByFile("/home/daniel/test.wav")*prefs.fileFormat((*it).extension).repTime );
            }
        }
        if(!plugin.enc.lossless.enabled&&!plugin.enc.lossy.enabled) {
            fileoptions.clear();
            fileoptions.append(QString("/home/daniel/test.wav").append("$soundkonverter-spacer$").append((*it).extension).append("$soundkonverter-spacer$").append("-").append("$soundkonverter-spacer$").append("-").append("$soundkonverter-spacer$").append("-").append("$soundkonverter-spacer$").append(samplingrate).append("$soundkonverter-spacer$").append(channels).append("$soundkonverter-spacer$").append(replaygain).append("$soundkonverter-spacer$").append("Waiting (Auto)"));
            fileoptions.append("/home/daniel/test.wav");
            fileoptions.append((*it).extension);
            fileoptions.append("-");
            fileoptions.append("-");
            fileoptions.append("-");
            fileoptions.append(samplingrate);
            fileoptions.append(channels);
            fileoptions.append(replaygain);
            fileoptions.append("!plugin.enc.lossless.enabled&&!plugin.enc.lossy.enabled");
            emit addFile(fileoptions);
            emit timeAdded( tools.timeByFile("/home/daniel/test.wav")*prefs.fileFormat((*it).extension).encTime );
            if( replaygain == i18n("yes") ) {
                emit timeAdded( tools.timeByFile("/home/daniel/test.wav")*prefs.fileFormat((*it).extension).repTime );
            }
        }
      }

      if(plugin.dec.enabled)
      {
          fileoptions.clear();
          fileoptions.append(QString("/home/daniel/temp/soundkonverter/test."+(*it).extension).append("$soundkonverter-spacer$").append("wav").append("$soundkonverter-spacer$").append("-").append("$soundkonverter-spacer$").append("-").append("$soundkonverter-spacer$").append("-").append("$soundkonverter-spacer$").append("-").append("$soundkonverter-spacer$").append("-").append("$soundkonverter-spacer$").append("-").append("$soundkonverter-spacer$").append("Waiting (Auto)"));
          fileoptions.append("/home/daniel/temp/soundkonverter/test."+(*it).extension);
          fileoptions.append("wav");
          fileoptions.append("-");
          fileoptions.append("-");
          fileoptions.append("-");
          fileoptions.append(samplingrate);
          fileoptions.append(channels);
          fileoptions.append(replaygain);
          fileoptions.append("plugin.dec.enabled");
          emit addFile(fileoptions);
          emit timeAdded( tools.timeByFile("/home/daniel/temp/soundkonverter/test."+(*it).extension)*prefs.fileFormat((*it).extension).decTime );
      }
    }
}
#endif

// Edit this to insert new codecs (optional)
void Options::addFiles( QStringList list )
{
    char cQuality[8], cBitrateRange[32];
    QString sFormat, sQuality, sBitrateMode, sBitrateRange, sSampleRate, sChannels, sReplayGain, sState;
    QStringList options;
    QString params;

    sFormat = optionsD->cFormat->currentText();
    sBitrateMode = optionsD->cBitrateMode->currentText();

    if( optionsD->cQualityMode->currentText() == i18n("Bitrate") ) {
        sprintf( cQuality, "%d kbps", optionsD->sQuality->value() );
        sQuality = cQuality;
    }
    else if( optionsD->cQualityMode->currentText() == i18n("Quality") ) {
        sprintf( cQuality, "%d", optionsD->sQuality->value() );
        sQuality = cQuality;
    }
    else {
        sQuality = "-";
        sBitrateMode = "-";
    }

    if( optionsD->cBitrateRange->isChecked() && optionsD->cBitrateRange->isEnabled() ) {
        sprintf(cBitrateRange, "%i-%i", optionsD->sMinBitrate->value(), optionsD->sMaxBitrate->value() );
        sBitrateRange = cBitrateRange;
    }
    else {
        sBitrateRange = "-";
    }

    if( optionsD->cResample->isChecked() && optionsD->cResample->isEnabled() ) {
        sSampleRate = optionsD->cSampleRate->currentText()+" Hz";
    }
    else {
        sSampleRate = "-";
    }

    if( optionsD->cChannels->isChecked() && optionsD->cChannels->isEnabled() ) {
        sChannels = optionsD->cNumChannels->currentText();
    }
    else {
        sChannels = "-";
    }

    if( optionsD->cReplayGain->isChecked() && optionsD->cReplayGain->isEnabled() ) {
        sReplayGain = i18n("yes");
    }
    else {
        sReplayGain = i18n("no");
    }

    /*if( sFormat == "wav" || sFormat == "flac" || sFormat == "ape" ) {
        sQuality = "-";
        sBitrateMode = "-";
        sBitrateRange = "-";
        sSampleRate = "-";
        sChannels = "-";
    }
    else if( sFormat == "mpc" ) {
        sBitrateRange = "-";
        sSampleRate = "-";
        sChannels = "-";
    }*/
    sState = i18n("Waiting...");

    QStringList::Iterator it = list.begin();
    while( it != list.end() )
    {
        if (*it == NULL)
            break;
        QFileInfo file(*it);
        if (!file.exists())
            break;
        if (file.isDir())
            break;

        QString sInputFormat=tools.fileExtension(*it);

        if( sInputFormat != "wav" || sFormat != "wav" )
        {
            if( sInputFormat != "wav" ) {
                emit timeAdded( tools.timeByFile(*it)*prefs.fileFormat(sInputFormat).decTime );
            }
            if( sFormat != "wav" ) {
                emit timeAdded( tools.timeByFile(*it)*prefs.fileFormat(sFormat).encTime );
            }
            if( sReplayGain == i18n("yes") ) {
                emit timeAdded( tools.timeByFile(*it)*prefs.fileFormat(sFormat).repTime );
            }

            params=*it;
            params+="$soundkonverter-spacer$"+sFormat;
            params+="$soundkonverter-spacer$"+sQuality;
            params+="$soundkonverter-spacer$"+sBitrateRange;
            params+="$soundkonverter-spacer$"+sBitrateMode;
            params+="$soundkonverter-spacer$"+sSampleRate;
            params+="$soundkonverter-spacer$"+sChannels;
            params+="$soundkonverter-spacer$"+sReplayGain;
            params+="$soundkonverter-spacer$"+sState;

            options.clear();
            options.append(params);
            options.append(*it);
            options.append(sFormat);
            options.append(sQuality);
            options.append(sBitrateRange);
            options.append(sBitrateMode);
            options.append(sSampleRate);
            options.append(sChannels);
            options.append(sReplayGain);
            options.append(sState);
            emit addFile(options);
        }
        it++;
    }
    emit allFilesAdded();
}

// Edit this to insert new codecs
void Options::tabChanged( QWidget *widget ) // FIXME Edit this to insert new codecs
{
    QString format, qualityMode, numChannels;
    int quality, sampleRate;
    bool bitrateRange, resample, channels;

    if( startup ) {
        startup=false;
        return;
    }

    if( widget == optionsS ) {
        format=optionsD->getFormat();
        qualityMode=optionsD->getQualityMode();
        numChannels=optionsD->getNumChannels();
        quality=optionsD->getQuality();
        sampleRate=optionsD->getSampleRate();
        bitrateRange=optionsD->getBitrateRange();
        resample=optionsD->getResample();
        channels=optionsD->getChannels();

        /*if( format == "flac" || format == "wav" || format == "ape" )
            optionsS->cProfile->setCurrentItem( optionsS->profileIndex("Lossless") );
        else if( format == "mpc" && quality == 20 )
            optionsS->cProfile->setCurrentItem( optionsS->profileIndex("Very Low") );
        else if( format == "mpc" && quality == 30 )
            optionsS->cProfile->setCurrentItem( optionsS->profileIndex("Low") );
        else if( format == "mpc" && quality == 40 )
            optionsS->cProfile->setCurrentItem( optionsS->profileIndex("Medium") );
        else if( format == "mpc" && quality == 50 )
            optionsS->cProfile->setCurrentItem( optionsS->profileIndex("High") );
        else if( format == "mpc" && quality == 60 )
            optionsS->cProfile->setCurrentItem( optionsS->profileIndex("Very High") );
        else if( qualityMode == i18n("Quality") && quality == 20 && !bitrateRange &&
        resample && sampleRate == 22050 && channels && numChannels == i18n("Mono") )
            optionsS->cProfile->setCurrentItem( optionsS->profileIndex("Very Low") );
        else if( qualityMode == i18n("Quality") && quality == 30 && !bitrateRange &&
        resample && sampleRate == 22050 && !channels )
            optionsS->cProfile->setCurrentItem( optionsS->profileIndex("Low") );
        else if( qualityMode == i18n("Quality") && quality == 40 && !bitrateRange &&
        !resample && !channels )
            optionsS->cProfile->setCurrentItem( optionsS->profileIndex("Medium") );
        else if( qualityMode == i18n("Quality") && quality == 50 && !bitrateRange &&
        !resample && !channels )
            optionsS->cProfile->setCurrentItem( optionsS->profileIndex("High") );
        else if( qualityMode == i18n("Quality") && quality == 60 && !bitrateRange &&
        !resample && !channels )
            optionsS->cProfile->setCurrentItem( optionsS->profileIndex("Very High") );
        else
            optionsS->cProfile->setCurrentItem( optionsS->profileIndex("User defined") );*/

/*        BackendPlugins::PluginStructure plugin=backendPlugins.plugin(prefs.fileFormat(actFile.Convert.sOutputFormat).encoder);

        if( ( plugin.enc.quality.enabled && qualityMode == i18n("Quality") ) || ( ( plugin.enc.bitrate.abr || plugin.enc.bitrate.cbr ) && qualityMode == i18n("Bitrate") ) &&
        ( ( plugin.enc.quality.enabled && quality == 20 ) || ( plugin.enc.bitrate.abr || plugin.enc.bitrate.cbr ) && quality == 64 ) &&
        !bitrateRange &&
        resample
        && sampleRate == 22050 &&
        channels
        && numChannels == i18n("Mono") )
            optionsS->cProfile->setCurrentItem( optionsS->profileIndex("Very Low") );
        else if( qualityMode == i18n("Quality") && quality == 30 && !bitrateRange &&
        resample && sampleRate == 22050 && !channels )
            optionsS->cProfile->setCurrentItem( optionsS->profileIndex("Low") );
        else if( qualityMode == i18n("Quality") && quality == 40 && !bitrateRange &&
        !resample && !channels )
            optionsS->cProfile->setCurrentItem( optionsS->profileIndex("Medium") );
        else if( qualityMode == i18n("Quality") && quality == 50 && !bitrateRange &&
        !resample && !channels )
            optionsS->cProfile->setCurrentItem( optionsS->profileIndex("High") );
        else if( qualityMode == i18n("Quality") && quality == 60 && !bitrateRange &&
        !resample && !channels )
            optionsS->cProfile->setCurrentItem( optionsS->profileIndex("Very High") );
        else
            optionsS->cProfile->setCurrentItem( optionsS->profileIndex("User defined") );
*/

        if( optionsD->cQualityMode->currentText() == i18n("Lossless") )
            optionsS->cProfile->setCurrentItem( optionsS->profileIndex(i18n("Lossless")) );
        else
            optionsS->cProfile->setCurrentItem( optionsS->profileIndex(i18n("User defined")) );

        // FIXME dirty
        optionsS->cFormat->clear();
        optionsS->sFormat=backendPlugins.allFileFormats();
        optionsS->cFormat->insertStringList(optionsS->sFormat);
        optionsS->cFormat->insertItem( "wav" );
        optionsS->sFormat.append( "wav" );
        optionsS->cFormat->setCurrentItem( optionsS->formatIndex(format) );

        optionsS->profileChanged();
    }
    else {
        optionsS->cProfile->setCurrentItem( optionsS->profileIndex(i18n("User defined")) );
    }
}

void Options::reset()
{
     QString format=optionsD->getFormat();

     optionsS->cFormat->clear();
     optionsS->sFormat=backendPlugins.allFileFormats();
     optionsS->cFormat->insertStringList(optionsS->sFormat);
     optionsS->cFormat->insertItem( "wav" );
     optionsS->sFormat.append( "wav" );
     optionsS->cFormat->setCurrentItem( optionsS->formatIndex(format) );
     optionsS->profileChanged();

     optionsD->cFormat->clear();
     optionsD->sFormat=backendPlugins.allFileFormats();
     optionsD->cFormat->insertStringList(optionsD->sFormat);
     optionsD->cFormat->insertItem( "wav" );
     optionsD->sFormat.append( "wav" );
     optionsD->cFormat->setCurrentItem( optionsD->formatIndex(format) );
     optionsD->formatChanged();
}

QString Options::currentFormat()
{
    return optionsD->cFormat->currentText();
}

/*void Options::showMoreOptions()
{
    moreOptions->exec();
}
*/
