
#include "config_dialogue_interface.h"
#include "config_defaults.h"
#include "config.h"

#include <qspinbox.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qtooltip.h>

#include <klocale.h>
#include <kfontrequester.h>


ConfigDialogueInterface::ConfigDialogueInterface( QWidget *parent, const char *name )
    : QWidget( parent, name )
{
    QVBoxLayout *box = new QVBoxLayout( this, 5 );

    QHBoxLayout *startTabBox = new QHBoxLayout(box);
    QLabel *lStartTab = new QLabel( i18n("Start in Mode")+":", this, "lStartTab" );
    startTabBox->addWidget(lStartTab);
    cStartTab = new QComboBox( this, "cStartTab" );
    cStartTab->insertItem( i18n("Simple") );
    cStartTab->insertItem( i18n("Detailed") );
    cStartTab->setCurrentItem(prefs.startTab);
    startTabBox->addWidget(cStartTab);
    connect(cStartTab,SIGNAL(activated(int)),this,SLOT(cfgChanged()));

    box->addSpacing(10);

    QHBoxLayout *pauseBox = new QHBoxLayout(box);
    QLabel *lPauseMS = new QLabel( i18n("Status update delay (time in ms)")+":", this, "lPauseMS" );
    pauseBox->addWidget(lPauseMS);
    sPauseMS = new QSpinBox(this, "sPauseMS");
    sPauseMS->setMinValue(100);
    sPauseMS->setMaxValue(5000);
    sPauseMS->setLineStep(100);
    sPauseMS->setValue(prefs.convert.pauseMS);
    QToolTip::add( sPauseMS, i18n("This time (in milliseconds) describes the breaks between the display is updated with the actual progress status.") );
    pauseBox->addWidget(sPauseMS);
    connect(sPauseMS,SIGNAL(valueChanged(int)),this,SLOT(cfgChanged()));

    box->addSpacing(10);

    QHBoxLayout *fontBox = new QHBoxLayout(box);
    QLabel *lFileListFontLabel = new QLabel( i18n("File list font")+":", this, "lFileListFontLabel" );
    fontBox->addWidget(lFileListFontLabel);
    fFileListFont = new KFontRequester(this,"fFileListFont");
    fFileListFont->setFont(prefs.fileListFont);
    fontBox->addWidget(fFileListFont);
    connect(fFileListFont,SIGNAL(fontSelected(const QFont&)),this,SLOT(cfgChanged()));

    box->addSpacing(10);

    QHBoxLayout *askForNewOptionsBox = new QHBoxLayout(box);
    cAskForNewOptions = new QCheckBox( i18n("Ask for new options, when adding files from external program"), this, "cAskForNewOptions" );
    QToolTip::add( cAskForNewOptions, i18n("If you open a file with soundKonverter and soundKonverter is already running,\nyou can either be asked to define new converting options\nor the current settings from the soundKonverter main window are used.") );
    cAskForNewOptions->setChecked(prefs.askForNewOptions);
    askForNewOptionsBox->addWidget(cAskForNewOptions);
    connect(cAskForNewOptions,SIGNAL(toggled(bool)),this,SLOT(cfgChanged()));

    box->addStretch();
}

ConfigDialogueInterface::~ConfigDialogueInterface()
{
}

void ConfigDialogueInterface::resetDefaults()
{
    cStartTab->setCurrentItem(DEFAULT_STARTTAB);
    sPauseMS->setValue(DEFAULT_PAUSEMS);
    fFileListFont->setFont(QFont());
    cAskForNewOptions->setChecked(DEFAULT_ASK_FOR_NEW_OPTIONS);
}

void ConfigDialogueInterface::saveSettings()
{
    prefs.startTab=cStartTab->currentItem();
    prefs.convert.pauseMS=sPauseMS->value();
    prefs.fileListFont=fFileListFont->font();
    prefs.askForNewOptions=cAskForNewOptions->isChecked();
}

void ConfigDialogueInterface::cfgChanged()
{
    emit configChanged();
}
