
#ifndef _CONFIG_DIALOGUE_EN_DECODER_OPTIONS_H_
#define _CONFIG_DIALOGUE_EN_DECODER_OPTIONS_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qwidget.h>

class KPushButton;
class QGroupBox;
class QGridLayout;
class QLabel;
class QSlider;
class QCheckBox;

class StrengthOptions
{
public:
    QString encoder;
    QGroupBox *group;
    QGridLayout *topGrid;
    QLabel *lStrength;
    QGridLayout *grid;
    QSlider *sStrength;
    QLabel *lStrengthInfoLeft;
    QLabel *lStrengthInfoRight;

    StrengthOptions();
    StrengthOptions(QString);
    ~StrengthOptions();
};

typedef QValueList<StrengthOptions> StrengthOptionsList;

/**
 * @short ConfigDialogueEnDecoderOptions
 * @author Daniel Faust <daniel@kaligames.de>
 * @version 0.1
 */
class ConfigDialogueEnDecoderOptions : public QWidget
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    ConfigDialogueEnDecoderOptions( QWidget *parent=0, const char *name=0 );

    /**
     * Default Destructor
     */
    virtual ~ConfigDialogueEnDecoderOptions();

private:
    //QCheckBox *cCRC;
    //QCheckBox *cISO;
    StrengthOptionsList strengthOptions;

public slots:
    void cfgChanged();
    void resetDefaults();
    void saveSettings();

signals:
    void configChanged();

private slots:

};

#endif // _CONFIG_DIALOGUE_EN_DECODER_OPTIONS_H_

