
#ifndef _CONFIG_DIALOGUE_BACKENDS_H_
#define _CONFIG_DIALOGUE_BACKENDS_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qwidget.h>

#include <kio/jobclasses.h>

class KPushButton;
class QListBox;
//class QProgressBar;
class QCheckBox;

/**
 * @short ConfigDialogueBackends
 * @author Daniel Faust <daniel@kaligames.de>
 * @version 0.1
 */
class ConfigDialogueBackends : public QWidget
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    ConfigDialogueBackends( QWidget *parent=0, const char *name=0 );

    /**
     * Default Destructor
     */
    virtual ~ConfigDialogueBackends();

private:
    QListBox *lDirectories;
    KPushButton *pAddDirectory;
    KPushButton *pRemoveDirectory;
    KPushButton *pRescanDirectories;
    KPushButton *pDirUp;
    KPushButton *pDirDown;
    QListBox *lPrograms;
    KPushButton *pRemoveProgram;
    QListBox *lOnlineBackends;
    KPushButton *pRefreshBackends;
    KPushButton *pInstallBackend;
    KPushButton *pAboutOnlineBackend;
    //QProgressBar *pDownloadBackendProgress;
    KIO::FileCopyJob *refreshBackendsJob;
    KIO::FileCopyJob *installBackendJob;
    KIO::FileCopyJob *getBackendInfoJob;
    QCheckBox *cCheckOnlineBackends;
    //QString downloadedBackend;
    QString distribution;

public slots:
    void resetDefaults();
    void saveSettings();
    void rescan();

signals:
    void configChanged();
    void recalcEnDecoderPage();

private slots:
    void cfgChanged();
    void dirUp();
    void dirDown();
    void addDirectory();
    void removeDirectory();

    void removeProgram();

    void refreshBackendDownloads();
    void installBackend();
    void getBackendInfo();
    //void downloadProgressbar(KIO::Job*,unsigned long);
    void refreshFinished(KIO::Job*);
    void installFinished(KIO::Job*);
    void getInfoFinished(KIO::Job*);
    void directoriesSelectionChanged(int);
    void programsSelectionChanged(int);
    void onlineBackendsSelectionChanged(int);

};

#endif // _CONFIG_DIALOGUE_BACKENDS_H_

