
#include "config_dialogue.h"

#include "config_dialogue_interface.h"
#include "config_dialogue_backend_plugins.h"
#include "config_dialogue_backends.h"
#include "config_dialogue_en_decoder.h"
#include "config_dialogue_en_decoder_options.h"

#include "tools.h"
#include "backend_plugins.h"
#include "replaygain_plugins.h"

#include <qlayout.h>

#include <kconfig.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kpushbutton.h>

ConfigDialogue::ConfigDialogue(QWidget *parent, const char *name, int index)
    : KDialogBase(
        IconList,
        i18n("Settings"),
        Apply | Cancel | Default | Help | Ok,
        Ok, // default button
        parent,
        name,
        true, // modal
        true // separator
    )
{
    connect(this,SIGNAL(applyClicked()),this,SLOT(applyClickedSlot()));
    connect(this,SIGNAL(okClicked()),this,SLOT(okClickedSlot()));
    connect(this,SIGNAL(defaultClicked()),this,SLOT(defaultClickedSlot()));

    interfacePage = addPage(i18n("Interface"), "style");
    QGridLayout *dInterfaceGrid = new QGridLayout( interfacePage );
    dInterface = new ConfigDialogueInterface(interfacePage,"dInterface");
    dInterfaceGrid->addWidget(dInterface,0,0);
    connect(dInterface,SIGNAL(configChanged()),this,SLOT(configChanged()));
    connect(this,SIGNAL(resetInterface()),dInterface,SLOT(resetDefaults()));
    connect(this,SIGNAL(saveInterface()),dInterface,SLOT(saveSettings()));

    backendPluginsPage = addPage(i18n("Backend Plugins"), "connect_creating");
    QGridLayout *dBackendPluginsGrid = new QGridLayout( backendPluginsPage );
    dBackendPlugins = new ConfigDialogueBackendPlugins(backendPluginsPage,"dBackendPlugins");
    dBackendPluginsGrid->addWidget(dBackendPlugins,0,0);
    connect(dBackendPlugins,SIGNAL(configChanged()),this,SLOT(configChanged()));
    connect(this,SIGNAL(resetBackendPlugins()),dBackendPlugins,SLOT(resetDefaults()));
    connect(this,SIGNAL(saveBackendPlugins()),dBackendPlugins,SLOT(saveSettings()));

    backendsPage = addPage(i18n("Backends"), "kcmsystem");
    QGridLayout *dBackendsGrid = new QGridLayout( backendsPage );
    dBackends = new ConfigDialogueBackends(backendsPage,"dBackends");
    dBackendsGrid->addWidget(dBackends,0,0);
    connect(dBackends,SIGNAL(configChanged()),this,SLOT(configChanged()));
    connect(this,SIGNAL(resetBackends()),dBackends,SLOT(resetDefaults()));
    connect(this,SIGNAL(saveBackends()),dBackends,SLOT(saveSettings()));

    connect(dBackendPlugins,SIGNAL(rescanForBackends()),dBackends,SLOT(rescan()));

    enDecoderPage = addPage(i18n("En, Decoder"), "run");
    QGridLayout *dEnDecoderGrid = new QGridLayout( enDecoderPage );
    dEnDecoder = new ConfigDialogueEnDecoder(enDecoderPage,"dEnDecoder");
    dEnDecoderGrid->addWidget(dEnDecoder,0,0);
    connect(dEnDecoder,SIGNAL(configChanged()),this,SLOT(configChanged()));
    connect(this,SIGNAL(recalcEnDecoderPage()),dEnDecoder,SLOT(recalc()));
    connect(this,SIGNAL(resetEnDecoder()),dEnDecoder,SLOT(resetDefaults()));
    connect(this,SIGNAL(saveEnDecoder()),dEnDecoder,SLOT(saveSettings()));

    connect(dBackendPlugins,SIGNAL(recalcEnDecoderPage()),dEnDecoder,SLOT(recalc()));
    connect(dBackends,SIGNAL(recalcEnDecoderPage()),dEnDecoder,SLOT(recalc()));
    connect(dBackendPlugins,SIGNAL(reloadEnDecoderPage()),dEnDecoder,SLOT(reload()));

    enDecoderOptionsPage = addPage(i18n("En, Decoder Options"), "package_development");
    QGridLayout *dEnDecoderOptionsGrid = new QGridLayout( enDecoderOptionsPage );
    dEnDecoderOptions = new ConfigDialogueEnDecoderOptions(enDecoderOptionsPage,"dEnDecoderOptions");
    dEnDecoderOptionsGrid->addWidget(dEnDecoderOptions,0,0);
    connect(dEnDecoderOptions,SIGNAL(configChanged()),this,SLOT(configChanged()));
    connect(this,SIGNAL(resetEnDecoderOptions()),dEnDecoderOptions,SLOT(resetDefaults()));
    connect(this,SIGNAL(saveEnDecoderOptions()),dEnDecoderOptions,SLOT(saveSettings()));

    //resize(760,540);
    ///adjustSize();
    ///resize(760,height());
    resize(QSize(dBackends->sizeHint().width()+400,dBackends->sizeHint().height()+100));

    //setMinimumHeight(height());

    setConfigChanged(false);

    if( index != -1 ) showPage(index);
}

ConfigDialogue::~ConfigDialogue()
{
}

QFrame *ConfigDialogue::addPage(const QString &itemName, const QString &iconName)
{
    return KDialogBase::addPage(itemName, QString::null, MainBarIcon(iconName, 32));
}

void ConfigDialogue::setConfigChanged(const bool value)
{
    actionButton(Apply)->setEnabled(value);
}

void ConfigDialogue::configChanged()
{
    setConfigChanged(true);
}

void ConfigDialogue::applyClickedSlot()
{
    okClickedSlot();
    emit recalcEnDecoderPage();
    setConfigChanged(false);
}

void ConfigDialogue::okClickedSlot()
{
    /*prefs.startTab=cStartTab->currentItem();
    prefs.convert.pauseMS=sPauseMS->value();
    prefs.fileListFont=fFileListFont->font();
    prefs.askForNewOptions=cAskForNewOptions->isChecked();

    prefs.backend.directories.clear();
    for( uint i=0; i<lDirectories->count(); i++ )
    {
        prefs.backend.directories.append(lDirectories->text(i));
    }
    prefs.backend.programs.clear();
    for( uint i=0; i<lPrograms->count(); i++ )
    {
        prefs.backend.programs.append(lPrograms->text(i));
    }

    prefs.calibrationFile=lTestFile->text();

    for( FormatOptionsList::Iterator it=formatOptions.begin(); it!=formatOptions.end(); ++it )
    {
        for( FileFormatList::Iterator jt=prefs.fileFormatList.begin(); jt!=prefs.fileFormatList.end(); ++jt )
        {
            if( (*jt).extension == (*it).format ) {
                (*jt).encoder=(*it).cEncoder->currentText();
                (*jt).decoder=(*it).cDecoder->currentText();
                (*jt).replaygain=(*it).cReplayGain->currentText();
            }
        }
    }

    prefs.convert.mp3CrcCheck=cCRC->isChecked();
    prefs.convert.mp3ISO=cISO->isChecked();

    for( StrengthOptionsList::Iterator it=strengthOptions.begin(); it!=strengthOptions.end(); ++it )
    {
        for( FileFormatList::Iterator jt=prefs.fileFormatList.begin(); jt!=prefs.fileFormatList.end(); ++jt )
        {
            if( (*jt).encoder == (*it).encoder ) {
                (*jt).compressionLevel=(*it).sStrength->value();
            }
        }
    }*/

    emit saveInterface();
    emit saveBackendPlugins();
    emit saveBackends();
    emit saveEnDecoder();
    emit saveEnDecoderOptions();

    prefs.write();
}

void ConfigDialogue::defaultClickedSlot()
{
    int index = activePageIndex();
    QStringList listDefaults;

    if(index == -1)
        return;

    if(index == pageIndex(interfacePage))
    {
        emit resetInterface();
        setConfigChanged(true);
    }
    else if(index == pageIndex(backendsPage))
    {
        /*listDefaults.clear();
        listDefaults.append("/usr/bin");
        listDefaults.append("/usr/local/bin");
        listDefaults.append(QDir::homeDirPath()+"/bin");
        QString datadir=locateLocal("data","soundkonverter/bin/");
        datadir.remove(datadir.length()-1,1);
        listDefaults.append(datadir);
        lDirectories->clear();
        lDirectories->insertStringList(listDefaults);
        listDefaults.clear();
        lPrograms->clear();
        lPrograms->insertStringList(listDefaults);*/
        emit resetBackendPlugins();
        setConfigChanged(true);
    }
    else if(index == pageIndex(enDecoderPage))
    {
        //KStandardDirs *stdDirs = new KStandardDirs();
        //lTestFile->setText(stdDirs->findResource("data","soundkonverter/test.ogg"));
        /*cOggEncoder->setCurrentItem(0);
        cOggDecoder->setCurrentItem(0);
        cMp3Encoder->setCurrentItem(0);
        cMp3Decoder->setCurrentItem(0);
        cFlacEncoder->setCurrentItem(0);
        cFlacDecoder->setCurrentItem(0);
        cMpcEncoder->setCurrentItem(0);
        cMpcDecoder->setCurrentItem(0);
        cApeEncoder->setCurrentItem(0);
        cApeDecoder->setCurrentItem(0);
        cWmaEncoder->setCurrentItem(0);
        cWmaDecoder->setCurrentItem(0);*/
        emit resetEnDecoder();
        setConfigChanged(true);
    }
    else if(index == pageIndex(enDecoderOptionsPage))
    {
        //cCRC->setChecked(DEFAULT_MP3_CRC_CHECK);
        //cISO->setChecked(DEFAULT_MP3_ISO);
        /*sFlacCompressionLevel->setValue(DEFAULT_FLAC_COMPRESSIONLEVEL);
        sApeCompressionLevel->setValue(DEFAULT_APE_COMPRESSIONLEVEL);*/
        emit resetEnDecoderOptions();
        setConfigChanged(true);
    }
}
