
#ifndef _BACKEND_PLUGINS_H_
#define _BACKEND_PLUGINS_H_

#include <qstring.h>
#include <qvaluelist.h>
#include <qstringlist.h>
#include <qdom.h>

class Extension
{
public:
    QString extension;
    int fileSize;

    Extension();
    Extension(QString ext,int size);
    ~Extension();
};

typedef QValueList<Extension> ExtensionList;


/**
 * @short BackendPlugins
 * @author Daniel Faust <daniel@kaligames.de>
 * @version 0.1
 */
class BackendPlugins
{
public:
    BackendPlugins();

    enum Level
    {
        Full, Most, Basic
    };

    enum Unit
    {
        Hz, KHz
    };

private:
    struct Dec
    {
        bool enabled;
        Level level;
        QString bin;
        QString param;
        QString silent_param;
        QStringList formats;
        QStringList synonymous_formats;
        QString mime_types;
        QString output;
        uint min_version;
        uint max_version;
        QString inOutFiles;
        QString overwrite;
        //QValueList<uint> file_sizes;
    };

    struct Tag
    {
        bool enabled;
        QString param;
        QString artist;
        QString album;
        QString title;
        QString genre;
        QString comment;
        QString track;
        QString year;
    };

    struct ReplayGain
    {
        bool enabled;
        QString use;
        QString avoid;
    };

    struct Lossy
    {
        bool enabled;
    };

    struct Lossless
    {
        bool enabled;
        QString param;
        QString output;
    };

    struct Channels
    {
        bool stereo_enabled;
        QString stereo_param;
        bool mono_enabled;
        QString mono_param;
    };

    struct Resample
    {
        bool enabled;
        QString param;
        Unit unit;
    };

    struct Cbr
    {
        bool enabled;
        QString param;
        QString output;
    };

    struct BitrateRange
    {
        bool enabled;
        QString param_min;
        QString param_max;
    };

    struct Abr
    {
        bool enabled;
        QString param;
        BitrateRange bitrate_range;
        QString output;
    };

    struct Bitrate
    {
        Abr abr;
        Cbr cbr;
    };

    struct Quality
    {
        bool enabled;
        QString param;
        float range_min;
        float range_max;
        float step;
        QChar seperator;
        QString help;
        QString output;
        QStringList profiles;
    };

    struct Strength
    {
        bool enabled;
        QString param;
        float range_min;
        float range_max;
        float step;
        QChar seperator;
        QStringList profiles;
    };

    struct Enc
    {
        bool enabled;
        Level level;
        QString bin;
        QString param;
        QString silent_param;
        QStringList formats;
        uint min_version;
        uint max_version;
        QString inOutFiles;
        QString overwrite;
        Strength strength;
        Quality quality;
        Bitrate bitrate;
        Resample resample;
        Channels channels;
        Lossless lossless;
        Lossy lossy;
        ReplayGain replaygain;
        Tag tag;
    };

    struct Info
    {
        int version; // v0.2.1 = 201, v11.3 = 110300
        QString name;
        QString author;
        QString about;
        QString short_info;
        QString format_descriptions;
    };

public:
    class PluginStructure
    {
    public:
        Info info;
        Enc enc;
        Dec dec;
        QString file_name;

        /*
        input:
            %i - input file
            %o - output file
            %p - parameters
            %q - quality
            %b - bitrate
            %m - min bitrate
            %M - max bitrate
            %s - sampling rate
            %c - compression strength
        tag:
            %ta - artist
            %tb - album
            %tc - comment
            %tg - genre
            %tn - track
            %tt - title
            %ty - year

        output:
            %i - input file name
            %o - output file name
            %p - percent
            %f - float percent
            %s - speed
            %c - current frame
            %n - number of frames
            %x - ignore
        */

        PluginStructure();
        PluginStructure(QString name);
        ~PluginStructure();
    };

    typedef QValueList<PluginStructure> PluginStructureList;

    PluginStructureList plugins;
    QStringList openFiles;

    void load();
    void reload();
    void unload(QString);
    void remove(QString);
    QStringList loadedPlugins();
    PluginStructure plugin(QString);

    QStringList allFileFormats();
    QStringList allLosslessFileFormats();
    QStringList allLossyFileFormats();
    int fileSize(QString);

private:
    ExtensionList extensionList;
    QDomDocument domTree;

    bool loadFile(QString);

};

extern BackendPlugins backendPlugins;

#endif // _BACKEND_PLUGINS_H_

