/* Somaplayer - Copyright (C) 2003-5 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#include "player.h"
#include "util.h"
#include "other.h"

/* Base64 decoding */

char base64table[] = {
  'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O',
  'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd',
  'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's',
  't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7',
  '8', '9', '+', '/'
};

char *
base64 (char *str)
{
  const char *data = str;
  size_t len = strlen (data);
  char *output;
  char *result;
  unsigned chunk;

  if (!(output = (char *) malloc ((len * 4 / 3 + 4) * sizeof (char))))
    fatal ("Error of memory.");
  result = output;

  while (len > 0)
    {
      chunk = (len > 3) ? 3 : len;
      *output++ = base64table[(*data & 0xfc) >> 2];
      *output++ =
	base64table[((*data & 0x03) << 4) | ((*(data + 1) & 0xf0) >> 4)];
      switch (chunk)
	{
	case 3:
	  *output++ = base64table[((*(data + 1) & 0x0f) << 2) |
				  ((*(data + 2) & 0xc0) >> 6)];
	  *output++ = base64table[(*(data + 2)) & 0x3f];
	  break;
	case 2:
	  *output++ = base64table[((*(data + 1) & 0x0f) << 2)];
	  *output++ = '=';
	  break;
	case 1:
	  *output++ = '=';
	  *output++ = '=';
	  break;
	}
      data += chunk;
      len -= chunk;
    }
  *output = 0;

  return result;
}

void
conv8 (unsigned char *pcmBuffer, unsigned int lenPcmBuffer,
       short int *left, short int *right, unsigned int channels)
{

  if (channels == 1)
    {
      register unsigned int i, j;

      for (i = 0, j = 0; i < lenPcmBuffer;)
	{
	  unsigned short int value;

	  value = pcmBuffer[i++];
	  left[j] = (short int) value;
	  ++j;
	}
    }
  else
    {
      register unsigned int i, j;

      for (i = 0, j = 0; i < lenPcmBuffer;)
	{
	  unsigned short int value;

	  value = pcmBuffer[i++];
	  left[j] = (short int) value;
	  value |= pcmBuffer[i++];
	  right[j] = (short int) value;
	  ++j;
	}
    }
}

void
conv16 (unsigned char *pcmBuffer, unsigned int lenPcmBuffer,
	short int *left, short int *right, unsigned int channels)
{

  if (big_endian ())
    {
      if (channels == 1)
	{
	  register unsigned int i, j;

	  for (i = 0, j = 0; i < lenPcmBuffer;)
	    {
	      unsigned short int value;

	      value = pcmBuffer[i++] << 8;
	      value |= pcmBuffer[i++];
	      left[j] = (short int) value;
	      ++j;
	    }
	}
      else
	{
	  register unsigned int i, j;

	  for (i = 0, j = 0; i < lenPcmBuffer;)
	    {
	      unsigned short int value;

	      value = pcmBuffer[i++] << 8;
	      value |= pcmBuffer[i++];
	      left[j] = (short int) value;
	      value = pcmBuffer[i++] << 8;
	      value |= pcmBuffer[i++];
	      right[j] = (short int) value;
	      ++j;
	    }
	}
    }
  else
    {
      if (channels == 1)
	{
	  register unsigned int i, j;

	  for (i = 0, j = 0; i < lenPcmBuffer;)
	    {
	      unsigned short int value;

	      value = pcmBuffer[i++];
	      value |= pcmBuffer[i++] << 8;
	      left[j] = (short int) value;
	      ++j;
	    }
	}
      else
	{
	  register unsigned int i, j;

	  for (i = 0, j = 0; i < lenPcmBuffer;)
	    {
	      unsigned short int value;

	      value = pcmBuffer[i++];
	      value |= pcmBuffer[i++] << 8;
	      left[j] = (short int) value;
	      value = pcmBuffer[i++];
	      value |= pcmBuffer[i++] << 8;
	      right[j] = (short int) value;
	      ++j;
	    }
	}
    }
}

void
conv (int bitrate, unsigned char *buffer, unsigned int len_buffer,
      short int *out_buffer)
{
  if (bitrate == 8)
    {
      register unsigned int i, j;

      for (i = 0, j = 0; i < len_buffer;)
	{
	  out_buffer[j] = buffer[i++];
	  ++j;
	}
    }

  else if (big_endian ())
    {
      register unsigned int i, j;

      for (i = 0, j = 0; i < len_buffer;)
	{
	  short int value;

	  value = buffer[i++] << 8;
	  value |= buffer[i++];
	  out_buffer[j] = value;
	  ++j;
	}
    }
  else
    {
      register unsigned int i, j;

      for (i = 0, j = 0; i < len_buffer;)
	{
	  short int value;

	  value = buffer[i++];
	  value |= buffer[i++] << 8;
	  out_buffer[j] = value;
	  ++j;
	}
    }
}

void
conv_2 (short int *buffer, unsigned int len_buffer, float **float_buffers,
	unsigned int channels)
{
  register unsigned int c, i, j;

  for (i = 0, j = 0; i < len_buffer;)
    {
      for (c = 0; c < channels; ++c)
	{
	  float_buffers[c][j] = ((float) buffer[i++]) / 32768.f;
	}
      ++j;
    }
}

#ifdef ENABLE_IPV6
int
ipv6_check ()
{
  int s;
  if ((s = socket (AF_INET6, SOCK_STREAM, 0)) != -1)
    {
      close (s);
      return 1;
    }

  return 0;
}
#endif

/* Bit endian check */
int
big_endian (void)
{
#ifdef WORDS_BIGENDIAN
  return 1;
#else
  return 0;
#endif
}

char *
get_tmp_dir (void)
{
#ifdef ENABLE_GLIB
  return (char *) g_get_tmp_dir ();
#else
  return "/tmp/";
#endif
}

static char urltable[16] = {
  '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e',
    'f'
};

static char safechars[256] = {
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
  0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,
  0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
};

char *
html_encode (char *data)
{
  const char *p;
  char *q, *dest;
  int digit;
  size_t n;

  if(!data) return NULL;

  for (p = data, n = 0; *p; p++)
    {
      n++;
      if (!safechars[(unsigned char) (*p)])
	n += 2;
    }
  if (!(dest = malloc (n + 1)))
    fatal (_("Error: memory."));

  for (p = data, q = dest; *p; p++, q++)
    {
      if (safechars[(unsigned char) (*p)])
	{
	  *q = *p;
	}
      else
	{
	  *q++ = '%';
	  digit = (*p >> 4) & 0xF;
	  *q++ = urltable[digit];
	  digit = *p & 0xf;
	  *q = urltable[digit];
	  n += 2;
	}
    }
  *q = '\0';

  return dest;
}

/* EOF */
