/* Somaplayer - Copyright (C) 2003-4 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#include "player.h"
#include "tty.h"
#include "other.h"
#include "volume.h"
#include "fconfig.h"
#include "format.h"
#include "options.h"
#include "fsignal.h"
#include "daemon.h"
#include "output.h"
#include "admin.h"
#include "bad_list.h"

pthread_t th1, th2;
struct termios t1, t2;

char **arg = NULL;
char **env = NULL;

/* Look here! This mask contains the events of somaplayer. 
 * Quit, Stop, Next, Prev, Play, ... */
event events = { 0, 0, 0, 0
#ifdef ENABLE_GTK
    , 0, 0
#endif
};

somaplayer *play;

int
main (int argc, char *argv[], char *arge[])
{
#ifdef ENABLE_NLS
  setlocale (LC_ALL, "");
  textdomain (PACKAGE);
  bindtextdomain (PACKAGE, LOCALEDIR);
#endif

  msg (_("%s Version: %s - %s\n\n"), NAME, VERSION, AUTHOR_COPYRIGHT);

  echo_off ();

  /* The struct! */
  if (!(play = (somaplayer *) malloc (sizeof (somaplayer))))
    fatal (_("Error: memory."));

  arg = argv;
  env = arge;

  play->play = 0;

  play->this = NULL;

  /* Active the mutex for the principal list */
  if (pthread_mutex_init (&play->m_list, NULL))
    fatal (_("Error: memory."));
  if (pthread_cond_init (&play->c_list, NULL))
    fatal (_("Error: memory."));
  play->first = NULL;
  play->last = NULL;

  volume_max ();

  /* Reset the elements... Like memset(play, 0x0, sizeof(somaplayer)); */
  play->balance = 0;
  play->number = 0;
  play->repeat = 0;
  play->random = 0;
  play->noverbose = 0;
  play->nobuffer = 0;

  play->ao_left = 0.0;
  play->ao_right = 0.0;

#ifdef ENABLE_GTK
  play->go_graphic = 0;
  play->mute = 0;
  play->size_x = -1;
  play->size_y = -1;
#endif

  play->trimming = 0;

#ifdef ENABLE_CDAUDIO
  play->cd = NULL;
#endif

  play->daemon = 0;

#ifdef ENABLE_DAEMON
  play->daemon_input = 0;
  play->daemon_input_opt = NULL;
#endif

#ifdef ENABLE_MIC
  play->devdsp = NULL;
  play->mic_option = NULL;
  play->microphone = 0;
#endif

  play->admin = NULL;

  play->norealtime = 0;

#ifdef ENABLE_GTK
  play->admin_active = 0;
#endif

  play->nooutput = 0;
  play->output = NULL;
  pthread_mutex_init (&play->m_output, NULL);

  play->bad_list = 0;
  play->bad_list_status = BAD_LIST_NULL;
  pthread_mutex_init (&play->bad_list_mutex, NULL);

  /* Active the list of formats */
  format_init ();

  /* Read the config */
  config_read ();

  /* Parse the parameters */
  if (options (argc, argv))
    quit (1);

  signal (SIGPIPE, signal_pipe);
  signal (SIGSEGV, segfault_handler);

  /* Audio init */
#ifdef ENABLE_AO
  ao_initialize ();
#endif

  /* DAEMON... */
  if (play->daemon)
    daemon_start ();

  /* ... or PLAYER ? */
  else
    {
      signal (SIGINT, signal_handler);

      /* Admin interface */
      if (play->admin)
	if (admin_start ())
	  fatal ("Admin interface error.");

      /* The interface of player is here: */
#ifdef ENABLE_GTK
      if (play->graphic)
	gtk_read ();		/* GTK */
      else
	{
#endif
	  /* Read after ... */
	  if (pthread_create (&th1, NULL, player, NULL))
	    fatal (_("Thread error."));

	  tty_read ();		/* TTY */
#ifdef ENABLE_GTK
	}
#endif
      /* The principal thread (main) is ONLY the interfaces
       * of the player. The other threads are:
       * - the player (TTY runs it now, GTK after)
       * - the buffer (the player runs it because no all type
       of file need the buffer)
       * - the output controllers
       * - other :)
       */


      /* When the interface exits: */
      if (events.quit)
	msg (_("Quitting."));

      events.quit = 1;

#ifdef ENABLE_GTK
      if (!play->graphic)
	{
#endif
	  pthread_cond_signal (&play->p_pop);
	  pthread_join (th1, NULL);
#ifdef ENABLE_GTK
	}
#endif

      echo_on ();
    }

  if (play->admin)
    {
      msg (_("Admin socket closed"));
      pthread_join (play->admin->th, NULL);
    }

  msg (_("Free memory."));

  pthread_cond_destroy (&play->p_pop);
  pthread_mutex_destroy (&play->m_output);

  output_exit ();

  format_free ();

#ifdef ENABLE_AO
  ao_shutdown ();
#endif

  free (play);

  msg (_("Done."));

  echo_on ();

  return 0;
}

/* EOF */
