/* Somaplayer - Copyright (C) 2003-4 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#ifdef ENABLE_STREAMING
#ifdef ENABLE_ICECAST

#include "../player.h"
#include "../audio.h"
#include "graphic.h"
#include "../other.h"

void
on_icecast_show_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  GtkWidget *dialog;
  GtkWidget *box;
  GtkWidget *table;
  GtkWidget *stock;
  GtkWidget *label;

  GtkWidget *rate;
  GtkWidget *quality;
  GtkWidget *bitrate;
  GtkWidget *channels;
  GtkWidget *lowpass;
  GtkWidget *highpass;

  GtkWidget *server;
  GtkWidget *port;
  GtkWidget *mount;
  GtkWidget *password;

  GtkWidget *genre;
  GtkWidget *name;
  GtkWidget *description;
  GtkWidget *url;

  GtkWidget *public;

  GtkWidget *dumpfilelocal;
  GtkWidget *dumpfileremote;

  audio *ao = (audio *) user_data;
  audio_data_streaming *streaming;
  char s[SIZE_BUFFER];

  if (!ao)
    return;

  streaming = ao->data;
  if (!streaming)
    return;

  dialog =
    gtk_dialog_new_with_buttons (_("SomaPlayer - icecast configuration"),
				 GTK_WINDOW (winmain),
				 GTK_DIALOG_MODAL |
				 GTK_DIALOG_DESTROY_WITH_PARENT,
				 GTK_STOCK_SAVE, 100,
				 GTK_STOCK_OK, GTK_RESPONSE_OK, NULL);

  box = gtk_hbox_new (FALSE, 8);
  gtk_container_set_border_width (GTK_CONTAINER (box), 8);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), box, FALSE, FALSE,
		      0);

  stock =
    gtk_image_new_from_stock (GTK_STOCK_DIALOG_INFO, GTK_ICON_SIZE_DIALOG);
  gtk_box_pack_start (GTK_BOX (box), stock, FALSE, FALSE, 0);

  table = gtk_table_new (0, 0, FALSE);
  gtk_table_set_row_spacings (GTK_TABLE (table), 4);
  gtk_table_set_col_spacings (GTK_TABLE (table), 4);
  gtk_box_pack_start (GTK_BOX (box), table, TRUE, TRUE, 0);

  label = gtk_label_new_with_mnemonic (_("Rate:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 0, 1);
  rate = gtk_entry_new ();
  snprintf (s, SIZE_BUFFER, "%d", streaming->rate);
  gtk_entry_set_text (GTK_ENTRY (rate), s);
  gtk_entry_set_editable (GTK_ENTRY (rate), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), rate, 1, 2, 0, 1);

  label = gtk_label_new_with_mnemonic (_("Quality:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 1, 2);
  quality = gtk_entry_new ();
  snprintf (s, SIZE_BUFFER, "%d", streaming->quality);
  gtk_entry_set_text (GTK_ENTRY (quality), s);
  gtk_entry_set_editable (GTK_ENTRY (quality), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), quality, 1, 2, 1, 2);

  label = gtk_label_new_with_mnemonic (_("Bitrate:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 2, 3);
  bitrate = gtk_entry_new ();
  snprintf (s, SIZE_BUFFER, "%d", streaming->bitrate);
  gtk_entry_set_text (GTK_ENTRY (bitrate), s);
  gtk_entry_set_editable (GTK_ENTRY (bitrate), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), bitrate, 1, 2, 2, 3);

  label = gtk_label_new_with_mnemonic (_("Channels:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 3, 4);
  channels = gtk_entry_new ();
  snprintf (s, SIZE_BUFFER, "%s",
	    streaming->channels == 1 ? "MONO" : "STEREO");
  gtk_entry_set_text (GTK_ENTRY (channels), s);
  gtk_entry_set_editable (GTK_ENTRY (channels), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), channels, 1, 2, 3, 4);

  label = gtk_label_new_with_mnemonic (_("LowPass:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 4, 5);
  lowpass = gtk_entry_new ();
  snprintf (s, SIZE_BUFFER, "%d", streaming->lowpass);
  gtk_entry_set_text (GTK_ENTRY (lowpass), s);
  gtk_entry_set_editable (GTK_ENTRY (lowpass), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), lowpass, 1, 2, 4, 5);

  label = gtk_label_new_with_mnemonic (_("HighPass:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 5, 6);
  highpass = gtk_entry_new ();
  snprintf (s, SIZE_BUFFER, "%d", streaming->highpass);
  gtk_entry_set_text (GTK_ENTRY (highpass), s);
  gtk_entry_set_editable (GTK_ENTRY (highpass), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), highpass, 1, 2, 5, 6);

  label = gtk_label_new_with_mnemonic (_("Server:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 6, 7);
  server = gtk_entry_new ();
  if (streaming->server)
    gtk_entry_set_text (GTK_ENTRY (server), streaming->server);
  gtk_entry_set_editable (GTK_ENTRY (server), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), server, 1, 2, 6, 7);

  label = gtk_label_new_with_mnemonic (_("Port:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 7, 8);
  port = gtk_entry_new ();
  snprintf (s, SIZE_BUFFER, "%d", streaming->port);
  gtk_entry_set_text (GTK_ENTRY (port), s);
  gtk_entry_set_editable (GTK_ENTRY (port), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), port, 1, 2, 7, 8);

  label = gtk_label_new_with_mnemonic (_("Mount:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 8, 9);
  mount = gtk_entry_new ();
  if (streaming->mount)
    gtk_entry_set_text (GTK_ENTRY (mount), streaming->mount);
  gtk_entry_set_editable (GTK_ENTRY (mount), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), mount, 1, 2, 8, 9);

  label = gtk_label_new_with_mnemonic (_("Password:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 9, 10);
  password = gtk_entry_new ();
  if (streaming->password)
    gtk_entry_set_text (GTK_ENTRY (password), streaming->password);
  gtk_entry_set_editable (GTK_ENTRY (password), FALSE);
  gtk_entry_set_visibility (GTK_ENTRY (password), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), password, 1, 2, 9, 10);

  label = gtk_label_new_with_mnemonic (_("Genre:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 10, 11);
  genre = gtk_entry_new ();
  if (streaming->genre)
    gtk_entry_set_text (GTK_ENTRY (genre), streaming->genre);
  gtk_entry_set_editable (GTK_ENTRY (genre), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), genre, 1, 2, 10, 11);

  label = gtk_label_new_with_mnemonic (_("Name:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 11, 12);
  name = gtk_entry_new ();
  if (streaming->name)
    gtk_entry_set_text (GTK_ENTRY (name), streaming->name);
  gtk_entry_set_editable (GTK_ENTRY (name), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), name, 1, 2, 11, 12);

  label = gtk_label_new_with_mnemonic (_("Description:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 12, 13);
  description = gtk_entry_new ();
  if (streaming->description)
    gtk_entry_set_text (GTK_ENTRY (description), streaming->description);
  gtk_entry_set_editable (GTK_ENTRY (description), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), description, 1, 2, 12, 13);

  label = gtk_label_new_with_mnemonic (_("Url:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 13, 14);
  url = gtk_entry_new ();
  if (streaming->url)
    gtk_entry_set_text (GTK_ENTRY (url), streaming->url);
  gtk_entry_set_editable (GTK_ENTRY (url), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), url, 1, 2, 13, 14);

  label = gtk_label_new_with_mnemonic (_("Public:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 14, 15);
  public = gtk_check_button_new ();
  if (streaming->public)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (public), TRUE);
  gtk_table_attach_defaults (GTK_TABLE (table), public, 1, 2, 14, 15);

  label = gtk_label_new_with_mnemonic (_("Dump File Local:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 15, 16);
  dumpfilelocal = gtk_entry_new ();
  if (streaming->dumpfilelocal)
    gtk_entry_set_text (GTK_ENTRY (dumpfilelocal), streaming->dumpfilelocal);
  gtk_entry_set_editable (GTK_ENTRY (dumpfilelocal), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), dumpfilelocal, 1, 2, 15, 16);

  label = gtk_label_new_with_mnemonic (_("Dump File Remote"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 16, 17);
  dumpfileremote = gtk_entry_new ();
  if (streaming->dumpfileremote)
    gtk_entry_set_text (GTK_ENTRY (dumpfileremote),
			streaming->dumpfileremote);
  gtk_entry_set_editable (GTK_ENTRY (dumpfileremote), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), dumpfileremote, 1, 2, 16, 17);

  gtk_widget_show_all (box);

  while (1)
    {
      if (gtk_dialog_run (GTK_DIALOG (dialog)) == 100)
	{
	  GtkWidget *fs;
	  char s[1024];

	  snprintf (s, 1024, "%s %s - Save icecast config file", NAME,
		    VERSION);
	  fs =
	    gtk_file_chooser_dialog_new (s, GTK_WINDOW (winmain),
					 GTK_FILE_CHOOSER_ACTION_SAVE,
					 GTK_STOCK_CANCEL,
					 GTK_RESPONSE_CANCEL, GTK_STOCK_SAVE,
					 GTK_RESPONSE_ACCEPT, NULL);

	  if (gtk_dialog_run (GTK_DIALOG (fs)) == GTK_RESPONSE_ACCEPT)
	    {
	      FILE *fl;
	      char *file =
		(char *)
		gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (fs));

	      gtk_widget_destroy (fs);

	      if (dialog_test_file (file))
		{
		  free (file);
		  continue;
		}

	      if (!(fl = fopen (file, "w")))
		{
		  msg_error ("I can't open %s", file);
		  free (file);
		  continue;
		}

	      fprintf (fl, "type = M\n");
	      fprintf (fl, "rate = %d\n", streaming->rate);
	      fprintf (fl, "quality = %d\n", streaming->quality);
	      fprintf (fl, "bitrate = %d\n", streaming->bitrate);
	      fprintf (fl, "channels = %d\n", streaming->channels);
	      fprintf (fl, "lowpass = %d\n", streaming->lowpass);
	      fprintf (fl, "highpass = %d\n", streaming->highpass);
	      fprintf (fl, "password = \"%s\"\n", streaming->password);
	      fprintf (fl, "server = \"%s\"\n", streaming->server);
	      fprintf (fl, "port = \"%d\"\n", streaming->port);
	      fprintf (fl, "mount = \"%s\"\n", streaming->mount);
	      fprintf (fl, "genre = \"%s\"\n", streaming->genre);
	      fprintf (fl, "name = \"%s\"\n", streaming->name);
	      fprintf (fl, "description = \"%s\"\n", streaming->description);
	      fprintf (fl, "url = \"%s\"\n", streaming->url);
	      fprintf (fl, "public = %s\n",
		       streaming->public ? "true" : "false");
	      fprintf (fl, "dumpfilelocal = \"%s\"\n",
		       streaming->dumpfilelocal);
	      fprintf (fl, "dumpfileremote = \"%s\"\n",
		       streaming->dumpfileremote);

	      fclose (fl);
	      free (file);

	      gtk_dialog_msg (_("Icecast config saved!"));
	    }

	  else
	    gtk_widget_destroy (fs);

	  continue;
	}
      else
	break;
    }

  gtk_widget_destroy (dialog);
}

#endif
#endif

/* EOF */
