/* Somaplayer - Copyright (C) 2003-4 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#ifdef ENABLE_STREAMING
#ifdef ENABLE_ICECAST

#include "../player.h"
#include "../audio.h"
#include "../output.h"
#include "../other.h"
#include "../output/streaming/streaming.h"
#include "graphic.h"

void
on_icecast_new_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  GtkWidget *dialog;
  GtkWidget *box;
  GtkWidget *table;
  GtkWidget *stock;
  GtkWidget *label;

  GtkWidget *rate;
  GtkAdjustment *quality_adj;
  GtkWidget *quality;
  GtkWidget *bitrate;
  GtkWidget *channels;
  GtkWidget *lowpass;
  GtkWidget *highpass;

  GtkWidget *server;
  GtkWidget *port;
  GtkAdjustment *port_adj;
  GtkWidget *mount;
  GtkWidget *password;
  GtkWidget *password2;

  GtkWidget *genre;
  GtkWidget *name;
  GtkWidget *description;
  GtkWidget *url;

  GtkWidget *public;

  GtkWidget *dumpfilelocal;
  GtkWidget *dumpfileremote;

  audio *tmp;

  int ret;

  dialog =
    gtk_dialog_new_with_buttons (_("SomaPlayer - icecast configuration"),
				 GTK_WINDOW (winmain),
				 GTK_DIALOG_MODAL |
				 GTK_DIALOG_DESTROY_WITH_PARENT,
				 GTK_STOCK_OPEN, 100,
				 GTK_STOCK_SAVE, 200,
				 GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
				 GTK_STOCK_OK, GTK_RESPONSE_OK, NULL);

  box = gtk_hbox_new (FALSE, 8);
  gtk_container_set_border_width (GTK_CONTAINER (box), 8);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), box, FALSE, FALSE,
		      0);

  stock =
    gtk_image_new_from_stock (GTK_STOCK_DIALOG_QUESTION,
			      GTK_ICON_SIZE_DIALOG);
  gtk_box_pack_start (GTK_BOX (box), stock, FALSE, FALSE, 0);

  table = gtk_table_new (0, 0, FALSE);
  gtk_table_set_row_spacings (GTK_TABLE (table), 4);
  gtk_table_set_col_spacings (GTK_TABLE (table), 4);
  gtk_box_pack_start (GTK_BOX (box), table, TRUE, TRUE, 0);

  label = gtk_label_new_with_mnemonic (_("Rate:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 0, 1);
  rate = gtk_entry_new ();
  gtk_table_attach_defaults (GTK_TABLE (table), rate, 1, 2, 0, 1);

  label = gtk_label_new_with_mnemonic (_("Quality:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 1, 2);
  quality_adj = (GtkAdjustment *) gtk_adjustment_new (8, 1, 10, 1, 1, 1);
  quality = gtk_spin_button_new (GTK_ADJUSTMENT (quality_adj), 1, 0);
  gtk_table_attach_defaults (GTK_TABLE (table), quality, 1, 2, 1, 2);

  label = gtk_label_new_with_mnemonic (_("Bitrate:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 2, 3);
  bitrate = gtk_entry_new ();
  gtk_table_attach_defaults (GTK_TABLE (table), bitrate, 1, 2, 2, 3);

  label = gtk_label_new_with_mnemonic (_("Channels:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 3, 4);
  channels = gtk_combo_box_new_text ();
  gtk_combo_box_append_text (GTK_COMBO_BOX (channels), "MONO");
  gtk_combo_box_append_text (GTK_COMBO_BOX (channels), "STEREO");
  gtk_table_attach_defaults (GTK_TABLE (table), channels, 1, 2, 3, 4);

  label = gtk_label_new_with_mnemonic (_("LowPass:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 4, 5);
  lowpass = gtk_entry_new ();
  gtk_table_attach_defaults (GTK_TABLE (table), lowpass, 1, 2, 4, 5);

  label = gtk_label_new_with_mnemonic (_("HighPass:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 5, 6);
  highpass = gtk_entry_new ();
  gtk_table_attach_defaults (GTK_TABLE (table), highpass, 1, 2, 5, 6);

  label = gtk_label_new_with_mnemonic (_("Server:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 6, 7);
  server = gtk_entry_new ();
  gtk_table_attach_defaults (GTK_TABLE (table), server, 1, 2, 6, 7);

  label = gtk_label_new_with_mnemonic (_("Port:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 7, 8);

  port_adj = (GtkAdjustment *) gtk_adjustment_new (8000, 0, 65536, 1, 10, 10);
  port = gtk_spin_button_new (port_adj, 1, 0);
  gtk_table_attach_defaults (GTK_TABLE (table), port, 1, 2, 7, 8);

  label = gtk_label_new_with_mnemonic (_("Mount:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 8, 9);
  mount = gtk_entry_new ();
  gtk_table_attach_defaults (GTK_TABLE (table), mount, 1, 2, 8, 9);

  label = gtk_label_new_with_mnemonic (_("Password:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 9, 10);
  password = gtk_entry_new ();
  gtk_entry_set_visibility (GTK_ENTRY (password), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), password, 1, 2, 9, 10);

  label = gtk_label_new_with_mnemonic (_("(Re)Password:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 10, 11);
  password2 = gtk_entry_new ();
  gtk_entry_set_visibility (GTK_ENTRY (password2), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), password2, 1, 2, 10, 11);

  label = gtk_label_new_with_mnemonic (_("Genre:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 11, 12);
  genre = gtk_entry_new ();
  gtk_table_attach_defaults (GTK_TABLE (table), genre, 1, 2, 11, 12);

  label = gtk_label_new_with_mnemonic (_("Name:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 12, 13);
  name = gtk_entry_new ();
  gtk_table_attach_defaults (GTK_TABLE (table), name, 1, 2, 12, 13);

  label = gtk_label_new_with_mnemonic (_("Description:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 13, 14);
  description = gtk_entry_new ();
  gtk_table_attach_defaults (GTK_TABLE (table), description, 1, 2, 13, 14);

  label = gtk_label_new_with_mnemonic (_("Url:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 14, 15);
  url = gtk_entry_new ();
  gtk_table_attach_defaults (GTK_TABLE (table), url, 1, 2, 14, 15);

  label = gtk_label_new_with_mnemonic (_("Public:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 15, 16);
  public = gtk_check_button_new ();
  gtk_table_attach_defaults (GTK_TABLE (table), public, 1, 2, 15, 16);

  label = gtk_label_new_with_mnemonic (_("Dump File Local:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 16, 17);
  dumpfilelocal = gtk_entry_new ();
  gtk_table_attach_defaults (GTK_TABLE (table), dumpfilelocal, 1, 2, 16, 17);

  label = gtk_label_new_with_mnemonic (_("Dump File Remote:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 17, 18);
  dumpfileremote = gtk_entry_new ();
  gtk_table_attach_defaults (GTK_TABLE (table), dumpfileremote, 1, 2, 17, 18);

  gtk_entry_set_text (GTK_ENTRY (rate), "22050");
  gtk_entry_set_text (GTK_ENTRY (bitrate), "24");
  gtk_combo_box_set_active (GTK_COMBO_BOX (channels), 0);
  gtk_entry_set_text (GTK_ENTRY (lowpass), "0");
  gtk_entry_set_text (GTK_ENTRY (highpass), "0");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (public), 1);

  gtk_widget_show_all (box);

  while (1)
    {

      ret = gtk_dialog_run (GTK_DIALOG (dialog));

      /* Oky... */
      if (ret == GTK_RESPONSE_OK)
	{
	  audio_data_streaming *l;

	  if (strcmp
	      (gtk_entry_get_text (GTK_ENTRY (password)),
	       gtk_entry_get_text (GTK_ENTRY (password2))))
	    {
	      gtk_dialog_msg (_("Passwords are different!"));
	      continue;
	    }

	  if (!strlen (gtk_entry_get_text (GTK_ENTRY (server))))
	    {
	      gtk_dialog_msg (_("No server?"));
	      continue;
	    }

	  if (!strlen (gtk_entry_get_text (GTK_ENTRY (mount))))
	    {
	      gtk_dialog_msg (_("No mount?"));
	      continue;
	    }

	  if (!
	      (l =
	       (audio_data_streaming *)
	       malloc (sizeof (audio_data_streaming))))
	    fatal (_("Error: memory."));

	  l->rate = atoi (gtk_entry_get_text (GTK_ENTRY (rate)));
	  l->quality =
	    (int) gtk_spin_button_get_value (GTK_SPIN_BUTTON (quality));
	  l->bitrate = atoi (gtk_entry_get_text (GTK_ENTRY (bitrate)));

	  if (!gtk_combo_box_get_active (GTK_COMBO_BOX (channels)))
	    l->channels = 1;
	  else
	    l->channels = 2;

	  l->lowpass = atoi (gtk_entry_get_text (GTK_ENTRY (lowpass)));
	  l->highpass = atoi (gtk_entry_get_text (GTK_ENTRY (highpass)));

	  if (!
	      (l->password =
	       strdup (gtk_entry_get_text (GTK_ENTRY (password)))))
	    fatal (_("Error: memory."));

	  if (!(l->server = strdup (gtk_entry_get_text (GTK_ENTRY (server)))))
	    fatal (_("Error: memory."));

	  l->port = (int) gtk_spin_button_get_value (GTK_SPIN_BUTTON (port));

	  if (!(l->mount = strdup (gtk_entry_get_text (GTK_ENTRY (mount)))))
	    fatal (_("Error: memory."));

	  if (!(l->genre = strdup (gtk_entry_get_text (GTK_ENTRY (genre)))))
	    fatal (_("Error: memory."));

	  if (!(l->name = strdup (gtk_entry_get_text (GTK_ENTRY (name)))))
	    fatal (_("Error: memory."));

	  if (!
	      (l->description =
	       strdup (gtk_entry_get_text (GTK_ENTRY (description)))))
	    fatal (_("Error: memory."));

	  if (!(l->url = strdup (gtk_entry_get_text (GTK_ENTRY (url)))))
	    fatal (_("Error: memory."));

	  l->public =
	    gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (public));

	  if (strlen (gtk_entry_get_text (GTK_ENTRY (dumpfilelocal))) > 0)
	    {
	      if (!
		  (l->dumpfilelocal =
		   strdup (gtk_entry_get_text (GTK_ENTRY (dumpfilelocal)))))
		fatal (_("Error: memory."));
	    }
	  else
	    l->dumpfilelocal = NULL;

	  if (strlen (gtk_entry_get_text (GTK_ENTRY (dumpfileremote))) > 0)
	    {
	      if (!
		  (l->dumpfileremote =
		   strdup (gtk_entry_get_text (GTK_ENTRY (dumpfileremote)))))
		fatal (_("Error: memory."));
	    }
	  else
	    l->dumpfileremote = NULL;

	  l->type = OUT_LAME;

	  if (!(tmp = (audio *) malloc (sizeof (audio))))
	    fatal (_("Error: memory."));

	  tmp->audio_type = USE_ICECAST;

	  tmp->realtime = 1;

	  tmp->open = icecast_start;
	  tmp->write = streaming_write;
	  tmp->close = streaming_quit;
	  tmp->check = NULL;
	  tmp->info = streaming_show;
	  tmp->data = (void *) l;
	  tmp->next = NULL;
	  tmp->audio_dev = NULL;
	  tmp->status = OUTPUT_DONE;

	  tmp->stop = 0;

	  if (pthread_cond_init (&tmp->cond, NULL))
	    fatal (_("Error: Cond init."));
	  if (pthread_mutex_init (&tmp->mutex, NULL))
	    fatal (_("Error: Mutex init."));
	  if (pthread_create (&tmp->th, NULL, output_thread, tmp))
	    fatal (_("Thread error."));

	  if (play->ao_rate && play->ao_channels && play->ao_bitrate)
	    {
	      if (tmp->
		  open (tmp, play->ao_rate, play->ao_channels,
			play->ao_bitrate))
		{
		  free (tmp);
		}
	      else
		{

		  tmp->info (tmp);

		  output_lock ();

		  tmp->next = play->output;
		  play->output = tmp;

		  output_unlock ();

		  output_window_add (tmp, PREPEND);
		}
	    }
	  else
	    {
	      output_lock ();

	      tmp->next = play->output;
	      play->output = tmp;

	      output_unlock ();

	      output_window_add (tmp, PREPEND);
	    }

	  break;
	}

      /* Cancel button */
      else if (ret == GTK_RESPONSE_CANCEL)
	{
	  break;
	}

      /* Open button */
      else if (ret == 100)
	{
	  audio_data_streaming *data;

	  GtkWidget *fs;
	  char s[1024];

	  snprintf (s, 1024, "%s %s - Open icecast config file...", NAME,
		    VERSION);
	  fs =
	    gtk_file_chooser_dialog_new (s, GTK_WINDOW (winmain),
					 GTK_FILE_CHOOSER_ACTION_OPEN,
					 GTK_STOCK_CANCEL,
					 GTK_RESPONSE_CANCEL, GTK_STOCK_OPEN,
					 GTK_RESPONSE_OK, NULL);

	  if (gtk_dialog_run (GTK_DIALOG (fs)) == GTK_RESPONSE_OK)
	    {
	      char *file =
		(char *)
		gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (fs));

	      if (!
		  (data =
		   (audio_data_streaming *)
		   malloc (sizeof (audio_data_streaming))))
		fatal ("Error: memory.");

	      /* Parse the file and update the item */
	      if (!streaming_read_config (file, data))
		{
		  snprintf (s, 1024, "%d", data->rate);
		  gtk_entry_set_text (GTK_ENTRY (rate), s);

		  snprintf (s, 1024, "%d", data->bitrate);
		  gtk_entry_set_text (GTK_ENTRY (bitrate), s);

		  gtk_spin_button_set_value (GTK_SPIN_BUTTON (quality),
					     (gdouble) data->quality);

		  snprintf (s, 1024, "%d", data->lowpass);
		  gtk_entry_set_text (GTK_ENTRY (lowpass), s);

		  snprintf (s, 1024, "%d", data->highpass);
		  gtk_entry_set_text (GTK_ENTRY (highpass), s);

		  switch (data->channels)
		    {
		    case 1:
		      gtk_combo_box_set_active (GTK_COMBO_BOX (channels), 0);
		      break;
		    case 2:
		      gtk_combo_box_set_active (GTK_COMBO_BOX (channels), 1);
		      break;
		    default:
		      gtk_combo_box_set_active (GTK_COMBO_BOX (channels), 0);
		    }

		  gtk_entry_set_text (GTK_ENTRY (password), data->password);
		  gtk_entry_set_text (GTK_ENTRY (password2), data->password);

		  gtk_entry_set_text (GTK_ENTRY (server), data->server);

		  gtk_spin_button_set_value (GTK_SPIN_BUTTON (port),
					     (gdouble) data->port);

		  gtk_entry_set_text (GTK_ENTRY (mount), data->mount);

		  gtk_entry_set_text (GTK_ENTRY (genre), data->genre);

		  gtk_entry_set_text (GTK_ENTRY (name), data->name);

		  gtk_entry_set_text (GTK_ENTRY (description),
				      data->description);

		  gtk_entry_set_text (GTK_ENTRY (url), data->url);

		  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (public),
						data->public);

		  gtk_entry_set_text (GTK_ENTRY (dumpfilelocal),
				      data->dumpfilelocal);
		  gtk_entry_set_text (GTK_ENTRY (dumpfileremote),
				      data->dumpfileremote);

		  if (data->dumpfileremote)
		    free (data->dumpfileremote);

		  if (data->dumpfilelocal)
		    free (data->dumpfilelocal);

		  if (data->irc)
		    free (data->irc);

		  if (data->icq)
		    free (data->icq);

		  if (data->aim)
		    free (data->aim);

		  if (data->url)
		    free (data->url);

		  if (data->name)
		    free (data->name);

		  if (data->description)
		    free (data->description);

		  if (data->genre)
		    free (data->genre);

		  if (data->mount)
		    free (data->mount);

		  if (data->password)
		    free (data->password);

		  if (data->server)
		    free (data->server);

		}

	      free (file);
	      free (data);
	    }

	  gtk_widget_destroy (fs);
	}

      /* Save button */
      else if (ret == 200)
	{
	  GtkWidget *fs;
	  char s[1024];

	  if (strcmp
	      (gtk_entry_get_text (GTK_ENTRY (password)),
	       gtk_entry_get_text (GTK_ENTRY (password2))))
	    {
	      gtk_dialog_msg (_("Passwords are different!"));
	      continue;
	    }

	  snprintf (s, 1024, "%s %s - Save icecast config file", NAME,
		    VERSION);
	  fs =
	    gtk_file_chooser_dialog_new (s, GTK_WINDOW (winmain),
					 GTK_FILE_CHOOSER_ACTION_SAVE,
					 GTK_STOCK_CANCEL,
					 GTK_RESPONSE_CANCEL, GTK_STOCK_SAVE,
					 GTK_RESPONSE_ACCEPT, NULL);

	  if (gtk_dialog_run (GTK_DIALOG (fs)) == GTK_RESPONSE_ACCEPT)
	    {
	      FILE *fl;
	      char *file =
		(char *)
		gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (fs));

	      gtk_widget_destroy (fs);

	      if (dialog_test_file (file))
		{
		  free (file);
		  continue;
		}

	      if (!(fl = fopen (file, "w")))
		{
		  msg_error ("I can't open %s", file);
		  free (file);
		  continue;
		}

	      fprintf (fl, "type = M\n");
	      fprintf (fl, "rate = %d\n",
		       atoi (gtk_entry_get_text (GTK_ENTRY (rate))));
	      fprintf (fl, "quality = %d\n",
		       (int)
		       gtk_spin_button_get_value (GTK_SPIN_BUTTON (quality)));
	      fprintf (fl, "bitrate = %d\n",
		       atoi (gtk_entry_get_text (GTK_ENTRY (bitrate))));
	      fprintf (fl, "channels = %d\n",
		       gtk_combo_box_get_active (GTK_COMBO_BOX (channels)) +
		       1);
	      fprintf (fl, "lowpass = %d\n",
		       atoi (gtk_entry_get_text (GTK_ENTRY (lowpass))));
	      fprintf (fl, "highpass = %d\n",
		       atoi (gtk_entry_get_text (GTK_ENTRY (highpass))));
	      fprintf (fl, "password = \"%s\"\n",
		       gtk_entry_get_text (GTK_ENTRY (password)));
	      fprintf (fl, "server = \"%s\"\n",
		       gtk_entry_get_text (GTK_ENTRY (server)));
	      fprintf (fl, "port = \"%d\"\n",
		       (int)
		       gtk_spin_button_get_value (GTK_SPIN_BUTTON (port)));
	      fprintf (fl, "mount = \"%s\"\n",
		       gtk_entry_get_text (GTK_ENTRY (mount)));
	      fprintf (fl, "genre = \"%s\"\n",
		       gtk_entry_get_text (GTK_ENTRY (genre)));
	      fprintf (fl, "name = \"%s\"\n",
		       gtk_entry_get_text (GTK_ENTRY (name)));
	      fprintf (fl, "description = \"%s\"\n",
		       gtk_entry_get_text (GTK_ENTRY (description)));
	      fprintf (fl, "url = \"%s\"\n",
		       gtk_entry_get_text (GTK_ENTRY (url)));
	      fprintf (fl, "public = %s\n",
		       gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON
						     (public)) ? "true" :
		       "false");
	      fprintf (fl, "dumpfilelocal = \"%s\"\n",
		       gtk_entry_get_text (GTK_ENTRY (dumpfilelocal)));
	      fprintf (fl, "dumpfileremote = \"%s\"\n",
		       gtk_entry_get_text (GTK_ENTRY (dumpfileremote)));

	      fclose (fl);

	      gtk_dialog_msg (_("Icecast config saved!"));
	    }

	  else
	    gtk_widget_destroy (fs);
	}
    }

  gtk_widget_destroy (dialog);

}

#endif
#endif

/* EOF */
