/* Somaplayer - Copyright (C) 2003-4 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#include "../player.h"
#include "../file.h"
#include "../other.h"
#include "../format.h"
#include "graphic.h"
#include "statusbar.h"
#include "gtkrc.c"

GtkWidget *winmain;
GtkWidget *winoutput;
GtkWidget *text;
GtkWidget *b_random;
GtkWidget *b_repeat;
GtkWidget *playlist;
GtkTreeSelection *p_selection;
GtkWidget *statusbar;
gint statusbar_id;
GtkWidget *output_list;
GtkWidget *ledbar_l;
GtkWidget *ledbar_r;

int playlist_selected = -1;

pthread_mutex_t gmutex;

void
gtk_read (void)
{

  gtk_init (NULL, NULL);
  gtk_rc_parse_string (gtkrc);

  winmain = create_winmain ();
  winoutput = create_winoutput ();
  gtk_widget_show (winmain);

  gtk_text_buffer_create_tag (GTK_TEXT_BUFFER (text), "title", "weight",
			      PANGO_WEIGHT_BOLD, "scale", PANGO_SCALE_SMALL,
			      "justification", GTK_JUSTIFY_CENTER, NULL);

  gtk_text_buffer_create_tag (GTK_TEXT_BUFFER (text), "time", "weight",
			      PANGO_WEIGHT_BOLD, "scale", PANGO_SCALE_MEDIUM,
			      "justification", GTK_JUSTIFY_LEFT, "family",
			      "monospace", NULL);

  if (play->repeat)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b_repeat), 1);
  else
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b_repeat), 0);

  if (play->random)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b_random), 1);
  else
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b_random), 0);

  if (pthread_create (&th1, NULL, player, NULL))
    fatal (_("Thread error."));

  playlist_restore ();
  playlist_refresh ();

  output_window_refresh ();

  g_timeout_add (500, timeout, NULL);
  g_timeout_add (100, ledbar_timeout, NULL);

  gtk_main ();

  play->graphic = 0;

  return;
}

void
graphic_save_size (int x, int y)
{
  char *home;
  char *file;
  int a;
  cfg_t *cfg;
  FILE *fl;

  cfg_opt_t opts[] = {
    CFG_STR ("buffer", NULL, CFGF_NONE),
    CFG_INT ("volume", 100, CFGF_NONE),
    CFG_BOOL ("random", cfg_false, CFGF_NONE),
    CFG_BOOL ("repeat", cfg_false, CFGF_NONE),
    CFG_BOOL ("noverbose", cfg_false, CFGF_NONE),
    CFG_BOOL ("nobuffer", cfg_false, CFGF_NONE),
    CFG_INT ("x", -1, CFGF_NONE),
    CFG_INT ("y", -1, CFGF_NONE),
    CFG_STR ("audio", NULL, CFGF_NONE),
    CFG_END ()
  };

  if (!(home = getenv ("HOME")))
    {
      msg (_("I can't know your home. Set the enviroment!"));
      return;
    }

  a = strlen (home) + strlen ("/.somaplayer") + 2;
  if (!(file = (char *) malloc (a * sizeof (char))))
    fatal (_("Error: memory."));

  snprintf (file, a, "%s/.somaplayer", home);

  cfg = cfg_init (opts, CFGF_NOCASE);

  switch (cfg_parse (cfg, file))
    {
    case CFG_FILE_ERROR:
      if (!(fl = fopen (file, "w")))
	{
	  msg (_("Error open config file."));
	  free (file);
	  return;
	}

      fprintf (fl, "x = %d\ny = %d\n", x, y);
      fclose (fl);
      free (file);
      return;

    case CFG_PARSE_ERROR:
      unlink (file);

      if (!(fl = fopen (file, "w")))
	{
	  msg (_("Error open config file."));
	  free (file);
	  return;
	}

      fprintf (fl, "x = %d\ny = %d\n", x, y);
      fclose (fl);
      free (file);
      return;
    }

  if (!(fl = fopen (file, "w")))
    {
      msg (_("Error open config file."));
      free (file);
      return;
    }

  if (cfg_getstr (cfg, "buffer"))
    fprintf (fl, "buffer = %s\n", cfg_getstr (cfg, "buffer"));

  fprintf (fl, "volume = %d\n", (int) cfg_getint (cfg, "volume"));
  fprintf (fl, "random = %s\n",
	   cfg_getbool (cfg, "random") == 1 ? "true" : "false");
  fprintf (fl, "repeat = %s\n",
	   cfg_getbool (cfg, "repeat") == 1 ? "true" : "false");
  fprintf (fl, "noverbose = %s\n",
	   cfg_getbool (cfg, "noverbose") == 1 ? "true" : "false");
  fprintf (fl, "nobuffer = %s\n",
	   cfg_getbool (cfg, "nobuffer") == 1 ? "true" : "false");

  if (cfg_getstr (cfg, "audio"))
    fprintf (fl, "audio = %s\n", cfg_getstr (cfg, "audio"));

  fprintf (fl, "x = %d\n", x);
  fprintf (fl, "y = %d\n", y);

  fclose (fl);

  cfg_free (cfg);
  free (file);

}

/* EOF */
