/* Somaplayer - Copyright (C) 2003-4 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#ifdef ENABLE_GTK

#include "../player.h"
#include "gdaemon.h"
#include "../gtk/graphic.h"
#include "../gtk/gtkled.h"
#include "../gtk/gtkledbar.h"
#include "../other.h"

GtkWidget *windaemon;
GtkWidget *crossfade_v;
GtkWidget *crossfade_b;
GtkWidget *gdaemon_box;
GtkWidget *gstatusbar;
GtkWidget *ledbar_dl;
GtkWidget *ledbar_dr;
GtkWidget *autofader;

pthread_mutex_t gdaemon_mutex;

gint gstatusbar_id;
int gpid = 0;
int stop_50_cent = 0;

/* Initialize the graphic interface */
void *
daemon_graphic (void *arg)
{

  gtk_init (NULL, NULL);

  gtk_rc_parse_string (gtkrc);

  if (pthread_mutex_init (&gdaemon_mutex, NULL))
    fatal (_("Error: Mutex init."));

  windaemon = create_windaemon ();
  crossfade_v = create_crossfade_v ();
  crossfade_b = create_crossfade_b ();
  autofader = create_autofader ();
  winoutput = create_winoutput ();
  gtk_widget_show (windaemon);

  play->ao_rate = 44100;
  play->ao_channels = 2;

  output_window_refresh ();

  g_timeout_add (200, gtimeout, NULL);
  gtk_main ();

  pthread_mutex_destroy (&gdaemon_mutex);

  pthread_exit (NULL);
}

/* Close the daemon */
gint
on_dquit_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  if (gpid)
    {
      GtkWidget *dialog;

      dialog =
	gtk_message_dialog_new (GTK_WINDOW (windaemon),
				GTK_DIALOG_MODAL |
				GTK_DIALOG_DESTROY_WITH_PARENT,
				GTK_MESSAGE_ERROR, GTK_BUTTONS_OK,
				_("Close the somaplayer client before!"));

      gtk_dialog_run (GTK_DIALOG (dialog));
      gtk_widget_destroy (dialog);
      return TRUE;
    }

  events.quit = 1;
  gtk_main_quit ();

  return FALSE;
}

/* Create the main window */
GtkWidget *
create_windaemon (void)
{
  GtkWidget *window;
  GtkWidget *vbox;
  GtkWidget *menubar;
  GtkWidget *table;
  GtkWidget *sds;

  GtkWidget *output;
  GtkWidget *output_menu;
  GtkWidget *output_item;

  GtkWidget *sds_menu;
  GtkWidget *player;
  GtkWidget *cross_v;
  GtkWidget *cross_b;
  GtkWidget *af;
  GtkWidget *about;
  GtkWidget *image;
  GtkWidget *separator;
  GtkWidget *quit;
  GtkWidget *mute;
  GtkWidget *label1;
  GtkWidget *label2;
  GtkAdjustment *adj_volume;
  GtkWidget *volume;
  GtkAdjustment *adj_balance;
  GtkWidget *balance;
  GtkWidget *vseparator;
  GtkWidget *hseparator;
  GtkAccelGroup *accel_group;
  GtkWidget *frame;

  accel_group = gtk_accel_group_new ();

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_size_request (window, -1, 400);
  gtk_window_set_title (GTK_WINDOW (window), _("SdS Mixer"));
  gtk_window_set_resizable (GTK_WINDOW (window), FALSE);
  gtk_widget_realize (window);

  vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox);
  gtk_container_add (GTK_CONTAINER (window), vbox);

  menubar = gtk_menu_bar_new ();
  gtk_widget_show (menubar);
  gtk_box_pack_start (GTK_BOX (vbox), menubar, FALSE, FALSE, 0);

  sds = gtk_menu_item_new_with_mnemonic (_("_SdS"));
  gtk_widget_show (sds);
  gtk_container_add (GTK_CONTAINER (menubar), sds);

  sds_menu = gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (sds), sds_menu);

  output = gtk_menu_item_new_with_mnemonic (_("O_utputs"));
  gtk_widget_show (output);
  gtk_container_add (GTK_CONTAINER (menubar), output);

  output_menu = gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (output), output_menu);

  output_item = gtk_menu_item_new_with_mnemonic (_("_Show Outputs"));
  gtk_widget_show (output_item);
  gtk_container_add (GTK_CONTAINER (output_menu), output_item);

  g_signal_connect ((gpointer) output_item, "activate",
		    G_CALLBACK (output_window_show), NULL);

  output_item = gtk_menu_item_new_with_mnemonic (_("_Add Output"));
  gtk_widget_show (output_item);
  gtk_container_add (GTK_CONTAINER (output_menu), output_item);

  output_menu = gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (output_item), output_menu);

#ifdef ENABLE_AO
  output_item = gtk_menu_item_new_with_mnemonic (_("Audio"));
  gtk_widget_show (output_item);
  gtk_container_add (GTK_CONTAINER (output_menu), output_item);

  g_signal_connect ((gpointer) output_item, "activate",
		    G_CALLBACK (on_ao_new_activate), NULL);
#endif

#ifdef ENABLE_DAEMON
  output_item =
    gtk_menu_item_new_with_mnemonic (_("Soma Distribuited Sound"));
  gtk_widget_show (output_item);
  gtk_container_add (GTK_CONTAINER (output_menu), output_item);

  g_signal_connect ((gpointer) output_item, "activate",
		    G_CALLBACK (on_sds_new_activate), NULL);
#endif

#ifdef ENABLE_LAME
  output_item = gtk_menu_item_new_with_mnemonic (_("Encode Mp3"));
  gtk_widget_show (output_item);
  gtk_container_add (GTK_CONTAINER (output_menu), output_item);

  g_signal_connect ((gpointer) output_item, "activate",
		    G_CALLBACK (on_lame_new_activate), NULL);
#endif

#ifdef ENABLE_OGG
  output_item = gtk_menu_item_new_with_mnemonic (_("Encode Ogg"));
  gtk_widget_show (output_item);
  gtk_container_add (GTK_CONTAINER (output_menu), output_item);

  g_signal_connect ((gpointer) output_item, "activate",
		    G_CALLBACK (on_ogg_new_activate), NULL);
#endif

#ifdef ENABLE_SNDFILE
  output_item = gtk_menu_item_new_with_mnemonic (_("Write a file"));
  gtk_widget_show (output_item);
  gtk_container_add (GTK_CONTAINER (output_menu), output_item);

  g_signal_connect ((gpointer) output_item, "activate",
		    G_CALLBACK (on_write_a_file_new_activate), NULL);
#endif

#ifdef ENABLE_STREAMING

#ifdef ENABLE_ICECAST
  output_item = gtk_menu_item_new_with_mnemonic (_("Icecast"));
  gtk_widget_show (output_item);
  gtk_container_add (GTK_CONTAINER (output_menu), output_item);

  g_signal_connect ((gpointer) output_item, "activate",
		    G_CALLBACK (on_icecast_new_activate), NULL);
#endif

#ifdef ENABLE_ICECAST2
  output_item = gtk_menu_item_new_with_mnemonic (_("Icecast2"));
  gtk_widget_show (output_item);
  gtk_container_add (GTK_CONTAINER (output_menu), output_item);

  g_signal_connect ((gpointer) output_item, "activate",
		    G_CALLBACK (on_icecast2_new_activate), NULL);
#endif

#ifdef ENABLE_SHOUTCAST
  output_item = gtk_menu_item_new_with_mnemonic (_("Shoutcast"));
  gtk_widget_show (output_item);
  gtk_container_add (GTK_CONTAINER (output_menu), output_item);

  g_signal_connect ((gpointer) output_item, "activate",
		    G_CALLBACK (on_shoutcast_new_activate), NULL);
#endif

#endif

  player = gtk_image_menu_item_new_with_mnemonic (_("_Run a SomaPlayer"));
  gtk_widget_show (player);
  gtk_container_add (GTK_CONTAINER (sds_menu), player);

  image = gtk_image_new_from_stock ("gtk-execute", GTK_ICON_SIZE_MENU);
  gtk_widget_show (image);
  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (player), image);

  cross_v =
    gtk_image_menu_item_new_with_mnemonic (_("Show _Crossfade Volume"));
  gtk_widget_show (cross_v);
  gtk_container_add (GTK_CONTAINER (sds_menu), cross_v);

  image = gtk_image_new_from_stock ("gtk-refresh", GTK_ICON_SIZE_MENU);
  gtk_widget_show (image);
  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (cross_v), image);

  cross_b =
    gtk_image_menu_item_new_with_mnemonic (_("Show _Crossfade Balance"));
  gtk_widget_show (cross_b);
  gtk_container_add (GTK_CONTAINER (sds_menu), cross_b);

  image = gtk_image_new_from_stock ("gtk-refresh", GTK_ICON_SIZE_MENU);
  gtk_widget_show (image);
  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (cross_b), image);

  af = gtk_image_menu_item_new_with_mnemonic (_("Show _Autofader"));
  gtk_widget_show (af);
  gtk_container_add (GTK_CONTAINER (sds_menu), af);

  image = gtk_image_new_from_stock ("gtk-refresh", GTK_ICON_SIZE_MENU);
  gtk_widget_show (image);
  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (af), image);

  about = gtk_image_menu_item_new_with_mnemonic (_("_About"));
  gtk_widget_show (about);
  gtk_container_add (GTK_CONTAINER (sds_menu), about);

  image =
    gtk_image_new_from_stock ("gtk-dialog-question", GTK_ICON_SIZE_MENU);
  gtk_widget_show (image);
  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (about), image);

  separator = gtk_menu_item_new ();
  gtk_widget_show (separator);
  gtk_container_add (GTK_CONTAINER (sds_menu), separator);
  gtk_widget_set_sensitive (separator, FALSE);

  quit = gtk_image_menu_item_new_from_stock ("gtk-quit", accel_group);
  gtk_widget_show (quit);
  gtk_container_add (GTK_CONTAINER (sds_menu), quit);

  gdaemon_box = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (gdaemon_box);
  gtk_container_add (GTK_CONTAINER (vbox), gdaemon_box);

  frame = gtk_frame_new (_("General"));
  gtk_widget_show (frame);
  gtk_box_pack_start (GTK_BOX (gdaemon_box), frame, TRUE, TRUE, 0);

  table = gtk_table_new (0, 0, FALSE);
  gtk_widget_show (table);
  gtk_container_add (GTK_CONTAINER (frame), table);

  mute = gtk_toggle_button_new_with_label (_("Mute"));
  gtk_widget_show (mute);
  gtk_table_attach (GTK_TABLE (table), mute, 0, 4, 0, 1,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  vseparator = gtk_vseparator_new ();
  gtk_widget_show (vseparator);
  gtk_table_attach (GTK_TABLE (table), vseparator, 1, 2, 2, 5,
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		    (GtkAttachOptions) (GTK_FILL), 0, 0);

  hseparator = gtk_hseparator_new ();
  gtk_widget_show (hseparator);

  gtk_table_attach (GTK_TABLE (table), hseparator, 0, 4, 1, 2,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (GTK_FILL), 0, 0);

  label1 = gtk_label_new (_("Volume"));
  gtk_widget_show (label1);
  gtk_label_set_justify (GTK_LABEL (label1), GTK_JUSTIFY_CENTER);
  gtk_table_attach (GTK_TABLE (table), label1, 0, 1, 4, 5,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  label2 = gtk_label_new (_("Balance"));
  gtk_widget_show (label2);
  gtk_label_set_justify (GTK_LABEL (label2), GTK_JUSTIFY_CENTER);
  gtk_table_attach (GTK_TABLE (table), label2, 2, 4, 4, 5,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  adj_volume =
    (GtkAdjustment *) gtk_adjustment_new ((gdouble) (play->volume), 0, 100, 5,
					  10, 0);
  volume = gtk_vscale_new (GTK_ADJUSTMENT (adj_volume));
  gtk_widget_show (volume);
  gtk_table_attach (GTK_TABLE (table), volume, 0, 1, 2, 4,
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_range_set_inverted (GTK_RANGE (volume), TRUE);

  ledbar_dl = gtk_led_bar_new (20, GTK_ORIENTATION_VERTICAL);
  gtk_widget_show (ledbar_dl);
  gtk_table_attach (GTK_TABLE (table), ledbar_dl, 2, 3, 2, 3,
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		    (GtkAttachOptions) (GTK_FILL), 0, 0);

  ledbar_dr = gtk_led_bar_new (20, GTK_ORIENTATION_VERTICAL);
  gtk_widget_show (ledbar_dr);
  gtk_table_attach (GTK_TABLE (table), ledbar_dr, 3, 4, 2, 3,
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		    (GtkAttachOptions) (GTK_FILL), 0, 0);

  adj_balance =
    (GtkAdjustment *) gtk_adjustment_new ((gdouble) (play->balance + 50), 0,
					  100, 5, 10, 0);
  balance = gtk_vscale_new (adj_balance);
  gtk_widget_show (balance);
  gtk_table_attach (GTK_TABLE (table), balance, 2, 4, 3, 4,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_range_set_inverted (GTK_RANGE (balance), TRUE);

  gstatusbar = gtk_statusbar_new ();
  gstatusbar_id =
    gtk_statusbar_get_context_id (GTK_STATUSBAR (gstatusbar), _("SdS Mixer"));
  gtk_widget_show (gstatusbar);

  gtk_box_pack_start (GTK_BOX (vbox), gstatusbar, FALSE, FALSE, 0);

  g_signal_connect ((gpointer) player, "activate",
		    G_CALLBACK (on_dplayer_activate), NULL);
  g_signal_connect ((gpointer) cross_v, "activate",
		    G_CALLBACK (crossfade_v_show), NULL);
  g_signal_connect ((gpointer) cross_b, "activate",
		    G_CALLBACK (crossfade_b_show), NULL);
  g_signal_connect ((gpointer) af, "activate",
		    G_CALLBACK (autofader_show), NULL);
  g_signal_connect ((gpointer) about, "activate",
		    G_CALLBACK (on_about_activate), NULL);
  g_signal_connect ((gpointer) quit, "activate",
		    G_CALLBACK (on_dquit_activate), NULL);
  g_signal_connect ((gpointer) window, "delete_event",
		    G_CALLBACK (on_dquit_activate), NULL);
  g_signal_connect ((gpointer) window, "destroy",
		    G_CALLBACK (gtk_main_quit), NULL);
  g_signal_connect ((gpointer) volume, "value_changed",
		    G_CALLBACK (on_dvolume_value_changed), NULL);
  g_signal_connect ((gpointer) balance, "value_changed",
		    G_CALLBACK (on_dbalance_value_changed), NULL);
  g_signal_connect ((gpointer) mute, "toggled", G_CALLBACK (on_mute_toggled),
		    NULL);

  gtk_window_add_accel_group (GTK_WINDOW (window), accel_group);

  pthread_mutex_lock (&gmutex);

  pthread_mutex_unlock (&gmutex);

  gtk_timeout_add (100, ledbar_d_timeout, NULL);

  return window;
}

#endif

/* EOF */
