/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.solr.handler.dataimport;

/**
 * Event listener for DataImportHandler
 *
 * <b>This API is experimental and subject to change</b>
 *
 * @version $Id: EventListener.java 757332 2009-03-23 07:14:19Z shalin $
 * @since solr 1.4
 */
public interface EventListener {

  /**
   * Event callback
   *
   * @param ctx the Context in which this event was called
   */
  public void onEvent(Context ctx);

}
