/* MAPIStoreMessageTable.m - this file is part of SOGo
 *
 * Copyright (C) 2010 Inverse inc
 *
 * Author: Wolfgang Sourdeau <wsourdeau@inverse.ca>
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#import <Foundation/NSArray.h>

#import <NGExtensions/NSObject+Logs.h>

#import <SOGo/SOGoFolder.h>
#import <SOGo/SOGoObject.h>

#import "MAPIStoreFolder.h"
#import "MAPIStoreTypes.h"
#import "NSData+MAPIStore.h"
#import "NSString+MAPIStore.h"

#import "MAPIStoreMessageTable.h"

@implementation MAPIStoreMessageTable

- (void) setSortOrder: (const struct SSortOrderSet *) set
{
  [self logWithFormat: @"unimplemented method: %@", NSStringFromSelector (_cmd)];
}

- (NSArray *) childKeys
{
  if (!childKeys)
    {
      childKeys = [(MAPIStoreFolder *)
                    container messageKeysMatchingQualifier: nil
                                          andSortOrderings: sortOrderings];
      [childKeys retain];
    }

  return childKeys;
}

- (NSArray *) restrictedChildKeys
{
  NSArray *keys;

  if (!restrictedChildKeys)
    {
      if (restrictionState != MAPIRestrictionStateAlwaysTrue)
        {
          if (restrictionState == MAPIRestrictionStateNeedsEval)
            keys = [(MAPIStoreFolder *)
                     container messageKeysMatchingQualifier: restriction
                                           andSortOrderings: sortOrderings];
          else
            keys = [NSArray array];
        }
      else
        keys = [self childKeys];

      ASSIGN (restrictedChildKeys, keys);
    }

  return restrictedChildKeys;
}

- (id) lookupChild: (NSString *) childKey
{
  return [(MAPIStoreFolder *) container lookupMessage: childKey];
}

@end
