/*
 * ------------------------------------------------------------------------------
 *
 * Emulation of PCF8574 8 Bit IO-Expander 
 *
 * (C) 2005  Lightmaze Solutions AG
 *   Author: Jochen Karrer
 *
 * State: Untested, might work
 *       
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 * ------------------------------------------------------------------------------
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <sys/time.h>
#include <time.h>
#include <unistd.h>
#include "i2c.h"
#include "signode.h"
#include "pcf8574.h"
#include "sgstring.h"

#if 0
#define dbgprintf(x...) { fprintf(stderr,x); }
#else
#define dbgprintf(x...)
#endif

#define PCF_STATE_DATA1  (0)

struct PCF8574 {
	I2C_Slave i2c_slave;
	int state;
	uint8_t outval; /* buffer for write */
	SigNode *port[8];
};

static void 
set_ports(PCF8574 *pcf)  {
	int i;
	for(i=0;i<8;i++) {
		if(!pcf->port[i]) {
			continue;
		}
		if(pcf->outval&(1<<i)) {
			SigNode_Set(pcf->port[i],SIG_PULLUP);	
		} else {
			SigNode_Set(pcf->port[i],SIG_LOW);	
		}
	}
}

static uint8_t 
get_ports(PCF8574 *pcf)  {
	int i;
	uint8_t value = 0;
	for(i=0;i<8;i++) {
		int sigval;
		if(!pcf->port[i]) {
			continue;
		}
		sigval = SigNode_Val(pcf->port[i]);	
		if((sigval == SIG_LOW) || (sigval == SIG_PULLDOWN)) {
				
		} else {
			value = value | (1<<i);
		}
	}
	return value;
}
/*
 * ------------------------------------
 * PCF8574 Write state machine 
 * ------------------------------------
 */
static int 
pcf8574_write(void *dev,uint8_t data) {
	PCF8574 *pcf = dev;
	switch(pcf->state) {
		case PCF_STATE_DATA1:
			dbgprintf("PCF8574 Write 0x%02x to %04x\n",data,pcf->reg_address);
			pcf->outval = data;
			pcf->state = PCF_STATE_DATA1;
			set_ports(pcf); 
			break;
	}
	return I2C_ACK;
};

static int 
pcf8574_read(void *dev,uint8_t *data) 
{
	PCF8574 *pcf = dev;
	switch(pcf->state) {
		case PCF_STATE_DATA1:
			*data = get_ports(pcf);
			pcf->state = PCF_STATE_DATA1;
			break;
	}
	return I2C_DONE;
};

static int 
pcf8574_start(void *dev,int i2c_addr,int operation) {
	PCF8574 *pcf = dev;
	dbgprintf("pcf8574 start\n");
	pcf->state = PCF_STATE_DATA1;
	return I2C_ACK;
}

static void 
pcf8574_stop(void *dev) {
	PCF8574 *pcf = dev;
	dbgprintf("pcf8574 stop\n");
	pcf->state =  PCF_STATE_DATA1; 
}

static I2C_SlaveOps pcf8574_ops = {
	.start = pcf8574_start,
	.stop =  pcf8574_stop,
	.read =  pcf8574_read,	
	.write = pcf8574_write	
};

I2C_Slave *
PCF8574_New(char *name) {
	char *nodename = alloca(strlen(name)+20);
	PCF8574 *pcf = sg_new(PCF8574); 
	I2C_Slave *i2c_slave;
	int i;
	i2c_slave = &pcf->i2c_slave;
	i2c_slave->devops = &pcf8574_ops; 
	i2c_slave->dev = pcf;
	i2c_slave->speed = I2C_SPEED_FAST;
	for(i=0;i<8;i++) {
		sprintf(nodename,"%s.P%02d",name,i);
		pcf->port[i]=SigNode_New(nodename);
		if(!pcf->port[i]) {
			fprintf(stderr,"PCF8574: Can not create Signal node %s",nodename);
			sleep(1);
		}
	}
	pcf->outval = 0xff;
	set_ports(pcf);
	fprintf(stderr,"PCF8574 8 Bit IO-Expander \"%s\" created\n",name);
	return i2c_slave;
}
