/* -*- C -*-
 *
 * This file is part of the Sofia-SIP package
 *
 * Copyright (C) 2006 Nokia Corporation.
 *
 * Contact: Pekka Pessi <pekka.pessi@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef SIP_EXTRA_H
/** Defined when <sofia-sip/sip_extra.h> has been included. */
#define SIP_EXTRA_H

/**@file sofia-sip/sip_extra.h
*
 * @brief Extension headers for SIP.
 *
 * This file is automatically generated from <sip_extra_headers.txt> by msg_parser.awk.
 *
 * @author Pekka Pessi <Pekka.Pessi@nokia.com>.
 */

#ifndef SIP_H
#include <sofia-sip/sip.h>
#endif

#ifndef SIP_HEADER_H
#include <sofia-sip/sip_header.h>
#endif

SOFIA_BEGIN_DECLS

typedef struct sip_refer_sub_s      sip_refer_sub_t;

/**@ingroup sip_refer_sub
 * @brief Structure for @ReferSub header.
 */
struct sip_refer_sub_s
{
  sip_common_t        rs_common[1];   	/**< Common fragment info */
  sip_error_t        *rs_next;        	/**< Dummy link to next */
  char const         *rs_value;       	/**< "true" or "false" */
  msg_param_t const  *rs_params;      	/**< List of extension parameters */
};

typedef struct sip_alert_info_s sip_alert_info_t;

/**@ingroup sip_alert_info
 * @brief Structure for @AlertInfo header.
 */
struct sip_alert_info_s
{
  sip_common_t        ai_common[1];     /**< Common fragment info */
  sip_alert_info_t   *ai_next;		/**< Link to next @AlertInfo */
  url_t               ai_url[1];	/**< URI to alert info */
  msg_param_t const  *ai_params;	/**< List of optional parameters */
};

typedef struct sip_reply_to_s sip_reply_to_t;

/**@ingroup sip_reply_to
 * @brief Structure for @ReplyTo header.
 */
struct sip_reply_to_s
{
  sip_common_t        rplyto_common[1];	/**< Common fragment info */
  sip_error_t        *rplyto_next;	/**< Dummy link to next header */
  char const         *rplyto_display;	/**< Display name */
  url_t               rplyto_url[1];	/**< Return URI */
  msg_param_t const  *rplyto_params;	/**< List of optional parameters */
};

typedef struct sip_suppress_body_if_match_s sip_suppress_body_if_match_t;

/**@ingroup sip_suppress_body_if_match
 * @brief Structure for @SuppressBodyIfMatch header.
 */
struct sip_suppress_body_if_match_s
{
  sip_common_t   sbim_common[1];	/**< Common fragment info */
  sip_error_t   *sbim_next;		/**< Dummy link to next header */
  char const    *sbim_tag;		/**< Entity-tag */
};

typedef struct sip_suppress_notify_if_match_s sip_suppress_notify_if_match_t;

/**@ingroup sip_suppress_notify_if_match
 * @brief Structure for @SuppressNotifyIfMatch header.
 */
struct sip_suppress_notify_if_match_s
{
  sip_common_t   snim_common[1];	/**< Common fragment info */
  sip_error_t   *snim_next;		/**< Dummy link to next header */
  char const    *snim_tag;		/**< Entity-tag */
};

typedef struct sip_p_asserted_identity_s sip_p_asserted_identity_t;

/**@ingroup sip_p_asserted_identity
 * @brief Structure for @PAssertedIdentity header.
 */
struct sip_p_asserted_identity_s
{
  sip_common_t       paid_common[1];/**< Common fragment info */
  sip_p_asserted_identity_t
                    *paid_next;	    /**< Link to next identity */
  char const        *paid_display;  /**< Display name */
  url_t              paid_url[1];   /**< SIP, SIPS or TEL URL */
};

typedef struct sip_p_preferred_identity_s sip_p_preferred_identity_t;

/**@ingroup sip_p_preferred_identity
 * @brief Structure for @PPreferredIdentity header.
 */
struct sip_p_preferred_identity_s
{
  sip_common_t       ppid_common[1];/**< Common fragment info */
  sip_p_preferred_identity_t
                    *ppid_next;	    /**< Link to next identity */
  char const        *ppid_display;  /**< Display name */
  url_t              ppid_url[1];   /**< SIP, SIPS or TEL URL */
};


int sip_p_initialize_remote_party_id_headers(msg_mclass_t *mclass);

typedef struct sip_remote_party_id_s sip_remote_party_id_t;

/**@ingroup sip_remote_party_id
 * @brief Structure for @RemotePartyID header.
 */
struct sip_remote_party_id_s
{
  sip_common_t       rpid_common[1];/**< Common fragment info */
  sip_remote_party_id_t
                    *rpid_next;	    /**< Link to next identity */
  char const        *rpid_display;  /**< Display name */
  url_t              rpid_url[1];   /**< URL */
  sip_param_t const *rpid_params;   /**< Parameters */
  /** Shortcuts to screen, party, id-type and privacy parameters */
  char const        *rpid_screen, *rpid_party, *rpid_id_type, *rpid_privacy;
};



/** Defined as 1 if the @ref sip_refer_sub "Refer-Sub header" is supported */
#define SIP_HAVE_REFER_SUB 1


enum { 
  /**@ingroup sip_refer_sub @internal 
   *
   * Hash of @ref sip_refer_sub "Refer-Sub header".
   *
   * @since New in @NEW_1_12_5.
   */
  sip_refer_sub_hash = 14607 
};

/**Header class for @ref sip_refer_sub "Refer-Sub header".
 * 
 * The header class sip_refer_sub_class defines how a SIP
 * @ref sip_refer_sub "Refer-Sub header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_refer_sub_t header structure.
 *
 * @ingroup sip_refer_sub
 *
 * @since New in @NEW_1_12_5.
 */
SIP_DLL extern msg_hclass_t sip_refer_sub_class[];


/**@addtogroup sip_refer_sub
 * @{
 */

/** Parse a SIP @ref sip_refer_sub "Refer-Sub header". @internal */
SOFIAPUBFUN issize_t sip_refer_sub_d(su_home_t *, msg_header_t *,
				       char *s, isize_t slen);

/** Print a SIP @ref sip_refer_sub "Refer-Sub header". @internal */
SOFIAPUBFUN issize_t sip_refer_sub_e(char b[], isize_t bsiz,
                    	            msg_header_t const *h, int flags);

/**Access a SIP @ref sip_refer_sub "Refer-Sub header"
 * structure #sip_refer_sub_t from #sip_t.
 * 
 * @since New in @NEW_1_12_5.
 */
#define sip_refer_sub(sip) \
  ((sip_refer_sub_t *)msg_header_access((msg_pub_t*)(sip), sip_refer_sub_class))

/**Initializer for structure #sip_refer_sub_t.
 * 
 * A static #sip_refer_sub_t structure for
 * @ref sip_refer_sub "Refer-Sub header" must be initialized with
 * the SIP_REFER_SUB_INIT() macro. 
 * For instance,
 * @code 
 * 
 *  sip_refer_sub_t sip_refer_sub = SIP_REFER_SUB_INIT;
 * 
 * @endcode
 * @HI
 *
 * @since New in @NEW_1_12_5.
 */
#define SIP_REFER_SUB_INIT() SIP_HDR_INIT(refer_sub)

/**Initialize a structure #sip_refer_sub_t.
 * 
 * An #sip_refer_sub_t structure for
 * @ref sip_refer_sub "Refer-Sub header" can be initialized with the
 * sip_refer_sub_init() function/macro. For instance,
 * @code
 * 
 *  sip_refer_sub_t sip_refer_sub;
 * 
 *  sip_refer_sub_init(&sip_refer_sub);
 * 
 * @endcode
 * @HI
 *
 * @since New in @NEW_1_12_5.
 */
#if SU_HAVE_INLINE
su_inline sip_refer_sub_t *sip_refer_sub_init(sip_refer_sub_t x[1])
{
  return SIP_HEADER_INIT(x, sip_refer_sub_class, sizeof(sip_refer_sub_t));
}
#else
#define sip_refer_sub_init(x) \
  SIP_HEADER_INIT(x, sip_refer_sub_class, sizeof(sip_refer_sub_t))
#endif

/**Test if header object is instance of #sip_refer_sub_t.
 * 
 * Check if the header class is an instance of
 * @ref sip_refer_sub "Refer-Sub header" object and return true (nonzero),
 * otherwise return false (zero).
 * 
 * @param header pointer to the header structure to be tested
 * 
 * @retval 1 (true) if the @a header is an instance of header refer_sub 
 * @retval 0 (false) otherwise
 *
 * @since New in @NEW_1_12_5.
 */
#if SU_HAVE_INLINE
su_inline int sip_is_refer_sub(sip_header_t const *header)
{
  return header && header->sh_class->hc_hash == sip_refer_sub_hash;
}
#else
int sip_is_refer_sub(sip_header_t const *header);
#endif

#define sip_refer_sub_p(h) sip_is_refer_sub((h))


/**Duplicate a list of @ref sip_refer_sub "Refer-Sub header" header structures #sip_refer_sub_t.
 * 
 * Duplicate a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 * 
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 * 
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 * 
 * @par Example
 * @code
 * 
 *   refer_sub = sip_refer_sub_dup(home, sip->sip_refer_sub);
 * 
 * @endcode
 * 
 * @return
 * A pointer to the
 * newly duplicated #sip_refer_sub_t header structure, or NULL
 * upon an error.
 *
 * @since New in @NEW_1_12_5.
 */
#if SU_HAVE_INLINE
su_inline
#endif
sip_refer_sub_t *sip_refer_sub_dup(su_home_t *home, sip_refer_sub_t const *hdr) 
     __attribute__((__malloc__));

#if SU_HAVE_INLINE
su_inline
sip_refer_sub_t *sip_refer_sub_dup(su_home_t *home, sip_refer_sub_t const *hdr)
{ 
  return (sip_refer_sub_t *)
    msg_header_dup_as(home, sip_refer_sub_class, (msg_header_t const *)hdr);
}
#endif

/**Copy a list of @ref sip_refer_sub "Refer-Sub header" header structures #sip_refer_sub_t.
 * 
 * The function sip_refer_sub_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the list of header
 * structure @a hdr.
 * 
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be copied
 * 
 * When copying, only the header structure and parameter lists attached to
 * it are duplicated. The new header structure retains all the references to
 * the strings within the old @a hdr header, including the encoding of the
 * old header, if present.
 * 
 * @par Example
 * @code
 * 
 *   refer_sub = sip_refer_sub_copy(home, sip->sip_refer_sub);
 * 
 * @endcode
 * 
 * @return
 * A pointer to newly copied header structure, or NULL upon an error.
 *
 * @since New in @NEW_1_12_5.
 */
#if SU_HAVE_INLINE
su_inline
#endif
sip_refer_sub_t *sip_refer_sub_copy(su_home_t *home, sip_refer_sub_t const *hdr) 
     __attribute__((__malloc__));

#if SU_HAVE_INLINE
su_inline
sip_refer_sub_t *sip_refer_sub_copy(su_home_t *home, sip_refer_sub_t const *hdr) 
{ 
  return (sip_refer_sub_t *)
    msg_header_copy_as(home, sip_refer_sub_class, (msg_header_t const *)hdr); 
}
#endif

/**Make a @ref sip_refer_sub "Refer-Sub header" structure #sip_refer_sub_t.
 * 
 * The function sip_refer_sub_make() makes a new
 * #sip_refer_sub_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 * 
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 * 
 * @return
 * A pointer to newly maked #sip_refer_sub_t header structure, or NULL upon an
 * error.
 *
 * @since New in @NEW_1_12_5.
 */
#if SU_HAVE_INLINE
su_inline 
#endif
sip_refer_sub_t *sip_refer_sub_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

#if SU_HAVE_INLINE
su_inline sip_refer_sub_t *sip_refer_sub_make(su_home_t *home, char const *s)
{
  return (sip_refer_sub_t *)sip_header_make(home, sip_refer_sub_class, s);
}
#endif

/**Make a @ref sip_refer_sub "Refer-Sub header" from formatting result.
 * 
 * Make a new #sip_refer_sub_t object using formatting result as its value. 
 * The function first prints the arguments according to the format @a fmt
 * specified. Then it allocates a new header structure, and parses the
 * formatting result to the structure #sip_refer_sub_t.
 * 
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 * 
 * @return
 * A pointer to newly
 * makes header structure, or NULL upon an error.
 * 
 * @HIDE
 *
 * @since New in @NEW_1_12_5.
 */
#if SU_HAVE_INLINE
su_inline
#endif
sip_refer_sub_t *sip_refer_sub_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));

#if SU_HAVE_INLINE
su_inline sip_refer_sub_t *sip_refer_sub_format(su_home_t *home, char const *fmt, ...)
{
  sip_header_t *h;
  va_list ap;
  
  va_start(ap, fmt);
  h = sip_header_vformat(home, sip_refer_sub_class, fmt, ap);
  va_end(ap);
 
  return (sip_refer_sub_t *)h;
}
#endif

/** @} */

/**@ingroup sip_refer_sub
 *
 * Tag list item for pointer to a @ref sip_refer_sub "Refer-Sub header"
 * structure #sip_refer_sub_t.
 *
 * The SIPTAG_REFER_SUB() macro is used to include a tag item with a
 * pointer to a #sip_refer_sub_t structure in a tag list.
 *
 * @param x pointer to a #sip_refer_sub_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_REFER_SUB_REF().
 *
 * @since New in @NEW_1_12_5.
 *
 * @HIDE
 */
#define SIPTAG_REFER_SUB(x) siptag_refer_sub, siptag_refer_sub_v(x)

SOFIAPUBVAR tag_typedef_t siptag_refer_sub;

/**@ingroup sip_refer_sub
 * Tag list item for reference to a 
 * @ref sip_refer_sub "Refer-Sub header" pointer.
 */
#define SIPTAG_REFER_SUB_REF(x) siptag_refer_sub_ref, siptag_refer_sub_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_refer_sub_ref;

/**@ingroup sip_refer_sub
 *
 * Tag list item for string with @ref sip_refer_sub "Refer-Sub header" value.
 *
 * The SIPTAG_REFER_SUB_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_refer_sub_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_refer_sub "Refer-Sub header" value, or NULL.
 *
 * The string in SIPTAG_REFER_SUB_STR() can be converted to a
 * #sip_refer_sub_t header structure by giving the string @a s has
 * second argument to function sip_refer_sub_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_REFER_SUB_STR_REF().
 *
 * @since New in @NEW_1_12_5.
 *
 * @HIDE
 */
#define SIPTAG_REFER_SUB_STR(s) siptag_refer_sub_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_refer_sub_str;

/**@ingroup sip_refer_sub
 * Tag list item for reference to a
 * @ref sip_refer_sub "Refer-Sub header" string.
 */
#define SIPTAG_REFER_SUB_STR_REF(x) siptag_refer_sub_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_refer_sub_str_ref;

#if SU_INLINE_TAG_CAST
su_inline tag_value_t
siptag_refer_sub_v(sip_refer_sub_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_refer_sub_vr(sip_refer_sub_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_refer_sub_v(v)   (tag_value_t)(v)
#define siptag_refer_sub_vr(vp) (tag_value_t)(vp)
#endif

/** Defined as 1 if the @ref sip_alert_info "Alert-Info header" is supported */
#define SIP_HAVE_ALERT_INFO 1


enum { 
  /**@ingroup sip_alert_info @internal 
   *
   * Hash of @ref sip_alert_info "Alert-Info header".
   *
   * @since New in @NEW_1_12_7.
   */
  sip_alert_info_hash = 53913 
};

/**Header class for @ref sip_alert_info "Alert-Info header".
 * 
 * The header class sip_alert_info_class defines how a SIP
 * @ref sip_alert_info "Alert-Info header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_alert_info_t header structure.
 *
 * @ingroup sip_alert_info
 *
 * @since New in @NEW_1_12_7.
 */
SIP_DLL extern msg_hclass_t sip_alert_info_class[];


/**@addtogroup sip_alert_info
 * @{
 */

/** Parse a SIP @ref sip_alert_info "Alert-Info header". @internal */
SOFIAPUBFUN issize_t sip_alert_info_d(su_home_t *, msg_header_t *,
				       char *s, isize_t slen);

/** Print a SIP @ref sip_alert_info "Alert-Info header". @internal */
SOFIAPUBFUN issize_t sip_alert_info_e(char b[], isize_t bsiz,
                    	            msg_header_t const *h, int flags);

/**Access a SIP @ref sip_alert_info "Alert-Info header"
 * structure #sip_alert_info_t from #sip_t.
 * 
 * @since New in @NEW_1_12_7.
 */
#define sip_alert_info(sip) \
  ((sip_alert_info_t *)msg_header_access((msg_pub_t*)(sip), sip_alert_info_class))

/**Initializer for structure #sip_alert_info_t.
 * 
 * A static #sip_alert_info_t structure for
 * @ref sip_alert_info "Alert-Info header" must be initialized with
 * the SIP_ALERT_INFO_INIT() macro. 
 * For instance,
 * @code 
 * 
 *  sip_alert_info_t sip_alert_info = SIP_ALERT_INFO_INIT;
 * 
 * @endcode
 * @HI
 *
 * @since New in @NEW_1_12_7.
 */
#define SIP_ALERT_INFO_INIT() SIP_HDR_INIT(alert_info)

/**Initialize a structure #sip_alert_info_t.
 * 
 * An #sip_alert_info_t structure for
 * @ref sip_alert_info "Alert-Info header" can be initialized with the
 * sip_alert_info_init() function/macro. For instance,
 * @code
 * 
 *  sip_alert_info_t sip_alert_info;
 * 
 *  sip_alert_info_init(&sip_alert_info);
 * 
 * @endcode
 * @HI
 *
 * @since New in @NEW_1_12_7.
 */
#if SU_HAVE_INLINE
su_inline sip_alert_info_t *sip_alert_info_init(sip_alert_info_t x[1])
{
  return SIP_HEADER_INIT(x, sip_alert_info_class, sizeof(sip_alert_info_t));
}
#else
#define sip_alert_info_init(x) \
  SIP_HEADER_INIT(x, sip_alert_info_class, sizeof(sip_alert_info_t))
#endif

/**Test if header object is instance of #sip_alert_info_t.
 * 
 * Check if the header class is an instance of
 * @ref sip_alert_info "Alert-Info header" object and return true (nonzero),
 * otherwise return false (zero).
 * 
 * @param header pointer to the header structure to be tested
 * 
 * @retval 1 (true) if the @a header is an instance of header alert_info 
 * @retval 0 (false) otherwise
 *
 * @since New in @NEW_1_12_7.
 */
#if SU_HAVE_INLINE
su_inline int sip_is_alert_info(sip_header_t const *header)
{
  return header && header->sh_class->hc_hash == sip_alert_info_hash;
}
#else
int sip_is_alert_info(sip_header_t const *header);
#endif

#define sip_alert_info_p(h) sip_is_alert_info((h))


/**Duplicate a list of @ref sip_alert_info "Alert-Info header" header structures #sip_alert_info_t.
 * 
 * Duplicate a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 * 
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 * 
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 * 
 * @par Example
 * @code
 * 
 *   alert_info = sip_alert_info_dup(home, sip->sip_alert_info);
 * 
 * @endcode
 * 
 * @return
 * A pointer to the
 * newly duplicated #sip_alert_info_t header structure, or NULL
 * upon an error.
 *
 * @since New in @NEW_1_12_7.
 */
#if SU_HAVE_INLINE
su_inline
#endif
sip_alert_info_t *sip_alert_info_dup(su_home_t *home, sip_alert_info_t const *hdr) 
     __attribute__((__malloc__));

#if SU_HAVE_INLINE
su_inline
sip_alert_info_t *sip_alert_info_dup(su_home_t *home, sip_alert_info_t const *hdr)
{ 
  return (sip_alert_info_t *)
    msg_header_dup_as(home, sip_alert_info_class, (msg_header_t const *)hdr);
}
#endif

/**Copy a list of @ref sip_alert_info "Alert-Info header" header structures #sip_alert_info_t.
 * 
 * The function sip_alert_info_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the list of header
 * structure @a hdr.
 * 
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be copied
 * 
 * When copying, only the header structure and parameter lists attached to
 * it are duplicated. The new header structure retains all the references to
 * the strings within the old @a hdr header, including the encoding of the
 * old header, if present.
 * 
 * @par Example
 * @code
 * 
 *   alert_info = sip_alert_info_copy(home, sip->sip_alert_info);
 * 
 * @endcode
 * 
 * @return
 * A pointer to newly copied header structure, or NULL upon an error.
 *
 * @since New in @NEW_1_12_7.
 */
#if SU_HAVE_INLINE
su_inline
#endif
sip_alert_info_t *sip_alert_info_copy(su_home_t *home, sip_alert_info_t const *hdr) 
     __attribute__((__malloc__));

#if SU_HAVE_INLINE
su_inline
sip_alert_info_t *sip_alert_info_copy(su_home_t *home, sip_alert_info_t const *hdr) 
{ 
  return (sip_alert_info_t *)
    msg_header_copy_as(home, sip_alert_info_class, (msg_header_t const *)hdr); 
}
#endif

/**Make a @ref sip_alert_info "Alert-Info header" structure #sip_alert_info_t.
 * 
 * The function sip_alert_info_make() makes a new
 * #sip_alert_info_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 * 
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 * 
 * @return
 * A pointer to newly maked #sip_alert_info_t header structure, or NULL upon an
 * error.
 *
 * @since New in @NEW_1_12_7.
 */
#if SU_HAVE_INLINE
su_inline 
#endif
sip_alert_info_t *sip_alert_info_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

#if SU_HAVE_INLINE
su_inline sip_alert_info_t *sip_alert_info_make(su_home_t *home, char const *s)
{
  return (sip_alert_info_t *)sip_header_make(home, sip_alert_info_class, s);
}
#endif

/**Make a @ref sip_alert_info "Alert-Info header" from formatting result.
 * 
 * Make a new #sip_alert_info_t object using formatting result as its value. 
 * The function first prints the arguments according to the format @a fmt
 * specified. Then it allocates a new header structure, and parses the
 * formatting result to the structure #sip_alert_info_t.
 * 
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 * 
 * @return
 * A pointer to newly
 * makes header structure, or NULL upon an error.
 * 
 * @HIDE
 *
 * @since New in @NEW_1_12_7.
 */
#if SU_HAVE_INLINE
su_inline
#endif
sip_alert_info_t *sip_alert_info_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));

#if SU_HAVE_INLINE
su_inline sip_alert_info_t *sip_alert_info_format(su_home_t *home, char const *fmt, ...)
{
  sip_header_t *h;
  va_list ap;
  
  va_start(ap, fmt);
  h = sip_header_vformat(home, sip_alert_info_class, fmt, ap);
  va_end(ap);
 
  return (sip_alert_info_t *)h;
}
#endif

/** @} */

/**@ingroup sip_alert_info
 *
 * Tag list item for pointer to a @ref sip_alert_info "Alert-Info header"
 * structure #sip_alert_info_t.
 *
 * The SIPTAG_ALERT_INFO() macro is used to include a tag item with a
 * pointer to a #sip_alert_info_t structure in a tag list.
 *
 * @param x pointer to a #sip_alert_info_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_ALERT_INFO_REF().
 *
 * @since New in @NEW_1_12_7.
 *
 * @HIDE
 */
#define SIPTAG_ALERT_INFO(x) siptag_alert_info, siptag_alert_info_v(x)

SOFIAPUBVAR tag_typedef_t siptag_alert_info;

/**@ingroup sip_alert_info
 * Tag list item for reference to a 
 * @ref sip_alert_info "Alert-Info header" pointer.
 */
#define SIPTAG_ALERT_INFO_REF(x) siptag_alert_info_ref, siptag_alert_info_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_alert_info_ref;

/**@ingroup sip_alert_info
 *
 * Tag list item for string with @ref sip_alert_info "Alert-Info header" value.
 *
 * The SIPTAG_ALERT_INFO_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_alert_info_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_alert_info "Alert-Info header" value, or NULL.
 *
 * The string in SIPTAG_ALERT_INFO_STR() can be converted to a
 * #sip_alert_info_t header structure by giving the string @a s has
 * second argument to function sip_alert_info_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_ALERT_INFO_STR_REF().
 *
 * @since New in @NEW_1_12_7.
 *
 * @HIDE
 */
#define SIPTAG_ALERT_INFO_STR(s) siptag_alert_info_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_alert_info_str;

/**@ingroup sip_alert_info
 * Tag list item for reference to a
 * @ref sip_alert_info "Alert-Info header" string.
 */
#define SIPTAG_ALERT_INFO_STR_REF(x) siptag_alert_info_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_alert_info_str_ref;

#if SU_INLINE_TAG_CAST
su_inline tag_value_t
siptag_alert_info_v(sip_alert_info_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_alert_info_vr(sip_alert_info_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_alert_info_v(v)   (tag_value_t)(v)
#define siptag_alert_info_vr(vp) (tag_value_t)(vp)
#endif

/** Defined as 1 if the @ref sip_reply_to "Reply-To header" is supported */
#define SIP_HAVE_REPLY_TO 1


enum { 
  /**@ingroup sip_reply_to @internal 
   *
   * Hash of @ref sip_reply_to "Reply-To header".
   *
   * @since New in @NEW_1_12_7.
   */
  sip_reply_to_hash = 38016 
};

/**Header class for @ref sip_reply_to "Reply-To header".
 * 
 * The header class sip_reply_to_class defines how a SIP
 * @ref sip_reply_to "Reply-To header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_reply_to_t header structure.
 *
 * @ingroup sip_reply_to
 *
 * @since New in @NEW_1_12_7.
 */
SIP_DLL extern msg_hclass_t sip_reply_to_class[];


/**@addtogroup sip_reply_to
 * @{
 */

/** Parse a SIP @ref sip_reply_to "Reply-To header". @internal */
SOFIAPUBFUN issize_t sip_reply_to_d(su_home_t *, msg_header_t *,
				       char *s, isize_t slen);

/** Print a SIP @ref sip_reply_to "Reply-To header". @internal */
SOFIAPUBFUN issize_t sip_reply_to_e(char b[], isize_t bsiz,
                    	            msg_header_t const *h, int flags);

/**Access a SIP @ref sip_reply_to "Reply-To header"
 * structure #sip_reply_to_t from #sip_t.
 * 
 * @since New in @NEW_1_12_7.
 */
#define sip_reply_to(sip) \
  ((sip_reply_to_t *)msg_header_access((msg_pub_t*)(sip), sip_reply_to_class))

/**Initializer for structure #sip_reply_to_t.
 * 
 * A static #sip_reply_to_t structure for
 * @ref sip_reply_to "Reply-To header" must be initialized with
 * the SIP_REPLY_TO_INIT() macro. 
 * For instance,
 * @code 
 * 
 *  sip_reply_to_t sip_reply_to = SIP_REPLY_TO_INIT;
 * 
 * @endcode
 * @HI
 *
 * @since New in @NEW_1_12_7.
 */
#define SIP_REPLY_TO_INIT() SIP_HDR_INIT(reply_to)

/**Initialize a structure #sip_reply_to_t.
 * 
 * An #sip_reply_to_t structure for
 * @ref sip_reply_to "Reply-To header" can be initialized with the
 * sip_reply_to_init() function/macro. For instance,
 * @code
 * 
 *  sip_reply_to_t sip_reply_to;
 * 
 *  sip_reply_to_init(&sip_reply_to);
 * 
 * @endcode
 * @HI
 *
 * @since New in @NEW_1_12_7.
 */
#if SU_HAVE_INLINE
su_inline sip_reply_to_t *sip_reply_to_init(sip_reply_to_t x[1])
{
  return SIP_HEADER_INIT(x, sip_reply_to_class, sizeof(sip_reply_to_t));
}
#else
#define sip_reply_to_init(x) \
  SIP_HEADER_INIT(x, sip_reply_to_class, sizeof(sip_reply_to_t))
#endif

/**Test if header object is instance of #sip_reply_to_t.
 * 
 * Check if the header class is an instance of
 * @ref sip_reply_to "Reply-To header" object and return true (nonzero),
 * otherwise return false (zero).
 * 
 * @param header pointer to the header structure to be tested
 * 
 * @retval 1 (true) if the @a header is an instance of header reply_to 
 * @retval 0 (false) otherwise
 *
 * @since New in @NEW_1_12_7.
 */
#if SU_HAVE_INLINE
su_inline int sip_is_reply_to(sip_header_t const *header)
{
  return header && header->sh_class->hc_hash == sip_reply_to_hash;
}
#else
int sip_is_reply_to(sip_header_t const *header);
#endif

#define sip_reply_to_p(h) sip_is_reply_to((h))


/**Duplicate a list of @ref sip_reply_to "Reply-To header" header structures #sip_reply_to_t.
 * 
 * Duplicate a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 * 
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 * 
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 * 
 * @par Example
 * @code
 * 
 *   reply_to = sip_reply_to_dup(home, sip->sip_reply_to);
 * 
 * @endcode
 * 
 * @return
 * A pointer to the
 * newly duplicated #sip_reply_to_t header structure, or NULL
 * upon an error.
 *
 * @since New in @NEW_1_12_7.
 */
#if SU_HAVE_INLINE
su_inline
#endif
sip_reply_to_t *sip_reply_to_dup(su_home_t *home, sip_reply_to_t const *hdr) 
     __attribute__((__malloc__));

#if SU_HAVE_INLINE
su_inline
sip_reply_to_t *sip_reply_to_dup(su_home_t *home, sip_reply_to_t const *hdr)
{ 
  return (sip_reply_to_t *)
    msg_header_dup_as(home, sip_reply_to_class, (msg_header_t const *)hdr);
}
#endif

/**Copy a list of @ref sip_reply_to "Reply-To header" header structures #sip_reply_to_t.
 * 
 * The function sip_reply_to_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the list of header
 * structure @a hdr.
 * 
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be copied
 * 
 * When copying, only the header structure and parameter lists attached to
 * it are duplicated. The new header structure retains all the references to
 * the strings within the old @a hdr header, including the encoding of the
 * old header, if present.
 * 
 * @par Example
 * @code
 * 
 *   reply_to = sip_reply_to_copy(home, sip->sip_reply_to);
 * 
 * @endcode
 * 
 * @return
 * A pointer to newly copied header structure, or NULL upon an error.
 *
 * @since New in @NEW_1_12_7.
 */
#if SU_HAVE_INLINE
su_inline
#endif
sip_reply_to_t *sip_reply_to_copy(su_home_t *home, sip_reply_to_t const *hdr) 
     __attribute__((__malloc__));

#if SU_HAVE_INLINE
su_inline
sip_reply_to_t *sip_reply_to_copy(su_home_t *home, sip_reply_to_t const *hdr) 
{ 
  return (sip_reply_to_t *)
    msg_header_copy_as(home, sip_reply_to_class, (msg_header_t const *)hdr); 
}
#endif

/**Make a @ref sip_reply_to "Reply-To header" structure #sip_reply_to_t.
 * 
 * The function sip_reply_to_make() makes a new
 * #sip_reply_to_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 * 
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 * 
 * @return
 * A pointer to newly maked #sip_reply_to_t header structure, or NULL upon an
 * error.
 *
 * @since New in @NEW_1_12_7.
 */
#if SU_HAVE_INLINE
su_inline 
#endif
sip_reply_to_t *sip_reply_to_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

#if SU_HAVE_INLINE
su_inline sip_reply_to_t *sip_reply_to_make(su_home_t *home, char const *s)
{
  return (sip_reply_to_t *)sip_header_make(home, sip_reply_to_class, s);
}
#endif

/**Make a @ref sip_reply_to "Reply-To header" from formatting result.
 * 
 * Make a new #sip_reply_to_t object using formatting result as its value. 
 * The function first prints the arguments according to the format @a fmt
 * specified. Then it allocates a new header structure, and parses the
 * formatting result to the structure #sip_reply_to_t.
 * 
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 * 
 * @return
 * A pointer to newly
 * makes header structure, or NULL upon an error.
 * 
 * @HIDE
 *
 * @since New in @NEW_1_12_7.
 */
#if SU_HAVE_INLINE
su_inline
#endif
sip_reply_to_t *sip_reply_to_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));

#if SU_HAVE_INLINE
su_inline sip_reply_to_t *sip_reply_to_format(su_home_t *home, char const *fmt, ...)
{
  sip_header_t *h;
  va_list ap;
  
  va_start(ap, fmt);
  h = sip_header_vformat(home, sip_reply_to_class, fmt, ap);
  va_end(ap);
 
  return (sip_reply_to_t *)h;
}
#endif

/** @} */

/**@ingroup sip_reply_to
 *
 * Tag list item for pointer to a @ref sip_reply_to "Reply-To header"
 * structure #sip_reply_to_t.
 *
 * The SIPTAG_REPLY_TO() macro is used to include a tag item with a
 * pointer to a #sip_reply_to_t structure in a tag list.
 *
 * @param x pointer to a #sip_reply_to_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_REPLY_TO_REF().
 *
 * @since New in @NEW_1_12_7.
 *
 * @HIDE
 */
#define SIPTAG_REPLY_TO(x) siptag_reply_to, siptag_reply_to_v(x)

SOFIAPUBVAR tag_typedef_t siptag_reply_to;

/**@ingroup sip_reply_to
 * Tag list item for reference to a 
 * @ref sip_reply_to "Reply-To header" pointer.
 */
#define SIPTAG_REPLY_TO_REF(x) siptag_reply_to_ref, siptag_reply_to_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_reply_to_ref;

/**@ingroup sip_reply_to
 *
 * Tag list item for string with @ref sip_reply_to "Reply-To header" value.
 *
 * The SIPTAG_REPLY_TO_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_reply_to_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_reply_to "Reply-To header" value, or NULL.
 *
 * The string in SIPTAG_REPLY_TO_STR() can be converted to a
 * #sip_reply_to_t header structure by giving the string @a s has
 * second argument to function sip_reply_to_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_REPLY_TO_STR_REF().
 *
 * @since New in @NEW_1_12_7.
 *
 * @HIDE
 */
#define SIPTAG_REPLY_TO_STR(s) siptag_reply_to_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_reply_to_str;

/**@ingroup sip_reply_to
 * Tag list item for reference to a
 * @ref sip_reply_to "Reply-To header" string.
 */
#define SIPTAG_REPLY_TO_STR_REF(x) siptag_reply_to_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_reply_to_str_ref;

#if SU_INLINE_TAG_CAST
su_inline tag_value_t
siptag_reply_to_v(sip_reply_to_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_reply_to_vr(sip_reply_to_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_reply_to_v(v)   (tag_value_t)(v)
#define siptag_reply_to_vr(vp) (tag_value_t)(vp)
#endif

/** Defined as 1 if the @ref sip_remote_party_id "Remote-Party-ID header" is supported */
#define SIP_HAVE_REMOTE_PARTY_ID 1


enum { 
  /**@ingroup sip_remote_party_id @internal 
   *
   * Hash of @ref sip_remote_party_id "Remote-Party-ID header".
   *
   * @since New in @NEW_1_12_7.
   */
  sip_remote_party_id_hash = 59907 
};

/**Header class for @ref sip_remote_party_id "Remote-Party-ID header".
 * 
 * The header class sip_remote_party_id_class defines how a SIP
 * @ref sip_remote_party_id "Remote-Party-ID header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_remote_party_id_t header structure.
 *
 * @ingroup sip_remote_party_id
 *
 * @since New in @NEW_1_12_7.
 */
SIP_DLL extern msg_hclass_t sip_remote_party_id_class[];


/**@addtogroup sip_remote_party_id
 * @{
 */

/** Parse a SIP @ref sip_remote_party_id "Remote-Party-ID header". @internal */
SOFIAPUBFUN issize_t sip_remote_party_id_d(su_home_t *, msg_header_t *,
				       char *s, isize_t slen);

/** Print a SIP @ref sip_remote_party_id "Remote-Party-ID header". @internal */
SOFIAPUBFUN issize_t sip_remote_party_id_e(char b[], isize_t bsiz,
                    	            msg_header_t const *h, int flags);

/**Access a SIP @ref sip_remote_party_id "Remote-Party-ID header"
 * structure #sip_remote_party_id_t from #sip_t.
 * 
 * @since New in @NEW_1_12_7.
 */
#define sip_remote_party_id(sip) \
  ((sip_remote_party_id_t *)msg_header_access((msg_pub_t*)(sip), sip_remote_party_id_class))

/**Initializer for structure #sip_remote_party_id_t.
 * 
 * A static #sip_remote_party_id_t structure for
 * @ref sip_remote_party_id "Remote-Party-ID header" must be initialized with
 * the SIP_REMOTE_PARTY_ID_INIT() macro. 
 * For instance,
 * @code 
 * 
 *  sip_remote_party_id_t sip_remote_party_id = SIP_REMOTE_PARTY_ID_INIT;
 * 
 * @endcode
 * @HI
 *
 * @since New in @NEW_1_12_7.
 */
#define SIP_REMOTE_PARTY_ID_INIT() SIP_HDR_INIT(remote_party_id)

/**Initialize a structure #sip_remote_party_id_t.
 * 
 * An #sip_remote_party_id_t structure for
 * @ref sip_remote_party_id "Remote-Party-ID header" can be initialized with the
 * sip_remote_party_id_init() function/macro. For instance,
 * @code
 * 
 *  sip_remote_party_id_t sip_remote_party_id;
 * 
 *  sip_remote_party_id_init(&sip_remote_party_id);
 * 
 * @endcode
 * @HI
 *
 * @since New in @NEW_1_12_7.
 */
#if SU_HAVE_INLINE
su_inline sip_remote_party_id_t *sip_remote_party_id_init(sip_remote_party_id_t x[1])
{
  return SIP_HEADER_INIT(x, sip_remote_party_id_class, sizeof(sip_remote_party_id_t));
}
#else
#define sip_remote_party_id_init(x) \
  SIP_HEADER_INIT(x, sip_remote_party_id_class, sizeof(sip_remote_party_id_t))
#endif

/**Test if header object is instance of #sip_remote_party_id_t.
 * 
 * Check if the header class is an instance of
 * @ref sip_remote_party_id "Remote-Party-ID header" object and return true (nonzero),
 * otherwise return false (zero).
 * 
 * @param header pointer to the header structure to be tested
 * 
 * @retval 1 (true) if the @a header is an instance of header remote_party_id 
 * @retval 0 (false) otherwise
 *
 * @since New in @NEW_1_12_7.
 */
#if SU_HAVE_INLINE
su_inline int sip_is_remote_party_id(sip_header_t const *header)
{
  return header && header->sh_class->hc_hash == sip_remote_party_id_hash;
}
#else
int sip_is_remote_party_id(sip_header_t const *header);
#endif

#define sip_remote_party_id_p(h) sip_is_remote_party_id((h))


/**Duplicate a list of @ref sip_remote_party_id "Remote-Party-ID header" header structures #sip_remote_party_id_t.
 * 
 * Duplicate a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 * 
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 * 
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 * 
 * @par Example
 * @code
 * 
 *   remote_party_id = sip_remote_party_id_dup(home, sip->sip_remote_party_id);
 * 
 * @endcode
 * 
 * @return
 * A pointer to the
 * newly duplicated #sip_remote_party_id_t header structure, or NULL
 * upon an error.
 *
 * @since New in @NEW_1_12_7.
 */
#if SU_HAVE_INLINE
su_inline
#endif
sip_remote_party_id_t *sip_remote_party_id_dup(su_home_t *home, sip_remote_party_id_t const *hdr) 
     __attribute__((__malloc__));

#if SU_HAVE_INLINE
su_inline
sip_remote_party_id_t *sip_remote_party_id_dup(su_home_t *home, sip_remote_party_id_t const *hdr)
{ 
  return (sip_remote_party_id_t *)
    msg_header_dup_as(home, sip_remote_party_id_class, (msg_header_t const *)hdr);
}
#endif

/**Copy a list of @ref sip_remote_party_id "Remote-Party-ID header" header structures #sip_remote_party_id_t.
 * 
 * The function sip_remote_party_id_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the list of header
 * structure @a hdr.
 * 
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be copied
 * 
 * When copying, only the header structure and parameter lists attached to
 * it are duplicated. The new header structure retains all the references to
 * the strings within the old @a hdr header, including the encoding of the
 * old header, if present.
 * 
 * @par Example
 * @code
 * 
 *   remote_party_id = sip_remote_party_id_copy(home, sip->sip_remote_party_id);
 * 
 * @endcode
 * 
 * @return
 * A pointer to newly copied header structure, or NULL upon an error.
 *
 * @since New in @NEW_1_12_7.
 */
#if SU_HAVE_INLINE
su_inline
#endif
sip_remote_party_id_t *sip_remote_party_id_copy(su_home_t *home, sip_remote_party_id_t const *hdr) 
     __attribute__((__malloc__));

#if SU_HAVE_INLINE
su_inline
sip_remote_party_id_t *sip_remote_party_id_copy(su_home_t *home, sip_remote_party_id_t const *hdr) 
{ 
  return (sip_remote_party_id_t *)
    msg_header_copy_as(home, sip_remote_party_id_class, (msg_header_t const *)hdr); 
}
#endif

/**Make a @ref sip_remote_party_id "Remote-Party-ID header" structure #sip_remote_party_id_t.
 * 
 * The function sip_remote_party_id_make() makes a new
 * #sip_remote_party_id_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 * 
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 * 
 * @return
 * A pointer to newly maked #sip_remote_party_id_t header structure, or NULL upon an
 * error.
 *
 * @since New in @NEW_1_12_7.
 */
#if SU_HAVE_INLINE
su_inline 
#endif
sip_remote_party_id_t *sip_remote_party_id_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

#if SU_HAVE_INLINE
su_inline sip_remote_party_id_t *sip_remote_party_id_make(su_home_t *home, char const *s)
{
  return (sip_remote_party_id_t *)sip_header_make(home, sip_remote_party_id_class, s);
}
#endif

/**Make a @ref sip_remote_party_id "Remote-Party-ID header" from formatting result.
 * 
 * Make a new #sip_remote_party_id_t object using formatting result as its value. 
 * The function first prints the arguments according to the format @a fmt
 * specified. Then it allocates a new header structure, and parses the
 * formatting result to the structure #sip_remote_party_id_t.
 * 
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 * 
 * @return
 * A pointer to newly
 * makes header structure, or NULL upon an error.
 * 
 * @HIDE
 *
 * @since New in @NEW_1_12_7.
 */
#if SU_HAVE_INLINE
su_inline
#endif
sip_remote_party_id_t *sip_remote_party_id_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));

#if SU_HAVE_INLINE
su_inline sip_remote_party_id_t *sip_remote_party_id_format(su_home_t *home, char const *fmt, ...)
{
  sip_header_t *h;
  va_list ap;
  
  va_start(ap, fmt);
  h = sip_header_vformat(home, sip_remote_party_id_class, fmt, ap);
  va_end(ap);
 
  return (sip_remote_party_id_t *)h;
}
#endif

/** @} */

/**@ingroup sip_remote_party_id
 *
 * Tag list item for pointer to a @ref sip_remote_party_id "Remote-Party-ID header"
 * structure #sip_remote_party_id_t.
 *
 * The SIPTAG_REMOTE_PARTY_ID() macro is used to include a tag item with a
 * pointer to a #sip_remote_party_id_t structure in a tag list.
 *
 * @param x pointer to a #sip_remote_party_id_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_REMOTE_PARTY_ID_REF().
 *
 * @since New in @NEW_1_12_7.
 *
 * @HIDE
 */
#define SIPTAG_REMOTE_PARTY_ID(x) siptag_remote_party_id, siptag_remote_party_id_v(x)

SOFIAPUBVAR tag_typedef_t siptag_remote_party_id;

/**@ingroup sip_remote_party_id
 * Tag list item for reference to a 
 * @ref sip_remote_party_id "Remote-Party-ID header" pointer.
 */
#define SIPTAG_REMOTE_PARTY_ID_REF(x) siptag_remote_party_id_ref, siptag_remote_party_id_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_remote_party_id_ref;

/**@ingroup sip_remote_party_id
 *
 * Tag list item for string with @ref sip_remote_party_id "Remote-Party-ID header" value.
 *
 * The SIPTAG_REMOTE_PARTY_ID_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_remote_party_id_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_remote_party_id "Remote-Party-ID header" value, or NULL.
 *
 * The string in SIPTAG_REMOTE_PARTY_ID_STR() can be converted to a
 * #sip_remote_party_id_t header structure by giving the string @a s has
 * second argument to function sip_remote_party_id_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_REMOTE_PARTY_ID_STR_REF().
 *
 * @since New in @NEW_1_12_7.
 *
 * @HIDE
 */
#define SIPTAG_REMOTE_PARTY_ID_STR(s) siptag_remote_party_id_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_remote_party_id_str;

/**@ingroup sip_remote_party_id
 * Tag list item for reference to a
 * @ref sip_remote_party_id "Remote-Party-ID header" string.
 */
#define SIPTAG_REMOTE_PARTY_ID_STR_REF(x) siptag_remote_party_id_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_remote_party_id_str_ref;

#if SU_INLINE_TAG_CAST
su_inline tag_value_t
siptag_remote_party_id_v(sip_remote_party_id_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_remote_party_id_vr(sip_remote_party_id_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_remote_party_id_v(v)   (tag_value_t)(v)
#define siptag_remote_party_id_vr(vp) (tag_value_t)(vp)
#endif

/** Defined as 1 if the @ref sip_p_asserted_identity "P-Asserted-Identity header" is supported */
#define SIP_HAVE_P_ASSERTED_IDENTITY 1


enum { 
  /**@ingroup sip_p_asserted_identity @internal 
   *
   * Hash of @ref sip_p_asserted_identity "P-Asserted-Identity header".
   *
   * @since New in @NEW_1_12_7.
   */
  sip_p_asserted_identity_hash = 16399 
};

/**Header class for @ref sip_p_asserted_identity "P-Asserted-Identity header".
 * 
 * The header class sip_p_asserted_identity_class defines how a SIP
 * @ref sip_p_asserted_identity "P-Asserted-Identity header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_p_asserted_identity_t header structure.
 *
 * @ingroup sip_p_asserted_identity
 *
 * @since New in @NEW_1_12_7.
 */
SIP_DLL extern msg_hclass_t sip_p_asserted_identity_class[];


/**@addtogroup sip_p_asserted_identity
 * @{
 */

/** Parse a SIP @ref sip_p_asserted_identity "P-Asserted-Identity header". @internal */
SOFIAPUBFUN issize_t sip_p_asserted_identity_d(su_home_t *, msg_header_t *,
				       char *s, isize_t slen);

/** Print a SIP @ref sip_p_asserted_identity "P-Asserted-Identity header". @internal */
SOFIAPUBFUN issize_t sip_p_asserted_identity_e(char b[], isize_t bsiz,
                    	            msg_header_t const *h, int flags);

/**Access a SIP @ref sip_p_asserted_identity "P-Asserted-Identity header"
 * structure #sip_p_asserted_identity_t from #sip_t.
 * 
 * @since New in @NEW_1_12_7.
 */
#define sip_p_asserted_identity(sip) \
  ((sip_p_asserted_identity_t *)msg_header_access((msg_pub_t*)(sip), sip_p_asserted_identity_class))

/**Initializer for structure #sip_p_asserted_identity_t.
 * 
 * A static #sip_p_asserted_identity_t structure for
 * @ref sip_p_asserted_identity "P-Asserted-Identity header" must be initialized with
 * the SIP_P_ASSERTED_IDENTITY_INIT() macro. 
 * For instance,
 * @code 
 * 
 *  sip_p_asserted_identity_t sip_p_asserted_identity = SIP_P_ASSERTED_IDENTITY_INIT;
 * 
 * @endcode
 * @HI
 *
 * @since New in @NEW_1_12_7.
 */
#define SIP_P_ASSERTED_IDENTITY_INIT() SIP_HDR_INIT(p_asserted_identity)

/**Initialize a structure #sip_p_asserted_identity_t.
 * 
 * An #sip_p_asserted_identity_t structure for
 * @ref sip_p_asserted_identity "P-Asserted-Identity header" can be initialized with the
 * sip_p_asserted_identity_init() function/macro. For instance,
 * @code
 * 
 *  sip_p_asserted_identity_t sip_p_asserted_identity;
 * 
 *  sip_p_asserted_identity_init(&sip_p_asserted_identity);
 * 
 * @endcode
 * @HI
 *
 * @since New in @NEW_1_12_7.
 */
#if SU_HAVE_INLINE
su_inline sip_p_asserted_identity_t *sip_p_asserted_identity_init(sip_p_asserted_identity_t x[1])
{
  return SIP_HEADER_INIT(x, sip_p_asserted_identity_class, sizeof(sip_p_asserted_identity_t));
}
#else
#define sip_p_asserted_identity_init(x) \
  SIP_HEADER_INIT(x, sip_p_asserted_identity_class, sizeof(sip_p_asserted_identity_t))
#endif

/**Test if header object is instance of #sip_p_asserted_identity_t.
 * 
 * Check if the header class is an instance of
 * @ref sip_p_asserted_identity "P-Asserted-Identity header" object and return true (nonzero),
 * otherwise return false (zero).
 * 
 * @param header pointer to the header structure to be tested
 * 
 * @retval 1 (true) if the @a header is an instance of header p_asserted_identity 
 * @retval 0 (false) otherwise
 *
 * @since New in @NEW_1_12_7.
 */
#if SU_HAVE_INLINE
su_inline int sip_is_p_asserted_identity(sip_header_t const *header)
{
  return header && header->sh_class->hc_hash == sip_p_asserted_identity_hash;
}
#else
int sip_is_p_asserted_identity(sip_header_t const *header);
#endif

#define sip_p_asserted_identity_p(h) sip_is_p_asserted_identity((h))


/**Duplicate a list of @ref sip_p_asserted_identity "P-Asserted-Identity header" header structures #sip_p_asserted_identity_t.
 * 
 * Duplicate a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 * 
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 * 
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 * 
 * @par Example
 * @code
 * 
 *   p_asserted_identity = sip_p_asserted_identity_dup(home, sip->sip_p_asserted_identity);
 * 
 * @endcode
 * 
 * @return
 * A pointer to the
 * newly duplicated #sip_p_asserted_identity_t header structure, or NULL
 * upon an error.
 *
 * @since New in @NEW_1_12_7.
 */
#if SU_HAVE_INLINE
su_inline
#endif
sip_p_asserted_identity_t *sip_p_asserted_identity_dup(su_home_t *home, sip_p_asserted_identity_t const *hdr) 
     __attribute__((__malloc__));

#if SU_HAVE_INLINE
su_inline
sip_p_asserted_identity_t *sip_p_asserted_identity_dup(su_home_t *home, sip_p_asserted_identity_t const *hdr)
{ 
  return (sip_p_asserted_identity_t *)
    msg_header_dup_as(home, sip_p_asserted_identity_class, (msg_header_t const *)hdr);
}
#endif

/**Copy a list of @ref sip_p_asserted_identity "P-Asserted-Identity header" header structures #sip_p_asserted_identity_t.
 * 
 * The function sip_p_asserted_identity_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the list of header
 * structure @a hdr.
 * 
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be copied
 * 
 * When copying, only the header structure and parameter lists attached to
 * it are duplicated. The new header structure retains all the references to
 * the strings within the old @a hdr header, including the encoding of the
 * old header, if present.
 * 
 * @par Example
 * @code
 * 
 *   p_asserted_identity = sip_p_asserted_identity_copy(home, sip->sip_p_asserted_identity);
 * 
 * @endcode
 * 
 * @return
 * A pointer to newly copied header structure, or NULL upon an error.
 *
 * @since New in @NEW_1_12_7.
 */
#if SU_HAVE_INLINE
su_inline
#endif
sip_p_asserted_identity_t *sip_p_asserted_identity_copy(su_home_t *home, sip_p_asserted_identity_t const *hdr) 
     __attribute__((__malloc__));

#if SU_HAVE_INLINE
su_inline
sip_p_asserted_identity_t *sip_p_asserted_identity_copy(su_home_t *home, sip_p_asserted_identity_t const *hdr) 
{ 
  return (sip_p_asserted_identity_t *)
    msg_header_copy_as(home, sip_p_asserted_identity_class, (msg_header_t const *)hdr); 
}
#endif

/**Make a @ref sip_p_asserted_identity "P-Asserted-Identity header" structure #sip_p_asserted_identity_t.
 * 
 * The function sip_p_asserted_identity_make() makes a new
 * #sip_p_asserted_identity_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 * 
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 * 
 * @return
 * A pointer to newly maked #sip_p_asserted_identity_t header structure, or NULL upon an
 * error.
 *
 * @since New in @NEW_1_12_7.
 */
#if SU_HAVE_INLINE
su_inline 
#endif
sip_p_asserted_identity_t *sip_p_asserted_identity_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

#if SU_HAVE_INLINE
su_inline sip_p_asserted_identity_t *sip_p_asserted_identity_make(su_home_t *home, char const *s)
{
  return (sip_p_asserted_identity_t *)sip_header_make(home, sip_p_asserted_identity_class, s);
}
#endif

/**Make a @ref sip_p_asserted_identity "P-Asserted-Identity header" from formatting result.
 * 
 * Make a new #sip_p_asserted_identity_t object using formatting result as its value. 
 * The function first prints the arguments according to the format @a fmt
 * specified. Then it allocates a new header structure, and parses the
 * formatting result to the structure #sip_p_asserted_identity_t.
 * 
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 * 
 * @return
 * A pointer to newly
 * makes header structure, or NULL upon an error.
 * 
 * @HIDE
 *
 * @since New in @NEW_1_12_7.
 */
#if SU_HAVE_INLINE
su_inline
#endif
sip_p_asserted_identity_t *sip_p_asserted_identity_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));

#if SU_HAVE_INLINE
su_inline sip_p_asserted_identity_t *sip_p_asserted_identity_format(su_home_t *home, char const *fmt, ...)
{
  sip_header_t *h;
  va_list ap;
  
  va_start(ap, fmt);
  h = sip_header_vformat(home, sip_p_asserted_identity_class, fmt, ap);
  va_end(ap);
 
  return (sip_p_asserted_identity_t *)h;
}
#endif

/** @} */

/**@ingroup sip_p_asserted_identity
 *
 * Tag list item for pointer to a @ref sip_p_asserted_identity "P-Asserted-Identity header"
 * structure #sip_p_asserted_identity_t.
 *
 * The SIPTAG_P_ASSERTED_IDENTITY() macro is used to include a tag item with a
 * pointer to a #sip_p_asserted_identity_t structure in a tag list.
 *
 * @param x pointer to a #sip_p_asserted_identity_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_P_ASSERTED_IDENTITY_REF().
 *
 * @since New in @NEW_1_12_7.
 *
 * @HIDE
 */
#define SIPTAG_P_ASSERTED_IDENTITY(x) siptag_p_asserted_identity, siptag_p_asserted_identity_v(x)

SOFIAPUBVAR tag_typedef_t siptag_p_asserted_identity;

/**@ingroup sip_p_asserted_identity
 * Tag list item for reference to a 
 * @ref sip_p_asserted_identity "P-Asserted-Identity header" pointer.
 */
#define SIPTAG_P_ASSERTED_IDENTITY_REF(x) siptag_p_asserted_identity_ref, siptag_p_asserted_identity_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_p_asserted_identity_ref;

/**@ingroup sip_p_asserted_identity
 *
 * Tag list item for string with @ref sip_p_asserted_identity "P-Asserted-Identity header" value.
 *
 * The SIPTAG_P_ASSERTED_IDENTITY_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_p_asserted_identity_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_p_asserted_identity "P-Asserted-Identity header" value, or NULL.
 *
 * The string in SIPTAG_P_ASSERTED_IDENTITY_STR() can be converted to a
 * #sip_p_asserted_identity_t header structure by giving the string @a s has
 * second argument to function sip_p_asserted_identity_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_P_ASSERTED_IDENTITY_STR_REF().
 *
 * @since New in @NEW_1_12_7.
 *
 * @HIDE
 */
#define SIPTAG_P_ASSERTED_IDENTITY_STR(s) siptag_p_asserted_identity_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_p_asserted_identity_str;

/**@ingroup sip_p_asserted_identity
 * Tag list item for reference to a
 * @ref sip_p_asserted_identity "P-Asserted-Identity header" string.
 */
#define SIPTAG_P_ASSERTED_IDENTITY_STR_REF(x) siptag_p_asserted_identity_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_p_asserted_identity_str_ref;

#if SU_INLINE_TAG_CAST
su_inline tag_value_t
siptag_p_asserted_identity_v(sip_p_asserted_identity_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_p_asserted_identity_vr(sip_p_asserted_identity_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_p_asserted_identity_v(v)   (tag_value_t)(v)
#define siptag_p_asserted_identity_vr(vp) (tag_value_t)(vp)
#endif

/** Defined as 1 if the @ref sip_p_preferred_identity "P-Preferred-Identity header" is supported */
#define SIP_HAVE_P_PREFERRED_IDENTITY 1


enum { 
  /**@ingroup sip_p_preferred_identity @internal 
   *
   * Hash of @ref sip_p_preferred_identity "P-Preferred-Identity header".
   *
   * @since New in @NEW_1_12_7.
   */
  sip_p_preferred_identity_hash = 44591 
};

/**Header class for @ref sip_p_preferred_identity "P-Preferred-Identity header".
 * 
 * The header class sip_p_preferred_identity_class defines how a SIP
 * @ref sip_p_preferred_identity "P-Preferred-Identity header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_p_preferred_identity_t header structure.
 *
 * @ingroup sip_p_preferred_identity
 *
 * @since New in @NEW_1_12_7.
 */
SIP_DLL extern msg_hclass_t sip_p_preferred_identity_class[];


/**@addtogroup sip_p_preferred_identity
 * @{
 */

/** Parse a SIP @ref sip_p_preferred_identity "P-Preferred-Identity header". @internal */
SOFIAPUBFUN issize_t sip_p_preferred_identity_d(su_home_t *, msg_header_t *,
				       char *s, isize_t slen);

/** Print a SIP @ref sip_p_preferred_identity "P-Preferred-Identity header". @internal */
SOFIAPUBFUN issize_t sip_p_preferred_identity_e(char b[], isize_t bsiz,
                    	            msg_header_t const *h, int flags);

/**Access a SIP @ref sip_p_preferred_identity "P-Preferred-Identity header"
 * structure #sip_p_preferred_identity_t from #sip_t.
 * 
 * @since New in @NEW_1_12_7.
 */
#define sip_p_preferred_identity(sip) \
  ((sip_p_preferred_identity_t *)msg_header_access((msg_pub_t*)(sip), sip_p_preferred_identity_class))

/**Initializer for structure #sip_p_preferred_identity_t.
 * 
 * A static #sip_p_preferred_identity_t structure for
 * @ref sip_p_preferred_identity "P-Preferred-Identity header" must be initialized with
 * the SIP_P_PREFERRED_IDENTITY_INIT() macro. 
 * For instance,
 * @code 
 * 
 *  sip_p_preferred_identity_t sip_p_preferred_identity = SIP_P_PREFERRED_IDENTITY_INIT;
 * 
 * @endcode
 * @HI
 *
 * @since New in @NEW_1_12_7.
 */
#define SIP_P_PREFERRED_IDENTITY_INIT() SIP_HDR_INIT(p_preferred_identity)

/**Initialize a structure #sip_p_preferred_identity_t.
 * 
 * An #sip_p_preferred_identity_t structure for
 * @ref sip_p_preferred_identity "P-Preferred-Identity header" can be initialized with the
 * sip_p_preferred_identity_init() function/macro. For instance,
 * @code
 * 
 *  sip_p_preferred_identity_t sip_p_preferred_identity;
 * 
 *  sip_p_preferred_identity_init(&sip_p_preferred_identity);
 * 
 * @endcode
 * @HI
 *
 * @since New in @NEW_1_12_7.
 */
#if SU_HAVE_INLINE
su_inline sip_p_preferred_identity_t *sip_p_preferred_identity_init(sip_p_preferred_identity_t x[1])
{
  return SIP_HEADER_INIT(x, sip_p_preferred_identity_class, sizeof(sip_p_preferred_identity_t));
}
#else
#define sip_p_preferred_identity_init(x) \
  SIP_HEADER_INIT(x, sip_p_preferred_identity_class, sizeof(sip_p_preferred_identity_t))
#endif

/**Test if header object is instance of #sip_p_preferred_identity_t.
 * 
 * Check if the header class is an instance of
 * @ref sip_p_preferred_identity "P-Preferred-Identity header" object and return true (nonzero),
 * otherwise return false (zero).
 * 
 * @param header pointer to the header structure to be tested
 * 
 * @retval 1 (true) if the @a header is an instance of header p_preferred_identity 
 * @retval 0 (false) otherwise
 *
 * @since New in @NEW_1_12_7.
 */
#if SU_HAVE_INLINE
su_inline int sip_is_p_preferred_identity(sip_header_t const *header)
{
  return header && header->sh_class->hc_hash == sip_p_preferred_identity_hash;
}
#else
int sip_is_p_preferred_identity(sip_header_t const *header);
#endif

#define sip_p_preferred_identity_p(h) sip_is_p_preferred_identity((h))


/**Duplicate a list of @ref sip_p_preferred_identity "P-Preferred-Identity header" header structures #sip_p_preferred_identity_t.
 * 
 * Duplicate a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 * 
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 * 
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 * 
 * @par Example
 * @code
 * 
 *   p_preferred_identity = sip_p_preferred_identity_dup(home, sip->sip_p_preferred_identity);
 * 
 * @endcode
 * 
 * @return
 * A pointer to the
 * newly duplicated #sip_p_preferred_identity_t header structure, or NULL
 * upon an error.
 *
 * @since New in @NEW_1_12_7.
 */
#if SU_HAVE_INLINE
su_inline
#endif
sip_p_preferred_identity_t *sip_p_preferred_identity_dup(su_home_t *home, sip_p_preferred_identity_t const *hdr) 
     __attribute__((__malloc__));

#if SU_HAVE_INLINE
su_inline
sip_p_preferred_identity_t *sip_p_preferred_identity_dup(su_home_t *home, sip_p_preferred_identity_t const *hdr)
{ 
  return (sip_p_preferred_identity_t *)
    msg_header_dup_as(home, sip_p_preferred_identity_class, (msg_header_t const *)hdr);
}
#endif

/**Copy a list of @ref sip_p_preferred_identity "P-Preferred-Identity header" header structures #sip_p_preferred_identity_t.
 * 
 * The function sip_p_preferred_identity_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the list of header
 * structure @a hdr.
 * 
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be copied
 * 
 * When copying, only the header structure and parameter lists attached to
 * it are duplicated. The new header structure retains all the references to
 * the strings within the old @a hdr header, including the encoding of the
 * old header, if present.
 * 
 * @par Example
 * @code
 * 
 *   p_preferred_identity = sip_p_preferred_identity_copy(home, sip->sip_p_preferred_identity);
 * 
 * @endcode
 * 
 * @return
 * A pointer to newly copied header structure, or NULL upon an error.
 *
 * @since New in @NEW_1_12_7.
 */
#if SU_HAVE_INLINE
su_inline
#endif
sip_p_preferred_identity_t *sip_p_preferred_identity_copy(su_home_t *home, sip_p_preferred_identity_t const *hdr) 
     __attribute__((__malloc__));

#if SU_HAVE_INLINE
su_inline
sip_p_preferred_identity_t *sip_p_preferred_identity_copy(su_home_t *home, sip_p_preferred_identity_t const *hdr) 
{ 
  return (sip_p_preferred_identity_t *)
    msg_header_copy_as(home, sip_p_preferred_identity_class, (msg_header_t const *)hdr); 
}
#endif

/**Make a @ref sip_p_preferred_identity "P-Preferred-Identity header" structure #sip_p_preferred_identity_t.
 * 
 * The function sip_p_preferred_identity_make() makes a new
 * #sip_p_preferred_identity_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 * 
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 * 
 * @return
 * A pointer to newly maked #sip_p_preferred_identity_t header structure, or NULL upon an
 * error.
 *
 * @since New in @NEW_1_12_7.
 */
#if SU_HAVE_INLINE
su_inline 
#endif
sip_p_preferred_identity_t *sip_p_preferred_identity_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

#if SU_HAVE_INLINE
su_inline sip_p_preferred_identity_t *sip_p_preferred_identity_make(su_home_t *home, char const *s)
{
  return (sip_p_preferred_identity_t *)sip_header_make(home, sip_p_preferred_identity_class, s);
}
#endif

/**Make a @ref sip_p_preferred_identity "P-Preferred-Identity header" from formatting result.
 * 
 * Make a new #sip_p_preferred_identity_t object using formatting result as its value. 
 * The function first prints the arguments according to the format @a fmt
 * specified. Then it allocates a new header structure, and parses the
 * formatting result to the structure #sip_p_preferred_identity_t.
 * 
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 * 
 * @return
 * A pointer to newly
 * makes header structure, or NULL upon an error.
 * 
 * @HIDE
 *
 * @since New in @NEW_1_12_7.
 */
#if SU_HAVE_INLINE
su_inline
#endif
sip_p_preferred_identity_t *sip_p_preferred_identity_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));

#if SU_HAVE_INLINE
su_inline sip_p_preferred_identity_t *sip_p_preferred_identity_format(su_home_t *home, char const *fmt, ...)
{
  sip_header_t *h;
  va_list ap;
  
  va_start(ap, fmt);
  h = sip_header_vformat(home, sip_p_preferred_identity_class, fmt, ap);
  va_end(ap);
 
  return (sip_p_preferred_identity_t *)h;
}
#endif

/** @} */

/**@ingroup sip_p_preferred_identity
 *
 * Tag list item for pointer to a @ref sip_p_preferred_identity "P-Preferred-Identity header"
 * structure #sip_p_preferred_identity_t.
 *
 * The SIPTAG_P_PREFERRED_IDENTITY() macro is used to include a tag item with a
 * pointer to a #sip_p_preferred_identity_t structure in a tag list.
 *
 * @param x pointer to a #sip_p_preferred_identity_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_P_PREFERRED_IDENTITY_REF().
 *
 * @since New in @NEW_1_12_7.
 *
 * @HIDE
 */
#define SIPTAG_P_PREFERRED_IDENTITY(x) siptag_p_preferred_identity, siptag_p_preferred_identity_v(x)

SOFIAPUBVAR tag_typedef_t siptag_p_preferred_identity;

/**@ingroup sip_p_preferred_identity
 * Tag list item for reference to a 
 * @ref sip_p_preferred_identity "P-Preferred-Identity header" pointer.
 */
#define SIPTAG_P_PREFERRED_IDENTITY_REF(x) siptag_p_preferred_identity_ref, siptag_p_preferred_identity_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_p_preferred_identity_ref;

/**@ingroup sip_p_preferred_identity
 *
 * Tag list item for string with @ref sip_p_preferred_identity "P-Preferred-Identity header" value.
 *
 * The SIPTAG_P_PREFERRED_IDENTITY_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_p_preferred_identity_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_p_preferred_identity "P-Preferred-Identity header" value, or NULL.
 *
 * The string in SIPTAG_P_PREFERRED_IDENTITY_STR() can be converted to a
 * #sip_p_preferred_identity_t header structure by giving the string @a s has
 * second argument to function sip_p_preferred_identity_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_P_PREFERRED_IDENTITY_STR_REF().
 *
 * @since New in @NEW_1_12_7.
 *
 * @HIDE
 */
#define SIPTAG_P_PREFERRED_IDENTITY_STR(s) siptag_p_preferred_identity_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_p_preferred_identity_str;

/**@ingroup sip_p_preferred_identity
 * Tag list item for reference to a
 * @ref sip_p_preferred_identity "P-Preferred-Identity header" string.
 */
#define SIPTAG_P_PREFERRED_IDENTITY_STR_REF(x) siptag_p_preferred_identity_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_p_preferred_identity_str_ref;

#if SU_INLINE_TAG_CAST
su_inline tag_value_t
siptag_p_preferred_identity_v(sip_p_preferred_identity_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_p_preferred_identity_vr(sip_p_preferred_identity_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_p_preferred_identity_v(v)   (tag_value_t)(v)
#define siptag_p_preferred_identity_vr(vp) (tag_value_t)(vp)
#endif

#if SU_HAVE_EXPERIMENTAL
/** Defined as 1 if the @ref sip_suppress_body_if_match "Suppress-Body-If-Match header" is supported */
#define SIP_HAVE_SUPPRESS_BODY_IF_MATCH 1


enum { 
  /**@ingroup sip_suppress_body_if_match @internal 
   *
   * Hash of @ref sip_suppress_body_if_match "Suppress-Body-If-Match header".
   *
   * @since New in @EXP_1_12_5.
   */
  sip_suppress_body_if_match_hash = 49874 
};

/**Header class for @ref sip_suppress_body_if_match "Suppress-Body-If-Match header".
 * 
 * The header class sip_suppress_body_if_match_class defines how a SIP
 * @ref sip_suppress_body_if_match "Suppress-Body-If-Match header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_suppress_body_if_match_t header structure.
 *
 * @ingroup sip_suppress_body_if_match
 *
 * @since New in @EXP_1_12_5.
 */
SIP_DLL extern msg_hclass_t sip_suppress_body_if_match_class[];


/**@addtogroup sip_suppress_body_if_match
 * @{
 */

/** Parse a SIP @ref sip_suppress_body_if_match "Suppress-Body-If-Match header". @internal */
SOFIAPUBFUN issize_t sip_suppress_body_if_match_d(su_home_t *, msg_header_t *,
				       char *s, isize_t slen);

/** Print a SIP @ref sip_suppress_body_if_match "Suppress-Body-If-Match header". @internal */
SOFIAPUBFUN issize_t sip_suppress_body_if_match_e(char b[], isize_t bsiz,
                    	            msg_header_t const *h, int flags);

/**Access a SIP @ref sip_suppress_body_if_match "Suppress-Body-If-Match header"
 * structure #sip_suppress_body_if_match_t from #sip_t.
 * 
 * @since New in @EXP_1_12_5.
 */
#define sip_suppress_body_if_match(sip) \
  ((sip_suppress_body_if_match_t *)msg_header_access((msg_pub_t*)(sip), sip_suppress_body_if_match_class))

/**Initializer for structure #sip_suppress_body_if_match_t.
 * 
 * A static #sip_suppress_body_if_match_t structure for
 * @ref sip_suppress_body_if_match "Suppress-Body-If-Match header" must be initialized with
 * the SIP_SUPPRESS_BODY_IF_MATCH_INIT() macro. 
 * For instance,
 * @code 
 * 
 *  sip_suppress_body_if_match_t sip_suppress_body_if_match = SIP_SUPPRESS_BODY_IF_MATCH_INIT;
 * 
 * @endcode
 * @HI
 *
 * @since New in @EXP_1_12_5.
 */
#define SIP_SUPPRESS_BODY_IF_MATCH_INIT() SIP_HDR_INIT(suppress_body_if_match)

/**Initialize a structure #sip_suppress_body_if_match_t.
 * 
 * An #sip_suppress_body_if_match_t structure for
 * @ref sip_suppress_body_if_match "Suppress-Body-If-Match header" can be initialized with the
 * sip_suppress_body_if_match_init() function/macro. For instance,
 * @code
 * 
 *  sip_suppress_body_if_match_t sip_suppress_body_if_match;
 * 
 *  sip_suppress_body_if_match_init(&sip_suppress_body_if_match);
 * 
 * @endcode
 * @HI
 *
 * @since New in @EXP_1_12_5.
 */
#if SU_HAVE_INLINE
su_inline sip_suppress_body_if_match_t *sip_suppress_body_if_match_init(sip_suppress_body_if_match_t x[1])
{
  return SIP_HEADER_INIT(x, sip_suppress_body_if_match_class, sizeof(sip_suppress_body_if_match_t));
}
#else
#define sip_suppress_body_if_match_init(x) \
  SIP_HEADER_INIT(x, sip_suppress_body_if_match_class, sizeof(sip_suppress_body_if_match_t))
#endif

/**Test if header object is instance of #sip_suppress_body_if_match_t.
 * 
 * Check if the header class is an instance of
 * @ref sip_suppress_body_if_match "Suppress-Body-If-Match header" object and return true (nonzero),
 * otherwise return false (zero).
 * 
 * @param header pointer to the header structure to be tested
 * 
 * @retval 1 (true) if the @a header is an instance of header suppress_body_if_match 
 * @retval 0 (false) otherwise
 *
 * @since New in @EXP_1_12_5.
 */
#if SU_HAVE_INLINE
su_inline int sip_is_suppress_body_if_match(sip_header_t const *header)
{
  return header && header->sh_class->hc_hash == sip_suppress_body_if_match_hash;
}
#else
int sip_is_suppress_body_if_match(sip_header_t const *header);
#endif

#define sip_suppress_body_if_match_p(h) sip_is_suppress_body_if_match((h))


/**Duplicate a list of @ref sip_suppress_body_if_match "Suppress-Body-If-Match header" header structures #sip_suppress_body_if_match_t.
 * 
 * Duplicate a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 * 
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 * 
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 * 
 * @par Example
 * @code
 * 
 *   suppress_body_if_match = sip_suppress_body_if_match_dup(home, sip->sip_suppress_body_if_match);
 * 
 * @endcode
 * 
 * @return
 * A pointer to the
 * newly duplicated #sip_suppress_body_if_match_t header structure, or NULL
 * upon an error.
 *
 * @since New in @EXP_1_12_5.
 */
#if SU_HAVE_INLINE
su_inline
#endif
sip_suppress_body_if_match_t *sip_suppress_body_if_match_dup(su_home_t *home, sip_suppress_body_if_match_t const *hdr) 
     __attribute__((__malloc__));

#if SU_HAVE_INLINE
su_inline
sip_suppress_body_if_match_t *sip_suppress_body_if_match_dup(su_home_t *home, sip_suppress_body_if_match_t const *hdr)
{ 
  return (sip_suppress_body_if_match_t *)
    msg_header_dup_as(home, sip_suppress_body_if_match_class, (msg_header_t const *)hdr);
}
#endif

/**Copy a list of @ref sip_suppress_body_if_match "Suppress-Body-If-Match header" header structures #sip_suppress_body_if_match_t.
 * 
 * The function sip_suppress_body_if_match_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the list of header
 * structure @a hdr.
 * 
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be copied
 * 
 * When copying, only the header structure and parameter lists attached to
 * it are duplicated. The new header structure retains all the references to
 * the strings within the old @a hdr header, including the encoding of the
 * old header, if present.
 * 
 * @par Example
 * @code
 * 
 *   suppress_body_if_match = sip_suppress_body_if_match_copy(home, sip->sip_suppress_body_if_match);
 * 
 * @endcode
 * 
 * @return
 * A pointer to newly copied header structure, or NULL upon an error.
 *
 * @since New in @EXP_1_12_5.
 */
#if SU_HAVE_INLINE
su_inline
#endif
sip_suppress_body_if_match_t *sip_suppress_body_if_match_copy(su_home_t *home, sip_suppress_body_if_match_t const *hdr) 
     __attribute__((__malloc__));

#if SU_HAVE_INLINE
su_inline
sip_suppress_body_if_match_t *sip_suppress_body_if_match_copy(su_home_t *home, sip_suppress_body_if_match_t const *hdr) 
{ 
  return (sip_suppress_body_if_match_t *)
    msg_header_copy_as(home, sip_suppress_body_if_match_class, (msg_header_t const *)hdr); 
}
#endif

/**Make a @ref sip_suppress_body_if_match "Suppress-Body-If-Match header" structure #sip_suppress_body_if_match_t.
 * 
 * The function sip_suppress_body_if_match_make() makes a new
 * #sip_suppress_body_if_match_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 * 
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 * 
 * @return
 * A pointer to newly maked #sip_suppress_body_if_match_t header structure, or NULL upon an
 * error.
 *
 * @since New in @EXP_1_12_5.
 */
#if SU_HAVE_INLINE
su_inline 
#endif
sip_suppress_body_if_match_t *sip_suppress_body_if_match_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

#if SU_HAVE_INLINE
su_inline sip_suppress_body_if_match_t *sip_suppress_body_if_match_make(su_home_t *home, char const *s)
{
  return (sip_suppress_body_if_match_t *)sip_header_make(home, sip_suppress_body_if_match_class, s);
}
#endif

/**Make a @ref sip_suppress_body_if_match "Suppress-Body-If-Match header" from formatting result.
 * 
 * Make a new #sip_suppress_body_if_match_t object using formatting result as its value. 
 * The function first prints the arguments according to the format @a fmt
 * specified. Then it allocates a new header structure, and parses the
 * formatting result to the structure #sip_suppress_body_if_match_t.
 * 
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 * 
 * @return
 * A pointer to newly
 * makes header structure, or NULL upon an error.
 * 
 * @HIDE
 *
 * @since New in @EXP_1_12_5.
 */
#if SU_HAVE_INLINE
su_inline
#endif
sip_suppress_body_if_match_t *sip_suppress_body_if_match_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));

#if SU_HAVE_INLINE
su_inline sip_suppress_body_if_match_t *sip_suppress_body_if_match_format(su_home_t *home, char const *fmt, ...)
{
  sip_header_t *h;
  va_list ap;
  
  va_start(ap, fmt);
  h = sip_header_vformat(home, sip_suppress_body_if_match_class, fmt, ap);
  va_end(ap);
 
  return (sip_suppress_body_if_match_t *)h;
}
#endif

/** @} */

/**@ingroup sip_suppress_body_if_match
 *
 * Tag list item for pointer to a @ref sip_suppress_body_if_match "Suppress-Body-If-Match header"
 * structure #sip_suppress_body_if_match_t.
 *
 * The SIPTAG_SUPPRESS_BODY_IF_MATCH() macro is used to include a tag item with a
 * pointer to a #sip_suppress_body_if_match_t structure in a tag list.
 *
 * @param x pointer to a #sip_suppress_body_if_match_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_SUPPRESS_BODY_IF_MATCH_REF().
 *
 * @since New in @EXP_1_12_5.
 *
 * @HIDE
 */
#define SIPTAG_SUPPRESS_BODY_IF_MATCH(x) siptag_suppress_body_if_match, siptag_suppress_body_if_match_v(x)

SOFIAPUBVAR tag_typedef_t siptag_suppress_body_if_match;

/**@ingroup sip_suppress_body_if_match
 * Tag list item for reference to a 
 * @ref sip_suppress_body_if_match "Suppress-Body-If-Match header" pointer.
 */
#define SIPTAG_SUPPRESS_BODY_IF_MATCH_REF(x) siptag_suppress_body_if_match_ref, siptag_suppress_body_if_match_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_suppress_body_if_match_ref;

/**@ingroup sip_suppress_body_if_match
 *
 * Tag list item for string with @ref sip_suppress_body_if_match "Suppress-Body-If-Match header" value.
 *
 * The SIPTAG_SUPPRESS_BODY_IF_MATCH_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_suppress_body_if_match_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_suppress_body_if_match "Suppress-Body-If-Match header" value, or NULL.
 *
 * The string in SIPTAG_SUPPRESS_BODY_IF_MATCH_STR() can be converted to a
 * #sip_suppress_body_if_match_t header structure by giving the string @a s has
 * second argument to function sip_suppress_body_if_match_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_SUPPRESS_BODY_IF_MATCH_STR_REF().
 *
 * @since New in @EXP_1_12_5.
 *
 * @HIDE
 */
#define SIPTAG_SUPPRESS_BODY_IF_MATCH_STR(s) siptag_suppress_body_if_match_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_suppress_body_if_match_str;

/**@ingroup sip_suppress_body_if_match
 * Tag list item for reference to a
 * @ref sip_suppress_body_if_match "Suppress-Body-If-Match header" string.
 */
#define SIPTAG_SUPPRESS_BODY_IF_MATCH_STR_REF(x) siptag_suppress_body_if_match_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_suppress_body_if_match_str_ref;

#if SU_INLINE_TAG_CAST
su_inline tag_value_t
siptag_suppress_body_if_match_v(sip_suppress_body_if_match_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_suppress_body_if_match_vr(sip_suppress_body_if_match_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_suppress_body_if_match_v(v)   (tag_value_t)(v)
#define siptag_suppress_body_if_match_vr(vp) (tag_value_t)(vp)
#endif

#endif /* SU_HAVE_EXPERIMENTAL */
#if SU_HAVE_EXPERIMENTAL
/** Defined as 1 if the @ref sip_suppress_notify_if_match "Suppress-Notify-If-Match header" is supported */
#define SIP_HAVE_SUPPRESS_NOTIFY_IF_MATCH 1


enum { 
  /**@ingroup sip_suppress_notify_if_match @internal 
   *
   * Hash of @ref sip_suppress_notify_if_match "Suppress-Notify-If-Match header".
   *
   * @since New in @EXP_1_12_5.
   */
  sip_suppress_notify_if_match_hash = 51341 
};

/**Header class for @ref sip_suppress_notify_if_match "Suppress-Notify-If-Match header".
 * 
 * The header class sip_suppress_notify_if_match_class defines how a SIP
 * @ref sip_suppress_notify_if_match "Suppress-Notify-If-Match header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_suppress_notify_if_match_t header structure.
 *
 * @ingroup sip_suppress_notify_if_match
 *
 * @since New in @EXP_1_12_5.
 */
SIP_DLL extern msg_hclass_t sip_suppress_notify_if_match_class[];


/**@addtogroup sip_suppress_notify_if_match
 * @{
 */

/** Parse a SIP @ref sip_suppress_notify_if_match "Suppress-Notify-If-Match header". @internal */
SOFIAPUBFUN issize_t sip_suppress_notify_if_match_d(su_home_t *, msg_header_t *,
				       char *s, isize_t slen);

/** Print a SIP @ref sip_suppress_notify_if_match "Suppress-Notify-If-Match header". @internal */
SOFIAPUBFUN issize_t sip_suppress_notify_if_match_e(char b[], isize_t bsiz,
                    	            msg_header_t const *h, int flags);

/**Access a SIP @ref sip_suppress_notify_if_match "Suppress-Notify-If-Match header"
 * structure #sip_suppress_notify_if_match_t from #sip_t.
 * 
 * @since New in @EXP_1_12_5.
 */
#define sip_suppress_notify_if_match(sip) \
  ((sip_suppress_notify_if_match_t *)msg_header_access((msg_pub_t*)(sip), sip_suppress_notify_if_match_class))

/**Initializer for structure #sip_suppress_notify_if_match_t.
 * 
 * A static #sip_suppress_notify_if_match_t structure for
 * @ref sip_suppress_notify_if_match "Suppress-Notify-If-Match header" must be initialized with
 * the SIP_SUPPRESS_NOTIFY_IF_MATCH_INIT() macro. 
 * For instance,
 * @code 
 * 
 *  sip_suppress_notify_if_match_t sip_suppress_notify_if_match = SIP_SUPPRESS_NOTIFY_IF_MATCH_INIT;
 * 
 * @endcode
 * @HI
 *
 * @since New in @EXP_1_12_5.
 */
#define SIP_SUPPRESS_NOTIFY_IF_MATCH_INIT() SIP_HDR_INIT(suppress_notify_if_match)

/**Initialize a structure #sip_suppress_notify_if_match_t.
 * 
 * An #sip_suppress_notify_if_match_t structure for
 * @ref sip_suppress_notify_if_match "Suppress-Notify-If-Match header" can be initialized with the
 * sip_suppress_notify_if_match_init() function/macro. For instance,
 * @code
 * 
 *  sip_suppress_notify_if_match_t sip_suppress_notify_if_match;
 * 
 *  sip_suppress_notify_if_match_init(&sip_suppress_notify_if_match);
 * 
 * @endcode
 * @HI
 *
 * @since New in @EXP_1_12_5.
 */
#if SU_HAVE_INLINE
su_inline sip_suppress_notify_if_match_t *sip_suppress_notify_if_match_init(sip_suppress_notify_if_match_t x[1])
{
  return SIP_HEADER_INIT(x, sip_suppress_notify_if_match_class, sizeof(sip_suppress_notify_if_match_t));
}
#else
#define sip_suppress_notify_if_match_init(x) \
  SIP_HEADER_INIT(x, sip_suppress_notify_if_match_class, sizeof(sip_suppress_notify_if_match_t))
#endif

/**Test if header object is instance of #sip_suppress_notify_if_match_t.
 * 
 * Check if the header class is an instance of
 * @ref sip_suppress_notify_if_match "Suppress-Notify-If-Match header" object and return true (nonzero),
 * otherwise return false (zero).
 * 
 * @param header pointer to the header structure to be tested
 * 
 * @retval 1 (true) if the @a header is an instance of header suppress_notify_if_match 
 * @retval 0 (false) otherwise
 *
 * @since New in @EXP_1_12_5.
 */
#if SU_HAVE_INLINE
su_inline int sip_is_suppress_notify_if_match(sip_header_t const *header)
{
  return header && header->sh_class->hc_hash == sip_suppress_notify_if_match_hash;
}
#else
int sip_is_suppress_notify_if_match(sip_header_t const *header);
#endif

#define sip_suppress_notify_if_match_p(h) sip_is_suppress_notify_if_match((h))


/**Duplicate a list of @ref sip_suppress_notify_if_match "Suppress-Notify-If-Match header" header structures #sip_suppress_notify_if_match_t.
 * 
 * Duplicate a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 * 
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 * 
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 * 
 * @par Example
 * @code
 * 
 *   suppress_notify_if_match = sip_suppress_notify_if_match_dup(home, sip->sip_suppress_notify_if_match);
 * 
 * @endcode
 * 
 * @return
 * A pointer to the
 * newly duplicated #sip_suppress_notify_if_match_t header structure, or NULL
 * upon an error.
 *
 * @since New in @EXP_1_12_5.
 */
#if SU_HAVE_INLINE
su_inline
#endif
sip_suppress_notify_if_match_t *sip_suppress_notify_if_match_dup(su_home_t *home, sip_suppress_notify_if_match_t const *hdr) 
     __attribute__((__malloc__));

#if SU_HAVE_INLINE
su_inline
sip_suppress_notify_if_match_t *sip_suppress_notify_if_match_dup(su_home_t *home, sip_suppress_notify_if_match_t const *hdr)
{ 
  return (sip_suppress_notify_if_match_t *)
    msg_header_dup_as(home, sip_suppress_notify_if_match_class, (msg_header_t const *)hdr);
}
#endif

/**Copy a list of @ref sip_suppress_notify_if_match "Suppress-Notify-If-Match header" header structures #sip_suppress_notify_if_match_t.
 * 
 * The function sip_suppress_notify_if_match_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the list of header
 * structure @a hdr.
 * 
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be copied
 * 
 * When copying, only the header structure and parameter lists attached to
 * it are duplicated. The new header structure retains all the references to
 * the strings within the old @a hdr header, including the encoding of the
 * old header, if present.
 * 
 * @par Example
 * @code
 * 
 *   suppress_notify_if_match = sip_suppress_notify_if_match_copy(home, sip->sip_suppress_notify_if_match);
 * 
 * @endcode
 * 
 * @return
 * A pointer to newly copied header structure, or NULL upon an error.
 *
 * @since New in @EXP_1_12_5.
 */
#if SU_HAVE_INLINE
su_inline
#endif
sip_suppress_notify_if_match_t *sip_suppress_notify_if_match_copy(su_home_t *home, sip_suppress_notify_if_match_t const *hdr) 
     __attribute__((__malloc__));

#if SU_HAVE_INLINE
su_inline
sip_suppress_notify_if_match_t *sip_suppress_notify_if_match_copy(su_home_t *home, sip_suppress_notify_if_match_t const *hdr) 
{ 
  return (sip_suppress_notify_if_match_t *)
    msg_header_copy_as(home, sip_suppress_notify_if_match_class, (msg_header_t const *)hdr); 
}
#endif

/**Make a @ref sip_suppress_notify_if_match "Suppress-Notify-If-Match header" structure #sip_suppress_notify_if_match_t.
 * 
 * The function sip_suppress_notify_if_match_make() makes a new
 * #sip_suppress_notify_if_match_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 * 
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 * 
 * @return
 * A pointer to newly maked #sip_suppress_notify_if_match_t header structure, or NULL upon an
 * error.
 *
 * @since New in @EXP_1_12_5.
 */
#if SU_HAVE_INLINE
su_inline 
#endif
sip_suppress_notify_if_match_t *sip_suppress_notify_if_match_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

#if SU_HAVE_INLINE
su_inline sip_suppress_notify_if_match_t *sip_suppress_notify_if_match_make(su_home_t *home, char const *s)
{
  return (sip_suppress_notify_if_match_t *)sip_header_make(home, sip_suppress_notify_if_match_class, s);
}
#endif

/**Make a @ref sip_suppress_notify_if_match "Suppress-Notify-If-Match header" from formatting result.
 * 
 * Make a new #sip_suppress_notify_if_match_t object using formatting result as its value. 
 * The function first prints the arguments according to the format @a fmt
 * specified. Then it allocates a new header structure, and parses the
 * formatting result to the structure #sip_suppress_notify_if_match_t.
 * 
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 * 
 * @return
 * A pointer to newly
 * makes header structure, or NULL upon an error.
 * 
 * @HIDE
 *
 * @since New in @EXP_1_12_5.
 */
#if SU_HAVE_INLINE
su_inline
#endif
sip_suppress_notify_if_match_t *sip_suppress_notify_if_match_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));

#if SU_HAVE_INLINE
su_inline sip_suppress_notify_if_match_t *sip_suppress_notify_if_match_format(su_home_t *home, char const *fmt, ...)
{
  sip_header_t *h;
  va_list ap;
  
  va_start(ap, fmt);
  h = sip_header_vformat(home, sip_suppress_notify_if_match_class, fmt, ap);
  va_end(ap);
 
  return (sip_suppress_notify_if_match_t *)h;
}
#endif

/** @} */

/**@ingroup sip_suppress_notify_if_match
 *
 * Tag list item for pointer to a @ref sip_suppress_notify_if_match "Suppress-Notify-If-Match header"
 * structure #sip_suppress_notify_if_match_t.
 *
 * The SIPTAG_SUPPRESS_NOTIFY_IF_MATCH() macro is used to include a tag item with a
 * pointer to a #sip_suppress_notify_if_match_t structure in a tag list.
 *
 * @param x pointer to a #sip_suppress_notify_if_match_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_SUPPRESS_NOTIFY_IF_MATCH_REF().
 *
 * @since New in @EXP_1_12_5.
 *
 * @HIDE
 */
#define SIPTAG_SUPPRESS_NOTIFY_IF_MATCH(x) siptag_suppress_notify_if_match, siptag_suppress_notify_if_match_v(x)

SOFIAPUBVAR tag_typedef_t siptag_suppress_notify_if_match;

/**@ingroup sip_suppress_notify_if_match
 * Tag list item for reference to a 
 * @ref sip_suppress_notify_if_match "Suppress-Notify-If-Match header" pointer.
 */
#define SIPTAG_SUPPRESS_NOTIFY_IF_MATCH_REF(x) siptag_suppress_notify_if_match_ref, siptag_suppress_notify_if_match_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_suppress_notify_if_match_ref;

/**@ingroup sip_suppress_notify_if_match
 *
 * Tag list item for string with @ref sip_suppress_notify_if_match "Suppress-Notify-If-Match header" value.
 *
 * The SIPTAG_SUPPRESS_NOTIFY_IF_MATCH_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_suppress_notify_if_match_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_suppress_notify_if_match "Suppress-Notify-If-Match header" value, or NULL.
 *
 * The string in SIPTAG_SUPPRESS_NOTIFY_IF_MATCH_STR() can be converted to a
 * #sip_suppress_notify_if_match_t header structure by giving the string @a s has
 * second argument to function sip_suppress_notify_if_match_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_SUPPRESS_NOTIFY_IF_MATCH_STR_REF().
 *
 * @since New in @EXP_1_12_5.
 *
 * @HIDE
 */
#define SIPTAG_SUPPRESS_NOTIFY_IF_MATCH_STR(s) siptag_suppress_notify_if_match_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_suppress_notify_if_match_str;

/**@ingroup sip_suppress_notify_if_match
 * Tag list item for reference to a
 * @ref sip_suppress_notify_if_match "Suppress-Notify-If-Match header" string.
 */
#define SIPTAG_SUPPRESS_NOTIFY_IF_MATCH_STR_REF(x) siptag_suppress_notify_if_match_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_suppress_notify_if_match_str_ref;

#if SU_INLINE_TAG_CAST
su_inline tag_value_t
siptag_suppress_notify_if_match_v(sip_suppress_notify_if_match_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_suppress_notify_if_match_vr(sip_suppress_notify_if_match_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_suppress_notify_if_match_v(v)   (tag_value_t)(v)
#define siptag_suppress_notify_if_match_vr(vp) (tag_value_t)(vp)
#endif

#endif /* SU_HAVE_EXPERIMENTAL */

SOFIA_END_DECLS

#endif /** !defined(SIP_EXTRA_H) */
