/*
 * This file is part of the Sofia-SIP package
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Pekka Pessi <pekka.pessi@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef HTTP_TAG_H
/** Defined when <sofia-sip/http_tag.h> has been included. */
#define HTTP_TAG_H

/**@file sofia-sip/http_tag.h
 * @brief Tag class for HTTP headers
 *
 * This file is automatically generated from <http.h> by msg_parser.awk.
 *
 * @author Pekka Pessi <Pekka.Pessi@nokia.com>
 *
 */

#ifndef SU_TAG_H
#include <sofia-sip/su_tag.h>
#endif
#ifndef SU_TAG_CLASS_H
#include <sofia-sip/su_tag_class.h>
#endif
#ifndef SU_TAG_CLASS_H
#include <sofia-sip/su_tag_class.h>
#endif

#ifndef HTTP_H
#include <sofia-sip/http.h>
#endif

SOFIA_BEGIN_DECLS

#define HTTPTAG(c, x)         httptag_##c, httptag_##c##_v(x)
#define HTTPTAG_REF(c, x)     httptag_##c##_ref, httptag_##c##_vr(&(x))
#define HTTPTAG_STR(c, s)     httptag_##c##_str, tag_str_v(s)
#define HTTPTAG_STR_REF(c, s) httptag_##c##_str_ref, tag_str_vr(&(s))

/** Test if tag type marks a http_t structure. @HIDE */
#define HTTPTAG_P(tt)     ((tt)->tt_class == httphdrtag_class)
/** Test if tag type marks a HTTP header string. @HIDE */
#define HTTPTAG_STR_P(tt) ((tt)->tt_class == httpstrtag_class)
/** Test if tag type marks a HTTP header structure. @HIDE */
#define HTTPTAG_HTTP_P(tt) ((tt)->tt_class == httpmsgtag_class)

/** Test if tag item contains http_t structure. @HIDE */
#define HTTPTAGI_P(t)     (HTTPTAG_P((t)->t_tag))
/** Test if tag item contains a HTTP header string. @HIDE */
#define HTTPTAGI_STR_P(t) (HTTPTAG_STR_P((t)->t_tag))
/** Test if tag item contains a HTTP header structure. @HIDE */
#define HTTPTAGI_HTTP_P(t) (HTTPTAG_HTTP_P((t)->t_tag))

SOFIAPUBVAR tag_class_t httphdrtag_class[1];
SOFIAPUBVAR tag_class_t httpstrtag_class[1];
SOFIAPUBVAR tag_class_t httpmsgtag_class[1];

/** Filter tag matching any http tag. */
#define HTTPTAG_ANY()         httptag_any, ((tag_value_t)0)
SOFIAPUBVAR tag_typedef_t httptag_any;

/**Tag list item for @c http_t object.
 *
 * The HTTPTAG_HTTP() macro is used to include a tag item for a http_t object
 * in the tag list.
 *
 * @param x pointer to a http_t message object, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_HTTP(x)       httptag_http, httptag_http_v((x))

/** Tag for @c http_t */
SOFIAPUBVAR tag_typedef_t httptag_http;

#define HTTPTAG_HTTP_REF(x)   httptag_http_ref, httptag_http_vr(&(x))
SOFIAPUBVAR tag_typedef_t httptag_http_ref;

#if SU_HAVE_INLINE
su_inline
tag_value_t httptag_http_v(http_t const *v) { return (tag_value_t)v; }
su_inline 
tag_value_t httptag_http_vr(http_t const **vp) { return (tag_value_t)vp; }
#else
#define httptag_http_v(v)   (tag_value_t)(v)
#define httptag_http_vr(vp) (tag_value_t)(vp)
#endif

/**Tag list item for http protocol version.
 *
 * The HTTPTAG_VERSION() macro is used to include a tag item for a HTTP
 * protocol version in the tag list.
 *
 * @param x pointer to a http_t message object, or NULL.
 */
#define HTTPTAG_VERSION(x)       httptag_http, (tag_value_t)x

extern tag_typedef_t httptag_version;

/** Reference to HTTPTAG_VERSION */
#define HTTPTAG_VERSION_REF(x)   httptag_http_ref, (tag_value_t)&(x)

extern tag_typedef_t httptag_version_ref;

/**Tag list item for header string.
 *
 * The HTTPTAG_HEADER() macro is used to include a tag item containing an
 * unknown HTTP header in the tag list, e.g., 
 * @code 
 * http_header_t *hdr;
 *
 * HTTPTAG_HEADER(hdr).
 * @endcode
 *
 * @param x pointer to a header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_HEADER(x)       httptag_header, httptag_header_v((x))

/** Tag for header string */
SOFIAPUBVAR tag_typedef_t httptag_header;

#define HTTPTAG_HEADER_REF(x)   httptag_header_ref, httptag_header_vr(&(x))
SOFIAPUBVAR tag_typedef_t httptag_header_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_header_v(http_header_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_header_vr(http_header_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_header_v(v)   (tag_value_t)(v)
#define httptag_header_vr(vp) (tag_value_t)(vp)
#endif

/**Tag list item for header string.
 *
 * The HTTPTAG_HEADER_STR() macro is used to include a tag item containing a
 * header string in the tag list.
 *
 * @param x pointer to a string, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_HEADER_STR(x)       httptag_header_str, tag_str_v((x))

/** Tag for header string */
SOFIAPUBVAR tag_typedef_t httptag_header_str;

#define HTTPTAG_HEADER_STR_REF(x)   httptag_header_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t httptag_header_str_ref;


/**@ingroup http_request
 *
 * Tag list item for pointer to a request line object.
 *
 * The HTTPTAG_REQUEST() macro is used to include a tag item with a
 * pointer to a http_request_t object in a tag list.
 *
 * @param x pointer to a http_request_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_REQUEST(x)        	  HTTPTAG(request, x)

SOFIAPUBVAR tag_typedef_t httptag_request;

/**@ingroup http_request
 *
 * Tag list item for string with request line value.
 *
 * The HTTPTAG_REQUEST_STR() macro is used to include a tag item with a 
 * string containing value of a http_request_t header in a tag list.
 *
 * @param s pointer to a string containing http_request_t value, or NULL.
 *
 * The HTTPTAG_REQUEST_STR string can be converted to a
 * http_request_t header structure by giving the string @a s has
 * second argument to function http_request_make().
 *
 * @HIDE
 */
#define HTTPTAG_REQUEST_STR(s)    	  HTTPTAG_STR(request, s)

SOFIAPUBVAR tag_typedef_t httptag_request_str;

#define HTTPTAG_REQUEST_REF(x)        	  HTTPTAG_REF(request, x)
SOFIAPUBVAR tag_typedef_t httptag_request_ref;

#define HTTPTAG_REQUEST_STR_REF(x)        HTTPTAG_STR_REF(request, x)
SOFIAPUBVAR tag_typedef_t httptag_request_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_request_v(http_request_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_request_vr(http_request_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_request_v(v)   (tag_value_t)(v)
#define httptag_request_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_status
 *
 * Tag list item for pointer to a status line object.
 *
 * The HTTPTAG_STATUS() macro is used to include a tag item with a
 * pointer to a http_status_t object in a tag list.
 *
 * @param x pointer to a http_status_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_STATUS(x)        	  HTTPTAG(status, x)

SOFIAPUBVAR tag_typedef_t httptag_status;

/**@ingroup http_status
 *
 * Tag list item for string with status line value.
 *
 * The HTTPTAG_STATUS_STR() macro is used to include a tag item with a 
 * string containing value of a http_status_t header in a tag list.
 *
 * @param s pointer to a string containing http_status_t value, or NULL.
 *
 * The HTTPTAG_STATUS_STR string can be converted to a
 * http_status_t header structure by giving the string @a s has
 * second argument to function http_status_make().
 *
 * @HIDE
 */
#define HTTPTAG_STATUS_STR(s)    	  HTTPTAG_STR(status, s)

SOFIAPUBVAR tag_typedef_t httptag_status_str;

#define HTTPTAG_STATUS_REF(x)        	  HTTPTAG_REF(status, x)
SOFIAPUBVAR tag_typedef_t httptag_status_ref;

#define HTTPTAG_STATUS_STR_REF(x)        HTTPTAG_STR_REF(status, x)
SOFIAPUBVAR tag_typedef_t httptag_status_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_status_v(http_status_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_status_vr(http_status_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_status_v(v)   (tag_value_t)(v)
#define httptag_status_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_accept
 *
 * Tag list item for pointer to a Accept header object.
 *
 * The HTTPTAG_ACCEPT() macro is used to include a tag item with a
 * pointer to a http_accept_t object in a tag list.
 *
 * @param x pointer to a http_accept_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_ACCEPT(x)        	  HTTPTAG(accept, x)

SOFIAPUBVAR tag_typedef_t httptag_accept;

/**@ingroup http_accept
 *
 * Tag list item for string with Accept header value.
 *
 * The HTTPTAG_ACCEPT_STR() macro is used to include a tag item with a 
 * string containing value of a http_accept_t header in a tag list.
 *
 * @param s pointer to a string containing http_accept_t value, or NULL.
 *
 * The HTTPTAG_ACCEPT_STR string can be converted to a
 * http_accept_t header structure by giving the string @a s has
 * second argument to function http_accept_make().
 *
 * @HIDE
 */
#define HTTPTAG_ACCEPT_STR(s)    	  HTTPTAG_STR(accept, s)

SOFIAPUBVAR tag_typedef_t httptag_accept_str;

#define HTTPTAG_ACCEPT_REF(x)        	  HTTPTAG_REF(accept, x)
SOFIAPUBVAR tag_typedef_t httptag_accept_ref;

#define HTTPTAG_ACCEPT_STR_REF(x)        HTTPTAG_STR_REF(accept, x)
SOFIAPUBVAR tag_typedef_t httptag_accept_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_accept_v(http_accept_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_accept_vr(http_accept_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_accept_v(v)   (tag_value_t)(v)
#define httptag_accept_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_accept_charset
 *
 * Tag list item for pointer to a Accept-Charset header object.
 *
 * The HTTPTAG_ACCEPT_CHARSET() macro is used to include a tag item with a
 * pointer to a http_accept_charset_t object in a tag list.
 *
 * @param x pointer to a http_accept_charset_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_ACCEPT_CHARSET(x)        	  HTTPTAG(accept_charset, x)

SOFIAPUBVAR tag_typedef_t httptag_accept_charset;

/**@ingroup http_accept_charset
 *
 * Tag list item for string with Accept-Charset header value.
 *
 * The HTTPTAG_ACCEPT_CHARSET_STR() macro is used to include a tag item with a 
 * string containing value of a http_accept_charset_t header in a tag list.
 *
 * @param s pointer to a string containing http_accept_charset_t value, or NULL.
 *
 * The HTTPTAG_ACCEPT_CHARSET_STR string can be converted to a
 * http_accept_charset_t header structure by giving the string @a s has
 * second argument to function http_accept_charset_make().
 *
 * @HIDE
 */
#define HTTPTAG_ACCEPT_CHARSET_STR(s)    	  HTTPTAG_STR(accept_charset, s)

SOFIAPUBVAR tag_typedef_t httptag_accept_charset_str;

#define HTTPTAG_ACCEPT_CHARSET_REF(x)        	  HTTPTAG_REF(accept_charset, x)
SOFIAPUBVAR tag_typedef_t httptag_accept_charset_ref;

#define HTTPTAG_ACCEPT_CHARSET_STR_REF(x)        HTTPTAG_STR_REF(accept_charset, x)
SOFIAPUBVAR tag_typedef_t httptag_accept_charset_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_accept_charset_v(http_accept_charset_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_accept_charset_vr(http_accept_charset_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_accept_charset_v(v)   (tag_value_t)(v)
#define httptag_accept_charset_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_accept_encoding
 *
 * Tag list item for pointer to a Accept-Encoding header object.
 *
 * The HTTPTAG_ACCEPT_ENCODING() macro is used to include a tag item with a
 * pointer to a http_accept_encoding_t object in a tag list.
 *
 * @param x pointer to a http_accept_encoding_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_ACCEPT_ENCODING(x)        	  HTTPTAG(accept_encoding, x)

SOFIAPUBVAR tag_typedef_t httptag_accept_encoding;

/**@ingroup http_accept_encoding
 *
 * Tag list item for string with Accept-Encoding header value.
 *
 * The HTTPTAG_ACCEPT_ENCODING_STR() macro is used to include a tag item with a 
 * string containing value of a http_accept_encoding_t header in a tag list.
 *
 * @param s pointer to a string containing http_accept_encoding_t value, or NULL.
 *
 * The HTTPTAG_ACCEPT_ENCODING_STR string can be converted to a
 * http_accept_encoding_t header structure by giving the string @a s has
 * second argument to function http_accept_encoding_make().
 *
 * @HIDE
 */
#define HTTPTAG_ACCEPT_ENCODING_STR(s)    	  HTTPTAG_STR(accept_encoding, s)

SOFIAPUBVAR tag_typedef_t httptag_accept_encoding_str;

#define HTTPTAG_ACCEPT_ENCODING_REF(x)        	  HTTPTAG_REF(accept_encoding, x)
SOFIAPUBVAR tag_typedef_t httptag_accept_encoding_ref;

#define HTTPTAG_ACCEPT_ENCODING_STR_REF(x)        HTTPTAG_STR_REF(accept_encoding, x)
SOFIAPUBVAR tag_typedef_t httptag_accept_encoding_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_accept_encoding_v(http_accept_encoding_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_accept_encoding_vr(http_accept_encoding_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_accept_encoding_v(v)   (tag_value_t)(v)
#define httptag_accept_encoding_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_accept_language
 *
 * Tag list item for pointer to a Accept-Language header object.
 *
 * The HTTPTAG_ACCEPT_LANGUAGE() macro is used to include a tag item with a
 * pointer to a http_accept_language_t object in a tag list.
 *
 * @param x pointer to a http_accept_language_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_ACCEPT_LANGUAGE(x)        	  HTTPTAG(accept_language, x)

SOFIAPUBVAR tag_typedef_t httptag_accept_language;

/**@ingroup http_accept_language
 *
 * Tag list item for string with Accept-Language header value.
 *
 * The HTTPTAG_ACCEPT_LANGUAGE_STR() macro is used to include a tag item with a 
 * string containing value of a http_accept_language_t header in a tag list.
 *
 * @param s pointer to a string containing http_accept_language_t value, or NULL.
 *
 * The HTTPTAG_ACCEPT_LANGUAGE_STR string can be converted to a
 * http_accept_language_t header structure by giving the string @a s has
 * second argument to function http_accept_language_make().
 *
 * @HIDE
 */
#define HTTPTAG_ACCEPT_LANGUAGE_STR(s)    	  HTTPTAG_STR(accept_language, s)

SOFIAPUBVAR tag_typedef_t httptag_accept_language_str;

#define HTTPTAG_ACCEPT_LANGUAGE_REF(x)        	  HTTPTAG_REF(accept_language, x)
SOFIAPUBVAR tag_typedef_t httptag_accept_language_ref;

#define HTTPTAG_ACCEPT_LANGUAGE_STR_REF(x)        HTTPTAG_STR_REF(accept_language, x)
SOFIAPUBVAR tag_typedef_t httptag_accept_language_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_accept_language_v(http_accept_language_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_accept_language_vr(http_accept_language_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_accept_language_v(v)   (tag_value_t)(v)
#define httptag_accept_language_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_accept_ranges
 *
 * Tag list item for pointer to a Accept-Ranges header object.
 *
 * The HTTPTAG_ACCEPT_RANGES() macro is used to include a tag item with a
 * pointer to a http_accept_ranges_t object in a tag list.
 *
 * @param x pointer to a http_accept_ranges_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_ACCEPT_RANGES(x)        	  HTTPTAG(accept_ranges, x)

SOFIAPUBVAR tag_typedef_t httptag_accept_ranges;

/**@ingroup http_accept_ranges
 *
 * Tag list item for string with Accept-Ranges header value.
 *
 * The HTTPTAG_ACCEPT_RANGES_STR() macro is used to include a tag item with a 
 * string containing value of a http_accept_ranges_t header in a tag list.
 *
 * @param s pointer to a string containing http_accept_ranges_t value, or NULL.
 *
 * The HTTPTAG_ACCEPT_RANGES_STR string can be converted to a
 * http_accept_ranges_t header structure by giving the string @a s has
 * second argument to function http_accept_ranges_make().
 *
 * @HIDE
 */
#define HTTPTAG_ACCEPT_RANGES_STR(s)    	  HTTPTAG_STR(accept_ranges, s)

SOFIAPUBVAR tag_typedef_t httptag_accept_ranges_str;

#define HTTPTAG_ACCEPT_RANGES_REF(x)        	  HTTPTAG_REF(accept_ranges, x)
SOFIAPUBVAR tag_typedef_t httptag_accept_ranges_ref;

#define HTTPTAG_ACCEPT_RANGES_STR_REF(x)        HTTPTAG_STR_REF(accept_ranges, x)
SOFIAPUBVAR tag_typedef_t httptag_accept_ranges_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_accept_ranges_v(http_accept_ranges_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_accept_ranges_vr(http_accept_ranges_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_accept_ranges_v(v)   (tag_value_t)(v)
#define httptag_accept_ranges_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_allow
 *
 * Tag list item for pointer to a Allow header object.
 *
 * The HTTPTAG_ALLOW() macro is used to include a tag item with a
 * pointer to a http_allow_t object in a tag list.
 *
 * @param x pointer to a http_allow_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_ALLOW(x)        	  HTTPTAG(allow, x)

SOFIAPUBVAR tag_typedef_t httptag_allow;

/**@ingroup http_allow
 *
 * Tag list item for string with Allow header value.
 *
 * The HTTPTAG_ALLOW_STR() macro is used to include a tag item with a 
 * string containing value of a http_allow_t header in a tag list.
 *
 * @param s pointer to a string containing http_allow_t value, or NULL.
 *
 * The HTTPTAG_ALLOW_STR string can be converted to a
 * http_allow_t header structure by giving the string @a s has
 * second argument to function http_allow_make().
 *
 * @HIDE
 */
#define HTTPTAG_ALLOW_STR(s)    	  HTTPTAG_STR(allow, s)

SOFIAPUBVAR tag_typedef_t httptag_allow_str;

#define HTTPTAG_ALLOW_REF(x)        	  HTTPTAG_REF(allow, x)
SOFIAPUBVAR tag_typedef_t httptag_allow_ref;

#define HTTPTAG_ALLOW_STR_REF(x)        HTTPTAG_STR_REF(allow, x)
SOFIAPUBVAR tag_typedef_t httptag_allow_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_allow_v(http_allow_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_allow_vr(http_allow_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_allow_v(v)   (tag_value_t)(v)
#define httptag_allow_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_authentication_info
 *
 * Tag list item for pointer to a Authentication-Info header object.
 *
 * The HTTPTAG_AUTHENTICATION_INFO() macro is used to include a tag item with a
 * pointer to a http_authentication_info_t object in a tag list.
 *
 * @param x pointer to a http_authentication_info_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_AUTHENTICATION_INFO(x)        	  HTTPTAG(authentication_info, x)

SOFIAPUBVAR tag_typedef_t httptag_authentication_info;

/**@ingroup http_authentication_info
 *
 * Tag list item for string with Authentication-Info header value.
 *
 * The HTTPTAG_AUTHENTICATION_INFO_STR() macro is used to include a tag item with a 
 * string containing value of a http_authentication_info_t header in a tag list.
 *
 * @param s pointer to a string containing http_authentication_info_t value, or NULL.
 *
 * The HTTPTAG_AUTHENTICATION_INFO_STR string can be converted to a
 * http_authentication_info_t header structure by giving the string @a s has
 * second argument to function http_authentication_info_make().
 *
 * @HIDE
 */
#define HTTPTAG_AUTHENTICATION_INFO_STR(s)    	  HTTPTAG_STR(authentication_info, s)

SOFIAPUBVAR tag_typedef_t httptag_authentication_info_str;

#define HTTPTAG_AUTHENTICATION_INFO_REF(x)        	  HTTPTAG_REF(authentication_info, x)
SOFIAPUBVAR tag_typedef_t httptag_authentication_info_ref;

#define HTTPTAG_AUTHENTICATION_INFO_STR_REF(x)        HTTPTAG_STR_REF(authentication_info, x)
SOFIAPUBVAR tag_typedef_t httptag_authentication_info_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_authentication_info_v(http_authentication_info_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_authentication_info_vr(http_authentication_info_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_authentication_info_v(v)   (tag_value_t)(v)
#define httptag_authentication_info_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_authorization
 *
 * Tag list item for pointer to a Authorization header object.
 *
 * The HTTPTAG_AUTHORIZATION() macro is used to include a tag item with a
 * pointer to a http_authorization_t object in a tag list.
 *
 * @param x pointer to a http_authorization_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_AUTHORIZATION(x)        	  HTTPTAG(authorization, x)

SOFIAPUBVAR tag_typedef_t httptag_authorization;

/**@ingroup http_authorization
 *
 * Tag list item for string with Authorization header value.
 *
 * The HTTPTAG_AUTHORIZATION_STR() macro is used to include a tag item with a 
 * string containing value of a http_authorization_t header in a tag list.
 *
 * @param s pointer to a string containing http_authorization_t value, or NULL.
 *
 * The HTTPTAG_AUTHORIZATION_STR string can be converted to a
 * http_authorization_t header structure by giving the string @a s has
 * second argument to function http_authorization_make().
 *
 * @HIDE
 */
#define HTTPTAG_AUTHORIZATION_STR(s)    	  HTTPTAG_STR(authorization, s)

SOFIAPUBVAR tag_typedef_t httptag_authorization_str;

#define HTTPTAG_AUTHORIZATION_REF(x)        	  HTTPTAG_REF(authorization, x)
SOFIAPUBVAR tag_typedef_t httptag_authorization_ref;

#define HTTPTAG_AUTHORIZATION_STR_REF(x)        HTTPTAG_STR_REF(authorization, x)
SOFIAPUBVAR tag_typedef_t httptag_authorization_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_authorization_v(http_authorization_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_authorization_vr(http_authorization_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_authorization_v(v)   (tag_value_t)(v)
#define httptag_authorization_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_age
 *
 * Tag list item for pointer to a Age header object.
 *
 * The HTTPTAG_AGE() macro is used to include a tag item with a
 * pointer to a http_age_t object in a tag list.
 *
 * @param x pointer to a http_age_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_AGE(x)        	  HTTPTAG(age, x)

SOFIAPUBVAR tag_typedef_t httptag_age;

/**@ingroup http_age
 *
 * Tag list item for string with Age header value.
 *
 * The HTTPTAG_AGE_STR() macro is used to include a tag item with a 
 * string containing value of a http_age_t header in a tag list.
 *
 * @param s pointer to a string containing http_age_t value, or NULL.
 *
 * The HTTPTAG_AGE_STR string can be converted to a
 * http_age_t header structure by giving the string @a s has
 * second argument to function http_age_make().
 *
 * @HIDE
 */
#define HTTPTAG_AGE_STR(s)    	  HTTPTAG_STR(age, s)

SOFIAPUBVAR tag_typedef_t httptag_age_str;

#define HTTPTAG_AGE_REF(x)        	  HTTPTAG_REF(age, x)
SOFIAPUBVAR tag_typedef_t httptag_age_ref;

#define HTTPTAG_AGE_STR_REF(x)        HTTPTAG_STR_REF(age, x)
SOFIAPUBVAR tag_typedef_t httptag_age_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_age_v(http_age_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_age_vr(http_age_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_age_v(v)   (tag_value_t)(v)
#define httptag_age_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_cache_control
 *
 * Tag list item for pointer to a Cache-Control header object.
 *
 * The HTTPTAG_CACHE_CONTROL() macro is used to include a tag item with a
 * pointer to a http_cache_control_t object in a tag list.
 *
 * @param x pointer to a http_cache_control_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_CACHE_CONTROL(x)        	  HTTPTAG(cache_control, x)

SOFIAPUBVAR tag_typedef_t httptag_cache_control;

/**@ingroup http_cache_control
 *
 * Tag list item for string with Cache-Control header value.
 *
 * The HTTPTAG_CACHE_CONTROL_STR() macro is used to include a tag item with a 
 * string containing value of a http_cache_control_t header in a tag list.
 *
 * @param s pointer to a string containing http_cache_control_t value, or NULL.
 *
 * The HTTPTAG_CACHE_CONTROL_STR string can be converted to a
 * http_cache_control_t header structure by giving the string @a s has
 * second argument to function http_cache_control_make().
 *
 * @HIDE
 */
#define HTTPTAG_CACHE_CONTROL_STR(s)    	  HTTPTAG_STR(cache_control, s)

SOFIAPUBVAR tag_typedef_t httptag_cache_control_str;

#define HTTPTAG_CACHE_CONTROL_REF(x)        	  HTTPTAG_REF(cache_control, x)
SOFIAPUBVAR tag_typedef_t httptag_cache_control_ref;

#define HTTPTAG_CACHE_CONTROL_STR_REF(x)        HTTPTAG_STR_REF(cache_control, x)
SOFIAPUBVAR tag_typedef_t httptag_cache_control_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_cache_control_v(http_cache_control_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_cache_control_vr(http_cache_control_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_cache_control_v(v)   (tag_value_t)(v)
#define httptag_cache_control_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_connection
 *
 * Tag list item for pointer to a Connection header object.
 *
 * The HTTPTAG_CONNECTION() macro is used to include a tag item with a
 * pointer to a http_connection_t object in a tag list.
 *
 * @param x pointer to a http_connection_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_CONNECTION(x)        	  HTTPTAG(connection, x)

SOFIAPUBVAR tag_typedef_t httptag_connection;

/**@ingroup http_connection
 *
 * Tag list item for string with Connection header value.
 *
 * The HTTPTAG_CONNECTION_STR() macro is used to include a tag item with a 
 * string containing value of a http_connection_t header in a tag list.
 *
 * @param s pointer to a string containing http_connection_t value, or NULL.
 *
 * The HTTPTAG_CONNECTION_STR string can be converted to a
 * http_connection_t header structure by giving the string @a s has
 * second argument to function http_connection_make().
 *
 * @HIDE
 */
#define HTTPTAG_CONNECTION_STR(s)    	  HTTPTAG_STR(connection, s)

SOFIAPUBVAR tag_typedef_t httptag_connection_str;

#define HTTPTAG_CONNECTION_REF(x)        	  HTTPTAG_REF(connection, x)
SOFIAPUBVAR tag_typedef_t httptag_connection_ref;

#define HTTPTAG_CONNECTION_STR_REF(x)        HTTPTAG_STR_REF(connection, x)
SOFIAPUBVAR tag_typedef_t httptag_connection_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_connection_v(http_connection_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_connection_vr(http_connection_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_connection_v(v)   (tag_value_t)(v)
#define httptag_connection_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_date
 *
 * Tag list item for pointer to a Date header object.
 *
 * The HTTPTAG_DATE() macro is used to include a tag item with a
 * pointer to a http_date_t object in a tag list.
 *
 * @param x pointer to a http_date_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_DATE(x)        	  HTTPTAG(date, x)

SOFIAPUBVAR tag_typedef_t httptag_date;

/**@ingroup http_date
 *
 * Tag list item for string with Date header value.
 *
 * The HTTPTAG_DATE_STR() macro is used to include a tag item with a 
 * string containing value of a http_date_t header in a tag list.
 *
 * @param s pointer to a string containing http_date_t value, or NULL.
 *
 * The HTTPTAG_DATE_STR string can be converted to a
 * http_date_t header structure by giving the string @a s has
 * second argument to function http_date_make().
 *
 * @HIDE
 */
#define HTTPTAG_DATE_STR(s)    	  HTTPTAG_STR(date, s)

SOFIAPUBVAR tag_typedef_t httptag_date_str;

#define HTTPTAG_DATE_REF(x)        	  HTTPTAG_REF(date, x)
SOFIAPUBVAR tag_typedef_t httptag_date_ref;

#define HTTPTAG_DATE_STR_REF(x)        HTTPTAG_STR_REF(date, x)
SOFIAPUBVAR tag_typedef_t httptag_date_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_date_v(http_date_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_date_vr(http_date_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_date_v(v)   (tag_value_t)(v)
#define httptag_date_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_etag
 *
 * Tag list item for pointer to a ETag header object.
 *
 * The HTTPTAG_ETAG() macro is used to include a tag item with a
 * pointer to a http_etag_t object in a tag list.
 *
 * @param x pointer to a http_etag_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_ETAG(x)        	  HTTPTAG(etag, x)

SOFIAPUBVAR tag_typedef_t httptag_etag;

/**@ingroup http_etag
 *
 * Tag list item for string with ETag header value.
 *
 * The HTTPTAG_ETAG_STR() macro is used to include a tag item with a 
 * string containing value of a http_etag_t header in a tag list.
 *
 * @param s pointer to a string containing http_etag_t value, or NULL.
 *
 * The HTTPTAG_ETAG_STR string can be converted to a
 * http_etag_t header structure by giving the string @a s has
 * second argument to function http_etag_make().
 *
 * @HIDE
 */
#define HTTPTAG_ETAG_STR(s)    	  HTTPTAG_STR(etag, s)

SOFIAPUBVAR tag_typedef_t httptag_etag_str;

#define HTTPTAG_ETAG_REF(x)        	  HTTPTAG_REF(etag, x)
SOFIAPUBVAR tag_typedef_t httptag_etag_ref;

#define HTTPTAG_ETAG_STR_REF(x)        HTTPTAG_STR_REF(etag, x)
SOFIAPUBVAR tag_typedef_t httptag_etag_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_etag_v(http_etag_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_etag_vr(http_etag_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_etag_v(v)   (tag_value_t)(v)
#define httptag_etag_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_expect
 *
 * Tag list item for pointer to a Expect header object.
 *
 * The HTTPTAG_EXPECT() macro is used to include a tag item with a
 * pointer to a http_expect_t object in a tag list.
 *
 * @param x pointer to a http_expect_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_EXPECT(x)        	  HTTPTAG(expect, x)

SOFIAPUBVAR tag_typedef_t httptag_expect;

/**@ingroup http_expect
 *
 * Tag list item for string with Expect header value.
 *
 * The HTTPTAG_EXPECT_STR() macro is used to include a tag item with a 
 * string containing value of a http_expect_t header in a tag list.
 *
 * @param s pointer to a string containing http_expect_t value, or NULL.
 *
 * The HTTPTAG_EXPECT_STR string can be converted to a
 * http_expect_t header structure by giving the string @a s has
 * second argument to function http_expect_make().
 *
 * @HIDE
 */
#define HTTPTAG_EXPECT_STR(s)    	  HTTPTAG_STR(expect, s)

SOFIAPUBVAR tag_typedef_t httptag_expect_str;

#define HTTPTAG_EXPECT_REF(x)        	  HTTPTAG_REF(expect, x)
SOFIAPUBVAR tag_typedef_t httptag_expect_ref;

#define HTTPTAG_EXPECT_STR_REF(x)        HTTPTAG_STR_REF(expect, x)
SOFIAPUBVAR tag_typedef_t httptag_expect_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_expect_v(http_expect_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_expect_vr(http_expect_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_expect_v(v)   (tag_value_t)(v)
#define httptag_expect_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_expires
 *
 * Tag list item for pointer to a Expires header object.
 *
 * The HTTPTAG_EXPIRES() macro is used to include a tag item with a
 * pointer to a http_expires_t object in a tag list.
 *
 * @param x pointer to a http_expires_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_EXPIRES(x)        	  HTTPTAG(expires, x)

SOFIAPUBVAR tag_typedef_t httptag_expires;

/**@ingroup http_expires
 *
 * Tag list item for string with Expires header value.
 *
 * The HTTPTAG_EXPIRES_STR() macro is used to include a tag item with a 
 * string containing value of a http_expires_t header in a tag list.
 *
 * @param s pointer to a string containing http_expires_t value, or NULL.
 *
 * The HTTPTAG_EXPIRES_STR string can be converted to a
 * http_expires_t header structure by giving the string @a s has
 * second argument to function http_expires_make().
 *
 * @HIDE
 */
#define HTTPTAG_EXPIRES_STR(s)    	  HTTPTAG_STR(expires, s)

SOFIAPUBVAR tag_typedef_t httptag_expires_str;

#define HTTPTAG_EXPIRES_REF(x)        	  HTTPTAG_REF(expires, x)
SOFIAPUBVAR tag_typedef_t httptag_expires_ref;

#define HTTPTAG_EXPIRES_STR_REF(x)        HTTPTAG_STR_REF(expires, x)
SOFIAPUBVAR tag_typedef_t httptag_expires_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_expires_v(http_expires_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_expires_vr(http_expires_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_expires_v(v)   (tag_value_t)(v)
#define httptag_expires_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_from
 *
 * Tag list item for pointer to a From header object.
 *
 * The HTTPTAG_FROM() macro is used to include a tag item with a
 * pointer to a http_from_t object in a tag list.
 *
 * @param x pointer to a http_from_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_FROM(x)        	  HTTPTAG(from, x)

SOFIAPUBVAR tag_typedef_t httptag_from;

/**@ingroup http_from
 *
 * Tag list item for string with From header value.
 *
 * The HTTPTAG_FROM_STR() macro is used to include a tag item with a 
 * string containing value of a http_from_t header in a tag list.
 *
 * @param s pointer to a string containing http_from_t value, or NULL.
 *
 * The HTTPTAG_FROM_STR string can be converted to a
 * http_from_t header structure by giving the string @a s has
 * second argument to function http_from_make().
 *
 * @HIDE
 */
#define HTTPTAG_FROM_STR(s)    	  HTTPTAG_STR(from, s)

SOFIAPUBVAR tag_typedef_t httptag_from_str;

#define HTTPTAG_FROM_REF(x)        	  HTTPTAG_REF(from, x)
SOFIAPUBVAR tag_typedef_t httptag_from_ref;

#define HTTPTAG_FROM_STR_REF(x)        HTTPTAG_STR_REF(from, x)
SOFIAPUBVAR tag_typedef_t httptag_from_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_from_v(http_from_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_from_vr(http_from_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_from_v(v)   (tag_value_t)(v)
#define httptag_from_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_host
 *
 * Tag list item for pointer to a Host header object.
 *
 * The HTTPTAG_HOST() macro is used to include a tag item with a
 * pointer to a http_host_t object in a tag list.
 *
 * @param x pointer to a http_host_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_HOST(x)        	  HTTPTAG(host, x)

SOFIAPUBVAR tag_typedef_t httptag_host;

/**@ingroup http_host
 *
 * Tag list item for string with Host header value.
 *
 * The HTTPTAG_HOST_STR() macro is used to include a tag item with a 
 * string containing value of a http_host_t header in a tag list.
 *
 * @param s pointer to a string containing http_host_t value, or NULL.
 *
 * The HTTPTAG_HOST_STR string can be converted to a
 * http_host_t header structure by giving the string @a s has
 * second argument to function http_host_make().
 *
 * @HIDE
 */
#define HTTPTAG_HOST_STR(s)    	  HTTPTAG_STR(host, s)

SOFIAPUBVAR tag_typedef_t httptag_host_str;

#define HTTPTAG_HOST_REF(x)        	  HTTPTAG_REF(host, x)
SOFIAPUBVAR tag_typedef_t httptag_host_ref;

#define HTTPTAG_HOST_STR_REF(x)        HTTPTAG_STR_REF(host, x)
SOFIAPUBVAR tag_typedef_t httptag_host_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_host_v(http_host_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_host_vr(http_host_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_host_v(v)   (tag_value_t)(v)
#define httptag_host_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_if_match
 *
 * Tag list item for pointer to a If-Match header object.
 *
 * The HTTPTAG_IF_MATCH() macro is used to include a tag item with a
 * pointer to a http_if_match_t object in a tag list.
 *
 * @param x pointer to a http_if_match_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_IF_MATCH(x)        	  HTTPTAG(if_match, x)

SOFIAPUBVAR tag_typedef_t httptag_if_match;

/**@ingroup http_if_match
 *
 * Tag list item for string with If-Match header value.
 *
 * The HTTPTAG_IF_MATCH_STR() macro is used to include a tag item with a 
 * string containing value of a http_if_match_t header in a tag list.
 *
 * @param s pointer to a string containing http_if_match_t value, or NULL.
 *
 * The HTTPTAG_IF_MATCH_STR string can be converted to a
 * http_if_match_t header structure by giving the string @a s has
 * second argument to function http_if_match_make().
 *
 * @HIDE
 */
#define HTTPTAG_IF_MATCH_STR(s)    	  HTTPTAG_STR(if_match, s)

SOFIAPUBVAR tag_typedef_t httptag_if_match_str;

#define HTTPTAG_IF_MATCH_REF(x)        	  HTTPTAG_REF(if_match, x)
SOFIAPUBVAR tag_typedef_t httptag_if_match_ref;

#define HTTPTAG_IF_MATCH_STR_REF(x)        HTTPTAG_STR_REF(if_match, x)
SOFIAPUBVAR tag_typedef_t httptag_if_match_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_if_match_v(http_if_match_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_if_match_vr(http_if_match_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_if_match_v(v)   (tag_value_t)(v)
#define httptag_if_match_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_if_modified_since
 *
 * Tag list item for pointer to a If-Modified-Since header object.
 *
 * The HTTPTAG_IF_MODIFIED_SINCE() macro is used to include a tag item with a
 * pointer to a http_if_modified_since_t object in a tag list.
 *
 * @param x pointer to a http_if_modified_since_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_IF_MODIFIED_SINCE(x)        	  HTTPTAG(if_modified_since, x)

SOFIAPUBVAR tag_typedef_t httptag_if_modified_since;

/**@ingroup http_if_modified_since
 *
 * Tag list item for string with If-Modified-Since header value.
 *
 * The HTTPTAG_IF_MODIFIED_SINCE_STR() macro is used to include a tag item with a 
 * string containing value of a http_if_modified_since_t header in a tag list.
 *
 * @param s pointer to a string containing http_if_modified_since_t value, or NULL.
 *
 * The HTTPTAG_IF_MODIFIED_SINCE_STR string can be converted to a
 * http_if_modified_since_t header structure by giving the string @a s has
 * second argument to function http_if_modified_since_make().
 *
 * @HIDE
 */
#define HTTPTAG_IF_MODIFIED_SINCE_STR(s)    	  HTTPTAG_STR(if_modified_since, s)

SOFIAPUBVAR tag_typedef_t httptag_if_modified_since_str;

#define HTTPTAG_IF_MODIFIED_SINCE_REF(x)        	  HTTPTAG_REF(if_modified_since, x)
SOFIAPUBVAR tag_typedef_t httptag_if_modified_since_ref;

#define HTTPTAG_IF_MODIFIED_SINCE_STR_REF(x)        HTTPTAG_STR_REF(if_modified_since, x)
SOFIAPUBVAR tag_typedef_t httptag_if_modified_since_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_if_modified_since_v(http_if_modified_since_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_if_modified_since_vr(http_if_modified_since_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_if_modified_since_v(v)   (tag_value_t)(v)
#define httptag_if_modified_since_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_if_none_match
 *
 * Tag list item for pointer to a If-None-Match header object.
 *
 * The HTTPTAG_IF_NONE_MATCH() macro is used to include a tag item with a
 * pointer to a http_if_none_match_t object in a tag list.
 *
 * @param x pointer to a http_if_none_match_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_IF_NONE_MATCH(x)        	  HTTPTAG(if_none_match, x)

SOFIAPUBVAR tag_typedef_t httptag_if_none_match;

/**@ingroup http_if_none_match
 *
 * Tag list item for string with If-None-Match header value.
 *
 * The HTTPTAG_IF_NONE_MATCH_STR() macro is used to include a tag item with a 
 * string containing value of a http_if_none_match_t header in a tag list.
 *
 * @param s pointer to a string containing http_if_none_match_t value, or NULL.
 *
 * The HTTPTAG_IF_NONE_MATCH_STR string can be converted to a
 * http_if_none_match_t header structure by giving the string @a s has
 * second argument to function http_if_none_match_make().
 *
 * @HIDE
 */
#define HTTPTAG_IF_NONE_MATCH_STR(s)    	  HTTPTAG_STR(if_none_match, s)

SOFIAPUBVAR tag_typedef_t httptag_if_none_match_str;

#define HTTPTAG_IF_NONE_MATCH_REF(x)        	  HTTPTAG_REF(if_none_match, x)
SOFIAPUBVAR tag_typedef_t httptag_if_none_match_ref;

#define HTTPTAG_IF_NONE_MATCH_STR_REF(x)        HTTPTAG_STR_REF(if_none_match, x)
SOFIAPUBVAR tag_typedef_t httptag_if_none_match_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_if_none_match_v(http_if_none_match_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_if_none_match_vr(http_if_none_match_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_if_none_match_v(v)   (tag_value_t)(v)
#define httptag_if_none_match_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_if_range
 *
 * Tag list item for pointer to a If-Range header object.
 *
 * The HTTPTAG_IF_RANGE() macro is used to include a tag item with a
 * pointer to a http_if_range_t object in a tag list.
 *
 * @param x pointer to a http_if_range_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_IF_RANGE(x)        	  HTTPTAG(if_range, x)

SOFIAPUBVAR tag_typedef_t httptag_if_range;

/**@ingroup http_if_range
 *
 * Tag list item for string with If-Range header value.
 *
 * The HTTPTAG_IF_RANGE_STR() macro is used to include a tag item with a 
 * string containing value of a http_if_range_t header in a tag list.
 *
 * @param s pointer to a string containing http_if_range_t value, or NULL.
 *
 * The HTTPTAG_IF_RANGE_STR string can be converted to a
 * http_if_range_t header structure by giving the string @a s has
 * second argument to function http_if_range_make().
 *
 * @HIDE
 */
#define HTTPTAG_IF_RANGE_STR(s)    	  HTTPTAG_STR(if_range, s)

SOFIAPUBVAR tag_typedef_t httptag_if_range_str;

#define HTTPTAG_IF_RANGE_REF(x)        	  HTTPTAG_REF(if_range, x)
SOFIAPUBVAR tag_typedef_t httptag_if_range_ref;

#define HTTPTAG_IF_RANGE_STR_REF(x)        HTTPTAG_STR_REF(if_range, x)
SOFIAPUBVAR tag_typedef_t httptag_if_range_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_if_range_v(http_if_range_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_if_range_vr(http_if_range_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_if_range_v(v)   (tag_value_t)(v)
#define httptag_if_range_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_if_unmodified_since
 *
 * Tag list item for pointer to a If-Unmodified-Since header object.
 *
 * The HTTPTAG_IF_UNMODIFIED_SINCE() macro is used to include a tag item with a
 * pointer to a http_if_unmodified_since_t object in a tag list.
 *
 * @param x pointer to a http_if_unmodified_since_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_IF_UNMODIFIED_SINCE(x)        	  HTTPTAG(if_unmodified_since, x)

SOFIAPUBVAR tag_typedef_t httptag_if_unmodified_since;

/**@ingroup http_if_unmodified_since
 *
 * Tag list item for string with If-Unmodified-Since header value.
 *
 * The HTTPTAG_IF_UNMODIFIED_SINCE_STR() macro is used to include a tag item with a 
 * string containing value of a http_if_unmodified_since_t header in a tag list.
 *
 * @param s pointer to a string containing http_if_unmodified_since_t value, or NULL.
 *
 * The HTTPTAG_IF_UNMODIFIED_SINCE_STR string can be converted to a
 * http_if_unmodified_since_t header structure by giving the string @a s has
 * second argument to function http_if_unmodified_since_make().
 *
 * @HIDE
 */
#define HTTPTAG_IF_UNMODIFIED_SINCE_STR(s)    	  HTTPTAG_STR(if_unmodified_since, s)

SOFIAPUBVAR tag_typedef_t httptag_if_unmodified_since_str;

#define HTTPTAG_IF_UNMODIFIED_SINCE_REF(x)        	  HTTPTAG_REF(if_unmodified_since, x)
SOFIAPUBVAR tag_typedef_t httptag_if_unmodified_since_ref;

#define HTTPTAG_IF_UNMODIFIED_SINCE_STR_REF(x)        HTTPTAG_STR_REF(if_unmodified_since, x)
SOFIAPUBVAR tag_typedef_t httptag_if_unmodified_since_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_if_unmodified_since_v(http_if_unmodified_since_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_if_unmodified_since_vr(http_if_unmodified_since_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_if_unmodified_since_v(v)   (tag_value_t)(v)
#define httptag_if_unmodified_since_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_last_modified
 *
 * Tag list item for pointer to a Last-Modified header object.
 *
 * The HTTPTAG_LAST_MODIFIED() macro is used to include a tag item with a
 * pointer to a http_last_modified_t object in a tag list.
 *
 * @param x pointer to a http_last_modified_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_LAST_MODIFIED(x)        	  HTTPTAG(last_modified, x)

SOFIAPUBVAR tag_typedef_t httptag_last_modified;

/**@ingroup http_last_modified
 *
 * Tag list item for string with Last-Modified header value.
 *
 * The HTTPTAG_LAST_MODIFIED_STR() macro is used to include a tag item with a 
 * string containing value of a http_last_modified_t header in a tag list.
 *
 * @param s pointer to a string containing http_last_modified_t value, or NULL.
 *
 * The HTTPTAG_LAST_MODIFIED_STR string can be converted to a
 * http_last_modified_t header structure by giving the string @a s has
 * second argument to function http_last_modified_make().
 *
 * @HIDE
 */
#define HTTPTAG_LAST_MODIFIED_STR(s)    	  HTTPTAG_STR(last_modified, s)

SOFIAPUBVAR tag_typedef_t httptag_last_modified_str;

#define HTTPTAG_LAST_MODIFIED_REF(x)        	  HTTPTAG_REF(last_modified, x)
SOFIAPUBVAR tag_typedef_t httptag_last_modified_ref;

#define HTTPTAG_LAST_MODIFIED_STR_REF(x)        HTTPTAG_STR_REF(last_modified, x)
SOFIAPUBVAR tag_typedef_t httptag_last_modified_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_last_modified_v(http_last_modified_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_last_modified_vr(http_last_modified_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_last_modified_v(v)   (tag_value_t)(v)
#define httptag_last_modified_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_location
 *
 * Tag list item for pointer to a Location header object.
 *
 * The HTTPTAG_LOCATION() macro is used to include a tag item with a
 * pointer to a http_location_t object in a tag list.
 *
 * @param x pointer to a http_location_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_LOCATION(x)        	  HTTPTAG(location, x)

SOFIAPUBVAR tag_typedef_t httptag_location;

/**@ingroup http_location
 *
 * Tag list item for string with Location header value.
 *
 * The HTTPTAG_LOCATION_STR() macro is used to include a tag item with a 
 * string containing value of a http_location_t header in a tag list.
 *
 * @param s pointer to a string containing http_location_t value, or NULL.
 *
 * The HTTPTAG_LOCATION_STR string can be converted to a
 * http_location_t header structure by giving the string @a s has
 * second argument to function http_location_make().
 *
 * @HIDE
 */
#define HTTPTAG_LOCATION_STR(s)    	  HTTPTAG_STR(location, s)

SOFIAPUBVAR tag_typedef_t httptag_location_str;

#define HTTPTAG_LOCATION_REF(x)        	  HTTPTAG_REF(location, x)
SOFIAPUBVAR tag_typedef_t httptag_location_ref;

#define HTTPTAG_LOCATION_STR_REF(x)        HTTPTAG_STR_REF(location, x)
SOFIAPUBVAR tag_typedef_t httptag_location_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_location_v(http_location_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_location_vr(http_location_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_location_v(v)   (tag_value_t)(v)
#define httptag_location_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_max_forwards
 *
 * Tag list item for pointer to a Max-Forwards header object.
 *
 * The HTTPTAG_MAX_FORWARDS() macro is used to include a tag item with a
 * pointer to a http_max_forwards_t object in a tag list.
 *
 * @param x pointer to a http_max_forwards_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_MAX_FORWARDS(x)        	  HTTPTAG(max_forwards, x)

SOFIAPUBVAR tag_typedef_t httptag_max_forwards;

/**@ingroup http_max_forwards
 *
 * Tag list item for string with Max-Forwards header value.
 *
 * The HTTPTAG_MAX_FORWARDS_STR() macro is used to include a tag item with a 
 * string containing value of a http_max_forwards_t header in a tag list.
 *
 * @param s pointer to a string containing http_max_forwards_t value, or NULL.
 *
 * The HTTPTAG_MAX_FORWARDS_STR string can be converted to a
 * http_max_forwards_t header structure by giving the string @a s has
 * second argument to function http_max_forwards_make().
 *
 * @HIDE
 */
#define HTTPTAG_MAX_FORWARDS_STR(s)    	  HTTPTAG_STR(max_forwards, s)

SOFIAPUBVAR tag_typedef_t httptag_max_forwards_str;

#define HTTPTAG_MAX_FORWARDS_REF(x)        	  HTTPTAG_REF(max_forwards, x)
SOFIAPUBVAR tag_typedef_t httptag_max_forwards_ref;

#define HTTPTAG_MAX_FORWARDS_STR_REF(x)        HTTPTAG_STR_REF(max_forwards, x)
SOFIAPUBVAR tag_typedef_t httptag_max_forwards_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_max_forwards_v(http_max_forwards_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_max_forwards_vr(http_max_forwards_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_max_forwards_v(v)   (tag_value_t)(v)
#define httptag_max_forwards_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_pragma
 *
 * Tag list item for pointer to a Pragma header object.
 *
 * The HTTPTAG_PRAGMA() macro is used to include a tag item with a
 * pointer to a http_pragma_t object in a tag list.
 *
 * @param x pointer to a http_pragma_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_PRAGMA(x)        	  HTTPTAG(pragma, x)

SOFIAPUBVAR tag_typedef_t httptag_pragma;

/**@ingroup http_pragma
 *
 * Tag list item for string with Pragma header value.
 *
 * The HTTPTAG_PRAGMA_STR() macro is used to include a tag item with a 
 * string containing value of a http_pragma_t header in a tag list.
 *
 * @param s pointer to a string containing http_pragma_t value, or NULL.
 *
 * The HTTPTAG_PRAGMA_STR string can be converted to a
 * http_pragma_t header structure by giving the string @a s has
 * second argument to function http_pragma_make().
 *
 * @HIDE
 */
#define HTTPTAG_PRAGMA_STR(s)    	  HTTPTAG_STR(pragma, s)

SOFIAPUBVAR tag_typedef_t httptag_pragma_str;

#define HTTPTAG_PRAGMA_REF(x)        	  HTTPTAG_REF(pragma, x)
SOFIAPUBVAR tag_typedef_t httptag_pragma_ref;

#define HTTPTAG_PRAGMA_STR_REF(x)        HTTPTAG_STR_REF(pragma, x)
SOFIAPUBVAR tag_typedef_t httptag_pragma_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_pragma_v(http_pragma_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_pragma_vr(http_pragma_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_pragma_v(v)   (tag_value_t)(v)
#define httptag_pragma_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_proxy_authenticate
 *
 * Tag list item for pointer to a Proxy-Authenticate header object.
 *
 * The HTTPTAG_PROXY_AUTHENTICATE() macro is used to include a tag item with a
 * pointer to a http_proxy_authenticate_t object in a tag list.
 *
 * @param x pointer to a http_proxy_authenticate_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_PROXY_AUTHENTICATE(x)        	  HTTPTAG(proxy_authenticate, x)

SOFIAPUBVAR tag_typedef_t httptag_proxy_authenticate;

/**@ingroup http_proxy_authenticate
 *
 * Tag list item for string with Proxy-Authenticate header value.
 *
 * The HTTPTAG_PROXY_AUTHENTICATE_STR() macro is used to include a tag item with a 
 * string containing value of a http_proxy_authenticate_t header in a tag list.
 *
 * @param s pointer to a string containing http_proxy_authenticate_t value, or NULL.
 *
 * The HTTPTAG_PROXY_AUTHENTICATE_STR string can be converted to a
 * http_proxy_authenticate_t header structure by giving the string @a s has
 * second argument to function http_proxy_authenticate_make().
 *
 * @HIDE
 */
#define HTTPTAG_PROXY_AUTHENTICATE_STR(s)    	  HTTPTAG_STR(proxy_authenticate, s)

SOFIAPUBVAR tag_typedef_t httptag_proxy_authenticate_str;

#define HTTPTAG_PROXY_AUTHENTICATE_REF(x)        	  HTTPTAG_REF(proxy_authenticate, x)
SOFIAPUBVAR tag_typedef_t httptag_proxy_authenticate_ref;

#define HTTPTAG_PROXY_AUTHENTICATE_STR_REF(x)        HTTPTAG_STR_REF(proxy_authenticate, x)
SOFIAPUBVAR tag_typedef_t httptag_proxy_authenticate_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_proxy_authenticate_v(http_proxy_authenticate_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_proxy_authenticate_vr(http_proxy_authenticate_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_proxy_authenticate_v(v)   (tag_value_t)(v)
#define httptag_proxy_authenticate_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_proxy_authorization
 *
 * Tag list item for pointer to a Proxy-Authorization header object.
 *
 * The HTTPTAG_PROXY_AUTHORIZATION() macro is used to include a tag item with a
 * pointer to a http_proxy_authorization_t object in a tag list.
 *
 * @param x pointer to a http_proxy_authorization_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_PROXY_AUTHORIZATION(x)        	  HTTPTAG(proxy_authorization, x)

SOFIAPUBVAR tag_typedef_t httptag_proxy_authorization;

/**@ingroup http_proxy_authorization
 *
 * Tag list item for string with Proxy-Authorization header value.
 *
 * The HTTPTAG_PROXY_AUTHORIZATION_STR() macro is used to include a tag item with a 
 * string containing value of a http_proxy_authorization_t header in a tag list.
 *
 * @param s pointer to a string containing http_proxy_authorization_t value, or NULL.
 *
 * The HTTPTAG_PROXY_AUTHORIZATION_STR string can be converted to a
 * http_proxy_authorization_t header structure by giving the string @a s has
 * second argument to function http_proxy_authorization_make().
 *
 * @HIDE
 */
#define HTTPTAG_PROXY_AUTHORIZATION_STR(s)    	  HTTPTAG_STR(proxy_authorization, s)

SOFIAPUBVAR tag_typedef_t httptag_proxy_authorization_str;

#define HTTPTAG_PROXY_AUTHORIZATION_REF(x)        	  HTTPTAG_REF(proxy_authorization, x)
SOFIAPUBVAR tag_typedef_t httptag_proxy_authorization_ref;

#define HTTPTAG_PROXY_AUTHORIZATION_STR_REF(x)        HTTPTAG_STR_REF(proxy_authorization, x)
SOFIAPUBVAR tag_typedef_t httptag_proxy_authorization_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_proxy_authorization_v(http_proxy_authorization_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_proxy_authorization_vr(http_proxy_authorization_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_proxy_authorization_v(v)   (tag_value_t)(v)
#define httptag_proxy_authorization_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_range
 *
 * Tag list item for pointer to a Range header object.
 *
 * The HTTPTAG_RANGE() macro is used to include a tag item with a
 * pointer to a http_range_t object in a tag list.
 *
 * @param x pointer to a http_range_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_RANGE(x)        	  HTTPTAG(range, x)

SOFIAPUBVAR tag_typedef_t httptag_range;

/**@ingroup http_range
 *
 * Tag list item for string with Range header value.
 *
 * The HTTPTAG_RANGE_STR() macro is used to include a tag item with a 
 * string containing value of a http_range_t header in a tag list.
 *
 * @param s pointer to a string containing http_range_t value, or NULL.
 *
 * The HTTPTAG_RANGE_STR string can be converted to a
 * http_range_t header structure by giving the string @a s has
 * second argument to function http_range_make().
 *
 * @HIDE
 */
#define HTTPTAG_RANGE_STR(s)    	  HTTPTAG_STR(range, s)

SOFIAPUBVAR tag_typedef_t httptag_range_str;

#define HTTPTAG_RANGE_REF(x)        	  HTTPTAG_REF(range, x)
SOFIAPUBVAR tag_typedef_t httptag_range_ref;

#define HTTPTAG_RANGE_STR_REF(x)        HTTPTAG_STR_REF(range, x)
SOFIAPUBVAR tag_typedef_t httptag_range_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_range_v(http_range_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_range_vr(http_range_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_range_v(v)   (tag_value_t)(v)
#define httptag_range_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_referer
 *
 * Tag list item for pointer to a Referer header object.
 *
 * The HTTPTAG_REFERER() macro is used to include a tag item with a
 * pointer to a http_referer_t object in a tag list.
 *
 * @param x pointer to a http_referer_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_REFERER(x)        	  HTTPTAG(referer, x)

SOFIAPUBVAR tag_typedef_t httptag_referer;

/**@ingroup http_referer
 *
 * Tag list item for string with Referer header value.
 *
 * The HTTPTAG_REFERER_STR() macro is used to include a tag item with a 
 * string containing value of a http_referer_t header in a tag list.
 *
 * @param s pointer to a string containing http_referer_t value, or NULL.
 *
 * The HTTPTAG_REFERER_STR string can be converted to a
 * http_referer_t header structure by giving the string @a s has
 * second argument to function http_referer_make().
 *
 * @HIDE
 */
#define HTTPTAG_REFERER_STR(s)    	  HTTPTAG_STR(referer, s)

SOFIAPUBVAR tag_typedef_t httptag_referer_str;

#define HTTPTAG_REFERER_REF(x)        	  HTTPTAG_REF(referer, x)
SOFIAPUBVAR tag_typedef_t httptag_referer_ref;

#define HTTPTAG_REFERER_STR_REF(x)        HTTPTAG_STR_REF(referer, x)
SOFIAPUBVAR tag_typedef_t httptag_referer_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_referer_v(http_referer_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_referer_vr(http_referer_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_referer_v(v)   (tag_value_t)(v)
#define httptag_referer_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_retry_after
 *
 * Tag list item for pointer to a Retry-After header object.
 *
 * The HTTPTAG_RETRY_AFTER() macro is used to include a tag item with a
 * pointer to a http_retry_after_t object in a tag list.
 *
 * @param x pointer to a http_retry_after_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_RETRY_AFTER(x)        	  HTTPTAG(retry_after, x)

SOFIAPUBVAR tag_typedef_t httptag_retry_after;

/**@ingroup http_retry_after
 *
 * Tag list item for string with Retry-After header value.
 *
 * The HTTPTAG_RETRY_AFTER_STR() macro is used to include a tag item with a 
 * string containing value of a http_retry_after_t header in a tag list.
 *
 * @param s pointer to a string containing http_retry_after_t value, or NULL.
 *
 * The HTTPTAG_RETRY_AFTER_STR string can be converted to a
 * http_retry_after_t header structure by giving the string @a s has
 * second argument to function http_retry_after_make().
 *
 * @HIDE
 */
#define HTTPTAG_RETRY_AFTER_STR(s)    	  HTTPTAG_STR(retry_after, s)

SOFIAPUBVAR tag_typedef_t httptag_retry_after_str;

#define HTTPTAG_RETRY_AFTER_REF(x)        	  HTTPTAG_REF(retry_after, x)
SOFIAPUBVAR tag_typedef_t httptag_retry_after_ref;

#define HTTPTAG_RETRY_AFTER_STR_REF(x)        HTTPTAG_STR_REF(retry_after, x)
SOFIAPUBVAR tag_typedef_t httptag_retry_after_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_retry_after_v(http_retry_after_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_retry_after_vr(http_retry_after_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_retry_after_v(v)   (tag_value_t)(v)
#define httptag_retry_after_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_server
 *
 * Tag list item for pointer to a Server header object.
 *
 * The HTTPTAG_SERVER() macro is used to include a tag item with a
 * pointer to a http_server_t object in a tag list.
 *
 * @param x pointer to a http_server_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_SERVER(x)        	  HTTPTAG(server, x)

SOFIAPUBVAR tag_typedef_t httptag_server;

/**@ingroup http_server
 *
 * Tag list item for string with Server header value.
 *
 * The HTTPTAG_SERVER_STR() macro is used to include a tag item with a 
 * string containing value of a http_server_t header in a tag list.
 *
 * @param s pointer to a string containing http_server_t value, or NULL.
 *
 * The HTTPTAG_SERVER_STR string can be converted to a
 * http_server_t header structure by giving the string @a s has
 * second argument to function http_server_make().
 *
 * @HIDE
 */
#define HTTPTAG_SERVER_STR(s)    	  HTTPTAG_STR(server, s)

SOFIAPUBVAR tag_typedef_t httptag_server_str;

#define HTTPTAG_SERVER_REF(x)        	  HTTPTAG_REF(server, x)
SOFIAPUBVAR tag_typedef_t httptag_server_ref;

#define HTTPTAG_SERVER_STR_REF(x)        HTTPTAG_STR_REF(server, x)
SOFIAPUBVAR tag_typedef_t httptag_server_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_server_v(http_server_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_server_vr(http_server_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_server_v(v)   (tag_value_t)(v)
#define httptag_server_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_te
 *
 * Tag list item for pointer to a TE header object.
 *
 * The HTTPTAG_TE() macro is used to include a tag item with a
 * pointer to a http_te_t object in a tag list.
 *
 * @param x pointer to a http_te_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_TE(x)        	  HTTPTAG(te, x)

SOFIAPUBVAR tag_typedef_t httptag_te;

/**@ingroup http_te
 *
 * Tag list item for string with TE header value.
 *
 * The HTTPTAG_TE_STR() macro is used to include a tag item with a 
 * string containing value of a http_te_t header in a tag list.
 *
 * @param s pointer to a string containing http_te_t value, or NULL.
 *
 * The HTTPTAG_TE_STR string can be converted to a
 * http_te_t header structure by giving the string @a s has
 * second argument to function http_te_make().
 *
 * @HIDE
 */
#define HTTPTAG_TE_STR(s)    	  HTTPTAG_STR(te, s)

SOFIAPUBVAR tag_typedef_t httptag_te_str;

#define HTTPTAG_TE_REF(x)        	  HTTPTAG_REF(te, x)
SOFIAPUBVAR tag_typedef_t httptag_te_ref;

#define HTTPTAG_TE_STR_REF(x)        HTTPTAG_STR_REF(te, x)
SOFIAPUBVAR tag_typedef_t httptag_te_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_te_v(http_te_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_te_vr(http_te_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_te_v(v)   (tag_value_t)(v)
#define httptag_te_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_trailer
 *
 * Tag list item for pointer to a Trailer header object.
 *
 * The HTTPTAG_TRAILER() macro is used to include a tag item with a
 * pointer to a http_trailer_t object in a tag list.
 *
 * @param x pointer to a http_trailer_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_TRAILER(x)        	  HTTPTAG(trailer, x)

SOFIAPUBVAR tag_typedef_t httptag_trailer;

/**@ingroup http_trailer
 *
 * Tag list item for string with Trailer header value.
 *
 * The HTTPTAG_TRAILER_STR() macro is used to include a tag item with a 
 * string containing value of a http_trailer_t header in a tag list.
 *
 * @param s pointer to a string containing http_trailer_t value, or NULL.
 *
 * The HTTPTAG_TRAILER_STR string can be converted to a
 * http_trailer_t header structure by giving the string @a s has
 * second argument to function http_trailer_make().
 *
 * @HIDE
 */
#define HTTPTAG_TRAILER_STR(s)    	  HTTPTAG_STR(trailer, s)

SOFIAPUBVAR tag_typedef_t httptag_trailer_str;

#define HTTPTAG_TRAILER_REF(x)        	  HTTPTAG_REF(trailer, x)
SOFIAPUBVAR tag_typedef_t httptag_trailer_ref;

#define HTTPTAG_TRAILER_STR_REF(x)        HTTPTAG_STR_REF(trailer, x)
SOFIAPUBVAR tag_typedef_t httptag_trailer_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_trailer_v(http_trailer_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_trailer_vr(http_trailer_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_trailer_v(v)   (tag_value_t)(v)
#define httptag_trailer_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_transfer_encoding
 *
 * Tag list item for pointer to a Transfer-Encoding header object.
 *
 * The HTTPTAG_TRANSFER_ENCODING() macro is used to include a tag item with a
 * pointer to a http_transfer_encoding_t object in a tag list.
 *
 * @param x pointer to a http_transfer_encoding_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_TRANSFER_ENCODING(x)        	  HTTPTAG(transfer_encoding, x)

SOFIAPUBVAR tag_typedef_t httptag_transfer_encoding;

/**@ingroup http_transfer_encoding
 *
 * Tag list item for string with Transfer-Encoding header value.
 *
 * The HTTPTAG_TRANSFER_ENCODING_STR() macro is used to include a tag item with a 
 * string containing value of a http_transfer_encoding_t header in a tag list.
 *
 * @param s pointer to a string containing http_transfer_encoding_t value, or NULL.
 *
 * The HTTPTAG_TRANSFER_ENCODING_STR string can be converted to a
 * http_transfer_encoding_t header structure by giving the string @a s has
 * second argument to function http_transfer_encoding_make().
 *
 * @HIDE
 */
#define HTTPTAG_TRANSFER_ENCODING_STR(s)    	  HTTPTAG_STR(transfer_encoding, s)

SOFIAPUBVAR tag_typedef_t httptag_transfer_encoding_str;

#define HTTPTAG_TRANSFER_ENCODING_REF(x)        	  HTTPTAG_REF(transfer_encoding, x)
SOFIAPUBVAR tag_typedef_t httptag_transfer_encoding_ref;

#define HTTPTAG_TRANSFER_ENCODING_STR_REF(x)        HTTPTAG_STR_REF(transfer_encoding, x)
SOFIAPUBVAR tag_typedef_t httptag_transfer_encoding_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_transfer_encoding_v(http_transfer_encoding_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_transfer_encoding_vr(http_transfer_encoding_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_transfer_encoding_v(v)   (tag_value_t)(v)
#define httptag_transfer_encoding_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_upgrade
 *
 * Tag list item for pointer to a Upgrade header object.
 *
 * The HTTPTAG_UPGRADE() macro is used to include a tag item with a
 * pointer to a http_upgrade_t object in a tag list.
 *
 * @param x pointer to a http_upgrade_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_UPGRADE(x)        	  HTTPTAG(upgrade, x)

SOFIAPUBVAR tag_typedef_t httptag_upgrade;

/**@ingroup http_upgrade
 *
 * Tag list item for string with Upgrade header value.
 *
 * The HTTPTAG_UPGRADE_STR() macro is used to include a tag item with a 
 * string containing value of a http_upgrade_t header in a tag list.
 *
 * @param s pointer to a string containing http_upgrade_t value, or NULL.
 *
 * The HTTPTAG_UPGRADE_STR string can be converted to a
 * http_upgrade_t header structure by giving the string @a s has
 * second argument to function http_upgrade_make().
 *
 * @HIDE
 */
#define HTTPTAG_UPGRADE_STR(s)    	  HTTPTAG_STR(upgrade, s)

SOFIAPUBVAR tag_typedef_t httptag_upgrade_str;

#define HTTPTAG_UPGRADE_REF(x)        	  HTTPTAG_REF(upgrade, x)
SOFIAPUBVAR tag_typedef_t httptag_upgrade_ref;

#define HTTPTAG_UPGRADE_STR_REF(x)        HTTPTAG_STR_REF(upgrade, x)
SOFIAPUBVAR tag_typedef_t httptag_upgrade_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_upgrade_v(http_upgrade_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_upgrade_vr(http_upgrade_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_upgrade_v(v)   (tag_value_t)(v)
#define httptag_upgrade_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_user_agent
 *
 * Tag list item for pointer to a User-Agent header object.
 *
 * The HTTPTAG_USER_AGENT() macro is used to include a tag item with a
 * pointer to a http_user_agent_t object in a tag list.
 *
 * @param x pointer to a http_user_agent_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_USER_AGENT(x)        	  HTTPTAG(user_agent, x)

SOFIAPUBVAR tag_typedef_t httptag_user_agent;

/**@ingroup http_user_agent
 *
 * Tag list item for string with User-Agent header value.
 *
 * The HTTPTAG_USER_AGENT_STR() macro is used to include a tag item with a 
 * string containing value of a http_user_agent_t header in a tag list.
 *
 * @param s pointer to a string containing http_user_agent_t value, or NULL.
 *
 * The HTTPTAG_USER_AGENT_STR string can be converted to a
 * http_user_agent_t header structure by giving the string @a s has
 * second argument to function http_user_agent_make().
 *
 * @HIDE
 */
#define HTTPTAG_USER_AGENT_STR(s)    	  HTTPTAG_STR(user_agent, s)

SOFIAPUBVAR tag_typedef_t httptag_user_agent_str;

#define HTTPTAG_USER_AGENT_REF(x)        	  HTTPTAG_REF(user_agent, x)
SOFIAPUBVAR tag_typedef_t httptag_user_agent_ref;

#define HTTPTAG_USER_AGENT_STR_REF(x)        HTTPTAG_STR_REF(user_agent, x)
SOFIAPUBVAR tag_typedef_t httptag_user_agent_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_user_agent_v(http_user_agent_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_user_agent_vr(http_user_agent_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_user_agent_v(v)   (tag_value_t)(v)
#define httptag_user_agent_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_vary
 *
 * Tag list item for pointer to a Vary header object.
 *
 * The HTTPTAG_VARY() macro is used to include a tag item with a
 * pointer to a http_vary_t object in a tag list.
 *
 * @param x pointer to a http_vary_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_VARY(x)        	  HTTPTAG(vary, x)

SOFIAPUBVAR tag_typedef_t httptag_vary;

/**@ingroup http_vary
 *
 * Tag list item for string with Vary header value.
 *
 * The HTTPTAG_VARY_STR() macro is used to include a tag item with a 
 * string containing value of a http_vary_t header in a tag list.
 *
 * @param s pointer to a string containing http_vary_t value, or NULL.
 *
 * The HTTPTAG_VARY_STR string can be converted to a
 * http_vary_t header structure by giving the string @a s has
 * second argument to function http_vary_make().
 *
 * @HIDE
 */
#define HTTPTAG_VARY_STR(s)    	  HTTPTAG_STR(vary, s)

SOFIAPUBVAR tag_typedef_t httptag_vary_str;

#define HTTPTAG_VARY_REF(x)        	  HTTPTAG_REF(vary, x)
SOFIAPUBVAR tag_typedef_t httptag_vary_ref;

#define HTTPTAG_VARY_STR_REF(x)        HTTPTAG_STR_REF(vary, x)
SOFIAPUBVAR tag_typedef_t httptag_vary_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_vary_v(http_vary_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_vary_vr(http_vary_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_vary_v(v)   (tag_value_t)(v)
#define httptag_vary_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_via
 *
 * Tag list item for pointer to a Via header object.
 *
 * The HTTPTAG_VIA() macro is used to include a tag item with a
 * pointer to a http_via_t object in a tag list.
 *
 * @param x pointer to a http_via_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_VIA(x)        	  HTTPTAG(via, x)

SOFIAPUBVAR tag_typedef_t httptag_via;

/**@ingroup http_via
 *
 * Tag list item for string with Via header value.
 *
 * The HTTPTAG_VIA_STR() macro is used to include a tag item with a 
 * string containing value of a http_via_t header in a tag list.
 *
 * @param s pointer to a string containing http_via_t value, or NULL.
 *
 * The HTTPTAG_VIA_STR string can be converted to a
 * http_via_t header structure by giving the string @a s has
 * second argument to function http_via_make().
 *
 * @HIDE
 */
#define HTTPTAG_VIA_STR(s)    	  HTTPTAG_STR(via, s)

SOFIAPUBVAR tag_typedef_t httptag_via_str;

#define HTTPTAG_VIA_REF(x)        	  HTTPTAG_REF(via, x)
SOFIAPUBVAR tag_typedef_t httptag_via_ref;

#define HTTPTAG_VIA_STR_REF(x)        HTTPTAG_STR_REF(via, x)
SOFIAPUBVAR tag_typedef_t httptag_via_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_via_v(http_via_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_via_vr(http_via_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_via_v(v)   (tag_value_t)(v)
#define httptag_via_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_warning
 *
 * Tag list item for pointer to a Warning header object.
 *
 * The HTTPTAG_WARNING() macro is used to include a tag item with a
 * pointer to a http_warning_t object in a tag list.
 *
 * @param x pointer to a http_warning_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_WARNING(x)        	  HTTPTAG(warning, x)

SOFIAPUBVAR tag_typedef_t httptag_warning;

/**@ingroup http_warning
 *
 * Tag list item for string with Warning header value.
 *
 * The HTTPTAG_WARNING_STR() macro is used to include a tag item with a 
 * string containing value of a http_warning_t header in a tag list.
 *
 * @param s pointer to a string containing http_warning_t value, or NULL.
 *
 * The HTTPTAG_WARNING_STR string can be converted to a
 * http_warning_t header structure by giving the string @a s has
 * second argument to function http_warning_make().
 *
 * @HIDE
 */
#define HTTPTAG_WARNING_STR(s)    	  HTTPTAG_STR(warning, s)

SOFIAPUBVAR tag_typedef_t httptag_warning_str;

#define HTTPTAG_WARNING_REF(x)        	  HTTPTAG_REF(warning, x)
SOFIAPUBVAR tag_typedef_t httptag_warning_ref;

#define HTTPTAG_WARNING_STR_REF(x)        HTTPTAG_STR_REF(warning, x)
SOFIAPUBVAR tag_typedef_t httptag_warning_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_warning_v(http_warning_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_warning_vr(http_warning_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_warning_v(v)   (tag_value_t)(v)
#define httptag_warning_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_www_authenticate
 *
 * Tag list item for pointer to a WWW-Authenticate header object.
 *
 * The HTTPTAG_WWW_AUTHENTICATE() macro is used to include a tag item with a
 * pointer to a http_www_authenticate_t object in a tag list.
 *
 * @param x pointer to a http_www_authenticate_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_WWW_AUTHENTICATE(x)        	  HTTPTAG(www_authenticate, x)

SOFIAPUBVAR tag_typedef_t httptag_www_authenticate;

/**@ingroup http_www_authenticate
 *
 * Tag list item for string with WWW-Authenticate header value.
 *
 * The HTTPTAG_WWW_AUTHENTICATE_STR() macro is used to include a tag item with a 
 * string containing value of a http_www_authenticate_t header in a tag list.
 *
 * @param s pointer to a string containing http_www_authenticate_t value, or NULL.
 *
 * The HTTPTAG_WWW_AUTHENTICATE_STR string can be converted to a
 * http_www_authenticate_t header structure by giving the string @a s has
 * second argument to function http_www_authenticate_make().
 *
 * @HIDE
 */
#define HTTPTAG_WWW_AUTHENTICATE_STR(s)    	  HTTPTAG_STR(www_authenticate, s)

SOFIAPUBVAR tag_typedef_t httptag_www_authenticate_str;

#define HTTPTAG_WWW_AUTHENTICATE_REF(x)        	  HTTPTAG_REF(www_authenticate, x)
SOFIAPUBVAR tag_typedef_t httptag_www_authenticate_ref;

#define HTTPTAG_WWW_AUTHENTICATE_STR_REF(x)        HTTPTAG_STR_REF(www_authenticate, x)
SOFIAPUBVAR tag_typedef_t httptag_www_authenticate_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_www_authenticate_v(http_www_authenticate_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_www_authenticate_vr(http_www_authenticate_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_www_authenticate_v(v)   (tag_value_t)(v)
#define httptag_www_authenticate_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_proxy_connection
 *
 * Tag list item for pointer to a Proxy-Connection header object.
 *
 * The HTTPTAG_PROXY_CONNECTION() macro is used to include a tag item with a
 * pointer to a http_proxy_connection_t object in a tag list.
 *
 * @param x pointer to a http_proxy_connection_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_PROXY_CONNECTION(x)        	  HTTPTAG(proxy_connection, x)

SOFIAPUBVAR tag_typedef_t httptag_proxy_connection;

/**@ingroup http_proxy_connection
 *
 * Tag list item for string with Proxy-Connection header value.
 *
 * The HTTPTAG_PROXY_CONNECTION_STR() macro is used to include a tag item with a 
 * string containing value of a http_proxy_connection_t header in a tag list.
 *
 * @param s pointer to a string containing http_proxy_connection_t value, or NULL.
 *
 * The HTTPTAG_PROXY_CONNECTION_STR string can be converted to a
 * http_proxy_connection_t header structure by giving the string @a s has
 * second argument to function http_proxy_connection_make().
 *
 * @HIDE
 */
#define HTTPTAG_PROXY_CONNECTION_STR(s)    	  HTTPTAG_STR(proxy_connection, s)

SOFIAPUBVAR tag_typedef_t httptag_proxy_connection_str;

#define HTTPTAG_PROXY_CONNECTION_REF(x)        	  HTTPTAG_REF(proxy_connection, x)
SOFIAPUBVAR tag_typedef_t httptag_proxy_connection_ref;

#define HTTPTAG_PROXY_CONNECTION_STR_REF(x)        HTTPTAG_STR_REF(proxy_connection, x)
SOFIAPUBVAR tag_typedef_t httptag_proxy_connection_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_proxy_connection_v(http_proxy_connection_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_proxy_connection_vr(http_proxy_connection_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_proxy_connection_v(v)   (tag_value_t)(v)
#define httptag_proxy_connection_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_set_cookie
 *
 * Tag list item for pointer to a Set-Cookie header object.
 *
 * The HTTPTAG_SET_COOKIE() macro is used to include a tag item with a
 * pointer to a http_set_cookie_t object in a tag list.
 *
 * @param x pointer to a http_set_cookie_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_SET_COOKIE(x)        	  HTTPTAG(set_cookie, x)

SOFIAPUBVAR tag_typedef_t httptag_set_cookie;

/**@ingroup http_set_cookie
 *
 * Tag list item for string with Set-Cookie header value.
 *
 * The HTTPTAG_SET_COOKIE_STR() macro is used to include a tag item with a 
 * string containing value of a http_set_cookie_t header in a tag list.
 *
 * @param s pointer to a string containing http_set_cookie_t value, or NULL.
 *
 * The HTTPTAG_SET_COOKIE_STR string can be converted to a
 * http_set_cookie_t header structure by giving the string @a s has
 * second argument to function http_set_cookie_make().
 *
 * @HIDE
 */
#define HTTPTAG_SET_COOKIE_STR(s)    	  HTTPTAG_STR(set_cookie, s)

SOFIAPUBVAR tag_typedef_t httptag_set_cookie_str;

#define HTTPTAG_SET_COOKIE_REF(x)        	  HTTPTAG_REF(set_cookie, x)
SOFIAPUBVAR tag_typedef_t httptag_set_cookie_ref;

#define HTTPTAG_SET_COOKIE_STR_REF(x)        HTTPTAG_STR_REF(set_cookie, x)
SOFIAPUBVAR tag_typedef_t httptag_set_cookie_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_set_cookie_v(http_set_cookie_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_set_cookie_vr(http_set_cookie_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_set_cookie_v(v)   (tag_value_t)(v)
#define httptag_set_cookie_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_cookie
 *
 * Tag list item for pointer to a Cookie header object.
 *
 * The HTTPTAG_COOKIE() macro is used to include a tag item with a
 * pointer to a http_cookie_t object in a tag list.
 *
 * @param x pointer to a http_cookie_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_COOKIE(x)        	  HTTPTAG(cookie, x)

SOFIAPUBVAR tag_typedef_t httptag_cookie;

/**@ingroup http_cookie
 *
 * Tag list item for string with Cookie header value.
 *
 * The HTTPTAG_COOKIE_STR() macro is used to include a tag item with a 
 * string containing value of a http_cookie_t header in a tag list.
 *
 * @param s pointer to a string containing http_cookie_t value, or NULL.
 *
 * The HTTPTAG_COOKIE_STR string can be converted to a
 * http_cookie_t header structure by giving the string @a s has
 * second argument to function http_cookie_make().
 *
 * @HIDE
 */
#define HTTPTAG_COOKIE_STR(s)    	  HTTPTAG_STR(cookie, s)

SOFIAPUBVAR tag_typedef_t httptag_cookie_str;

#define HTTPTAG_COOKIE_REF(x)        	  HTTPTAG_REF(cookie, x)
SOFIAPUBVAR tag_typedef_t httptag_cookie_ref;

#define HTTPTAG_COOKIE_STR_REF(x)        HTTPTAG_STR_REF(cookie, x)
SOFIAPUBVAR tag_typedef_t httptag_cookie_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_cookie_v(http_cookie_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_cookie_vr(http_cookie_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_cookie_v(v)   (tag_value_t)(v)
#define httptag_cookie_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_mime_version
 *
 * Tag list item for pointer to a MIME-Version header object.
 *
 * The HTTPTAG_MIME_VERSION() macro is used to include a tag item with a
 * pointer to a http_mime_version_t object in a tag list.
 *
 * @param x pointer to a http_mime_version_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_MIME_VERSION(x)        	  HTTPTAG(mime_version, x)

SOFIAPUBVAR tag_typedef_t httptag_mime_version;

/**@ingroup http_mime_version
 *
 * Tag list item for string with MIME-Version header value.
 *
 * The HTTPTAG_MIME_VERSION_STR() macro is used to include a tag item with a 
 * string containing value of a http_mime_version_t header in a tag list.
 *
 * @param s pointer to a string containing http_mime_version_t value, or NULL.
 *
 * The HTTPTAG_MIME_VERSION_STR string can be converted to a
 * http_mime_version_t header structure by giving the string @a s has
 * second argument to function http_mime_version_make().
 *
 * @HIDE
 */
#define HTTPTAG_MIME_VERSION_STR(s)    	  HTTPTAG_STR(mime_version, s)

SOFIAPUBVAR tag_typedef_t httptag_mime_version_str;

#define HTTPTAG_MIME_VERSION_REF(x)        	  HTTPTAG_REF(mime_version, x)
SOFIAPUBVAR tag_typedef_t httptag_mime_version_ref;

#define HTTPTAG_MIME_VERSION_STR_REF(x)        HTTPTAG_STR_REF(mime_version, x)
SOFIAPUBVAR tag_typedef_t httptag_mime_version_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_mime_version_v(http_mime_version_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_mime_version_vr(http_mime_version_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_mime_version_v(v)   (tag_value_t)(v)
#define httptag_mime_version_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_content_encoding
 *
 * Tag list item for pointer to a Content-Encoding header object.
 *
 * The HTTPTAG_CONTENT_ENCODING() macro is used to include a tag item with a
 * pointer to a http_content_encoding_t object in a tag list.
 *
 * @param x pointer to a http_content_encoding_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_CONTENT_ENCODING(x)        	  HTTPTAG(content_encoding, x)

SOFIAPUBVAR tag_typedef_t httptag_content_encoding;

/**@ingroup http_content_encoding
 *
 * Tag list item for string with Content-Encoding header value.
 *
 * The HTTPTAG_CONTENT_ENCODING_STR() macro is used to include a tag item with a 
 * string containing value of a http_content_encoding_t header in a tag list.
 *
 * @param s pointer to a string containing http_content_encoding_t value, or NULL.
 *
 * The HTTPTAG_CONTENT_ENCODING_STR string can be converted to a
 * http_content_encoding_t header structure by giving the string @a s has
 * second argument to function http_content_encoding_make().
 *
 * @HIDE
 */
#define HTTPTAG_CONTENT_ENCODING_STR(s)    	  HTTPTAG_STR(content_encoding, s)

SOFIAPUBVAR tag_typedef_t httptag_content_encoding_str;

#define HTTPTAG_CONTENT_ENCODING_REF(x)        	  HTTPTAG_REF(content_encoding, x)
SOFIAPUBVAR tag_typedef_t httptag_content_encoding_ref;

#define HTTPTAG_CONTENT_ENCODING_STR_REF(x)        HTTPTAG_STR_REF(content_encoding, x)
SOFIAPUBVAR tag_typedef_t httptag_content_encoding_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_content_encoding_v(http_content_encoding_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_content_encoding_vr(http_content_encoding_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_content_encoding_v(v)   (tag_value_t)(v)
#define httptag_content_encoding_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_content_language
 *
 * Tag list item for pointer to a Content-Language header object.
 *
 * The HTTPTAG_CONTENT_LANGUAGE() macro is used to include a tag item with a
 * pointer to a http_content_language_t object in a tag list.
 *
 * @param x pointer to a http_content_language_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_CONTENT_LANGUAGE(x)        	  HTTPTAG(content_language, x)

SOFIAPUBVAR tag_typedef_t httptag_content_language;

/**@ingroup http_content_language
 *
 * Tag list item for string with Content-Language header value.
 *
 * The HTTPTAG_CONTENT_LANGUAGE_STR() macro is used to include a tag item with a 
 * string containing value of a http_content_language_t header in a tag list.
 *
 * @param s pointer to a string containing http_content_language_t value, or NULL.
 *
 * The HTTPTAG_CONTENT_LANGUAGE_STR string can be converted to a
 * http_content_language_t header structure by giving the string @a s has
 * second argument to function http_content_language_make().
 *
 * @HIDE
 */
#define HTTPTAG_CONTENT_LANGUAGE_STR(s)    	  HTTPTAG_STR(content_language, s)

SOFIAPUBVAR tag_typedef_t httptag_content_language_str;

#define HTTPTAG_CONTENT_LANGUAGE_REF(x)        	  HTTPTAG_REF(content_language, x)
SOFIAPUBVAR tag_typedef_t httptag_content_language_ref;

#define HTTPTAG_CONTENT_LANGUAGE_STR_REF(x)        HTTPTAG_STR_REF(content_language, x)
SOFIAPUBVAR tag_typedef_t httptag_content_language_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_content_language_v(http_content_language_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_content_language_vr(http_content_language_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_content_language_v(v)   (tag_value_t)(v)
#define httptag_content_language_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_content_length
 *
 * Tag list item for pointer to a Content-Length header object.
 *
 * The HTTPTAG_CONTENT_LENGTH() macro is used to include a tag item with a
 * pointer to a http_content_length_t object in a tag list.
 *
 * @param x pointer to a http_content_length_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_CONTENT_LENGTH(x)        	  HTTPTAG(content_length, x)

SOFIAPUBVAR tag_typedef_t httptag_content_length;

/**@ingroup http_content_length
 *
 * Tag list item for string with Content-Length header value.
 *
 * The HTTPTAG_CONTENT_LENGTH_STR() macro is used to include a tag item with a 
 * string containing value of a http_content_length_t header in a tag list.
 *
 * @param s pointer to a string containing http_content_length_t value, or NULL.
 *
 * The HTTPTAG_CONTENT_LENGTH_STR string can be converted to a
 * http_content_length_t header structure by giving the string @a s has
 * second argument to function http_content_length_make().
 *
 * @HIDE
 */
#define HTTPTAG_CONTENT_LENGTH_STR(s)    	  HTTPTAG_STR(content_length, s)

SOFIAPUBVAR tag_typedef_t httptag_content_length_str;

#define HTTPTAG_CONTENT_LENGTH_REF(x)        	  HTTPTAG_REF(content_length, x)
SOFIAPUBVAR tag_typedef_t httptag_content_length_ref;

#define HTTPTAG_CONTENT_LENGTH_STR_REF(x)        HTTPTAG_STR_REF(content_length, x)
SOFIAPUBVAR tag_typedef_t httptag_content_length_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_content_length_v(http_content_length_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_content_length_vr(http_content_length_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_content_length_v(v)   (tag_value_t)(v)
#define httptag_content_length_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_content_location
 *
 * Tag list item for pointer to a Content-Location header object.
 *
 * The HTTPTAG_CONTENT_LOCATION() macro is used to include a tag item with a
 * pointer to a http_content_location_t object in a tag list.
 *
 * @param x pointer to a http_content_location_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_CONTENT_LOCATION(x)        	  HTTPTAG(content_location, x)

SOFIAPUBVAR tag_typedef_t httptag_content_location;

/**@ingroup http_content_location
 *
 * Tag list item for string with Content-Location header value.
 *
 * The HTTPTAG_CONTENT_LOCATION_STR() macro is used to include a tag item with a 
 * string containing value of a http_content_location_t header in a tag list.
 *
 * @param s pointer to a string containing http_content_location_t value, or NULL.
 *
 * The HTTPTAG_CONTENT_LOCATION_STR string can be converted to a
 * http_content_location_t header structure by giving the string @a s has
 * second argument to function http_content_location_make().
 *
 * @HIDE
 */
#define HTTPTAG_CONTENT_LOCATION_STR(s)    	  HTTPTAG_STR(content_location, s)

SOFIAPUBVAR tag_typedef_t httptag_content_location_str;

#define HTTPTAG_CONTENT_LOCATION_REF(x)        	  HTTPTAG_REF(content_location, x)
SOFIAPUBVAR tag_typedef_t httptag_content_location_ref;

#define HTTPTAG_CONTENT_LOCATION_STR_REF(x)        HTTPTAG_STR_REF(content_location, x)
SOFIAPUBVAR tag_typedef_t httptag_content_location_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_content_location_v(http_content_location_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_content_location_vr(http_content_location_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_content_location_v(v)   (tag_value_t)(v)
#define httptag_content_location_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_content_md5
 *
 * Tag list item for pointer to a Content-MD5 header object.
 *
 * The HTTPTAG_CONTENT_MD5() macro is used to include a tag item with a
 * pointer to a http_content_md5_t object in a tag list.
 *
 * @param x pointer to a http_content_md5_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_CONTENT_MD5(x)        	  HTTPTAG(content_md5, x)

SOFIAPUBVAR tag_typedef_t httptag_content_md5;

/**@ingroup http_content_md5
 *
 * Tag list item for string with Content-MD5 header value.
 *
 * The HTTPTAG_CONTENT_MD5_STR() macro is used to include a tag item with a 
 * string containing value of a http_content_md5_t header in a tag list.
 *
 * @param s pointer to a string containing http_content_md5_t value, or NULL.
 *
 * The HTTPTAG_CONTENT_MD5_STR string can be converted to a
 * http_content_md5_t header structure by giving the string @a s has
 * second argument to function http_content_md5_make().
 *
 * @HIDE
 */
#define HTTPTAG_CONTENT_MD5_STR(s)    	  HTTPTAG_STR(content_md5, s)

SOFIAPUBVAR tag_typedef_t httptag_content_md5_str;

#define HTTPTAG_CONTENT_MD5_REF(x)        	  HTTPTAG_REF(content_md5, x)
SOFIAPUBVAR tag_typedef_t httptag_content_md5_ref;

#define HTTPTAG_CONTENT_MD5_STR_REF(x)        HTTPTAG_STR_REF(content_md5, x)
SOFIAPUBVAR tag_typedef_t httptag_content_md5_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_content_md5_v(http_content_md5_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_content_md5_vr(http_content_md5_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_content_md5_v(v)   (tag_value_t)(v)
#define httptag_content_md5_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_content_range
 *
 * Tag list item for pointer to a Content-Range header object.
 *
 * The HTTPTAG_CONTENT_RANGE() macro is used to include a tag item with a
 * pointer to a http_content_range_t object in a tag list.
 *
 * @param x pointer to a http_content_range_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_CONTENT_RANGE(x)        	  HTTPTAG(content_range, x)

SOFIAPUBVAR tag_typedef_t httptag_content_range;

/**@ingroup http_content_range
 *
 * Tag list item for string with Content-Range header value.
 *
 * The HTTPTAG_CONTENT_RANGE_STR() macro is used to include a tag item with a 
 * string containing value of a http_content_range_t header in a tag list.
 *
 * @param s pointer to a string containing http_content_range_t value, or NULL.
 *
 * The HTTPTAG_CONTENT_RANGE_STR string can be converted to a
 * http_content_range_t header structure by giving the string @a s has
 * second argument to function http_content_range_make().
 *
 * @HIDE
 */
#define HTTPTAG_CONTENT_RANGE_STR(s)    	  HTTPTAG_STR(content_range, s)

SOFIAPUBVAR tag_typedef_t httptag_content_range_str;

#define HTTPTAG_CONTENT_RANGE_REF(x)        	  HTTPTAG_REF(content_range, x)
SOFIAPUBVAR tag_typedef_t httptag_content_range_ref;

#define HTTPTAG_CONTENT_RANGE_STR_REF(x)        HTTPTAG_STR_REF(content_range, x)
SOFIAPUBVAR tag_typedef_t httptag_content_range_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_content_range_v(http_content_range_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_content_range_vr(http_content_range_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_content_range_v(v)   (tag_value_t)(v)
#define httptag_content_range_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_content_type
 *
 * Tag list item for pointer to a Content-Type header object.
 *
 * The HTTPTAG_CONTENT_TYPE() macro is used to include a tag item with a
 * pointer to a http_content_type_t object in a tag list.
 *
 * @param x pointer to a http_content_type_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_CONTENT_TYPE(x)        	  HTTPTAG(content_type, x)

SOFIAPUBVAR tag_typedef_t httptag_content_type;

/**@ingroup http_content_type
 *
 * Tag list item for string with Content-Type header value.
 *
 * The HTTPTAG_CONTENT_TYPE_STR() macro is used to include a tag item with a 
 * string containing value of a http_content_type_t header in a tag list.
 *
 * @param s pointer to a string containing http_content_type_t value, or NULL.
 *
 * The HTTPTAG_CONTENT_TYPE_STR string can be converted to a
 * http_content_type_t header structure by giving the string @a s has
 * second argument to function http_content_type_make().
 *
 * @HIDE
 */
#define HTTPTAG_CONTENT_TYPE_STR(s)    	  HTTPTAG_STR(content_type, s)

SOFIAPUBVAR tag_typedef_t httptag_content_type_str;

#define HTTPTAG_CONTENT_TYPE_REF(x)        	  HTTPTAG_REF(content_type, x)
SOFIAPUBVAR tag_typedef_t httptag_content_type_ref;

#define HTTPTAG_CONTENT_TYPE_STR_REF(x)        HTTPTAG_STR_REF(content_type, x)
SOFIAPUBVAR tag_typedef_t httptag_content_type_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_content_type_v(http_content_type_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_content_type_vr(http_content_type_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_content_type_v(v)   (tag_value_t)(v)
#define httptag_content_type_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_unknown
 *
 * Tag list item for pointer to a unknown headers object.
 *
 * The HTTPTAG_UNKNOWN() macro is used to include a tag item with a
 * pointer to a http_unknown_t object in a tag list.
 *
 * @param x pointer to a http_unknown_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_UNKNOWN(x)        	  HTTPTAG(unknown, x)

SOFIAPUBVAR tag_typedef_t httptag_unknown;

/**@ingroup http_unknown
 *
 * Tag list item for string with unknown headers value.
 *
 * The HTTPTAG_UNKNOWN_STR() macro is used to include a tag item with a 
 * string containing value of a http_unknown_t header in a tag list.
 *
 * @param s pointer to a string containing http_unknown_t value, or NULL.
 *
 * The HTTPTAG_UNKNOWN_STR string can be converted to a
 * http_unknown_t header structure by giving the string @a s has
 * second argument to function http_unknown_make().
 *
 * @HIDE
 */
#define HTTPTAG_UNKNOWN_STR(s)    	  HTTPTAG_STR(unknown, s)

SOFIAPUBVAR tag_typedef_t httptag_unknown_str;

#define HTTPTAG_UNKNOWN_REF(x)        	  HTTPTAG_REF(unknown, x)
SOFIAPUBVAR tag_typedef_t httptag_unknown_ref;

#define HTTPTAG_UNKNOWN_STR_REF(x)        HTTPTAG_STR_REF(unknown, x)
SOFIAPUBVAR tag_typedef_t httptag_unknown_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_unknown_v(http_unknown_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_unknown_vr(http_unknown_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_unknown_v(v)   (tag_value_t)(v)
#define httptag_unknown_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_error
 *
 * Tag list item for pointer to a erroneous headers object.
 *
 * The HTTPTAG_ERROR() macro is used to include a tag item with a
 * pointer to a http_error_t object in a tag list.
 *
 * @param x pointer to a http_error_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_ERROR(x)        	  HTTPTAG(error, x)

SOFIAPUBVAR tag_typedef_t httptag_error;

/**@ingroup http_error
 *
 * Tag list item for string with erroneous headers value.
 *
 * The HTTPTAG_ERROR_STR() macro is used to include a tag item with a 
 * string containing value of a http_error_t header in a tag list.
 *
 * @param s pointer to a string containing http_error_t value, or NULL.
 *
 * The HTTPTAG_ERROR_STR string can be converted to a
 * http_error_t header structure by giving the string @a s has
 * second argument to function http_error_make().
 *
 * @HIDE
 */
#define HTTPTAG_ERROR_STR(s)    	  HTTPTAG_STR(error, s)

SOFIAPUBVAR tag_typedef_t httptag_error_str;

#define HTTPTAG_ERROR_REF(x)        	  HTTPTAG_REF(error, x)
SOFIAPUBVAR tag_typedef_t httptag_error_ref;

#define HTTPTAG_ERROR_STR_REF(x)        HTTPTAG_STR_REF(error, x)
SOFIAPUBVAR tag_typedef_t httptag_error_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_error_v(http_error_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_error_vr(http_error_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_error_v(v)   (tag_value_t)(v)
#define httptag_error_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_separator
 *
 * Tag list item for pointer to a separator line between headers and body object.
 *
 * The HTTPTAG_SEPARATOR() macro is used to include a tag item with a
 * pointer to a http_separator_t object in a tag list.
 *
 * @param x pointer to a http_separator_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_SEPARATOR(x)        	  HTTPTAG(separator, x)

SOFIAPUBVAR tag_typedef_t httptag_separator;

/**@ingroup http_separator
 *
 * Tag list item for string with separator line between headers and body value.
 *
 * The HTTPTAG_SEPARATOR_STR() macro is used to include a tag item with a 
 * string containing value of a http_separator_t header in a tag list.
 *
 * @param s pointer to a string containing http_separator_t value, or NULL.
 *
 * The HTTPTAG_SEPARATOR_STR string can be converted to a
 * http_separator_t header structure by giving the string @a s has
 * second argument to function http_separator_make().
 *
 * @HIDE
 */
#define HTTPTAG_SEPARATOR_STR(s)    	  HTTPTAG_STR(separator, s)

SOFIAPUBVAR tag_typedef_t httptag_separator_str;

#define HTTPTAG_SEPARATOR_REF(x)        	  HTTPTAG_REF(separator, x)
SOFIAPUBVAR tag_typedef_t httptag_separator_ref;

#define HTTPTAG_SEPARATOR_STR_REF(x)        HTTPTAG_STR_REF(separator, x)
SOFIAPUBVAR tag_typedef_t httptag_separator_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_separator_v(http_separator_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_separator_vr(http_separator_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_separator_v(v)   (tag_value_t)(v)
#define httptag_separator_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup http_payload
 *
 * Tag list item for pointer to a message payload object.
 *
 * The HTTPTAG_PAYLOAD() macro is used to include a tag item with a
 * pointer to a http_payload_t object in a tag list.
 *
 * @param x pointer to a http_payload_t header structure, or NULL.
 *
 * @HIDE
 */
#define HTTPTAG_PAYLOAD(x)        	  HTTPTAG(payload, x)

SOFIAPUBVAR tag_typedef_t httptag_payload;

/**@ingroup http_payload
 *
 * Tag list item for string with message payload value.
 *
 * The HTTPTAG_PAYLOAD_STR() macro is used to include a tag item with a 
 * string containing value of a http_payload_t header in a tag list.
 *
 * @param s pointer to a string containing http_payload_t value, or NULL.
 *
 * The HTTPTAG_PAYLOAD_STR string can be converted to a
 * http_payload_t header structure by giving the string @a s has
 * second argument to function http_payload_make().
 *
 * @HIDE
 */
#define HTTPTAG_PAYLOAD_STR(s)    	  HTTPTAG_STR(payload, s)

SOFIAPUBVAR tag_typedef_t httptag_payload_str;

#define HTTPTAG_PAYLOAD_REF(x)        	  HTTPTAG_REF(payload, x)
SOFIAPUBVAR tag_typedef_t httptag_payload_ref;

#define HTTPTAG_PAYLOAD_STR_REF(x)        HTTPTAG_STR_REF(payload, x)
SOFIAPUBVAR tag_typedef_t httptag_payload_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
httptag_payload_v(http_payload_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
httptag_payload_vr(http_payload_t const **vp)
{ return (tag_value_t)vp; }
#else
#define httptag_payload_v(v)   (tag_value_t)(v)
#define httptag_payload_vr(vp) (tag_value_t)(vp)
#endif

SOFIA_END_DECLS
#endif /* !defined(HTTP_TAG_H) */
