/*
 * This file is part of the Sofia-SIP package
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Pekka Pessi <pekka.pessi@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

/**@ingroup msg_mime
 *
 * @CFILE msg_mime_table.c
 * @brief Parser table used for testing.
 *
 * This file is automatically generated from <msg_mime.h> by msg_parser.awk.
 *
 * This file is generated from template <msg_mime_table.c.in>.
 *
 * @author Pekka Pessi <Pekka.Pessi@nokia.com>
 */

#include "config.h"

#include <stddef.h>
#include <string.h>

#include <sofia-sip/msg_mime.h>
#include <sofia-sip/msg_mime_protos.h>

#include <sofia-sip/msg_mclass.h>

#define msg_multipart_extract_body NULL

#define msg_request_class NULL
#define mp_request mp_common

#define msg_status_class NULL
#define mp_status  mp_common

#define msg_multipart_update NULL

#define MSG_MULTIPART_HCLASS                                   \
MSG_HEADER_CLASS(msg_, multipart, NULL, "", mp_common, append, \
	         msg_multipart, msg_multipart)



#define msg_offsetof(s, f) ((unsigned short)offsetof(s ,f))


msg_mclass_t const msg_multipart_mclass[1] = 
{{
# if defined (MSG_MULTIPART_HCLASS)
  MSG_MULTIPART_HCLASS,
#else
  {{ 0 }},
#endif
  MSG_MULTIPART_VERSION_CURRENT,
  MSG_MULTIPART_PROTOCOL_TAG,
#if defined (MSG_MULTIPART_PARSER_FLAGS)
  MSG_MULTIPART_PARSER_FLAGS,
#else
  0,
#endif
  sizeof (msg_multipart_t),
  msg_multipart_extract_body,
  {{ msg_request_class, msg_offsetof(msg_multipart_t, mp_request) }},
  {{ msg_status_class, msg_offsetof(msg_multipart_t, mp_status) }},
  {{ msg_separator_class, msg_offsetof(msg_multipart_t, mp_separator) }},
  {{ msg_payload_class, msg_offsetof(msg_multipart_t, mp_payload) }},
  {{ msg_unknown_class, msg_offsetof(msg_multipart_t, mp_unknown) }},
  {{ msg_error_class, msg_offsetof(msg_multipart_t, mp_error) }},
  {{ NULL, 0 }},
  NULL, 
  127, 
  7,
  {
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { msg_content_language_class, msg_offsetof(msg_multipart_t, mp_content_language) },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { msg_content_location_class, msg_offsetof(msg_multipart_t, mp_content_location) },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { msg_content_type_class, msg_offsetof(msg_multipart_t, mp_content_type) },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { msg_content_encoding_class, msg_offsetof(msg_multipart_t, mp_content_encoding) },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { msg_content_disposition_class, msg_offsetof(msg_multipart_t, mp_content_disposition) },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { msg_content_transfer_encoding_class, msg_offsetof(msg_multipart_t, mp_content_transfer_encoding) },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { msg_content_id_class, msg_offsetof(msg_multipart_t, mp_content_id) },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 },
    { NULL, 0 }
  }
}};

