;;; Snd documentation index (generated by index.cl)

(provide 'snd-index.scm)

(define (html obj)
  "(html arg) where arg can be a string, symbol, or procedure looks for a corresponding url 
and if one is found, and the Snd documentation can be found, calls (html-program) with that url"
  (letrec ((find-close-paren
	    (lambda (str)
	      (let loop ((pos 0)) ;from slib/strsrch.scm
		(cond
		 ((>= pos (string-length str)) #f)
		 ((char=? #\) (string-ref str pos)) pos)
		 ((char=? #\space (string-ref str pos)) pos)
		 (else (loop (+ 1 pos)))))))
	   
	   (goto-html
	    (lambda (n)
	      ;; look for doc on current dir, then html dir, then global dir
	      ;; snd.html is what we'll search for
	      (let ((dir (if (file-exists? "snd.html") 
			     (getcwd)
			     (if (and (string? (html-dir))
				      (file-exists? (string-append (html-dir) "/snd.html")))
				 (html-dir)
				 (if (file-exists? "/usr/share/doc/snd-7/snd.html")
				     "/usr/share/doc/snd-7"
				     (if (file-exists? "/usr/local/share/doc/snd-7/snd.html")
					 "/usr/local/share/doc/snd-7"
					 (if (file-exists? "/usr/doc/snd-7/snd.html")
					     "/usr/doc/snd-7"
					     (if (file-exists? "/usr/share/doc/snd-6/snd.html")
						 "/usr/share/doc/snd-6"
						 (if (file-exists? "/usr/local/share/doc/snd-6/snd.html")
						     "/usr/local/share/doc/snd-6"
						     (if (file-exists? "/usr/doc/snd-6/snd.html")
							 "/usr/doc/snd-6"
							 #f))))))))))
		(if dir
		    (if (or (string=? (html-program) "netscape")
			    (string=? (html-program) "mozilla"))
			(send-netscape (string-append dir "/" n)) ; definition in snd-gxutils.c
			(system (string-append (html-program) " file:" dir "/" n))))))))
    
    (let ((name (if (string? obj) 
		    obj
		    (if (symbol? obj) 
			(symbol->string obj)
			(let ((doc (if (procedure? obj)
				       (or (procedure-property obj 'documentation)
					   (procedure-documentation obj)
					   (object-property obj 'documentation))
				       (object-property obj 'documentation))))
			  (if (and (string? doc)
				   (char=? (string-ref doc 0) #\())
			      (let ((pos (find-close-paren doc)))
				(if pos
				    (substring doc 1 pos)
				    #f))))))))
      (if (and name (string? name))
	  (let ((url (snd-url name)))
	    (if url 
		(goto-html url)
		(snd-print (format #f "no url for ~A?" name))))
	  (snd-print (format #f "no doc for ~A?" name))))))


(define (? obj)
  "(? obj) prints out any help it can find for obj, and tries to find obj in the docs via netscape"
  (let ((hlp (snd-help obj)))
    (if (string? hlp)
	(snd-print hlp))
    (html obj)))

#!
;;; this code reads an entire file and runs a regexp over it returning a list of matches:
;;;   but, I can't decide how to tie this into the help search mechanism in a useful way.
;;;   Based on guile's ice-9/regex.scm list-matches
;;;   (The original idea here was to mimic Google's sorted list of references, as in the
;;;   Mac OSX help dialog, but how to sort the list?)

(use-modules (ice-9 regex))
(define (match-list regexp file)
  ;; (match-list "[tT]racking [cC]ursor" "extsnd.html")
  (let* ((str (file->string file))      ; using undocumented procedure in snd-utils.c
					;  (I can't find a simple way to do this in Scheme)
	 (strlen (string-length str))
	 (reg (make-regexp regexp)))
    (let loop ((start 0)
	       (value '())
	       (abuts #f))
      (let ((m (if (> start strlen)
		   #f
		   (regexp-exec reg str start 0))))
	(if (not m)
	    (reverse value)
	    (if (and (= (match:start m) 
			(match:end m)) 
		     abuts)
		(loop (+ start 1) value #f)
		(loop (match:end m) (cons (list (match:substring m) (match:start m)) value) #t)))))))
!#
;; this from Thien-Thi Nguyen
;(let* ((size (stat:size (stat file)))
;       (buf (make-string size))
;       (p (open-input-file file)))
;  then a weird looking read-string of size
;  (close-port p))

