(define file-names '(("teq.scm" . "v-eq")
		     ("titer.scm" . "v-iter")
		     ("tmap.scm" . "v-map")
		     ("tform.scm" . "v-form")
		     ("thash.scm" . "v-hash")
		     ("tcopy.scm" . "v-cop")
		     ("lg.scm" . "v-lg")
		     ("tgen.scm" . "v-gen")
		     ("tauto.scm" . "v-auto")
		     ("make-index.scm" . "v-index")
		     ("snd-test.scm" . "v-call")
		     ("tall.scm" . "v-all")
		     ("s7test.scm" . "v-test")
		     ))

(define (last-callg)
  (let ((name (system "ls callg*" #t)))
    (let ((len (length name)))
      (do ((i 0 (+ i 1)))
	  ((or (= i len)
	       (char-whitespace? (name i)))
	   (substring name 0 i))))))

(define (next-file f)
  (let ((name (system (format #f "ls -t ~A*" f) #t)))
    (let ((len (length name)))
      (do ((i 0 (+ i 1)))
	  ((or (= i len)
	       (and (char-numeric? (name i))
		    (char-numeric? (name (+ i 1)))))
	   (+ 1 (string->number (substring name i (+ i 2)))))))))

(define (call-valgrind)
  (for-each
   (lambda (caller+file)
     (system "rm callg*")
     (format *stderr* "~%~NC~%~NC ~A ~NC~%~NC~%" 40 #\- 16 #\- (cadr caller+file) 16 #\- 40 #\-)
     (system (format #f "valgrind --tool=callgrind ./~A ~A" (car caller+file) (cadr caller+file)))
     (let ((outfile (cdr (assoc (cadr caller+file) file-names))))
       (let ((next (next-file outfile)))
	 (system (format #f "callgrind_annotate --auto=yes --threshold=100 ~A > ~A~D" (last-callg) outfile next))
	 (format *stderr* "~NC ~A~D -> ~A~D: ~NC~%" 8 #\space outfile (- next 1) outfile next 8 #\space)
	 (system (format #f "./snd compare-calls.scm -e '(compare-calls \"~A~D\" \"~A~D\")'" outfile (- next 1) outfile next)))))
   (list (list "repl" "teq.scm")
	 (list "repl" "s7test.scm")
	 (list "snd -noinit" "make-index.scm")
	 (list "repl" "tmap.scm")
	 (list "repl" "tform.scm")
	 (list "repl" "tcopy.scm")
	 (list "repl" "tauto.scm")
	 (list "repl" "titer.scm")
	 (list "repl" "lg.scm")
	 (list "repl" "thash.scm")
	 (list "snd -noinit" "tgen.scm")    ; repl here + cload sndlib was slower
	 (list "snd -noinit" "tall.scm")
	 (list "snd -l" "snd-test.scm")
	 )))
	 

(call-valgrind)

(when (file-exists? "test.table")
  (system "mv test.table old-test.table"))
(load "compare-calls.scm")
(combine-latest)

(exit)