/*==================================================================
 * sffile.h - Header file for sound font file saving/loading funcs
 *
 * Smurf Sound Font Editor
 * Copyright (C) 1999-2001 Josh Green
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Smurf homepage: http://smurf.sourceforge.net
 *==================================================================*/
#ifndef __SFFILE_H__
#define __SFFILE_H__

#include "sfont.h"

#define CHNKIDSTR(id)           &idlist[(id - 1) * 4]

/* sfont file chunk sizes */
#define SFPHDRSIZE	38
#define SFBAGSIZE	4
#define SFMODSIZE	10
#define SFGENSIZE	4
#define SFIHDRSIZE	22
#define SFSHDRSIZE	46

/* sfont file data structures */
typedef struct _SFChunk
{				/* RIFF file chunk structure */
  guint32 id;			/* chunk id */
  guint32 size;			/* size of the following chunk */
}
SFChunk;

typedef struct _SFPhdr
{
  guint8 name[20];		/* preset name */
  guint16 preset;		/* preset number */
  guint16 bank;			/* bank number */
  guint16 pbagndx;		/* index into preset bag */
  guint32 library;		/* just for preserving them */
  guint32 genre;		/* Not used */
  guint32 morphology;		/* Not used */
}
SFPhdr;

typedef struct _SFBag
{
  guint16 genndx;		/* index into generator list */
  guint16 modndx;		/* index into modulator list */
}
SFBag;

typedef struct _SFIhdr
{
  gchar name[20];		/* Name of instrument */
  guint16 ibagndx;		/* Instrument bag index */
}
SFIhdr;

typedef struct _SFShdr
{				/* Sample header loading struct */
  gchar name[20];		/* Sample name */
  guint32 start;		/* Offset to start of sample */
  guint32 end;			/* Offset to end of sample */
  guint32 loopstart;		/* Offset to start of loop */
  guint32 loopend;		/* Offset to end of loop */
  guint32 samplerate;		/* Sample rate recorded at */
  guint8 origpitch;		/* root midi key number */
  gint8 pitchadj;		/* pitch correction in cents */
  guint16 samplelink;		/* Not used */
  guint16 sampletype;		/* 1 mono,2 right,4 left,linked 8,0x8000=ROM */
}
SFShdr;

/* data */
extern gchar idlist[];

/* functions */
SFData *sfload_file (gchar * fname);
int sfsave_file (SFData * sf, FILE * fd);
void sfsave_undo_sample_posofs (void);
void sfsave_free_sample_posofs (void);

#endif	/* __SFFILE_H__ */
