/*==================================================================
 * wtbl_awefx.h - Header file for AWE effects routines
 *
 * Smurf Sound Font Editor
 * Copyright (C) 1999-2001 Josh Green
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Smurf homepage: http://smurf.sourceforge.net
 *==================================================================*/
#ifndef __WTBL_AWEFX_H__
#define __WTBL_AWEFX_H__

#include "config.h"

#ifdef AWE_SUPPORT

#include <glib.h>
#include "sfont.h"

typedef enum
{ METH_INVALID, METH_NONE, METH_SEQCTRL, METH_EFFECT }
AweFXMethod;

typedef struct _AweFXConvType
{
  gint (*convfunc) (gint16 val);	/* SF to AWE conversion function */
  gint awenum;			/* AWE effect enumeration val */
  AweFXMethod method;		/* enum of method of setting effect */
}
AweFXConvType;

extern AweFXConvType awefxtbl[];

#endif /* #ifdef AWE_SUPPORT */

#endif /* __WTBL_AWEFX_H__ */
