#include <exception>
#include <string.h>
#include "cgdbm.h"

using namespace std;

Cdatum::Cdatum()
{
    dat.dptr = NULL;
    dat.dsize = 0;
}

Cdatum::Cdatum(const Cdatum &cd)
{
    dat.dsize = cd.dat.dsize;
    dat.dptr = NULL;
    if (cd.dat.dptr != NULL) {
	    dat.dptr = (char*)malloc(dat.dsize);
	    memcpy(dat.dptr, cd.dat.dptr, dat.dsize);
    }
}

Cdatum &Cdatum::operator=(const Cdatum &cd)
{
    Clear();
    dat.dsize = cd.dat.dsize;
    if (cd.dat.dptr != NULL) {
	    dat.dptr = (char*)malloc(dat.dsize);
	    memcpy(dat.dptr, cd.dat.dptr, dat.dsize);
    }
    return *this;
}

Cdatum &Cdatum::operator=(const datum &d)
{
    Clear();
    dat.dsize = d.dsize;
    if (d.dptr != NULL) {
	    dat.dptr = (char*)malloc(dat.dsize);
	    memcpy(dat.dptr, d.dptr, dat.dsize);
    }
    return *this;
}

Cdatum::Cdatum(const datum &d)
{
    dat.dsize = d.dsize;
    dat.dptr = NULL;
    if (d.dptr != NULL) {
	    dat.dptr = (char*)malloc(dat.dsize);
	    memcpy(dat.dptr, d.dptr, dat.dsize);
    }
}

Cdatum::Cdatum(const void *ptr, int size)
{
    dat.dsize = size;
    dat.dptr = (char*)malloc(dat.dsize);
    memcpy(dat.dptr, ptr, size);
}

Cdatum::Cdatum(const string &str)
{
    dat.dsize = str.length() + 1;
    dat.dptr = (char*)malloc(dat.dsize);
    strcpy(dat.dptr, str.c_str());
}

Cdatum::Cdatum(long val)
{
    dat.dptr = (char*)malloc(dat.dsize = sizeof(val));
    memcpy(dat.dptr, &val, dat.dsize);
}

Cdatum::Cdatum(float val)
{
    dat.dptr = (char*)malloc(dat.dsize = sizeof(val));
    memcpy(dat.dptr, &val, dat.dsize);
}

void Cdatum::Clear()
{
	if (dat.dptr != NULL && dat.dsize) free(dat.dptr);
	dat.dptr = NULL;
	dat.dsize = 0;
}

Cdatum::~Cdatum()
{
	Clear();
}

Cdatum::operator datum&()
{
    return dat;
}

Cdatum::operator string()
{
    string str = (const char*)dat.dptr;
    return str;
}

Cdatum::operator const void*()
{
    return dat.dptr;
}

//////////////////////////////////////

inline const int Cgdbm::Status()
{
    return (db != NULL);
}

Cgdbm::Cgdbm(const string &_filename, int block_size, int read_write, int mode)
{
    db = NULL;
    Open(_filename, block_size, read_write, mode);
}

Cgdbm::~Cgdbm()
{
    Close();
}
 
bool Cgdbm::Open(const string &_filename, int block_size, int read_write, int mode)
{
    if (db != NULL) Close();
    filename = _filename;
    db = gdbm_open((char*)(filename.c_str()), block_size, read_write, mode, NULL);
    return db != NULL;
}

void Cgdbm::Close()
{
       if (db != NULL) {
	       gdbm_close(db);
	       db = NULL;
       }
}
   
bool Cgdbm::store(Cdatum &key, Cdatum &content, int flag)
{
	if (!Status()) throw Cgdbm_exception();
    return gdbm_store(db, key, content, flag);
}

bool Cgdbm::insert(Cdatum &key, Cdatum &content)
{
	if (!Status()) throw Cgdbm_exception();
    return store(key, content, GDBM_INSERT);
}
 
bool Cgdbm::replace(Cdatum &key, Cdatum &content)
{
	if (!Status()) throw Cgdbm_exception();
    return store(key, content, GDBM_REPLACE);
}

Cdatum Cgdbm::operator[](Cdatum &key)
{
	if (!Status()) throw Cgdbm_exception();
	Cdatum tmp_key = gdbm_fetch(db, key);
	if (tmp_key.isNull()) throw "gdbm_fetch()"; 
	return tmp_key;
}

Cdatum Cgdbm::begin()
{
	if (!Status()) throw Cgdbm_exception();
	tmp_key = gdbm_firstkey(db);
	if (tmp_key.isNull()) throw "gdbm_firstkey()"; 
	return tmp_key;
}

Cdatum Cgdbm::next()
{
	if (!Status()) throw Cgdbm_exception();
	tmp_key = gdbm_nextkey(db, tmp_key);
	if (tmp_key.isNull()) throw "gdbm_nextkey()"; 
	return tmp_key;
}

bool Cgdbm::Exists(Cdatum &key)
{
	if (!Status()) throw Cgdbm_exception();
    return gdbm_exists(db, key) != 0;
}

bool Cgdbm::Delete(Cdatum &key)
{
	if (!Status()) throw Cgdbm_exception();
    return gdbm_delete(db, key) != 0;
}

bool Cgdbm::Reorganize()
{
	if (!Status()) throw Cgdbm_exception();
    return gdbm_reorganize(db) != 0;
}

void Cgdbm::Sync()
{
	if (!Status()) throw Cgdbm_exception();
    gdbm_sync(db);
}
 
int Cgdbm::SetOpt(int option, int *value, int size)
{
	if (!Status()) throw Cgdbm_exception();
    return gdbm_setopt(db, option, value, size);
}

const char *Cgdbm::StrError(gdbm_error err)
{
    if ((err = (gdbm_error)-1)) err = gdbm_errno;
    return gdbm_strerror(err);
}

const char *Cgdbm::Version()
{
    return gdbm_version;
}
