/*****************************************************************
Modul do wysylania SMSow przez bramke WWW.SUPERSMS.PL
Wymagana rejestracja w serwisie WWW.SUPERSMS.PL
Autor: Marian Witkowski marian@witkowscy.com
Historia:
02.04.2002 - pierwsza wersja finalna
*****************************************************************/

#include <string.h>
#include <iostream.h>
#include <stdlib.h>
#include <ctype.h>
#include "request.h"
#include "headers.h"
#include "sms.h"

/*
 z racji tego ze metoda str2url klay HTTP_Request jest w sekcji
 protected, postanowilem przepisac funkcje
*/
char *urlencode(const char *value, char *buf)
{
    const char *c = value;
    char hex[10], *ptr = buf;

    while (*c) {
         if (*c == ' ') *ptr++ = '+'; else
         if (isalnum(*c)) *ptr++ = *c;
         else {
              *ptr++ = *c;
         }
         c++;
    } 
    *ptr = '\0';
    return buf;
}


int WyslijSMS_SuperSMS(SMS_packet *sms)
{
	char *telefon = sms->telefon;
	char *wiadomosc = sms->wiadomosc;
	char *ok_msg = sms->potwierdzenie;
	int ret_val;
	char url[2048];

    while (1) {

        HTTP_Request *s = new HTTP_Request("www.supersms.pl", 80,konfig.w3cache_host, konfig.w3cache_port);
	s->AddHeader("Host","www.supersms.pl"); 

	snprintf(url,sizeof(url)-1,"/distribution/sms.php?user=%s&pass=%s&gsm=%s&msg=%s",konfig.supersms_user,konfig.supersms_pass,telefon,urlencode(wiadomosc,wiadomosc));
	s->GetData(url,1);
        ret_val = poprawna_odpowiedz(ok_msg, "", s->GetBody());

        delete s;
	return ret_val;
	}

	// jesli znajdujemy sie tutaj, to znaczy, ze gdzies wystapil blad
	throw new Exception("Blad podczas obslugi strony www.supersms.pl");
	return 0;
}
