#ifndef __LIST_H__
#define __LIST_H__

typedef struct{
    void	*first;
    void	*last;

    #define	next	first
    #define	prev	last
} LIST;


#define	next_elem(elem)		(((LIST*)(elem))->next)
#define prev_elem(elem)		(((LIST*)(elem))->prev)

#define insert_elem_after(elem, new_elem)			\
    next_elem(new_elem) = next_elem(elem);			\
    next_elem(elem) = new_elem;					\
    prev_elem(new_elem) = prev_elem(next_elem(new_elem));	\
    prev_elem(next_elem(new_elem)) = new_elem;

#define insert_elem_before(elem, new_elem)			\
    prev_elem(new_elem) = prev_elem(elem);			\
    prev_elem(elem) = new_elem;					\
    next_elem(new_elem) = next_elem(prev_elem(new_elem));	\
    next_elem(prev_elem(new_elem)) = new_elem;

#define remove_elem(elem)					\
    next_elem(prev_elem(elem)) = next_elem(elem); 		\
    prev_elem(next_elem(elem)) = prev_elem(elem);


#define	first_elem(list)		((list)->first)
#define last_elem(list)			((list)->last)
#define	add_to_list(list, elem)		{ insert_elem_after(list, elem); }
#define	add_to_list_back(list, elem)	{ insert_elem_before(list, elem); }
#define	remove_from_list(list, elem)	{ remove_elem(elem); }

#define is_list_empty(list)		((void*) (list) == (list)->first)
#define is_valid_elem(list, elem)	((void*) (elem) != (void*) (list))
#define	init_list(list)			(list)->first = (list)->last = (void*) (list)
#define STATIC_LIST_INITIALIZER(list)	{ &list, &list }

#endif	/* __LIST_H__ */
