/***************************************************************************
    smb4k_cat  -  This utility behaves essentially like 'cat'. It is
    used to "read" system configuration files and is part of Smb4K.
                             -------------------
    begin                : Mi Nov 2 2005
    copyright            : (C) 2005-2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <locale.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <getopt.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <fstream>
#include <iostream>
using namespace std;

#define SMB4K_CAT_VERSION 0.5

void info()
{
	cout << "This is smb4k_cat (version " << SMB4K_CAT_VERSION << "), the cat utility of Smb4K" << endl;
	cout << "Copyright (C) 2005-2007, Alexander Reinholdt" << endl;
	cout << endl;
	cout << "Usage:" << endl;
	cout << "  smb4k_cat {file}" << endl;
	cout << "  smb4k_cat --help" << endl;
	cout << "  smb4k_cat --version" << endl;
	cout << endl;
	cout << "Arguments:" << endl;
	cout << "  {file}\tThe (full) path of the file that should be printed to stdout." << endl;
	cout << endl;
	cout << "  --help\tDisplay this help screen and exit." << endl;
	cout << "  --version\tDisplay the version information and exit." << endl;
	cout << endl;
}


void version()
{
	cout << "Version: " << SMB4K_CAT_VERSION << endl;
}


int main( int argc, char *argv[] )
{
	(void) setlocale( LC_ALL, "" );

	if ( argc < 2 )
	{
		info();
		exit( EXIT_FAILURE );
	}

	char *filename = NULL;

	int c;

	while ( 1 )
	{
		int option_index = 0;

		static struct option long_options[] =
		{
			{ "help", 0, 0, 0 },
			{ "version", 0, 0, 0 },
			{ 0, 0, 0, 0 }
		};

		c = getopt_long( argc, argv, "", long_options, &option_index );

		if ( c == -1 )
		{
			break;
		}

		switch ( c )
		{
			case 0:
			{
				int len = strlen( long_options[option_index].name ) + 1;
				char opt[len];
				opt[0] = '\0';
				(void) strncpy( opt, long_options[option_index].name, len );
				opt[len-1] = '\0';

				if ( !strncmp( opt, "help", len ) )
				{
					info();
					exit( EXIT_SUCCESS );
				}
				else if ( !strncmp( opt, "version", len ) )
				{
					version();
					exit( EXIT_SUCCESS );
				}
				else
				{
					break;
				}

				break;
			}
			case '?':
			{
				// Abort the program if an unknown option 
				// is encountered:
				exit( EXIT_FAILURE );
			}
			default:
			{
				break;
			}
		}
	}

	if ( optind < argc )
	{
		// If we have an existing regular file, read it,
		// display its contents and exit.
		while ( optind < argc )
		{
			struct stat file_stat;

			if ( lstat( argv[optind], &file_stat ) == -1 )
			{
				int err = errno;
				cerr << "smb4k_cat: " << strerror( err ) << endl;
				exit( EXIT_FAILURE );
			}

			if ( !filename )
			{
				int len = strlen( argv[optind] ) + 1;
				filename = new char[len];
				filename[0] = '\0';
				(void) strncpy( filename, argv[optind], len );
				filename[len-1] = '\0';
			}
			else
			{
				break;
			}

			optind++;
		}
	}

	if ( filename )
	{
		FILE *fd;

		if ( (fd = fopen( filename, "r" )) == NULL )
		{
			int err = errno;
			cerr << "smb4k_cat: " << strerror( err ) << endl;
			exit( EXIT_FAILURE );
		}

		char line[255];
		line[0] = '\0';

		while( !feof( fd ) )
		{
			fgets( line, 255, fd );
			cout << line;
			line[0] = '\0';
		}

		fclose( fd );
	}
	else
	{
		// This is redundant, but we'll keep it regardless.
		cerr << "smb4k_cat: No file specified" << endl;
		exit( EXIT_FAILURE );
	}

	exit( EXIT_SUCCESS );
}

