/***************************************************************************
                          smb4ksharetooltip  -  description
                             -------------------
    begin                : Fr Aug 19 2005
    copyright            : (C) 2005 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

// Qt includes
#include <qtooltip.h>
#include <qapplication.h>
#include <qdesktopwidget.h>
#include <qrect.h>
#include <qpoint.h>
#include <qtimer.h>

// KDE includes
#include <klocale.h>
#include <kmessagebox.h>
#include <kiconloader.h>

// application specific includes
#include "smb4ksharetooltip.h"
#include "smb4ksharewidgetitem.h"


Smb4KShareTooltip::Smb4KShareTooltip( Smb4KShareWidgetItem *item, const QPoint &pos )
: QLabel( 0, "ShareTooltip", WStyle_StaysOnTop | WStyle_Customize | WStyle_NoBorder | WStyle_Tool | WX11BypassWM | WDestructiveClose ), m_pos( pos ), m_item( item )
{
  setPalette( QToolTip::palette() );
  setLineWidth( 1 );
  setMidLineWidth( 1 );
  setFrameShape( Box );
  setFrameShadow( Plain );
  setMouseTracking( true );

  m_layout = new QGridLayout( this );
  m_layout->setMargin( 10 );
  m_layout->setSpacing( 3 );

  refresh( item );
}


Smb4KShareTooltip::~Smb4KShareTooltip()
{
}


void Smb4KShareTooltip::refresh( Smb4KShareWidgetItem *item )
{
  if ( !item )
  {
    return;
  }
  else
  {
    // Do not delete m_item! You'll remove an item
    // from the shares view if you do.
    m_item = item;
  }

  m_layout->addWidget( new QLabel( i18n( "Share:" ), this ), 0, 1, 0 );
  m_layout->addWidget( new QLabel( m_item->shareObject()->name(), this ), 0, 2, 0 );
  m_layout->addWidget( new QLabel( i18n( "Mount point:" ), this ), 1, 1, 0 );
  m_layout->addWidget( new QLabel( m_item->shareObject()->path(), this ), 1, 2, 0 );

  if ( QString::compare( m_item->shareObject()->filesystem(), "smbfs" ) == 0 )
  {
    m_layout->addWidget( new QLabel( "User:", this ), 2, 1, 0 );
    m_layout->addWidget( new QLabel( QString( "%1 - %2" ).arg( m_item->shareObject()->user(), m_item->shareObject()->group() ), this ), 2, 2, 0 );
  }
  else
  {
    m_layout->addWidget( new QLabel( "Login:", this ), 2, 1, 0 );
    m_layout->addWidget( new QLabel( m_item->shareObject()->cifsLogin(), this ), 2, 2, 0 );
  }

  m_layout->addWidget( new QLabel( i18n( "File system:" ), this ), 3, 1, 0 );
  m_layout->addWidget( new QLabel( m_item->shareObject()->filesystem().upper(), this ), 3, 2, 0 );

  // Prepare the disk usage stuff.
  if ( m_item->shareObject()->totalDiskSpace() != -1 &&  m_item->shareObject()->freeDiskSpace() > -1 )
  {
    QString total, free, used, total_dim, free_dim, used_dim;

    if ( m_item->shareObject()->totalDiskSpace() - m_item->shareObject()->freeDiskSpace() > 1024 )
    {
      double tmp_used = (m_item->shareObject()->totalDiskSpace() - m_item->shareObject()->freeDiskSpace()) / 1024;
      used_dim = "MB";

      if ( tmp_used >= 1024 )
      {
        tmp_used = tmp_used / 1024;
        used_dim = "GB";
      }

      used = QString( "%1" ).arg( tmp_used, 0, 'g', tmp_used >= 10 ? 4 : 3 );
    }
    else
    {
      used_dim = "kB";
      double tmp_used = m_item->shareObject()->totalDiskSpace() - m_item->shareObject()->freeDiskSpace();
      used = QString( "%1" ).arg( tmp_used, 0, 'g', tmp_used >= 10 ? 4 : 3 );
    }

    if ( m_item->shareObject()->freeDiskSpace() >= 1024 )
    {
      double tmp_free = m_item->shareObject()->freeDiskSpace() / 1024;
      free_dim = "MB";

      if ( tmp_free >= 1024 )
      {
        tmp_free = tmp_free / 1024;
        free_dim = "GB";
      }

      free = QString( "%1" ).arg( tmp_free, 0, 'g', tmp_free >= 10 ? 4 : 3 );
    }
    else
    {
      free_dim = "kB";
      free = QString( "%1" ).arg( m_item->shareObject()->freeDiskSpace(), 0, 'g', m_item->shareObject()->freeDiskSpace() >= 10 ? 4 : 3 );
    }

    if ( m_item->shareObject()->totalDiskSpace() >= 1024 )
    {
      double tmp_total = m_item->shareObject()->totalDiskSpace() / 1024;
      total_dim = "MB";

      if ( tmp_total >= 1024 )
      {
        tmp_total = tmp_total / 1024;
        total_dim = "GB";
      }

      total = QString( "%1" ).arg( tmp_total, 0, 'g', tmp_total >= 10 ? 4 : 3 );
    }
    else
    {
      total_dim = "kB";
      total = QString( "%1" ).arg( m_item->shareObject()->totalDiskSpace(), 0, 'g', m_item->shareObject()->totalDiskSpace() >= 10 ? 4 : 3 );
    }

    m_layout->addWidget( new QLabel( i18n( "Size:" ), this ), 4, 1, 0 );
    m_layout->addWidget( new QLabel( QString( "%1 %2" ).arg( used, used_dim ), this ), 4, 2, 0 );
    m_layout->addWidget( new QLabel( i18n( "Free disk space:" ), this ), 5, 1, 0 );
    m_layout->addWidget( new QLabel( i18n( "%1 %2 out of %3 %4 (%5\% used)" ).arg( free, free_dim ).arg( total, total_dim ).arg( m_item->shareObject()->percentage(), 0, 'g', m_item->shareObject()->percentage() >= 10 ? 4 : 3 ), this ), 5, 2, 0 );
  }
  else
  {
    QLabel *error = new QLabel( i18n( "This share went offline!" ), this  );

    QFont font;
    font.setItalic( true );

    error->setFont( font );

    m_layout->addMultiCellWidget( error, 4, 4, 1, 2, Qt::AlignCenter );
  }

  QLabel *pix_label = new QLabel( this );
  pix_label->setPixmap( m_item->desktopIcon() );

  m_layout->addMultiCellWidget( pix_label, 0, m_layout->numRows(), 0, 0, Qt::AlignCenter );
}


void Smb4KShareTooltip::showTip( const QPoint &pos )
{
  if ( isShown() )
  {
    return;
  }

  // Update position where the tooltip should be
  // shown.
  if ( m_pos != pos )
  {
    m_pos = pos;
  }

  adjustSize();

  QDesktopWidget *d = QApplication::desktop();

  if ( m_pos.x() + width() > d->width() )
  {
    m_pos.setX( m_pos.x() - width() - 5 );
  }
  else
  {
    m_pos.setX( m_pos.x() + 5 );
  }

  if ( m_pos.y() + height() > d->height() )
  {
    m_pos.setY( m_pos.y() - height() - 5 );
  }
  else
  {
    m_pos.setY( m_pos.y() + 5 );
  }

  setGeometry( m_pos.x(), m_pos.y(), width(), height() );
  polish();
  show();
  QTimer::singleShot( 10000, this, SLOT( slotHideTooltip() ) );
}


void Smb4KShareTooltip::mousePressEvent( QMouseEvent *e )
{
  hide();
  QLabel::mousePressEvent( e );
}


void Smb4KShareTooltip::leaveEvent( QEvent *e )
{
  hide();
  QLabel::leaveEvent( e );
}


/////////////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////

void Smb4KShareTooltip::slotHideTooltip()
{
  if ( isShown() )
  {
    hide();
  }
}


#include "smb4ksharetooltip.moc"
