/***************************************************************************
    smb4ksambaoptions.cpp  -  description
                             -------------------
    begin                : Mo Jan 26 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KSAMBAOPTIONS_H
#define SMB4KSAMBAOPTIONS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qtabwidget.h>
#include <qradiobutton.h>
#include <qcheckbox.h>

// KDE includes
#include <klineedit.h>
#include <knuminput.h>
#include <kcombobox.h>
#include <klistview.h>
#include <kpushbutton.h>


/**
 * This class manages the configuration dialog of the options
 * that can be passed to smbmount and other programs of the
 * Samba software suite.
 */


class Smb4KSambaOptions : public QTabWidget
{
  Q_OBJECT

  friend class Smb4KOptionsDlg;

  public:
    /**
     * The constructor.
     */
    Smb4KSambaOptions( QWidget *parent = 0, const char *name = 0 );

    /**
     * The destructor.
     */
    ~Smb4KSambaOptions();

    /**
     * This enumeration is used for the list view in the "Custom" tab.
     */
#ifndef __FreeBSD__
    enum Columns{ ItemName = 0, Port = 1, Kerberos = 2, Protocol = 3, Filesystem = 4, WriteAccess = 5, UID = 6, GID = 7 };
#else
    enum Columns{ ItemName = 0, Port = 1, Kerberos = 2, Protocol = 3, UID = 4, GID = 5 };
#endif

  protected slots:
    /**
     * Enables/disables widgets according to the choice of the filesystem (SMBFS/CIFS).
     *
     * This slot is connected to the combo box that stores the file systems.
     *
     * @param filesystem       The name of the filesystem that should be used
     */
    void slotSambaFileSystem( const QString &filesystem );

    /**
     * Remove the highlighted custom options.
     */
    void slotRemoveCustomOptions();

    /**
     * This slot is invoked if an item in the list of custom options has been
     * clicked. It will put the values that are carried by the list view item
     * into the editor combo boxes, num inputs, etc.
     *
     * @param item             The item that has been clicked/highlighted.
     */
    void slotClicked( QListViewItem *item );

    /**
     * This slot is invoked if the custom port number was changed from the num
     * input.
     *
     * @param number           The port number
     */
    void slotCustomPortChanged( int number );

    /**
     * This slot is invoked if the custom file system was changed from the file system
     * input.
     *
     * @param index            The index number of the new file system
     */
    void slotCustomFilesystemChanged( int index );

    /**
     * This slot is invoked if the custom protocol was changed from the protocol
     * input.
     *
     * @param index            The index number of the new protocol
     */
    void slotCustomProtocolChanged( int index );

    /**
     * This slot is invoked if the value for the custom Kerberos settings was changed.
     *
     * @param index            The index number of the new setting
     */
    void slotCustomKerberosChanged( int index );

    /**
     * This slot is invoked if the value for the custom write access setting was changed.
     *
     * @param index            The index number of the new setting
     */
    void slotCustomWriteAccessChanged( int index );

    /**
     * This slot is invoked if the value for the custom UID setting changed.
     *
     * @param index             The index number of the new setting
     */
    void slotCustomUIDChanged( int index );

    /**
     * This slot is invoked if the value for the custom GID setting changed.
     *
     * @param index             The index number of the new setting
     */
    void slotCustomGIDChanged( int index );

  private:
    /**
     * This line edit is for the NetBIOS name.
     */
    KLineEdit *m_netbios;

    /**
     * All UIDs that are present on the system and that
     * are no system UIDs are shown here.
     */
    KComboBox *m_uid;

    /**
     * All GIDs that are connected with the non-system
     * UIDs are shown here.
     */
    KComboBox *m_gid;

    /**
     * This input holds the SMB port that's used by smbmount
     * and friends.
     */
    KIntNumInput *m_port;

    /**
     * Holds the file mask for the remote files.
     */
    KLineEdit *m_fmask;

    /**
     * Holds the directory mask.
     */
    KLineEdit *m_dmask;

    /**
     * The combo box where the user can choose whether the
     * shares should be mounted read/write or read only.
     */
    KComboBox *m_read_mode;

    /**
     * Charset combo box
     */
    KComboBox *m_charset;

    /**
     * Codepage combo box
     */
    KComboBox *m_codepage;

    /**
     * Socket options input line edit
     */
    KLineEdit *m_sockopt;

    /**
     * Scope input line edit
     */
    KLineEdit *m_scope;

#ifndef __FreeBSD__
    /**
     * The caching time used for mounting
     */
    KIntNumInput *m_ttl;
    
    /**
     * Unicode support
     */
    QCheckBox *m_unicode;
    
    /**
     * Long file support
     */
    QCheckBox *m_lfs;
    
    /**
     * This check box determines whether the user wants to use the
     * default network read size. (CIFS only).
     */
    QCheckBox *m_rsize;

    /**
     * This check box determines whether the user wants to use the
     * default network write size. (CIFS only).
     */
    QCheckBox *m_wsize;
#endif
    
    /**
     * Determines whether Kerberos should be used.
     */
    QCheckBox *m_krb;

    KLineEdit *m_resolve;
    KIntNumInput *m_buffer;
    QCheckBox *m_udp;

    /**
     * Holds the domain string.
     */
    KLineEdit *m_domain;

    /**
     * Broadcast input line edit
     */
    KLineEdit *m_broadcast;

    /**
     * The combo box where the user can choose the file system that
     * should be used for mounting.
     */
    KComboBox *m_filesystem;

    /**
     * This button deterimes that the protocol for the net command
     * should be auto-detected.
     */
    QRadioButton *m_net_auto;

    /**
     * net command should use ADS protocol.
     */
    QRadioButton *m_net_ads;

    /**
     * net command should use RPC protocol.
     */
    QRadioButton *m_net_rpc;

    /**
     * net command should use RAP protocol.
     */
    QRadioButton *m_net_rap;

    /**
     * If this button is checked, the '-P' (authenticate as machine account)
     * option should be added to the net command.
     */
    QCheckBox *m_net_machine_account;

    /**
     * List view for custom options
     */
    KListView *m_custom_options;

    /**
     * Button to remove the custom options.
     */
    KPushButton *m_remove_custom;

    /**
     * Input for custom port setting
     */
    KIntNumInput *m_custom_port;

    /**
     * Combo box for custom protocol setting
     */
    KComboBox *m_custom_protocol;

    /**
     * Combo box for custom Kerberos setting
     */
    KComboBox *m_custom_kerberos;

#ifndef __FreeBSD__
    /**
     * Combo box for custom file system setting
     */
    KComboBox *m_custom_filesystem;

    /**
     * Combo box for custom write access setting
     */
    KComboBox *m_custom_rw;
#endif

    /**
     * Combo box for custom UID setting
     */
    KComboBox *m_custom_uid;

    /**
     * Combo box for custom GID setting
     */
    KComboBox *m_custom_gid;
};

#endif
