/***************************************************************************
                          smb4k_mv  -  description
                             -------------------
    begin                : Sa Nov 19 2005
    copyright            : (C) 2005 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream>
#include <cstring>
#include <cctype>
#include <cerrno>
#include <sys/types.h>
#include <unistd.h>
#include <sys/wait.h>
using namespace std;

#define SMB4K_MV_VERSION 0.2


//
// Returns the information about the program
//

void info()
{
  cout << "This is smb4k_mv (version " << SMB4K_MV_VERSION << "), the move utility of Smb4K" << endl;
  cout << "Copyright (C) 2005-2006, Alexander Reinholdt" << endl << endl;
  cout << "Usage:" << endl;
  cout << " smb4k_mv {user}:{group} {perm} {src} {dest}" << endl;
  cout << " smb4k_mv --help" << endl << endl;
  cout << "Arguments:" << endl;
  cout << "  {user}\tThe user the file will belong to after it has been moved." << endl;
  cout << endl;
  cout << "  {group}\tThe group the file will belong to after it has been moved." << endl;
  cout << endl;
  cout << "  {perm}\tThe permissions of the file after it has been moved." << endl;
  cout << endl;
  cout << "  {src}\t\tThe source file that will be moved." << endl;
  cout << endl;
  cout << "  {dest}\tThe destination where the file will be moved to." << endl;
  cout << endl;
  cout << "  --help\tDisplays this help screen and exits." << endl;
  cout << endl;
}


//
// Finds programs
//

const char *findprog( const char *name )
{
  const char *paths[] = { "/bin/", "/sbin/", "/usr/bin/", "/usr/sbin/", "/usr/local/bin/", "/usr/local/sbin/" };
  string file = "";

  for ( uint i = 0; i < sizeof( paths ) / sizeof( char * ); i++ )
  {
    string path( paths[i] );
    path.append( name );

    if ( access( path.c_str(), X_OK ) == 0 )
    {
      file.assign( path );
      break;
    }
  }

  if ( !strcmp( file.c_str(), "" ) )
  {
    cerr << "smb4k_mv: Could not find " << name << "." << endl;
    exit( EXIT_FAILURE );
  }

  return file.c_str();
}


int main( int argc, char *argv[], char *envp[] )
{
  if ( (argc == 2 && !strcmp( argv[1], "--help" )) || argc != 5 )
  {
    info();

    if ( argc != 5 )
    {
      exit( EXIT_FAILURE );
    }
    else
    {
      exit( EXIT_SUCCESS );
    }
  }

  int i;

  // Change the owner and group
  char chown_prog[6] = "chown";
  char *chown_argv[4] = { chown_prog, argv[1], argv[3], (char *)NULL };

  if ( fork() == 0 )
  {
    if ( (i = execve( findprog( "chown" ), chown_argv, envp )) == -1 )
    {
      int err_code = errno;
      cerr << "smb4k_mv: " << strerror( err_code ) << endl;
      exit( EXIT_FAILURE );
    }
  }
  else
  {
    wait( &i );
  }

  // Change the permissions
  char chmod_prog[6] = "chmod";
  char *chmod_argv[4] = { chmod_prog, argv[2], argv[3], (char *)NULL };

  if ( fork() == 0 )
  {
    if ( (i = execve( findprog( "chmod" ), chmod_argv, envp )) == -1 )
    {
      int err_code = errno;
      cerr << "smb4k_mv: " << strerror( err_code ) << endl;
      exit( EXIT_FAILURE );
    }
  }
  else
  {
    wait( &i );
  }

  // Move the file
  char mv[3] = "mv";
  char *mv_argv[4] = { mv, argv[3], argv[4], (char *)NULL };

  if ( fork() == 0 )
  {
    if ( (i = execve( findprog( "mv" ), mv_argv, envp )) == -1 )
    {
      int err_code = errno;
      cerr << "smb4k_mv: " << strerror( err_code ) << endl;
      exit( EXIT_FAILURE );
    }
  }
  else
  {
    wait( &i );
  }

  return EXIT_SUCCESS;
}
