/***************************************************************************
    main.cpp  -  Main file of the Smb4K program.
                             -------------------
    begin                : Sam M�  1 14:57:21 CET 2003
    copyright            : (C) 2003 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <kiconloader.h>
#include <dcopclient.h>
#include <kconfig.h>

#include "smb4k.h"
#include "core/smb4kglobal.h"
using namespace Smb4KGlobal;


static const char *description =
I18N_NOOP( "Smb4K is an SMB/CIFS share browser for KDE.\nIt uses Samba to access the local network neighborhood." );
// INSERT A DESCRIPTION FOR YOUR APPLICATION HERE


static KCmdLineOptions options[] =
{
//   { "+[File]", I18N_NOOP("file to open"), 0 },
  { 0, 0, 0 }
  // INSERT YOUR COMMANDLINE OPTIONS HERE
};


void modifyConfig()
{
  if ( config()->getConfigState() != KConfig::NoAccess && config()->getConfigState() != KConfig::ReadOnly )
  {
    if ( config()->hasGroup( "Appearance" ) )
    {
      // Get the entries of this group:
      QMap<QString, QString> map = config()->entryMap( "Appearance" );

      // Now write it to the new group:
      config()->setGroup( "User Interface" );

      for ( QMap<QString, QString>::ConstIterator it = map.begin(); it != map.end(); ++it )
      {
        config()->writeEntry( it.key(), it.data() );
      }

      config()->deleteGroup( "Appearance" );
    }

    config()->sync();
  }
};



int main( int argc, char *argv[] )
{
  KAboutData aboutData( "smb4k", I18N_NOOP( "Smb4K" ),
  VERSION, description, KAboutData::License_GPL,
  I18N_NOOP( "(c) 2003-2006, Alexander Reinholdt & the Smb4K team" ), 0, "http://smb4k.berlios.de", "smb4k-bugs@lists.berlios.de" );

  // Authors:
  aboutData.addAuthor( "Alexander Reinholdt", I18N_NOOP( "Developer" ), "dustpuppy@users.berlios.de" );
  aboutData.addAuthor( "Massimo Callegari", I18N_NOOP( "Developer" ), "massimocallegari@yahoo.it" );
  aboutData.addAuthor( "Franck Babin", I18N_NOOP( "Developer" ), "babinfranck@yahoo.ca" );
//   aboutData.addAuthor( "Matthew P. Barnson", I18N_NOOP( "Documentation" ), "mbarnson@users.berlios.de" );

  // All our credits:
  aboutData.addCredit( "Leopold Palomo Avellaneda", I18N_NOOP( "Catalan translation" ), "lepalom@wol.es" );
  aboutData.addCredit( "Radoslaw Zawartko", I18N_NOOP( "Polish translation" ), "radzaw@lnet.szn.pl" );
  aboutData.addCredit( "Nick Chen", I18N_NOOP( "Chinese Simplified translation" ), "nick_chen75@hotmail.com" );
  aboutData.addCredit( "Stanislav Yudin", I18N_NOOP( "Russian translation" ), "decvar@mail.berlios.de" );
  aboutData.addCredit( "Marc Hansen", I18N_NOOP( "Swedish translation and intensive testing" ), "marc.hansen@gmx.de" );
  aboutData.addCredit( "Giovanni Degani", I18N_NOOP( "Brazilian Portuguese translation" ), "tiefox@terra.com.br" );
  aboutData.addCredit( "Ivan Petrouchtchak", I18N_NOOP( "Ukrainian translation" ), "iip@telus.net" );
  aboutData.addCredit( "Karoly Barcza", I18N_NOOP( "Hungarian translation" ), "kbarcza@blackpanther.hu" );
  aboutData.addCredit( "Quique", I18N_NOOP( "Spanish translation" ), "quique@sindominio.net" );
  aboutData.addCredit( "Michal Šulek", I18N_NOOP( "Slovak translation" ), "reloadshot@atlas.sk" );
  aboutData.addCredit( "Nicolas Ternisien", I18N_NOOP( "French translation" ), "nicolast@libertysurf.fr" );
  aboutData.addCredit( "Toyohiro Asukai", I18N_NOOP( "Japanese translation" ), "toyohiro@ksmplus.com" );
  aboutData.addCredit( "Atanas Mavrov", I18N_NOOP( "Bulgarian translation" ), "bugar@developer.bg" );
  aboutData.addCredit( "Isidoro Russo", I18N_NOOP( "Italian translation" ), "risidoro@aliceposta.it" );
  aboutData.addCredit( "Nils Kristian Tomren", I18N_NOOP( "Norwegian translations" ), "project@nilsk.net" );
  aboutData.addCredit( "Alois Nešpor", I18N_NOOP( "Czech translation" ), 
"alois.nespor@gmail.com" );
  aboutData.addCredit( "Martín Carr", I18N_NOOP( "Spanish translation" ), "tincarr@gmail.com" );
  aboutData.addCredit( "Görkem Çetin", I18N_NOOP( "Turkish translation" ), "gorkem@gorkemcetin.com" );
  aboutData.addCredit( "Jack Liu", I18N_NOOP( "Chinese Traditional translation" ), "chuany@chuany.net" );
  aboutData.addCredit( "Arnar Leósson", I18N_NOOP( "Icelandic translation" ), "leosson@frisurf.no" );
  aboutData.addCredit( "Michael Brinkloev", I18N_NOOP( "Danish translation" ), "mhb@qxp.dk" );
  aboutData.addCredit( "Joop Beris", I18N_NOOP( "Dutch translation" ), "jberis@risse.nl" );
  aboutData.addCredit( "Lamarque V. Souza", I18N_NOOP( "Brazilian Portuguese translation" ), "lamarque_souza@hotmail.com" );
  aboutData.addCredit( "Serdar Soytetir", I18N_NOOP( "Turkish translation" ), "sendirom@gmail.com" );
  aboutData.addCredit( "Wei-Lun Chao", I18N_NOOP( "Chinese Traditional translation" ), "chaoweilun@users.berlios.de" );
  aboutData.addCredit( "Rashid N. Achilov", I18N_NOOP( "Testing of Smb4K under FreeBSD" ), "shelton@sentry.granch.ru" );

  KCmdLineArgs::init( argc, argv, &aboutData );
  KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

  KUniqueApplication app;

//  This is for debugging only:
//   KApplication app;

  // Modify the configuration in case some entries changed:
  modifyConfig();

  // You can access the core by including the header file smb4kcore.h
  // and use the smb4k_core static variable or the smb4kcore() function.
  Smb4KCore *core = new Smb4KCore( 0, "Core" );
  Smb4KApp *smb4k = new Smb4KApp( 0, "MainApp" );

  app.setMainWidget( smb4k );

  bool startDocked;

  config()->setGroup( "Docking" );
  startDocked = config()->readBoolEntry( "Start Docked", false );

  if ( !startDocked )
  {
    smb4k->show();
  }

  int result = app.exec();

  delete core;

  return result;
}
