/***************************************************************************
    smb4kappearance.cpp  -  description
                             -------------------
    begin                : Di Okt 28 2003
    copyright            : (C) 2003 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// Qt includes
#include <qlayout.h>
#include <qbuttongroup.h>

// KDE includes
#include <klocale.h>

// application specific includes
#include "smb4kappearanceoptions.h"


/** The configuration dialog for the appearance of Smb4K. */

Smb4KAppearanceOptions::Smb4KAppearanceOptions( QWidget *parent, const char *name ) : QWidget( parent, name )
{
  QGridLayout *grid = new QGridLayout( this );
  grid->setSpacing( 10 );

  // Appearance of the browser widget.
  QButtonGroup *browserGroup = new QButtonGroup( i18n( "Network Browser" ), this );

  m_showHidden = new QCheckBox( i18n( "Show hidden shares" ), browserGroup );
  m_showHidden->setGeometry( QRect( 10, 25, m_showHidden->sizeHint().width(), m_showHidden->sizeHint().height() ) );

  m_showIPC = new QCheckBox( i18n( "Show IPC$ shares" ), browserGroup );
  m_showIPC->setGeometry( QRect( 30, m_showHidden->frameGeometry().bottom()+5, m_showIPC->sizeHint().width(), m_showIPC->sizeHint().height() ) );

  m_showAdmin = new QCheckBox( i18n( "Show ADMIN$ shares" ), browserGroup );
  m_showAdmin->setGeometry( QRect( 30, m_showIPC->frameGeometry().bottom()+5, m_showAdmin->sizeHint().width(), m_showAdmin->sizeHint().height() ) );

  m_showPrinter = new QCheckBox( i18n( "Show printer shares" ), browserGroup );
  m_showPrinter->setGeometry( QRect( 10, m_showAdmin->frameGeometry().bottom()+5, m_showPrinter->sizeHint().width(), m_showPrinter->sizeHint().height() ) );

  m_showType = new QCheckBox( i18n( "Show type" ), browserGroup );
  m_showType->setGeometry( 10, m_showPrinter->frameGeometry().bottom()+5, m_showType->sizeHint().width(), m_showType->sizeHint().height() );
  
  m_showIP = new QCheckBox( i18n( "Show IP address" ), browserGroup );  
  m_showIP->setGeometry( QRect( 10, m_showType->frameGeometry().bottom()+5, m_showIP->sizeHint().width(), m_showIP->sizeHint().height() ) );
  
  m_showComment = new QCheckBox( i18n( "Show comment" ), browserGroup );
  m_showComment->setGeometry( QRect( 10, m_showIP->frameGeometry().bottom()+5, m_showComment->sizeHint().width(), m_showComment->sizeHint().height() ) );  
      
  // Appearance of the share view.
  QButtonGroup *shareGroup = new QButtonGroup( i18n( "Shares View" ), this );
  
  // The buttons:
  m_description = new QCheckBox( i18n( "Show mount point instead of share name" ), shareGroup, 0 );
  m_description->setGeometry( 10, 25, m_description->sizeHint().width(), m_description->sizeHint().height() );
  m_shareview = new QCheckBox( i18n( "Show shares as list instead of as icons" ), shareGroup, 0 );
  m_shareview->setGeometry( 10, m_description->frameGeometry().bottom()+5, m_shareview->sizeHint().width(), m_shareview->sizeHint().height() );
  m_external = new QCheckBox( i18n( "Show all shares that are mounted on the system" ), shareGroup, 0 );
  m_external->setGeometry( 10, m_shareview->frameGeometry().bottom()+5, m_external->sizeHint().width(), m_external->sizeHint().height() );
  
  QSpacerItem *spacer1 = new QSpacerItem( 0, 0, QSizePolicy::Preferred, QSizePolicy::Expanding );
  
  grid->addWidget( browserGroup, 0, 0, 0 );
  grid->addWidget( shareGroup, 1, 0, 0 );
  grid->addItem( spacer1, 2, 0 );
}


Smb4KAppearanceOptions::~Smb4KAppearanceOptions()
{
}

#include "smb4kappearanceoptions.moc"
