/***************************************************************************
    smb4ksystemtray.h  - The widget that handles the docking to the
             system tray.
                             -------------------
    begin                : Mon Jan 12 2004
    copyright            : (C) 2004 by Franck Babin
    email                : babinfranck@yahoo.ca
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SMB4KSYSTEMTRAY_H
#define SMB4KSYSTEMTRAY_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qwidget.h>

// KDE includes
#include <ksystemtray.h>
#include <kaction.h>


class Smb4KSystemTray : public KSystemTray
{
  Q_OBJECT

  public:
    /**
     * The constructor.
     */
    Smb4KSystemTray( bool dock_now, QWidget *parent = 0, const char *name = 0 );
    /**
     * The destructor.
     */
    ~Smb4KSystemTray();
    /**
     * Returns TRUE if the main application has been docked
     * to the system tray and FALSE otherwise.
     */
    bool isDocked() { return m_docked; }
    /**
     * Inserts an action to the given position.
     *
     * @param action    The action that is to be plugged into the system tray.
     *
     * @param pos       The position where the action should be plugged.
     */
    void insertAction( KAction *action, int pos );

  public slots:
    /**
     * Docks the main widget to the system tray.
     */
    void dock();
    /**
     * Undocks the window from the system tray.
     */
    void undock();

  private:
    /**
     * Sets up the context menu.
     */
    void setupContextMenu();
    /**
     * When the application is currently docked, this is set to
     * TRUE otherwise it is false.
     */
    bool m_docked;
};

#endif
