/***************************************************************************
    smb4k.h  -  The main class of Smb4K.
                             -------------------
    begin                : Sam Mr  1 14:57:21 CET 2003
    copyright            : (C) 2003 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SMB4K_H
#define SMB4K_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt forward declarations
#include <qlabel.h>

// include files for KDE
#include <kuniqueapplication.h>
#include <kdockwidget.h>
#include <kaccel.h>
#include <kaction.h>
#include <kconfig.h>
#include <klistview.h>
#include <kiconview.h>
#include <kprogress.h>

// application specific includes
#include "core/smb4kcore.h"
#include "smb4ksystemtray.h"
#include "widgets/smb4kbookmarkmenuwidget.h"
#include "widgets/smb4ksharewidget.h"
#include "widgets/smb4kbrowserwidget.h"
#include "widgets/smb4knetworktab.h"
#include "widgets/smb4ksearchtab.h"
#include "widgets/smb4ksharetab.h"

/**
  * The base class for Smb4K application windows. It sets up the main
  * window and reads the config file as well as providing a menubar, toolbar
  * and statusbar. An instance of Smb4KView creates your center view, which is connected
  * to the window's Doc object.
  * Smb4KApp reimplements the methods that KMainWindow provides for main window handling and supports
  * full session management as well as using KActions.
  * @see KMainWindow
  * @see KApplication
  * @see KConfig
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
  * @version KDevelop version 1.2 code generation
  */
class Smb4KApp : public KDockMainWindow
{
  Q_OBJECT

  friend class Smb4KBrowserWidget;
  friend class Smb4KShareWidget;
  friend class Smb4KSystemTray;
  friend class Smb4KBookmarkMenuWidget;

  public:
    /** construtor of Smb4KApp, calls all init functions to create the application. */
    Smb4KApp( QWidget* parent=0, const char *name=0 );
    /**
     * The destructor.
     */
    ~Smb4KApp();
    /**
     * Returns the pointer to the network view.
     */
    Smb4KBrowserWidget *networkView() { return m_network_view; }
    /**
     * Returns the pointer to the share tab.
     */
    Smb4KShareTab *shareTab() { return m_share_tab; }
    /**
     * Returns the pointer to the network tab.
     */
    Smb4KNetworkTab *networkTab() { return m_network_tab; }
    /**
     * Returns the pointer to the search tab.
     */
    Smb4KSearchTab *searchTab() { return m_search_tab; }
    /**
     * read general Options again and initialize all variables like the recent file list
     */
    void readOptions();


  protected:
    /** save general Options like all bar positions and status as well as the geometry and the recent file list to the configuration
     * file
     */
    void saveOptions();
    /**
     * Initializes the KActions of the application
     */
    void initActions();
    /**
     * Sets up the statusbar for the main window by initialzing a statuslabel.
     */
    void initStatusBar();
    /** creates the centerwidget of the KTMainWindow instance and sets it as the view */
    void initView();
    /**
     * Initializes the core applications.
     */
    void initCore();
    /**
     * Plugs several items into the menu bar that could not be loaded otherwise.
     */
    void setupMenuBar();
    /**
     * Sets up the system tray icon.
     */
    void setupSystemTray();
    /**
     * Reimplemented from KMainWindow.
     */
    bool queryExit();
    /**
     * Reimplemented from KMainWindow.
     */
    bool queryClose();

  public slots:
    void slotQuit();
    void slotViewToolBar();
    void slotViewStatusBar();
    void slotStatusMsg(const QString &text);
    /** Opens the configuration dialog. */
    void slotSmb4KOptionsDlg();

  protected slots:
    /**
     * Aborts any action of the program.
     */
    void slotAbort();
    /**
     * Sets the progress bar.
     */
    void slotSetProgress();
    /**
     * This slot is invoked, if the options have to be reread.
     */
    void slotReadOptions();
    /**
     * This slot is activated when the run state of the core changed. It handles
     * the messages of the status bar and the enabling and disabling of the
     * Abort and other actions.
     */
    void slotCoreRunStateChanged();
    /**
     * This slot shows the network info tab when the appropriate key(s) is
     * pressed.
     */
    void slotShowNetworkTab();
    /**
     * This slot shows the share info tab when the appropriate key(s) is
     * pressed.
     */
    void slotShowShareTab();
    /**
     * This slot shows the search tab when the appropriate key(s) is
     * pressed.
     */
    void slotShowSearchTab();

  private:
    /**
     * Determines whether Smb4K should only start docked or if the main window
     * should be shown.
     */
    bool m_startDocked;
    /**
     * the configuration object of the application
     */
    KConfig *m_config;
    /**
     * The docking class
     */
    Smb4KSystemTray *sys_tray;
    /**
     * Label to hold the WINS server info in the status bar.
     */
    QLabel *m_winsLabel;
    /**
     * Label to hold the browse list retrieval info in the status bar.
     */
    QLabel *m_listLabel;
    /**
     * The progress bar for the status bar.
     */
    KProgress *m_progress;
    /**
     * The timer, that drives the progress bar.
     */
    QTimer *m_progTimer;
    /**
     * KAction for quitting the application
     */
    KAction *quitApp;
    KToggleAction* viewToolBar;
    KToggleAction* viewStatusBar;
    KAction *networkRescan;
    KAction *abort;
    KAction *networkSearch;
    KAction *networkMount;
    KAction *sharesUnmount;
    KAction *sharesUnmountAll;
    KAction *sharesForceUnmount;
    KAction *sharesStartFilemanager;
    KAction *settingsSmb4KOptions;
    KAction *networkPreview;
    KAction *networkAskPass;
    KAction *networkAddBookmark;
    KAction *networkPrint;
    KAction *sharesManualMount;
    /**
     * The share view.
     */
    Smb4KShareWidget *m_share_view;
    /**
     * The network view.
     */
    Smb4KBrowserWidget *m_network_view;
    /**
     * The network info tab.
     */
    Smb4KNetworkTab *m_network_tab;
    /**
     * The share tab.
     */
    Smb4KShareTab *m_share_tab;
    /**
     * The search tab.
     */
    Smb4KSearchTab *m_search_tab;
};

#endif // SMB4K_H
